/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.loaders.trace.TraceXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.impl.TRCHeapDumpImpl;

public class XMLheapDumpDefLoader
extends TraceXMLFragmentLoader {
    protected static final String BASE_TIME = "basetime";
    protected static final String HEAP_DUMP_ID = "heapDumpId";
    protected String name;
    protected double baseTime;
    protected short heapDumpId;

    public void addAttribute(String name, String value) {
        switch (LoadersUtils.getHashCode((String)name)) {
            case 3373707: {
                this.name = value;
                break;
            }
            case -1720547042: {
                this.baseTime = Double.parseDouble(value);
                break;
            }
            case -1198575813: {
                this.heapDumpId = Short.parseShort(value);
                break;
            }
            default: {
                super.addAttribute(name, value);
            }
        }
    }

    public void addYourselfInContext() {
        this.dispatchProcessMode(0);
    }

    private void createHeapDump() {
        this.theProcess = this.getProcess();
        if (!TraceUtils.isBooleanOptionEnabled(this.context, "MULTIPLE_HEAP_DUMPS")) {
            this.removePreviousHeapDump(this.theProcess);
        }
        this.theHeapDump = (TRCHeapDump)LookupServiceExtensions.getInstance().locate(this.context, TRCHeapDumpImpl.class, (int)this.heapDumpId);
        if (this.theHeapDump == null) {
            this.theHeapDump = TraceFactory.eINSTANCE.createTRCHeapDump();
            this.theHeapDump.setId(this.heapDumpId);
        }
        this.theHeapDump.setName(this.name);
        this.theHeapDump.setEntryTime(this.createDeltaTime());
        this.theHeapDump.setProcess(this.theProcess);
    }

    protected void removePreviousHeapDump(TRCProcess p) {
        for (TRCHeapDump element : p.getHeapDumps()) {
            TRCObjectReference[] references = (TRCObjectReference[])element.getReferences().toArray((Object[])new TRCObjectReference[element.getReferences().size()]);
            int i = 0;
            while (i < references.length) {
                references[i].setOwner(null);
                references[i].setTarget(null);
                references[i].setHeapDump(null);
                ++i;
            }
        }
        p.getHeapDumps().clear();
    }

    public void initialize(HierarchyContext context, String name) {
        this.loadToModel = context.isLoadToModel();
        super.initialize(context, name);
        name = null;
        this.baseTime = 0.0;
        this.heapDumpId = 0;
    }

    protected void processHF(int step) {
        super.processHF(step);
        this.createHeapDump();
    }

    protected void processHS(int step) {
        super.processHS(step);
        this.createHeapDump();
    }
}

