/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.loaders.trace.TraceXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCSignatureNotation;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodWithLLDataImpl;
import org.eclipse.hyades.models.trace.impl.TRCTraceObjectImpl;

public class XMLmethodDefLoader
extends TraceXMLFragmentLoader {
    protected static final String START_LINE_NUMBER = "startLineNumber";
    protected static final String END_LINE_NUMBER = "endLineNumber";
    protected static final String SIGNATURE = "signature";
    protected static final String SIG_NOTATION = "sigNotation";
    protected static final String METHOD_ID = "methodId";
    protected String access;
    protected String name;
    protected String signature;
    protected TRCSignatureNotation sigNotation;
    protected int methodId;
    protected int endLineNumber;
    protected int startLineNumber;

    public void addAttribute(String name, String value) {
        switch (LoadersUtils.getHashCode((String)name)) {
            case -443210276: {
                this.methodId = Integer.parseInt(value);
                break;
            }
            case 3373707: {
                if (this.currentAnnotation != null) {
                    this.currentAnnotation.setName(value);
                    break;
                }
                this.name = value;
                break;
            }
            case 508763123: {
                this.sigNotation = TRCSignatureNotation.get(value);
                break;
            }
            case 1073584312: {
                this.signature = value;
                break;
            }
            case 1571143263: {
                this.startLineNumber = Integer.parseInt(value);
                break;
            }
            case -191889512: {
                this.endLineNumber = Integer.parseInt(value);
                break;
            }
            default: {
                super.addAttribute(name, value);
            }
        }
    }

    public void addYourselfInContext() {
        if (this.name == null || this.name.length() == 0) {
            this.name = "unknown";
        }
        if (this.context.isFilterOn()) {
            if (this.context.getFilterEngine().isFiltered((EStructuralFeature)TracePackage.eINSTANCE.getTRCClass_Name(), LoadersUtils.getLookUpKey((long)this.classIdRef))) {
                this.context.getFilterEngine().addExcludedId((EStructuralFeature)TracePackage.eINSTANCE.getTRCMethod_Name(), LoadersUtils.getLookUpKey((int)this.methodId));
                return;
            }
            this.theProcess = this.getProcess();
            this.getTRCClass();
            String realName = this.name.equals("-init-") && this.theClass != null ? this.theClass.getName() : this.name;
            if (this.context.getFilterEngine().isFiltered((EStructuralFeature)TracePackage.eINSTANCE.getTRCMethod_Name(), LoadersUtils.getLookUpKey((int)this.methodId), (Object)realName)) {
                return;
            }
        }
        if (this.theProcess == null) {
            this.theProcess = this.getProcess();
        }
        if (this.sigNotation == null) {
            this.sigNotation = TRCSignatureNotation.JNI_LITERAL;
        }
        Class clazz = TraceUtils.isBooleanOptionEnabled(this.context, "LLDATA_ENABLED") ? TRCMethodWithLLDataImpl.class : TRCMethodImpl.class;
        this.theMethod = (TRCMethod)LookupServiceExtensions.getInstance().locate(this.context, clazz, this.methodId);
        this.dispatchProcessMode(0);
        if (this.theMethod == null) {
            this.theMethod = this.createTRCMethod(this.theClass);
            this.theMethod.setId(this.methodId);
            this.theMethod.setDefiningClass(this.theClass);
        }
        if (this.sourceName != null) {
            TraceUtils.setSourceInfo(this.context, this.theProcess, this.theMethod, this.sourceName, this.language);
        }
        this.addLanguageIfRequired((List)this.theProcess.getLanguages());
        this.addAnnotationsIfRequired(this.theMethod);
        if (TraceUtils.isConstructor(this.name)) {
            this.theMethod.setModifier(this.theMethod.getModifier() | 0x80);
        }
        this.theMethod.setName(TraceUtils.getMethodName(this.theMethod, this.name));
        this.theMethod.setSignature(TraceUtils.convertMethodSignature(this.theMethod, this.signature));
        this.theMethod.setNotation(this.sigNotation);
        this.theMethod.setLineNo(this.startLineNumber);
        this.theMethod.setLineCount(this.endLineNumber - this.startLineNumber);
    }

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        name = null;
        this.access = null;
        this.signature = null;
        this.startLineNumber = 0;
        this.endLineNumber = 0;
        this.sigNotation = null;
        this.methodId = 0;
        this.sourceName = null;
        this.language = null;
        this.annotations.clear();
    }

    protected void getTRCClass() {
        if (this.theClass == null) {
            this.theClass = this.theProcess.getThreads().size() > 0 ? this.getClassByIdRef((TRCThread)this.theProcess.getThreads().get(this.theProcess.getThreads().size() - 1), TRCTraceObjectImpl.class, 0) : this.getClassByIdRef(this.getThreadByIdRef(this.theProcess), TRCTraceObjectImpl.class, 0);
        }
    }

    protected void processEF(int step) {
        super.processEF(0);
        this.getTRCClass();
    }

    protected void processES(int step) {
        super.processES(step);
        this.getTRCClass();
    }

    protected void processHF(int step) {
        super.processHF(0);
        this.getTRCClass();
    }

    protected void processHS(int step) {
        super.processHS(0);
        this.getTRCClass();
    }
}

