/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.loaders.trace.CallStackPerThread;
import org.eclipse.hyades.loaders.trace.TraceMethodBaseLoader;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.loaders.trace.VirtualObjectInfo;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl;
import org.eclipse.hyades.models.util.ModelDebugger;

public class XMLmethodEntryLoader
extends TraceMethodBaseLoader {
    public void addAttribute(String name, String value) {
        if (!this.loadToModel) {
            return;
        }
        super.addAttribute(name, value);
    }

    public void addYourselfInContext() {
        if (!this.loadToModel) {
            return;
        }
        if (this.context.isFilterOn() && this.context.getFilterEngine().isFiltered((EStructuralFeature)TracePackage.eINSTANCE.getTRCMethod_Name(), LoadersUtils.getLookUpKey((int)this.methodIdRef))) {
            return;
        }
        if (this.remoteInvocationContext) {
            this.activeInvocationContext = true;
        }
        this.theProcess = this.getProcess();
        this.theThread = this.getThreadByIdRef(this.theProcess);
        this.cs = (CallStackPerThread)LookupServiceExtensions.getInstance().locate(this.context, CallStackPerThread.class, this.threadIdRef);
        if (this.cs == null) {
            Object csKey = LoadersUtils.getLookUpKey((int)this.threadIdRef);
            this.cs = new CallStackPerThread();
            LoadersUtils.registerGenericLookUpEntry((HierarchyContext)this.context, (Object)csKey, (Object)this.cs);
        }
        this.invocationPool = this.cs.invocationPool;
        this.dispatchProcessMode(0);
        this.setMaxStackDepth(this.theThread);
    }

    public void cleanUp(HierarchyContext context) {
        LookupServiceExtensions.getInstance().deregister(context, CallStackPerThread.class);
        super.cleanUp();
    }

    public void endChild(String name) {
    }

    public void initialize(HierarchyContext context, String name) {
        this.loadToModel = context.isLoadToModel();
        if (!this.loadToModel) {
            return;
        }
        super.initialize(context, name);
        this.fullInvoker = null;
    }

    public void startChild(String name) {
        if (!this.loadToModel) {
            return;
        }
        if (name.equals("InvocationContext")) {
            this.setNullInvocationContext();
            this.activeInvocationContext = true;
        } else {
            super.startChild(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processENI(int step) {
        super.processEF(step);
        this.theClass = this.getClassByIdRef(this.theThread, TRCFullTraceObjectImpl.class, 0);
        this.theMethod = this.getMethodByIdRef(this.theClass);
        this.fullInvocation = TraceFactory.eINSTANCE.createTRCFullMethodInvocation();
        this.fullInvocation.setStackDepth(this.stackDepth);
        this.fullInvocation.setEntryTime(this.createDeltaTime());
        this.fullInvocation.setTicket(this.ticket);
        this.fullInvocation.setMethod(this.theMethod);
        this.fullInvocation.setThread(this.theThread);
        this.fullInvocation.setProcess(this.theProcess);
        this.addInputOutputValues();
        Object object = REMOTE_INVOCATION_RESOLUTION_LOCK;
        synchronized (object) {
            this.setInvokerMethod(this.theThread, this.fullInvocation);
            this.updateForwardInvokes(this.fullInvocation);
        }
        if (this.cs.isEmpty()) {
            this.theThread.getInitialInvocations().add((Object)this.fullInvocation);
        }
        if (this.useUpdateStatisticalInfoOld) {
            this.updateStatisticalInfo(this.theThread, this.fullInvoker, this.fullInvocation, this.theMethod, (TRCFullTraceObject)this.theObject, this.theClass);
        } else {
            this.updateStatisticalInfoNew(this.theThread, this.fullInvoker, this.fullInvocation, this.theMethod, (TRCFullTraceObject)this.theObject, this.theClass);
        }
        this.cs.push(this.invocationPool.allocInvocation(this.fullInvocation, this.cs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEF(int step) {
        super.processEF(step);
        this.theClass = this.getClassByIdRef(this.theThread, TRCFullTraceObjectImpl.class, 0);
        this.theMethod = this.getMethodByIdRef(this.theClass);
        if (this.createClassObjects) {
            this.theObject = this.objIdRef > 0L ? this.getObjectByIdRef(this.objIdRef, TRCFullTraceObjectImpl.class) : this.getClassObject(this.theMethod.getDefiningClass(), TRCFullTraceObjectImpl.class);
            if (this.theObject == null) {
                this.theObject = TraceFactory.eINSTANCE.createTRCFullTraceObject();
            }
        }
        this.fullInvocation = TraceFactory.eINSTANCE.createTRCFullMethodInvocation();
        this.fullInvocation.setStackDepth(this.stackDepth);
        this.fullInvocation.setEntryTime(this.createDeltaTime());
        this.fullInvocation.setTicket(this.ticket);
        this.fullInvocation.setMethod(this.theMethod);
        this.fullInvocation.setThread(this.theThread);
        this.fullInvocation.setProcess(this.theProcess);
        this.fullInvocation.setOwningObject((TRCFullTraceObject)this.theObject);
        this.addInputOutputValues();
        Object object = REMOTE_INVOCATION_RESOLUTION_LOCK;
        synchronized (object) {
            this.setInvokerMethod(this.theThread, this.fullInvocation);
            this.updateForwardInvokes(this.fullInvocation);
        }
        if (this.cs.isEmpty()) {
            this.theThread.getInitialInvocations().add((Object)this.fullInvocation);
        }
        if (this.useUpdateStatisticalInfoOld) {
            this.updateStatisticalInfo(this.theThread, this.fullInvoker, this.fullInvocation, this.theMethod, (TRCFullTraceObject)this.theObject, this.theClass);
        } else {
            this.updateStatisticalInfoNew(this.theThread, this.fullInvoker, this.fullInvocation, this.theMethod, (TRCFullTraceObject)this.theObject, this.theClass);
        }
        this.cs.push(this.invocationPool.allocInvocation(this.fullInvocation, this.cs));
    }

    protected void processES(int step) {
        super.processES(step);
        this.theClass = this.getClassByIdRef(this.theThread, TRCFullTraceObjectImpl.class, 0);
        this.theMethod = this.getMethodByIdRef(this.theClass);
        if (this.createClassObjects) {
            if (this.objIdRef > 0L) {
                this.virtualObject = (VirtualObjectInfo)LookupServiceExtensions.getInstance().locate(this.context, VirtualObjectInfo.class, this.objIdRef);
                if (this.virtualObject != null) {
                    this.theObject = this.getClassObject(this.virtualObject.myClass, TRCFullTraceObjectImpl.class);
                }
            } else {
                this.theObject = this.getClassObject(this.theClass, TRCFullTraceObjectImpl.class);
            }
        }
        this.updateStatisticalInfoOnly(this.theMethod, (TRCFullTraceObject)this.theObject, this.theClass, this.theThread, this.createDeltaTime());
    }

    protected void updateStatisticalInfoNew(TRCThread aThread, TRCFullMethodInvocation invoker, TRCFullMethodInvocation invocation, TRCMethod aMethod, TRCFullTraceObject anObject, TRCClass aClass) {
        try {
            aMethod.setCalls(aMethod.getCalls() + 1);
            this.theProcess.setCalls(this.theProcess.getCalls() + 1);
            this.theProcess.setLastEventTime(invocation.getEntryTime());
            if (anObject != null) {
                anObject.setCalls(anObject.getCalls() + 1);
                this.invokerObjectClass = this.getExtendedClass(anObject, aClass);
                if (this.invokerObjectClass != null) {
                    this.invokerObjectClass.setInheritedCalls(this.invokerObjectClass.getInheritedCalls() + 1);
                    this.invokerObjectClass.getPackage().setInheritedCalls(this.invokerObjectClass.getPackage().getInheritedCalls() + 1);
                    this.invokerObjectClass.getPackage().getProcess().setInheritedCalls(this.invokerObjectClass.getPackage().getProcess().getInheritedCalls() + 1);
                }
            }
            aClass.setCalls(aClass.getCalls() + 1);
            aClass.getPackage().setCalls(aClass.getPackage().getCalls() + 1);
        }
        catch (Exception e) {
            ModelDebugger.log((Throwable)e);
        }
    }

    protected void updateStatisticalInfo(TRCThread aThread, TRCFullMethodInvocation invoker, TRCFullMethodInvocation invocation, TRCMethod aMethod, TRCFullTraceObject anObject, TRCClass aClass) {
        try {
            aMethod.setCalls(aMethod.getCalls() + 1);
            this.theProcess.setCalls(this.theProcess.getCalls() + 1);
            this.theProcess.setLastEventTime(invocation.getEntryTime());
            if (anObject != null) {
                anObject.setCalls(anObject.getCalls() + 1);
                this.invokerObjectClass = this.getExtendedClass(anObject, aClass);
                if (this.invokerObjectClass != null) {
                    this.invokerObjectClass.setInheritedCalls(this.invokerObjectClass.getInheritedCalls() + 1);
                    this.invokerObjectClass.getPackage().setInheritedCalls(this.invokerObjectClass.getPackage().getInheritedCalls() + 1);
                    this.invokerObjectClass.getPackage().getProcess().setInheritedCalls(this.invokerObjectClass.getPackage().getProcess().getInheritedCalls() + 1);
                }
            }
            aClass.setCalls(aClass.getCalls() + 1);
            aClass.getPackage().setCalls(aClass.getPackage().getCalls() + 1);
            if (invoker != null) {
                int size = invoker.getInvokes().size();
                if (size > 1) {
                    this.previousSiblingExitTime = ((TRCFullMethodInvocation)invoker.getInvokes().get(size - 2)).getExitTime();
                    this.deltaBaseTime = invocation.getEntryTime() - this.previousSiblingExitTime;
                } else {
                    this.deltaBaseTime = invocation.getEntryTime() - invoker.getEntryTime();
                }
                this.invokerObject = (TRCFullTraceObject)invoker.getOwningObject();
                this.invokerMethod = invoker.getMethod();
                this.invokerClass = invoker.getMethod().getDefiningClass();
                this.invokerObjectClass = this.getExtendedClass(this.invokerObject, this.invokerClass);
                this.updateTimeStatistics();
            }
        }
        catch (Exception e) {
            ModelDebugger.log((Throwable)e);
        }
    }

    private void updateStatisticalInfoOnly(TRCMethod aMethod, TRCFullTraceObject anObject, TRCClass aClass, TRCThread aThread, double entryTime) {
        TraceUtils.InvocationInfo invoker = null;
        if (!this.cs.isEmpty()) {
            invoker = (TraceUtils.InvocationInfo)this.cs.peek();
        }
        this.updateStatisticalInfoOnlyExtra(invoker, entryTime, aMethod, anObject, aClass);
        this.cs.push(this.invocationPool.allocInvocation(this.cs, anObject, aClass, aMethod, entryTime));
        this.theProcess.setCalls(this.theProcess.getCalls() + 1);
        this.theProcess.setLastEventTime(entryTime);
    }

    private void updateStatisticalInfoOnlyExtra(TraceUtils.InvocationInfo invoker, double entryTime, TRCMethod aMethod, TRCFullTraceObject anObject, TRCClass aClass) {
        try {
            aMethod.setCalls(aMethod.getCalls() + 1);
            if (anObject != null) {
                anObject.setCalls(anObject.getCalls() + 1);
                this.invokerObjectClass = this.getExtendedClass(anObject, aClass);
                if (this.invokerObjectClass != null) {
                    this.invokerObjectClass.setInheritedCalls(this.invokerObjectClass.getInheritedCalls() + 1);
                    this.invokerObjectClass.getPackage().setInheritedCalls(this.invokerObjectClass.getPackage().getInheritedCalls() + 1);
                    this.invokerObjectClass.getPackage().getProcess().setInheritedCalls(this.invokerObjectClass.getPackage().getProcess().getInheritedCalls() + 1);
                }
            }
            aClass.setCalls(aClass.getCalls() + 1);
            aClass.getPackage().setCalls(aClass.getPackage().getCalls() + 1);
            aClass.getPackage().getProcess().setCalls(aClass.getPackage().getProcess().getCalls() + 1);
            if (invoker != null) {
                this.previousSiblingExitTime = invoker.getLastChildExitTime();
                this.deltaBaseTime = this.previousSiblingExitTime > 0.0 ? entryTime - this.previousSiblingExitTime + invoker.getLastChildOverhead() : entryTime - invoker.getEntryTime();
                this.invokerObject = invoker.getObject();
                this.invokerClass = invoker.getTheClass();
                this.invokerObjectClass = invoker.getObjectClass();
                this.invokerMethod = invoker.getMethod();
                this.updateTimeStatistics();
            }
        }
        catch (Exception e) {
            ModelDebugger.log((Throwable)e);
        }
    }
}

