/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.loaders.trace.CallStackPerThread;
import org.eclipse.hyades.loaders.trace.TraceMethodBaseLoader;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.util.ModelDebugger;

public class XMLmethodExitLoader
extends TraceMethodBaseLoader {
    protected static final String OVERHEAD = "overhead";
    protected static final String CPU_TIME = "cpuTime";
    protected static final String CONSUMED_CPU_TIME = "consumedCpuTime";
    protected double overhead;
    protected double cpuTime;

    public void addAttribute(String name, String value) {
        if (!this.loadToModel) {
            return;
        }
        switch (LoadersUtils.getHashCode((String)name)) {
            case 529694900: {
                this.overhead = LoadersUtils.parseTraceTime((String)value);
                break;
            }
            case 985674901: 
            case 1624740749: {
                this.cpuTime = LoadersUtils.parseTraceTime((String)value);
                break;
            }
            default: {
                super.addAttribute(name, value);
            }
        }
    }

    public void addYourselfInContext() {
        if (!this.loadToModel) {
            return;
        }
        if (this.context.isFilterOn() && this.context.getFilterEngine().isFiltered((EStructuralFeature)TracePackage.eINSTANCE.getTRCMethod_Name(), LoadersUtils.getLookUpKey((int)this.methodIdRef))) {
            return;
        }
        this.cs = (CallStackPerThread)LookupServiceExtensions.getInstance().locate(this.context, CallStackPerThread.class, this.threadIdRef);
        if (this.cs == null || this.cs.isEmpty()) {
            return;
        }
        this.invocationPool = this.cs.invocationPool;
        this.theProcess = this.getProcess();
        this.dispatchProcessMode(0);
    }

    public void initialize(HierarchyContext context, String name) {
        this.loadToModel = context.isLoadToModel();
        if (!this.loadToModel) {
            return;
        }
        super.initialize(context, name);
        this.overhead = 0.0;
        this.cpuTime = 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEF(int step) {
        super.processEF(step);
        this.fullInvocation = ((TraceUtils.InvocationInfo)this.cs.peek()).getMethodInvocation();
        if (this.fullInvocation != null) {
            this.theThread = this.fullInvocation.getThread();
            this.fullInvocation.setExitTime(this.createDeltaTime());
            this.fullInvocation.setOverhead(this.overhead);
            this.addInputOutputValues();
            Object object = REMOTE_INVOCATION_RESOLUTION_LOCK;
            synchronized (object) {
                this.updateForwardInvokes(this.fullInvocation);
            }
            if (this.useUpdateStatisticalInfoOld) {
                this.updateStatisticalInfo();
            } else {
                this.updateStatisticalInfoNew();
            }
            this.invocationPool.release((TraceUtils.InvocationInfo)this.cs.pop());
        }
    }

    protected void processES(int step) {
        super.processES(step);
        this.updateStatisticalInfoOnly();
    }

    protected void updateStatisticalInfoNew() {
        try {
            double childrenCumulativTime = 0.0;
            int i = this.fullInvocation.getInvokes().size();
            while (i-- > 0) {
                TRCFullMethodInvocation element = (TRCFullMethodInvocation)this.fullInvocation.getInvokes().get(i);
                if (this.isAsynchronous(this.fullInvocation, element) || !(element.getExitTime() > 0.0)) continue;
                childrenCumulativTime = childrenCumulativTime + element.getExitTime() - element.getEntryTime() - element.getOverhead();
            }
            this.deltaBaseTime = this.fullInvocation.getExitTime() - this.fullInvocation.getEntryTime() - this.fullInvocation.getOverhead() - childrenCumulativTime;
            this.invokerMethod = this.fullInvocation.getMethod();
            this.invokerObject = (TRCFullTraceObject)this.fullInvocation.getOwningObject();
            this.invokerClass = this.fullInvocation.getMethod().getDefiningClass();
            this.invokerObjectClass = this.getExtendedClass(this.invokerObject, this.invokerClass);
            this.updateCPUTime();
            this.updateTimeStatistics();
            if (this.fullInvocation.getInvokedBy() != null && this.fullInvocation.eContainer() != this.fullInvocation.getInvokedBy().eContainer()) {
                this.updateBaseTimeIfRequired(this.fullInvocation, this.fullInvocation.getInvokedBy());
            }
        }
        catch (Exception e) {
            ModelDebugger.log((Throwable)e);
        }
    }

    private boolean isAsynchronous(TRCFullMethodInvocation parentInvocation, TRCFullMethodInvocation childInvocation) {
        String childInvocationHost;
        String parentInvocationHost = parentInvocation.getThread().getProcess().getAgent().getAgentProxy().getProcessProxy().getNode().getName();
        if (parentInvocationHost.equalsIgnoreCase(childInvocationHost = childInvocation.getThread().getProcess().getAgent().getAgentProxy().getProcessProxy().getNode().getName())) {
            if (parentInvocation.getThread().getId() == childInvocation.getThread().getId()) {
                return false;
            }
            TRCAgent parentAgent = parentInvocation.getThread().getProcess().getAgent();
            TRCAgent childAgent = childInvocation.getInvokedBy().getThread().getProcess().getAgent();
            return parentAgent.getRuntimeId() == childAgent.getRuntimeId();
        }
        return true;
    }

    protected void updateStatisticalInfo() {
        try {
            int size = this.fullInvocation.getInvokes().size();
            if (size > 0) {
                this.lastChildExitTime = ((TRCFullMethodInvocation)this.fullInvocation.getInvokes().get(size - 1)).getExitTime();
                this.deltaBaseTime = this.fullInvocation.getExitTime() - this.lastChildExitTime - this.fullInvocation.getOverhead();
            } else {
                this.deltaBaseTime = this.fullInvocation.getExitTime() - this.fullInvocation.getEntryTime() - this.fullInvocation.getOverhead();
            }
            this.invokerMethod = this.fullInvocation.getMethod();
            this.invokerObject = (TRCFullTraceObject)this.fullInvocation.getOwningObject();
            this.invokerClass = this.fullInvocation.getMethod().getDefiningClass();
            this.invokerObjectClass = this.getExtendedClass(this.invokerObject, this.invokerClass);
            this.updateCPUTime();
            this.updateTimeStatistics();
        }
        catch (Exception e) {
            ModelDebugger.log((Throwable)e);
        }
    }

    protected void updateCPUTime() {
        if (this.cpuTime != 0.0) {
            try {
                double correctedCPUTime = this.cpuTime;
                if (this.fullInvocation != null) {
                    this.fullInvocation.setCpuTime(correctedCPUTime);
                }
                this.invokerMethod.setTotalCpuTime(this.invokerMethod.getTotalCpuTime() + correctedCPUTime);
                this.invokerClass.setTotalCpuTime(this.invokerClass.getTotalCpuTime() + correctedCPUTime);
                this.invokerClass.getPackage().setTotalCpuTime(this.invokerClass.getPackage().getTotalCpuTime() + correctedCPUTime);
                this.getProcess().setTotalCpuTime(this.getProcess().getTotalCpuTime() + correctedCPUTime);
            }
            catch (Exception e) {
                ModelDebugger.log((Throwable)e);
            }
        }
    }

    protected void updateStatisticalInfoOnly() {
        try {
            TraceUtils.InvocationInfo invoker;
            TraceUtils.InvocationInfo currentInvocation = (TraceUtils.InvocationInfo)this.cs.peek();
            double exitTime = this.createDeltaTime();
            this.lastChildExitTime = currentInvocation.getLastChildExitTime();
            double lastChildOverhead = currentInvocation.getLastChildOverhead();
            this.deltaBaseTime = this.lastChildExitTime > 0.0 ? exitTime - this.lastChildExitTime - this.overhead + lastChildOverhead : exitTime - currentInvocation.getEntryTime() - this.overhead;
            this.invokerObject = currentInvocation.getObject();
            this.invokerClass = currentInvocation.getTheClass();
            this.invokerObjectClass = currentInvocation.getObjectClass();
            this.invokerMethod = currentInvocation.getMethod();
            this.updateCPUTime();
            this.updateTimeStatistics();
            this.invocationPool.release((TraceUtils.InvocationInfo)this.cs.pop());
            if (!this.cs.isEmpty() && (invoker = (TraceUtils.InvocationInfo)this.cs.peek()) != null) {
                invoker.setLastChildExitTime(exitTime);
                invoker.setLastChildOverhead(this.overhead);
            }
            this.theProcess.setLastEventTime(exitTime);
        }
        catch (Exception e) {
            ModelDebugger.log((Throwable)e);
        }
    }
}

