/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.loaders.trace.ThreadEventsContext;
import org.eclipse.hyades.loaders.trace.XMLmonWaitLoader;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadDeadAndNotifyJoinedEvent;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadInterruptThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadNotifyAllEvent;
import org.eclipse.hyades.models.trace.TRCThreadNotifyEvent;
import org.eclipse.hyades.models.trace.TRCThreadRunningEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitTimeoutExceedEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForJoinEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;

public class XMLmonWaitedLoader
extends XMLmonWaitLoader {
    protected static final String IS_TIMED_OUT = "isTimedOut";
    protected boolean isTimedOut = false;

    public void addAttribute(String name, String value) {
        switch (LoadersUtils.getHashCode((String)name)) {
            case 1424783329: {
                this.isTimedOut = value.equals("1");
                break;
            }
            default: {
                super.addAttribute(name, value);
            }
        }
    }

    public void addYourselfInContext() {
        if (this.context.isFilterOn() && this.context.getFilterEngine().isFiltered((EStructuralFeature)TracePackage.eINSTANCE.getTRCThread_Name(), LoadersUtils.getLookUpKey((int)this.threadIdRef))) {
            return;
        }
        this.theProcess = this.getProcess();
        this.theThread = this.getThreadByIdRef(this.theProcess);
        this.dispatchProcessMode(0);
        TRCThreadRunningEvent runningEvent = TraceFactory.eINSTANCE.createTRCThreadRunningEvent();
        runningEvent.setTime(this.createDeltaTime());
        this.addAnnotationsIfRequired(runningEvent);
        if (this.isTimedOut) {
            TRCThreadWaitTimeoutExceedEvent timeoutEvent = TraceFactory.eINSTANCE.createTRCThreadWaitTimeoutExceedEvent();
            timeoutEvent.setTime(this.createDeltaTime());
            this.theThread.getThreadEvents().add((Object)timeoutEvent);
            this.theThread.getThreadEvents().add((Object)runningEvent);
        } else {
            TRCThreadNotifyAllEvent notifyAllEvent;
            TRCThreadDeadAndNotifyJoinedEvent deadNotifyEvent;
            this.theThread.getThreadEvents().add((Object)runningEvent);
            ThreadEventsContext threadEventsContext = this.getThreadEventsContext();
            TRCThreadInterruptThreadEvent interruptEvent = (TRCThreadInterruptThreadEvent)threadEventsContext.getThread2InterruptionMap().get(this.theThread);
            if (interruptEvent != null && this.canEventsBeBound(runningEvent, interruptEvent)) {
                interruptEvent.getRunningEvents().add((Object)runningEvent);
                threadEventsContext.getThread2InterruptionMap().remove(this.theThread);
                return;
            }
            TRCThread threadObject = (TRCThread)threadEventsContext.getObject2ThreadMap().get(this.theObject);
            if (threadObject != null && (deadNotifyEvent = (TRCThreadDeadAndNotifyJoinedEvent)threadEventsContext.getThread2ThreadDeadNotifyEventMap().get(threadObject)) != null && this.canEventsBeBound(runningEvent, deadNotifyEvent)) {
                deadNotifyEvent.getRunningEvents().add((Object)runningEvent);
                TRCThreadWaitingForObjectEvent lastWaitForObjEvent = null;
                int objectPos = -1;
                int x = this.theThread.getThreadEvents().size() - 1;
                while (x >= 0 && x >= this.theThread.getThreadEvents().size() - 3) {
                    TRCThreadEvent te = (TRCThreadEvent)this.theThread.getThreadEvents().get(x);
                    if (te instanceof TRCThreadWaitingForObjectEvent) {
                        lastWaitForObjEvent = (TRCThreadWaitingForObjectEvent)te;
                        objectPos = x;
                        break;
                    }
                    --x;
                }
                if (objectPos != -1 && lastWaitForObjEvent != null && this.theThread.getThreadEvents().size() - objectPos <= 3) {
                    TRCThreadWaitingForJoinEvent waitJoinEvent = TraceFactory.eINSTANCE.createTRCThreadWaitingForJoinEvent();
                    TRCThreadWaitingForObjectEvent waitNotifyEvent = (TRCThreadWaitingForObjectEvent)this.theThread.getThreadEvents().set(objectPos, (Object)waitJoinEvent);
                    waitJoinEvent.setObjectWaitingFor(waitNotifyEvent.getObjectWaitingFor());
                    waitJoinEvent.setThread(waitNotifyEvent.getThread());
                    waitJoinEvent.setTime(waitNotifyEvent.getTime());
                    waitJoinEvent.setTimeout(waitNotifyEvent.getTimeout());
                    waitJoinEvent.getAnnotations().addAll(waitNotifyEvent.getAnnotations());
                }
                return;
            }
            List notifyEventList = (List)threadEventsContext.getMonitor2NotifyMap().get(this.theObject);
            if (notifyEventList != null) {
                for (TRCThreadNotifyEvent notifyEvent : notifyEventList) {
                    if (!this.canEventsBeBound(runningEvent, notifyEvent)) continue;
                    notifyEvent.getRunningEvents().add((Object)runningEvent);
                    notifyEventList.remove(notifyEvent);
                    if (notifyEventList.isEmpty()) {
                        threadEventsContext.getMonitor2NotifyMap().remove(this.theObject);
                    }
                    return;
                }
            }
            if ((notifyAllEvent = (TRCThreadNotifyAllEvent)threadEventsContext.getMonitor2NotifyAllMap().get(this.theObject)) != null) {
                double waitEventTime = ((TRCThreadEvent)this.theThread.getThreadEvents().get(this.theThread.getThreadEvents().size() - 2)).getTime();
                if (waitEventTime < notifyAllEvent.getTime()) {
                    for (TRCThreadRunningEvent threadRE : notifyAllEvent.getRunningEvents()) {
                        TRCThread reThread = threadRE.getThread();
                        if (reThread == null || !reThread.equals(this.theObject)) continue;
                        return;
                    }
                }
                if (this.canEventsBeBound(runningEvent, notifyAllEvent)) {
                    notifyAllEvent.getRunningEvents().add((Object)runningEvent);
                }
            }
        }
    }
}

