/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.loaders.trace.ThreadSleepStartEntry;
import org.eclipse.hyades.loaders.trace.TraceXMLThreadEventsLoader;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadInterruptThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadRunningEvent;
import org.eclipse.hyades.models.trace.TRCThreadSleepingEvent;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;

public class XMLthreadInterruptCalledLoader
extends TraceXMLThreadEventsLoader {
    private TRCThreadSleepingEvent createThreadSleepingEvent(TRCThread interruptedThread) {
        ThreadSleepStartEntry lastEntry = null;
        List sleepData = this.getThreadEventsContext().getThreadSleepData(interruptedThread.getId());
        if (sleepData == null) {
            return null;
        }
        for (Object o : sleepData) {
            if (!(o instanceof ThreadSleepStartEntry)) continue;
            lastEntry = (ThreadSleepStartEntry)o;
        }
        if (lastEntry == null) {
            return null;
        }
        sleepData.remove(lastEntry);
        TRCThreadSleepingEvent sleepingEvent = TraceFactory.eINSTANCE.createTRCThreadSleepingEvent();
        long sleepTimeInMsecs = (long)((this.time - lastEntry.getThreadSleepStartTime()) * 1000.0);
        sleepingEvent.setSleepingTime((int)sleepTimeInMsecs);
        sleepingEvent.setTime(lastEntry.getThreadSleepStartTime() - this.getZeroTime());
        sleepingEvent.setThread(interruptedThread);
        this.addAnnotationsIfRequired(sleepingEvent);
        return sleepingEvent;
    }

    public void addYourselfInContext() {
        TRCThreadSleepingEvent sleepEvent;
        if (this.context.isFilterOn() && this.context.getFilterEngine().isFiltered((EStructuralFeature)TracePackage.eINSTANCE.getTRCThread_Name(), LoadersUtils.getLookUpKey((int)this.threadIdRef))) {
            return;
        }
        this.theProcess = this.getProcess();
        this.theThread = this.getThreadByIdRef(this.theProcess);
        this.dispatchProcessMode(0);
        TRCThread interruptedThread = (TRCThread)this.getThreadEventsContext().getObject2ThreadMap().get(this.theObject);
        if (interruptedThread != null && (sleepEvent = this.createThreadSleepingEvent(interruptedThread)) != null) {
            interruptedThread.getThreadEvents().add((Object)sleepEvent);
            TRCThreadRunningEvent runningEvent = TraceFactory.eINSTANCE.createTRCThreadRunningEvent();
            runningEvent.setTime(this.createDeltaTime());
            this.addAnnotationsIfRequired(runningEvent);
            interruptedThread.getThreadEvents().add((Object)runningEvent);
        }
        TRCThreadInterruptThreadEvent interruptEvent = TraceFactory.eINSTANCE.createTRCThreadInterruptThreadEvent();
        interruptEvent.setInterruptedThread(interruptedThread);
        interruptEvent.setTime(this.createDeltaTime());
        this.addAnnotationsIfRequired(interruptEvent);
        this.addInteractionEvent(this.theThread, interruptEvent);
        this.getThreadEventsContext().getThread2InterruptionMap().put(interruptedThread, interruptEvent);
    }
}

