/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.common.impl;

import java.io.IOException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.models.common.common.CMNAnnotation;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.common.CommonPackage;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.facades.behavioral.IAnnotatableResource;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;

public class CMNAnnotationImpl
extends CMNNamedElementImpl
implements CMNAnnotation {
    protected static final String URI_EDEFAULT = null;
    protected String uri = URI_EDEFAULT;
    protected static final String TYPE_EDEFAULT = null;
    protected String type = TYPE_EDEFAULT;
    public static final String ANNOTATION_QUERY = "annotationID=/";

    protected CMNAnnotationImpl() {
    }

    protected EClass eStaticClass() {
        return CommonPackage.Literals.CMN_ANNOTATION;
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String newURI) {
        String oldURI = this.uri;
        this.uri = newURI;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldURI, (Object)this.uri));
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String newType) {
        String oldType = this.type;
        this.type = newType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldType, (Object)this.type));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getURI();
            }
            case 4: {
                return this.getType();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setURI((String)newValue);
                return;
            }
            case 4: {
                this.setType((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setURI(URI_EDEFAULT);
                return;
            }
            case 4: {
                this.setType(TYPE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return URI_EDEFAULT == null ? this.uri != null : !URI_EDEFAULT.equals(this.uri);
            }
            case 4: {
                return TYPE_EDEFAULT == null ? this.type != null : !TYPE_EDEFAULT.equals(this.type);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (URI: ");
        result.append(this.uri);
        result.append(", type: ");
        result.append(this.type);
        result.append(')');
        return result.toString();
    }

    public URI getFileAnnotation() throws UnsupportedOperationException, IOException {
        if (!this.isFileAnnotation()) {
            throw new UnsupportedOperationException("Annotation is not a File Annotation " + this.toString());
        }
        if (!(this.eResource() instanceof IAnnotatableResource)) {
            throw new UnsupportedOperationException("Resource is not supported by an IAnnotatableResource");
        }
        return ((IAnnotatableResource)this.eResource()).getFileAnnotation(this);
    }

    public boolean isFileAnnotation() {
        if (!(this.eResource() instanceof IAnnotatableResource)) {
            throw new UnsupportedOperationException("Resource is not supported by an IAnnotatableResource");
        }
        return ((IAnnotatableResource)this.eResource()).isFileAnnotation(this);
    }

    private URI queryURItoRelativeURI(URI uri) {
        if (uri.hasQuery()) {
            String query = uri.query();
            String uriString = query.replaceFirst(ANNOTATION_QUERY, "");
            uri = URI.createURI((String)uriString);
        }
        return uri;
    }

    private URI relativeURItoQueryURI(URI uri) {
        if (!uri.hasQuery()) {
            String queryString = ANNOTATION_QUERY + uri.toString();
            uri = URI.createHierarchicalURI(null, null, null, (String)queryString, null);
        }
        return uri;
    }

    public void putFileAnnotation(URI file) throws UnsupportedOperationException, IOException {
        if (!(this.eResource() instanceof IAnnotatableResource)) {
            throw new UnsupportedOperationException("Resource is not supported by an IAnnotatableResource");
        }
        ((IAnnotatableResource)this.eResource()).putFileAnnotation(file, this);
    }

    private String getContainerID() throws UnsupportedOperationException {
        String containerID;
        EObject container = this.eContainer();
        if (container == null) {
            throw new UnsupportedOperationException("FileAnnotation must be contained in a model element");
        }
        if (container instanceof CMNNamedElement) {
            CMNNamedElement con = (CMNNamedElement)container;
            containerID = con.getId();
        } else if (container instanceof TPFExecutionEvent) {
            TPFExecutionEvent con = (TPFExecutionEvent)container;
            containerID = con.getId();
        } else {
            throw new UnsupportedOperationException("Annotations not supported for container of type " + container);
        }
        return containerID;
    }

    public void removeFileAnnotation() throws UnsupportedOperationException, IOException {
        if (!(this.eResource() instanceof IAnnotatableResource)) {
            throw new UnsupportedOperationException("Resource is not supported by an IAnnotatableResource");
        }
        try {
            ((IAnnotatableResource)this.eResource()).removeFileAnnotation(this);
        }
        finally {
            this.setURI(URI_EDEFAULT);
        }
    }
}

