/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.configuration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CFGCategorySelectionMode implements Enumerator
{
    ENTER_VALUE_LITERAL(0, "enterValue", "enterValue"),
    SELECT_AND_ENTER_VALUE_LITERAL(1, "selectAndEnterValue", "selectAndEnterValue"),
    SELECT_VALUE_LITERAL(2, "selectValue", "selectValue"),
    PASSWORD_LITERAL(3, "password", "password");

    public static final int ENTER_VALUE = 0;
    public static final int SELECT_AND_ENTER_VALUE = 1;
    public static final int SELECT_VALUE = 2;
    public static final int PASSWORD = 3;
    private static final CFGCategorySelectionMode[] VALUES_ARRAY;
    public static final List<CFGCategorySelectionMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CFGCategorySelectionMode[]{ENTER_VALUE_LITERAL, SELECT_AND_ENTER_VALUE_LITERAL, SELECT_VALUE_LITERAL, PASSWORD_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CFGCategorySelectionMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CFGCategorySelectionMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CFGCategorySelectionMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CFGCategorySelectionMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CFGCategorySelectionMode get(int value) {
        switch (value) {
            case 0: {
                return ENTER_VALUE_LITERAL;
            }
            case 1: {
                return SELECT_AND_ENTER_VALUE_LITERAL;
            }
            case 2: {
                return SELECT_VALUE_LITERAL;
            }
            case 3: {
                return PASSWORD_LITERAL;
            }
        }
        return null;
    }

    private CFGCategorySelectionMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

