/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.datapool.impl;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType;
import org.eclipse.hyades.execution.runtime.datapool.DatapoolException;
import org.eclipse.hyades.execution.runtime.datapool.IDatapool;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolIterator;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolFactory;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage;
import org.eclipse.hyades.models.common.datapool.DPLCell;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.DPLDatapoolSpec;
import org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass;
import org.eclipse.hyades.models.common.datapool.DPLRecord;
import org.eclipse.hyades.models.common.datapool.DPLRole;
import org.eclipse.hyades.models.common.datapool.DPLVariable;
import org.eclipse.hyades.models.common.datapool.impl.DPLCellImpl;
import org.eclipse.hyades.models.common.datapool.impl.DPLDatapoolImpl;
import org.eclipse.hyades.models.common.datapool.impl.DPLDatapoolSpecImpl;
import org.eclipse.hyades.models.common.datapool.impl.DPLEquivalenceClassImpl;
import org.eclipse.hyades.models.common.datapool.impl.DPLLogImpl;
import org.eclipse.hyades.models.common.datapool.impl.DPLRecordImpl;
import org.eclipse.hyades.models.common.datapool.impl.DPLVariableImpl;
import org.eclipse.hyades.models.common.datapool.impl.DatapoolSuggestedTypeImpl;
import org.eclipse.hyades.models.common.datapool.impl.Messages;
import org.eclipse.hyades.models.common.facades.behavioral.impl.FacadeResourceFactoryImpl;

public class Common_DatapoolFactoryImpl
extends EFactoryImpl
implements Common_DatapoolFactory {
    private static HashMap datapoolsOpen = new HashMap();
    private static HashMap datapoolRefCounts = new HashMap();

    public static Common_DatapoolFactory init() {
        try {
            Common_DatapoolFactory theCommon_DatapoolFactory = (Common_DatapoolFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/hyades/models/common/datapool.xmi");
            if (theCommon_DatapoolFactory != null) {
                return theCommon_DatapoolFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new Common_DatapoolFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createDPLDatapoolSpec();
            }
            case 1: {
                return this.createDPLEquivalenceClass();
            }
            case 2: {
                return this.createDPLRecord();
            }
            case 3: {
                return this.createDPLCell();
            }
            case 4: {
                return this.createDPLVariable();
            }
            case 5: {
                return this.createDPLDatapool();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.createDPLRoleFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.convertDPLRoleToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public DPLDatapoolSpec createDPLDatapoolSpec() {
        DPLDatapoolSpecImpl dplDatapoolSpec = new DPLDatapoolSpecImpl();
        return dplDatapoolSpec;
    }

    public DPLDatapool createDPLDatapool() {
        DPLDatapoolImpl dplDatapool = new DPLDatapoolImpl();
        return dplDatapool;
    }

    public DPLRole createDPLRoleFromString(EDataType eDataType, String initialValue) {
        DPLRole result = DPLRole.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertDPLRoleToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public DPLEquivalenceClass createDPLEquivalenceClass() {
        DPLEquivalenceClassImpl dplEquivalenceClass = new DPLEquivalenceClassImpl();
        return dplEquivalenceClass;
    }

    public DPLRecord createDPLRecord() {
        DPLRecordImpl dplRecord = new DPLRecordImpl();
        return dplRecord;
    }

    public DPLCell createDPLCell() {
        DPLCellImpl dplCell = new DPLCellImpl();
        return dplCell;
    }

    public DPLVariable createDPLVariable() {
        DPLVariableImpl dplVariable = new DPLVariableImpl();
        return dplVariable;
    }

    public Common_DatapoolPackage getCommon_DatapoolPackage() {
        return (Common_DatapoolPackage)this.getEPackage();
    }

    @Deprecated
    public static Common_DatapoolPackage getPackage() {
        return Common_DatapoolPackage.eINSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.eclipse.hyades.edit.datapool.IDatapool loadForEdit(File dpFile, boolean sharedInstance) {
        Common_DatapoolFactoryImpl common_DatapoolFactoryImpl = this;
        synchronized (common_DatapoolFactoryImpl) {
            FacadeResourceFactoryImpl.initializeRequisiteModels();
            String dpAbsolutePath = dpFile.getAbsolutePath();
            org.eclipse.hyades.edit.datapool.IDatapool dp = (org.eclipse.hyades.edit.datapool.IDatapool)datapoolsOpen.get(dpAbsolutePath);
            if (!sharedInstance || sharedInstance && dp == null) {
                if (!dpFile.exists()) {
                    throw new DatapoolException(Messages.getString("Common_DatapoolFactoryImpl.29", dpAbsolutePath));
                }
                if (dpFile.length() == 0L) {
                    throw new DatapoolException(Messages.getString("Common_DatapoolFactoryImpl.30", dpAbsolutePath));
                }
                try {
                    DPLLogImpl.log("Load file: " + dpAbsolutePath);
                    Resource resource = new ResourceSetImpl().getResource(URI.createFileURI((String)dpAbsolutePath), true);
                    resource.load(null);
                    org.eclipse.hyades.edit.datapool.IDatapool datapool = (org.eclipse.hyades.edit.datapool.IDatapool)resource.getContents().get(0);
                    if (sharedInstance) {
                        DPLLogImpl.log("Datapool cached, refCount = 1");
                        datapoolsOpen.put(dpAbsolutePath, datapool);
                        datapoolRefCounts.put(dpAbsolutePath, new Integer(1));
                    }
                    ((DPLDatapoolImpl)datapool).setAbsoluteFilePathname(dpAbsolutePath);
                    return datapool;
                }
                catch (WrappedException w) {
                    throw new DatapoolException(Messages.getString("Common_DatapoolFactoryImpl.21", dpAbsolutePath), w.getCause());
                }
                catch (Throwable t) {
                    throw new DatapoolException(Messages.getString("Common_DatapoolFactoryImpl.21", dpAbsolutePath), t);
                }
            }
            Integer refCount = (Integer)datapoolRefCounts.remove(dpAbsolutePath);
            Integer newRefCount = new Integer(refCount + 1);
            DPLLogImpl.log("Refcount: " + newRefCount);
            datapoolRefCounts.put(dpAbsolutePath, newRefCount);
            return dp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(org.eclipse.hyades.edit.datapool.IDatapool datapool) {
        String dpAbsolutePath = ((DPLDatapoolImpl)datapool).getAbsoluteFilePathname();
        Common_DatapoolFactoryImpl common_DatapoolFactoryImpl = this;
        synchronized (common_DatapoolFactoryImpl) {
            Integer refCount = (Integer)datapoolRefCounts.remove(dpAbsolutePath);
            if (refCount != null && refCount > 1) {
                Integer newRefCount = new Integer(refCount - 1);
                DPLLogImpl.log("Refcount: " + newRefCount);
                datapoolRefCounts.put(dpAbsolutePath, newRefCount);
            } else if (refCount != null && refCount == 1) {
                DPLLogImpl.log("datapool uncached");
                datapoolsOpen.remove(dpAbsolutePath);
            }
        }
    }

    public void save(org.eclipse.hyades.edit.datapool.IDatapool datapool) {
        this.saveAs(datapool, new File(((DPLDatapoolImpl)datapool).getAbsoluteFilePathname()));
    }

    public void saveAs(org.eclipse.hyades.edit.datapool.IDatapool datapool, File dpFile) {
        String dpAbsolutePath = dpFile.getAbsolutePath();
        try {
            DPLLogImpl.log("Save file: " + dpAbsolutePath);
            Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
            Map m = reg.getExtensionToFactoryMap();
            m.put("xmi", new XMIResourceFactoryImpl());
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry();
            Resource res = resourceSet.createResource(URI.createFileURI((String)dpAbsolutePath));
            res.getContents().add((Object)((EObject)datapool));
            res.save(Collections.EMPTY_MAP);
        }
        catch (WrappedException w) {
            throw new DatapoolException(Messages.getString("Common_DatapoolFactoryImpl.27", dpAbsolutePath), w.getCause());
        }
        catch (Throwable t) {
            throw new DatapoolException(Messages.getString("Common_DatapoolFactoryImpl.27", dpAbsolutePath), t);
        }
    }

    public IDatapool load(File dpFile, boolean sharedInstance) {
        return this.loadForEdit(dpFile, sharedInstance);
    }

    public void unload(IDatapool datapool) {
        this.unload((org.eclipse.hyades.edit.datapool.IDatapool)datapool);
    }

    public IDatapoolIterator open(IDatapool datapool, String iteratorExtensionId) {
        IDatapoolIterator myIterator = null;
        Class<?> myIteratorClass = null;
        try {
            IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.tptp.platform.models.datapool_iterator");
            DPLLogImpl.log("iterator ext point found!!!");
            IExtension[] extensions = extPoint.getExtensions();
            DPLLogImpl.log("extensions.length: " + extensions.length);
            int i = 0;
            boolean found = false;
            while (!found && i < extensions.length) {
                IExtension currentExtension = extensions[i];
                DPLLogImpl.log("   extension:" + currentExtension.getUniqueIdentifier());
                if (iteratorExtensionId.equals(currentExtension.getUniqueIdentifier())) {
                    IConfigurationElement[] configElements = currentExtension.getConfigurationElements();
                    DPLLogImpl.log("configElements.length : " + configElements.length);
                    IConfigurationElement currentConfigElement = configElements[0];
                    myIterator = (IDatapoolIterator)currentConfigElement.createExecutableExtension("class");
                    DPLLogImpl.log("iterator: " + myIterator.toString());
                    myIteratorClass = myIterator.getClass();
                    found = true;
                    continue;
                }
                ++i;
            }
            if (!found) {
                throw new DatapoolException();
            }
        }
        catch (Throwable throwable) {
            try {
                myIteratorClass = Class.forName(iteratorExtensionId);
            }
            catch (Throwable throwable2) {
                throw new DatapoolException(Messages.getString("Common_DatapoolFactoryImpl.23", iteratorExtensionId));
            }
        }
        try {
            Method getInstanceMethod = myIteratorClass.getMethod("getInstance", new Class[0]);
            return (IDatapoolIterator)getInstanceMethod.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Constructor<?> ctor = myIteratorClass.getConstructor(new Class[0]);
                return (IDatapoolIterator)ctor.newInstance(new Object[0]);
            }
            catch (Throwable t) {
                throw new DatapoolException(Messages.getString("Common_DatapoolFactoryImpl.25", iteratorExtensionId), t);
            }
        }
        catch (Throwable t) {
            throw new DatapoolException(Messages.getString("Common_DatapoolFactoryImpl.25", iteratorExtensionId), t);
        }
    }

    public void close(IDatapoolIterator iterator) {
        try {
            Method closeMethod = iterator.getClass().getMethod("close", new Class[0]);
            closeMethod.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Throwable t) {
            throw new DatapoolException(Messages.getString("Common_DatapoolFactoryImpl.28"), t);
        }
    }

    public IDatapoolSuggestedType createDatapoolSuggestedType() {
        return new DatapoolSuggestedTypeImpl();
    }

    public org.eclipse.hyades.edit.datapool.IDatapool constructDatapool() {
        DPLDatapoolImpl datapool = new DPLDatapoolImpl();
        DPLDatapoolSpecImpl datapoolSpec = new DPLDatapoolSpecImpl();
        datapool.setDatapoolSpec(datapoolSpec);
        return datapool;
    }
}

