/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.datapool.impl;

import java.util.Collection;
import java.util.ListIterator;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.edit.datapool.IDatapoolListener;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable;
import org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolFactory;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage;
import org.eclipse.hyades.models.common.datapool.DPLCell;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.DPLDatapoolSpec;
import org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass;
import org.eclipse.hyades.models.common.datapool.DPLRecord;
import org.eclipse.hyades.models.common.datapool.DPLVariable;
import org.eclipse.hyades.models.common.datapool.impl.DPLLogImpl;
import org.eclipse.hyades.models.common.datapool.impl.DPLRecordImpl;
import org.eclipse.hyades.models.common.datapool.impl.DatapoolSuggestedTypeImpl;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.util.DatapoolUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DPLDatapoolImpl
extends CFGClassImpl
implements DPLDatapool {
    protected static final String CHALLENGE_EDEFAULT = null;
    protected String challenge = CHALLENGE_EDEFAULT;
    protected EList<DPLEquivalenceClass> equivalenceClasses;
    protected DPLDatapoolSpec datapoolSpec;
    protected int defaultEquivalenceClass = 0;
    protected ListenerList listenerList = new ListenerList();
    String absoluteFilePathname;

    protected DPLDatapoolImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return Common_DatapoolPackage.Literals.DPL_DATAPOOL;
    }

    @Override
    public String getChallenge() {
        return this.challenge;
    }

    @Override
    public void setChallenge(String newChallenge) {
        String oldChallenge = this.challenge;
        this.challenge = newChallenge;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldChallenge, (Object)this.challenge));
        }
    }

    @Override
    public EList<DPLEquivalenceClass> getEquivalenceClasses() {
        if (this.equivalenceClasses == null) {
            this.equivalenceClasses = new EObjectContainmentEList(DPLEquivalenceClass.class, (InternalEObject)this, 7);
        }
        return this.equivalenceClasses;
    }

    @Override
    public DPLDatapoolSpec getDatapoolSpec() {
        return this.datapoolSpec;
    }

    public NotificationChain basicSetDatapoolSpec(DPLDatapoolSpec newDatapoolSpec, NotificationChain msgs) {
        DPLDatapoolSpec oldDatapoolSpec = this.datapoolSpec;
        this.datapoolSpec = newDatapoolSpec;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldDatapoolSpec, (Object)newDatapoolSpec);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setDatapoolSpec(DPLDatapoolSpec newDatapoolSpec) {
        if (newDatapoolSpec != this.datapoolSpec) {
            NotificationChain msgs = null;
            if (this.datapoolSpec != null) {
                msgs = ((InternalEObject)this.datapoolSpec).eInverseRemove((InternalEObject)this, -9, null, msgs);
            }
            if (newDatapoolSpec != null) {
                msgs = ((InternalEObject)newDatapoolSpec).eInverseAdd((InternalEObject)this, -9, null, msgs);
            }
            if ((msgs = this.basicSetDatapoolSpec(newDatapoolSpec, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)newDatapoolSpec, (Object)newDatapoolSpec));
        }
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                return ((InternalEList)this.getEquivalenceClasses()).basicRemove((Object)otherEnd, msgs);
            }
            case 8: {
                return this.basicSetDatapoolSpec(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 6: {
                return this.getChallenge();
            }
            case 7: {
                return this.getEquivalenceClasses();
            }
            case 8: {
                return this.getDatapoolSpec();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 6: {
                this.setChallenge((String)newValue);
                return;
            }
            case 7: {
                this.getEquivalenceClasses().clear();
                this.getEquivalenceClasses().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.setDatapoolSpec((DPLDatapoolSpec)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 6: {
                this.setChallenge(CHALLENGE_EDEFAULT);
                return;
            }
            case 7: {
                this.getEquivalenceClasses().clear();
                return;
            }
            case 8: {
                this.setDatapoolSpec(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 6: {
                return CHALLENGE_EDEFAULT == null ? this.challenge != null : !CHALLENGE_EDEFAULT.equals(this.challenge);
            }
            case 7: {
                return this.equivalenceClasses != null && !this.equivalenceClasses.isEmpty();
            }
            case 8: {
                return this.datapoolSpec != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (challenge: ");
        result.append(this.challenge);
        result.append(')');
        return result.toString();
    }

    @Override
    public String getLocation() {
        return null;
    }

    @Override
    public ITest getOwner() {
        return null;
    }

    @Override
    public String getResource() {
        return null;
    }

    @Override
    public void setLocation(String location) {
    }

    @Override
    public void setResource(String resource) {
    }

    @Override
    public void updateVariable(org.eclipse.hyades.edit.datapool.IDatapoolVariable variable, int variableIndex) {
        this.removeVariableDoNotNotify(variableIndex);
        this.insertVariableDoNotNotify(variable, variableIndex);
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IDatapoolListener)listeners[i]).variableChanged(this, variableIndex);
            ++i;
        }
    }

    @Override
    public void insertVariable(org.eclipse.hyades.edit.datapool.IDatapoolVariable variable, int beforeVariableIndex) {
        this.insertVariableDoNotNotify(variable, beforeVariableIndex);
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IDatapoolListener)listeners[i]).variableAdded(this, beforeVariableIndex);
            ++i;
        }
    }

    protected void insertVariableDoNotNotify(org.eclipse.hyades.edit.datapool.IDatapoolVariable variable, int beforeVariableIndex) {
        this.getDatapoolSpec().getVariables().add(beforeVariableIndex, (Object)((DPLVariable)variable));
        ListIterator ecIter = this.getEquivalenceClasses().listIterator();
        while (ecIter.hasNext()) {
            DPLEquivalenceClass ec = (DPLEquivalenceClass)ecIter.next();
            ListIterator recIter = ec.getRecords().listIterator();
            while (recIter.hasNext()) {
                DPLRecord rec = (DPLRecord)recIter.next();
                DPLCell newCell = Common_DatapoolFactory.eINSTANCE.createDPLCell();
                newCell.setVariable((DPLVariable)variable);
                ((DPLRecordImpl)rec).insertCell(newCell, beforeVariableIndex);
            }
        }
    }

    @Override
    public void appendVariable(org.eclipse.hyades.edit.datapool.IDatapoolVariable variable) {
        this.insertVariable(variable, this.getDatapoolSpec().getVariables().size());
    }

    @Override
    public void moveVariable(int sourceVariableIndex, int targetVariableIndex) {
        DPLVariable var = (DPLVariable)this.getDatapoolSpec().getVariables().remove(sourceVariableIndex);
        this.getDatapoolSpec().getVariables().add(targetVariableIndex, (Object)var);
        ListIterator ecIter = this.getEquivalenceClasses().listIterator();
        while (ecIter.hasNext()) {
            DPLEquivalenceClass ec = (DPLEquivalenceClass)ecIter.next();
            ListIterator recIter = ec.getRecords().listIterator();
            while (recIter.hasNext()) {
                DPLRecord rec = (DPLRecord)recIter.next();
                DPLCell cell = (DPLCell)rec.getCells().remove(sourceVariableIndex);
                rec.getCells().add(targetVariableIndex, (Object)cell);
            }
        }
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IDatapoolListener)listeners[i]).variableMoved(this, sourceVariableIndex, targetVariableIndex);
            ++i;
        }
    }

    @Override
    public void removeVariable(int variableIndex) {
        this.removeVariableDoNotNotify(variableIndex);
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IDatapoolListener)listeners[i]).variableRemoved(this, variableIndex);
            ++i;
        }
    }

    protected void removeVariableDoNotNotify(int variableIndex) {
        this.getDatapoolSpec().getVariables().remove(variableIndex);
        ListIterator ecIter = this.getEquivalenceClasses().listIterator();
        while (ecIter.hasNext()) {
            DPLEquivalenceClass ec = (DPLEquivalenceClass)ecIter.next();
            ListIterator recIter = ec.getRecords().listIterator();
            while (recIter.hasNext()) {
                DPLRecord rec = (DPLRecord)recIter.next();
                rec.getCells().remove(variableIndex);
            }
        }
    }

    @Override
    public void setDefaultEquivalenceClassIndex(int equivalenceClassIndex) {
        this.defaultEquivalenceClass = equivalenceClassIndex;
    }

    @Override
    public void updateEquivalenceClass(org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass equivalenceClass, int equivalenceClassIndex) {
        this.removeEquivalenceClassDoNotNotify(equivalenceClassIndex);
        this.insertEquivalenceClassDoNotNotify(equivalenceClass, equivalenceClassIndex);
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IDatapoolListener)listeners[i]).equivalenceClassChanged(this, equivalenceClassIndex);
            ++i;
        }
    }

    @Override
    public void insertEquivalenceClass(org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass equivalenceClass, int beforeEquivalenceClassIndex) {
        this.insertEquivalenceClassDoNotNotify(equivalenceClass, beforeEquivalenceClassIndex);
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IDatapoolListener)listeners[i]).equivalenceClassAdded(this, beforeEquivalenceClassIndex);
            ++i;
        }
    }

    protected void insertEquivalenceClassDoNotNotify(org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass equivalenceClass, int beforeEquivalenceClassIndex) {
        this.getEquivalenceClasses().add(beforeEquivalenceClassIndex, (Object)((DPLEquivalenceClass)equivalenceClass));
    }

    @Override
    public void appendEquivalenceClass(org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass equivalenceClass) {
        this.insertEquivalenceClass(equivalenceClass, this.getEquivalenceClasses().size());
    }

    @Override
    public void moveEquivalenceClass(int sourceEquivalenceClassIndex, int targetEquivalenceClassIndex) {
        DPLEquivalenceClass ec = (DPLEquivalenceClass)this.getEquivalenceClasses().get(sourceEquivalenceClassIndex);
        this.removeEquivalenceClassDoNotNotify(sourceEquivalenceClassIndex);
        this.insertEquivalenceClassDoNotNotify(ec, targetEquivalenceClassIndex);
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IDatapoolListener)listeners[i]).equivalenceClassMoved(this, sourceEquivalenceClassIndex, targetEquivalenceClassIndex);
            ++i;
        }
    }

    @Override
    public void removeEquivalenceClass(int equivalenceClassIndex) {
        this.removeEquivalenceClassDoNotNotify(equivalenceClassIndex);
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IDatapoolListener)listeners[i]).equivalenceClassRemoved(this, equivalenceClassIndex);
            ++i;
        }
    }

    protected void removeEquivalenceClassDoNotNotify(int equivalenceClassIndex) {
        this.getEquivalenceClasses().remove(equivalenceClassIndex);
    }

    @Override
    public void addDatapoolListener(IDatapoolListener listener) {
        if (listener != null) {
            this.listenerList.add((Object)listener);
        }
    }

    public IDatapoolListener getDatapoolListener() {
        Object[] listeners = this.listenerList.getListeners();
        if (listeners.length > 0) {
            return (IDatapoolListener)listeners[0];
        }
        return null;
    }

    public IDatapoolListener[] getDatapoolListeners() {
        Object[] listeners = this.listenerList.getListeners();
        IDatapoolListener[] dpListeners = new IDatapoolListener[listeners.length];
        int i = 0;
        while (i < listeners.length) {
            dpListeners[i] = (IDatapoolListener)listeners[i];
            ++i;
        }
        return dpListeners;
    }

    @Override
    public void removeDatapoolListener(IDatapoolListener listener) {
        if (listener != null) {
            this.listenerList.remove((Object)listener);
        }
    }

    @Override
    public int getVariableCount() {
        if (this.getDatapoolSpec() == null) {
            DPLDatapoolSpec datapoolSpec = Common_DatapoolFactory.eINSTANCE.createDPLDatapoolSpec();
            this.setDatapoolSpec(datapoolSpec);
        }
        return this.getDatapoolSpec().getVariables().size();
    }

    @Override
    public IDatapoolVariable getVariable(int variableIndex) {
        if (this.getDatapoolSpec() == null) {
            DPLDatapoolSpec datapoolSpec = Common_DatapoolFactory.eINSTANCE.createDPLDatapoolSpec();
            this.setDatapoolSpec(datapoolSpec);
        }
        return (org.eclipse.hyades.edit.datapool.IDatapoolVariable)this.getDatapoolSpec().getVariables().get(variableIndex);
    }

    @Override
    public int getVariableIndex(String variableName) {
        ListIterator it = this.getDatapoolSpec().getVariables().listIterator();
        while (it.hasNext()) {
            DPLVariable var = (DPLVariable)it.next();
            if (!variableName.equals(var.getName())) continue;
            return it.previousIndex();
        }
        return -1;
    }

    @Override
    public int getVariableIndexById(String variableId) {
        ListIterator it = this.getDatapoolSpec().getVariables().listIterator();
        while (it.hasNext()) {
            DPLVariable var = (DPLVariable)it.next();
            if (!variableId.equals(var.getId())) continue;
            return it.previousIndex();
        }
        return -1;
    }

    @Override
    public int getEquivalenceClassCount() {
        return this.getEquivalenceClasses().size();
    }

    @Override
    public IDatapoolEquivalenceClass getEquivalenceClass(int index) {
        return (IDatapoolEquivalenceClass)this.getEquivalenceClasses().get(index);
    }

    @Override
    public int getDefaultEquivalenceClassIndex() {
        return this.defaultEquivalenceClass;
    }

    @Override
    public int getEquivalenceClassIndex(String equivalenceClassName) {
        ListIterator it = this.getEquivalenceClasses().listIterator();
        while (it.hasNext()) {
            DPLEquivalenceClass ec = (DPLEquivalenceClass)it.next();
            if (!equivalenceClassName.equals(ec.getName())) continue;
            return it.previousIndex();
        }
        return -1;
    }

    @Override
    public int getEquivalenceClassIndexById(String equivalenceClassId) {
        ListIterator it = this.getEquivalenceClasses().listIterator();
        while (it.hasNext()) {
            DPLEquivalenceClass ec = (DPLEquivalenceClass)it.next();
            if (!equivalenceClassId.equals(ec.getId())) continue;
            return it.previousIndex();
        }
        return -1;
    }

    public void logDatapoolAsStrings() {
        DPLLogImpl.log("Datapool " + this.getName() + " **********************************");
        DPLLogImpl.log("");
        ListIterator varIter = this.getDatapoolSpec().getVariables().listIterator();
        DPLLogImpl.log("Variables: ");
        while (varIter.hasNext()) {
            DPLLogImpl.log("      " + ((DPLVariable)varIter.next()).getName());
        }
        DPLLogImpl.log("");
        ListIterator ecIter = this.getEquivalenceClasses().listIterator();
        while (ecIter.hasNext()) {
            DPLEquivalenceClass ec = (DPLEquivalenceClass)ecIter.next();
            DPLLogImpl.log("EC: " + ec.getName());
            ListIterator recIter = ec.getRecords().listIterator();
            while (recIter.hasNext()) {
                DPLRecord rec = (DPLRecord)recIter.next();
                ListIterator cellIter = rec.getCells().listIterator();
                while (cellIter.hasNext()) {
                    DPLLogImpl.log("      " + ((DPLCell)cellIter.next()).getValue());
                }
                DPLLogImpl.log("");
            }
            DPLLogImpl.log("");
        }
        DPLLogImpl.log("End of  " + this.getName() + " **********************************");
        DPLLogImpl.log("");
    }

    void setAbsoluteFilePathname(String absoluteFilePathname) {
        this.absoluteFilePathname = absoluteFilePathname;
    }

    void unsetAbsoluteFilePathname() {
        this.absoluteFilePathname = null;
    }

    String getAbsoluteFilePathname() {
        return this.absoluteFilePathname;
    }

    @Override
    public org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass constructEquivalenceClass() {
        DPLEquivalenceClass ec = Common_DatapoolFactory.eINSTANCE.createDPLEquivalenceClass();
        String name = DatapoolUtil.createUniqueECName(this);
        ec.setName(name);
        return ec;
    }

    @Override
    public org.eclipse.hyades.edit.datapool.IDatapoolVariable constructVariable() {
        DPLVariable var = Common_DatapoolFactory.eINSTANCE.createDPLVariable();
        String name = DatapoolUtil.createUniqueVariableName(this);
        var.setName(name);
        DatapoolSuggestedTypeImpl suggestedType = new DatapoolSuggestedTypeImpl();
        suggestedType.setSuggestedType(0);
        var.setSuggestedType(suggestedType);
        return var;
    }
}

