/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.datapool.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.edit.datapool.IDatapoolListener;
import org.eclipse.hyades.edit.datapool.IDatapoolRecord;
import org.eclipse.hyades.execution.runtime.datapool.DatapoolException;
import org.eclipse.hyades.execution.runtime.datapool.IDatapool;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolFactory;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage;
import org.eclipse.hyades.models.common.datapool.DPLCell;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass;
import org.eclipse.hyades.models.common.datapool.DPLRecord;
import org.eclipse.hyades.models.common.datapool.DPLVariable;
import org.eclipse.hyades.models.common.datapool.impl.DPLDatapoolImpl;
import org.eclipse.hyades.models.common.datapool.impl.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DPLEquivalenceClassImpl
extends CMNNamedElementImpl
implements DPLEquivalenceClass {
    protected EList<DPLRecord> records;

    protected DPLEquivalenceClassImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return Common_DatapoolPackage.Literals.DPL_EQUIVALENCE_CLASS;
    }

    @Override
    public EList<DPLRecord> getRecords() {
        if (this.records == null) {
            this.records = new EObjectContainmentEList(DPLRecord.class, (InternalEObject)this, 3);
        }
        return this.records;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return ((InternalEList)this.getRecords()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getRecords();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.getRecords().clear();
                this.getRecords().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.getRecords().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.records != null && !this.records.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public IDatapoolRecord constructRecord() {
        return this.constructRecord(null);
    }

    @Override
    public IDatapoolRecord constructRecord(Object[] elements) {
        DPLRecord rec = Common_DatapoolFactory.eINSTANCE.createDPLRecord();
        DPLDatapool datapool = (DPLDatapool)this.eContainer;
        if (datapool == null) {
            return null;
        }
        EList<DPLVariable> variables = datapool.getDatapoolSpec().getVariables();
        ListIterator it = variables.listIterator();
        int elementIndex = 0;
        while (it.hasNext()) {
            DPLCell newCell = Common_DatapoolFactory.eINSTANCE.createDPLCell();
            newCell.setVariable((DPLVariable)it.next());
            rec.getCells().add((Object)newCell);
            if (elements != null && elementIndex < elements.length) {
                newCell.setCellValue((String)elements[elementIndex++]);
                continue;
            }
            newCell.setValue(null);
        }
        return rec;
    }

    @Override
    public void insertRecord(IDatapoolRecord data, int beforeRecord) {
        this.insertRecordDoNotNotify(data, beforeRecord);
        DPLDatapool dp = (DPLDatapool)this.eContainer();
        IDatapoolListener[] listeners = ((DPLDatapoolImpl)dp).getDatapoolListeners();
        if (listeners != null) {
            int i = 0;
            while (i < listeners.length) {
                listeners[i].recordAdded(dp, dp.getEquivalenceClasses().indexOf((Object)this), beforeRecord);
                ++i;
            }
        }
    }

    public void insertRecordDoNotNotify(IDatapoolRecord data, int beforeRecord) {
        if (this.getRecords().contains((Object)data)) {
            throw new DatapoolException(Messages.getString("DPLEquivalenceClassImpl.1"));
        }
        this.getRecords().add(beforeRecord, (Object)((DPLRecord)data));
    }

    @Override
    public void appendRecord(IDatapoolRecord record) {
        this.insertRecord(record, this.getRecords().size());
    }

    @Override
    public void replaceRecord(IDatapoolRecord data, int recordIndex) {
        this.removeRecordDoNotNotify(recordIndex);
        this.insertRecordDoNotNotify(data, recordIndex);
        DPLDatapool dp = (DPLDatapool)this.eContainer();
        IDatapoolListener[] listeners = ((DPLDatapoolImpl)dp).getDatapoolListeners();
        if (listeners != null) {
            int i = 0;
            while (i < listeners.length) {
                listeners[i].recordChanged(dp, dp.getEquivalenceClasses().indexOf((Object)this), recordIndex);
                ++i;
            }
        }
    }

    @Override
    public IDatapoolRecord removeRecord(int recordIndex) {
        IDatapoolRecord removedRecord = this.removeRecordDoNotNotify(recordIndex);
        DPLDatapool dp = (DPLDatapool)this.eContainer();
        IDatapoolListener[] listeners = ((DPLDatapoolImpl)dp).getDatapoolListeners();
        if (listeners != null) {
            int i = 0;
            while (i < listeners.length) {
                listeners[i].recordRemoved(dp, dp.getEquivalenceClasses().indexOf((Object)this), recordIndex);
                ++i;
            }
        }
        return removedRecord;
    }

    protected IDatapoolRecord removeRecordDoNotNotify(int recordIndex) {
        IDatapoolRecord removedRecord = (IDatapoolRecord)this.getRecords().remove(recordIndex);
        return removedRecord;
    }

    @Override
    public void moveRecord(int sourceRecordIndex, int targetRecordIndex) {
        IDatapoolRecord rec = this.removeRecordDoNotNotify(sourceRecordIndex);
        this.insertRecordDoNotNotify(rec, targetRecordIndex);
        DPLDatapool dp = (DPLDatapool)this.eContainer();
        IDatapoolListener[] listeners = ((DPLDatapoolImpl)dp).getDatapoolListeners();
        if (listeners != null) {
            int i = 0;
            while (i < listeners.length) {
                listeners[i].recordMoved(dp, dp.getEquivalenceClasses().indexOf((Object)this), sourceRecordIndex, targetRecordIndex);
                ++i;
            }
        }
    }

    @Override
    public void reorder(int[] recordOrder) {
        LinkedList<Object> list = new LinkedList<Object>();
        if (recordOrder.length != this.getRecordCount()) {
            throw new DatapoolException(Messages.getString("DPLEquivalenceClassImpl.2"));
        }
        int i = 0;
        while (i < recordOrder.length) {
            list.add(this.getRecords().get(recordOrder[i]));
            ++i;
        }
        this.getRecords().clear();
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            this.insertRecordDoNotNotify((IDatapoolRecord)it.next(), this.getRecords().size());
        }
        DPLDatapool dp = (DPLDatapool)this.eContainer();
        int equivalenceClassIndex = dp.getEquivalenceClasses().indexOf((Object)this);
        IDatapoolListener[] listeners = ((DPLDatapoolImpl)dp).getDatapoolListeners();
        if (listeners != null) {
            i = 0;
            while (i < listeners.length) {
                listeners[i].equivalenceClassReordered(dp, equivalenceClassIndex);
                ++i;
            }
        }
    }

    @Override
    public int getRecordCount() {
        return this.getRecords().size();
    }

    @Override
    public org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord getRecord(int record) {
        return (org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord)this.getRecords().get(record);
    }

    @Override
    public IDatapool getDatapool() {
        return (IDatapool)this.eContainer();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        DPLDatapool dp = (DPLDatapool)this.eContainer();
        if (dp == null) {
            return;
        }
        IDatapoolListener[] listeners = ((DPLDatapoolImpl)dp).getDatapoolListeners();
        if (listeners != null) {
            int i = 0;
            while (i < listeners.length) {
                listeners[i].equivalenceClassChanged(dp, dp.getEquivalenceClasses().indexOf((Object)this));
                ++i;
            }
        }
    }
}

