/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.datapool.internal.util;

import org.eclipse.hyades.execution.runtime.datapool.IDatapoolSuggestedType;

public class DatapoolSuggestedTypeChecker {
    private int languageType = 0;
    private static DatapoolSuggestedTypeChecker instance = null;
    public static final String JAVA_TYPE_VOID = "void";
    public static final String JAVA_TYPE_BOOLEAN = "boolean";
    public static final String JAVA_TYPE_BYTE = "byte";
    public static final String JAVA_TYPE_SHORT = "short";
    public static final String JAVA_TYPE_INT = "int";
    public static final String JAVA_TYPE_LONG = "long";
    public static final String JAVA_TYPE_FLOAT = "float";
    public static final String JAVA_TYPE_DOUBLE = "double";
    public static final String JAVA_TYPE_CHAR = "char";
    public static final String JAVA_OBJ_TYPE_BOOLEAN = "java.lang.Boolean";
    public static final String JAVA_OBJ_TYPE_BYTE = "java.lang.Byte";
    public static final String JAVA_OBJ_TYPE_SHORT = "java.lang.Short";
    public static final String JAVA_OBJ_TYPE_INTEGER = "java.lang.Integer";
    public static final String JAVA_OBJ_TYPE_LONG = "java.lang.Long";
    public static final String JAVA_OBJ_TYPE_FLOAT = "java.lang.Float";
    public static final String JAVA_OBJ_TYPE_DOUBLE = "java.lang.Double";
    public static final String JAVA_OBJ_TYPE_CHAR = "java.lang.Character";
    public static final String JAVA_OBJ_TYPE_STRING = "java.lang.String";
    public static final String JAVA_OBJ_TYPE_BOOLEAN_SN = "Boolean";
    public static final String JAVA_OBJ_TYPE_BYTE_SN = "Byte";
    public static final String JAVA_OBJ_TYPE_SHORT_SN = "Short";
    public static final String JAVA_OBJ_TYPE_INTEGER_SN = "Integer";
    public static final String JAVA_OBJ_TYPE_LONG_SN = "Long";
    public static final String JAVA_OBJ_TYPE_FLOAT_SN = "Float";
    public static final String JAVA_OBJ_TYPE_DOUBLE_SN = "Double";
    public static final String JAVA_OBJ_TYPE_CHAR_SN = "Character";
    public static final String JAVA_OBJ_TYPE_STRING_SN = "String";
    public static final String JAVA_INTERFACE_TYPE_ENUMERATION = "java.lang.Enumeration";
    public static final String JAVA_INTERFACE_TYPE_ENUMERATION_SN = "Enumeration";
    public static final String CSHARP_TYPE_BOOL = "bool";
    public static final String CSHARP_TYPE_SBYTE = "sbyte";
    public static final String CSHARP_TYPE_BYTE = "byte";
    public static final String CSHARP_TYPE_USHORT = "ushort";
    public static final String CSHARP_TYPE_SHORT = "short";
    public static final String CSHARP_TYPE_UINT = "uint";
    public static final String CSHARP_TYPE_INT = "int";
    public static final String CSHARP_TYPE_ULONG = "ulong";
    public static final String CSHARP_TYPE_LONG = "long";
    public static final String CSHARP_TYPE_FLOAT = "float";
    public static final String CSHARP_TYPE_DOUBLE = "double";
    public static final String CSHARP_TYPE_DECIMAL = "decimal";
    public static final String CSHARP_TYPE_CHAR = "char";
    public static final String CSHARP_TYPE_STRING = "string";
    public static final String CSHARP_OBJ_TYPE_BOOL = "System.Boolean";
    public static final String CSHARP_OBJ_TYPE_SBYTE = "System.SByte";
    public static final String CSHARP_OBJ_TYPE_BYTE = "System.Byte";
    public static final String CSHARP_OBJ_TYPE_USHORT = "System.UInt16";
    public static final String CSHARP_OBJ_TYPE_SHORT = "System.Int16";
    public static final String CSHARP_OBJ_TYPE_UINT = "System.UInt32";
    public static final String CSHARP_OBJ_TYPE_INT = "System.Int32";
    public static final String CSHARP_OBJ_TYPE_ULONG = "System.UInt64";
    public static final String CSHARP_OBJ_TYPE_LONG = "System.Int64";
    public static final String CSHARP_OBJ_TYPE_FLOAT = "System.Single";
    public static final String CSHARP_OBJ_TYPE_DOUBLE = "System.Double";
    public static final String CSHARP_OBJ_TYPE_DECIMAL = "System.Decimal";
    public static final String CSHARP_OBJ_TYPE_CHAR = "System.Char";
    public static final String CSHARP_OBJ_TYPE_STRING = "System.String";
    public static final String CSHARP_OBJ_TYPE_BOOL_SN = "Boolean";
    public static final String CSHARP_OBJ_TYPE_SBYTE_SN = "SByte";
    public static final String CSHARP_OBJ_TYPE_BYTE_SN = "Byte";
    public static final String CSHARP_OBJ_TYPE_USHORT_SN = "UInt16";
    public static final String CSHARP_OBJ_TYPE_SHORT_SN = "Int16";
    public static final String CSHARP_OBJ_TYPE_UINT_SN = "UInt32";
    public static final String CSHARP_OBJ_TYPE_INT_SN = "Int32";
    public static final String CSHARP_OBJ_TYPE_ULONG_SN = "UInt64";
    public static final String CSHARP_OBJ_TYPE_LONG_SN = "Int64";
    public static final String CSHARP_OBJ_TYPE_FLOAT_SN = "Single";
    public static final String CSHARP_OBJ_TYPE_DOUBLE_SN = "Double";
    public static final String CSHARP_OBJ_TYPE_DECIMAL_SN = "Decimal";
    public static final String CSHARP_OBJ_TYPE_CHAR_SN = "Char";
    public static final String CSHARP_OBJ_TYPE_STRING_SN = "String";
    public static final String CPP_TYPE_VOID = "void";
    public static final String CPP_TYPE_CHAR = "char";
    public static final String CPP_TYPE_SINT = "short int";
    public static final String CPP_TYPE_INT = "int";
    public static final String CPP_TYPE_LINT = "long int";
    public static final String CPP_TYPE_FLOAT = "float";
    public static final String CPP_TYPE_DOUBLE = "double";
    public static final String CPP_TYPE_LDOUBLE = "long double";
    public static final String CPP_TYPE_S_CHAR = "signed char";
    public static final String CPP_TYPE_S_SINT = "signed short int";
    public static final String CPP_TYPE_S_INT = "signed int";
    public static final String CPP_TYPE_S_LINT = "signed long int";
    public static final String CPP_TYPE_U_CHAR = "unsigned char";
    public static final String CPP_TYPE_U_SINT = "unsigned short int";
    public static final String CPP_TYPE_U_INT = "unsigned int";
    public static final String CPP_TYPE_U_LINT = "unsigned long int";
    public static final int LANG_JAVA = 1;
    public static final int LANG_CSHARP = 2;
    public static final int LANG_CPP = 3;

    public static DatapoolSuggestedTypeChecker getInstance() {
        if (instance == null) {
            instance = new DatapoolSuggestedTypeChecker();
        }
        return instance;
    }

    private DatapoolSuggestedTypeChecker() {
    }

    public void setLanguageType(int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: {
                this.languageType = type;
            }
        }
    }

    public boolean isNumber(String type) {
        if (type == null) {
            return false;
        }
        if ((this.languageType == 0 || this.languageType == 1) && (type.equals("int") || type.equals("float") || type.equals("double") || type.equals("long") || type.equals("short") || type.equals(JAVA_OBJ_TYPE_INTEGER) || type.equals(JAVA_OBJ_TYPE_INTEGER_SN) || type.equals(JAVA_OBJ_TYPE_FLOAT) || type.equals(JAVA_OBJ_TYPE_FLOAT_SN) || type.equals(JAVA_OBJ_TYPE_DOUBLE) || type.equals("Double") || type.equals(JAVA_OBJ_TYPE_LONG) || type.equals(JAVA_OBJ_TYPE_LONG_SN) || type.equals(JAVA_OBJ_TYPE_SHORT) || type.equals(JAVA_OBJ_TYPE_SHORT_SN))) {
            return true;
        }
        if ((this.languageType == 0 || this.languageType == 2) && (type.equals(CSHARP_OBJ_TYPE_DECIMAL) || type.equals(CSHARP_OBJ_TYPE_DECIMAL_SN) || type.equals(CSHARP_OBJ_TYPE_DOUBLE) || type.equals("Double") || type.equals(CSHARP_OBJ_TYPE_FLOAT) || type.equals(CSHARP_OBJ_TYPE_FLOAT_SN) || type.equals(CSHARP_OBJ_TYPE_INT) || type.equals(CSHARP_OBJ_TYPE_INT_SN) || type.equals(CSHARP_OBJ_TYPE_LONG) || type.equals(CSHARP_OBJ_TYPE_LONG_SN) || type.equals(CSHARP_OBJ_TYPE_SHORT) || type.equals(CSHARP_OBJ_TYPE_SHORT_SN) || type.equals(CSHARP_OBJ_TYPE_UINT) || type.equals(CSHARP_OBJ_TYPE_UINT_SN) || type.equals(CSHARP_OBJ_TYPE_ULONG) || type.equals(CSHARP_OBJ_TYPE_ULONG_SN) || type.equals(CSHARP_OBJ_TYPE_USHORT) || type.equals(CSHARP_OBJ_TYPE_USHORT_SN) || type.equals(CSHARP_TYPE_DECIMAL) || type.equals("float") || type.equals("int") || type.equals("long") || type.equals("short") || type.equals(CSHARP_TYPE_UINT) || type.equals(CSHARP_TYPE_ULONG) || type.equals(CSHARP_TYPE_USHORT))) {
            return true;
        }
        return !(this.languageType != 0 && this.languageType != 3 || !type.equals("double") && !type.equals("float") && !type.equals(CPP_TYPE_SINT) && !type.equals("int") && !type.equals(CPP_TYPE_LINT) && !type.equals(CPP_TYPE_LDOUBLE) && !type.equals(CPP_TYPE_S_INT) && !type.equals(CPP_TYPE_S_LINT) && !type.equals(CPP_TYPE_S_SINT) && !type.equals(CPP_TYPE_U_INT) && !type.equals(CPP_TYPE_U_LINT) && !type.equals(CPP_TYPE_U_SINT));
    }

    public boolean isBoolean(String type) {
        if (type == null) {
            return false;
        }
        if ((this.languageType == 0 || this.languageType == 1) && (type.equals(JAVA_TYPE_BOOLEAN) || type.equals(JAVA_OBJ_TYPE_BOOLEAN) || type.equals("Boolean"))) {
            return true;
        }
        if ((this.languageType == 0 || this.languageType == 2) && (type.equals(CSHARP_TYPE_BOOL) || type.equals(CSHARP_OBJ_TYPE_BOOL) || type.equals("Boolean"))) {
            return true;
        }
        if (this.languageType != 0) {
            // empty if block
        }
        return false;
    }

    public boolean isString(String type) {
        if (type == null) {
            return false;
        }
        if ((this.languageType == 0 || this.languageType == 1) && (type.equals(JAVA_OBJ_TYPE_STRING) || type.equals("String"))) {
            return true;
        }
        if ((this.languageType == 0 || this.languageType == 2) && (type.equals(CSHARP_OBJ_TYPE_STRING) || type.equals("String") || type.equals(CSHARP_TYPE_STRING))) {
            return true;
        }
        if (this.languageType != 0) {
            // empty if block
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isEnumeration(String type) {
        if (type == null) {
            return false;
        }
        if (this.languageType != 0) {
            if (this.languageType != 1) return false;
        }
        if (type.equals(JAVA_INTERFACE_TYPE_ENUMERATION)) return true;
        if (type.equals(JAVA_INTERFACE_TYPE_ENUMERATION_SN)) {
            return true;
        }
        try {
            Class<?> cls = Class.forName(type);
            block2: while (true) {
                if (cls == null) {
                    return false;
                }
                Class<?>[] interfaces = cls.getInterfaces();
                int i = 0;
                while (true) {
                    if (i >= interfaces.length) {
                        cls = cls.getSuperclass();
                        continue block2;
                    }
                    Class<?> inter = interfaces[i];
                    if (inter.getName().equals(JAVA_INTERFACE_TYPE_ENUMERATION)) return true;
                    if (inter.getName().equals(JAVA_INTERFACE_TYPE_ENUMERATION_SN)) {
                        return true;
                    }
                    ++i;
                }
                break;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean isPrimitive(String type, boolean includeVoid) {
        if (type == null) {
            return false;
        }
        if (this.languageType == 0 || this.languageType == 1) {
            if (type.equals(JAVA_TYPE_BOOLEAN) || type.equals("byte") || type.equals("char") || type.equals("double") || type.equals("float") || type.equals("int") || type.equals("long") || type.equals("short")) {
                return true;
            }
            if (includeVoid && type.equals("void")) {
                return true;
            }
        }
        if (this.languageType == 0 || this.languageType == 2) {
            return false;
        }
        if (this.languageType == 0 || this.languageType == 3) {
            if (type.equals("double") || type.equals("float") || type.equals(CPP_TYPE_SINT) || type.equals("int") || type.equals(CPP_TYPE_LINT) || type.equals(CPP_TYPE_LDOUBLE) || type.equals("char") || type.equals(CPP_TYPE_U_CHAR) || type.equals(CPP_TYPE_S_CHAR) || type.equals(CPP_TYPE_S_INT) || type.equals(CPP_TYPE_S_LINT) || type.equals(CPP_TYPE_S_SINT) || type.equals(CPP_TYPE_U_INT) || type.equals(CPP_TYPE_U_LINT) || type.equals(CPP_TYPE_U_SINT)) {
                return true;
            }
            if (includeVoid && type.equals("void")) {
                return true;
            }
        }
        return false;
    }

    public void setVariableType(org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType suggestedType, String type) {
        if (suggestedType == null) {
            return;
        }
        if (DatapoolSuggestedTypeChecker.getInstance().isString(type)) {
            suggestedType.setSuggestedType(0);
        } else if (DatapoolSuggestedTypeChecker.getInstance().isBoolean(type)) {
            suggestedType.setSuggestedType(2);
        } else if (DatapoolSuggestedTypeChecker.getInstance().isNumber(type)) {
            suggestedType.setSuggestedType(1);
        } else if (DatapoolSuggestedTypeChecker.getInstance().isEnumeration(type)) {
            suggestedType.setSuggestedType(3);
        } else {
            suggestedType.setSuggestedType(4);
        }
        suggestedType.setSuggestedClassName(type);
    }

    public boolean isTypeMatch(String type, IDatapoolSuggestedType suggestedType) {
        if (type == null || suggestedType == null) {
            return false;
        }
        if (type.equals(suggestedType.getSuggestedClassName())) {
            return true;
        }
        int sugType = suggestedType.getSuggestedType();
        if (sugType == 0 && this.isString(type)) {
            return true;
        }
        if (sugType == 2 && this.isBoolean(type)) {
            return true;
        }
        if (sugType == 1 && this.isNumber(type)) {
            return true;
        }
        return sugType == 3 && this.isEnumeration(type);
    }
}

