/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.export.util.impl;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.common.CMNDefaultProperty;
import org.eclipse.hyades.models.common.common.CMNExtendedProperty;
import org.eclipse.hyades.models.common.export.util.impl.XMLSerializer;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionType;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFLoopEvent;
import org.eclipse.hyades.models.common.testprofile.TPFMessageEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTimedEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictReason;
import org.eclipse.hyades.models.common.testprofile.TPFWaitEvent;
import org.eclipse.hyades.models.common.util.ExecutionUtil;
import org.w3c.dom.Element;

public class TPFTestSuiteSerializer
extends XMLSerializer {
    public static final String RESPONSE_URL = "ResponseURL:";
    public static final String TIME = "Time:";
    public static final String LF = "\n";
    protected boolean onlyConsiderMostRecentResult = false;
    protected boolean constrainDates = true;
    protected int[] suiteVerdict;
    protected int[] overallVerdict;
    protected Stack containsVerdicts;
    protected long startTime = -1L;
    protected long endTime = -1L;

    public TPFTestSuiteSerializer(EList content, OutputStream os) {
        super(content, os);
    }

    public TPFTestSuiteSerializer(EList content) {
        super(content);
    }

    protected void init() {
        try {
            this.dom = this.createDocument("testSuites");
            this.parent = this.dom.getDocumentElement();
            this.parentStack.push(this.parent);
            this.suiteVerdict = new int[4];
            this.overallVerdict = new int[4];
            this.containsVerdicts = new Stack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void cleanup() {
        this.dom = null;
        this.parent = null;
        this.parentStack.clear();
        this.parentStack = null;
        this.suiteVerdict = new int[4];
        this.overallVerdict = new int[4];
        this.containsVerdicts.clear();
        this.containsVerdicts = null;
    }

    protected boolean isContainsVerdict() {
        return (Boolean)this.containsVerdicts.peek();
    }

    protected void setParentContainsVerdict(boolean flag) {
        Object currentVerdict = this.containsVerdicts.pop();
        if (!this.containsVerdicts.empty()) {
            this.containsVerdicts.pop();
            this.containsVerdicts.push(flag);
        }
        this.containsVerdicts.push(currentVerdict);
    }

    protected void setVerdict(boolean flag) {
        this.containsVerdicts.push(flag);
    }

    protected void resetVerdict() {
        this.containsVerdicts.pop();
    }

    public boolean isOnlyConsiderMostRecentResult() {
        return this.onlyConsiderMostRecentResult;
    }

    public void setOnlyConsiderMostRecentResult(boolean onlyConsiderMostRecentResult) {
        this.onlyConsiderMostRecentResult = onlyConsiderMostRecentResult;
    }

    private List filterOldExecutionResults(List results) {
        Iterator resultIter = results.iterator();
        TPFExecutionResult latestResult = null;
        long latestTimestamp = 0L;
        while (resultIter.hasNext()) {
            TPFExecutionEvent event;
            long timestamp;
            TPFExecutionResult result = (TPFExecutionResult)resultIter.next();
            TPFExecutionHistory history = result.getExecutionHistory();
            if (history == null || history.getExecutionEvents().isEmpty() || (timestamp = (event = (TPFExecutionEvent)history.getExecutionEvents().get(0)).getTimestamp()) <= latestTimestamp || !this.dateWithinRange(timestamp)) continue;
            latestResult = result;
            latestTimestamp = timestamp;
        }
        if (latestResult != null) {
            results.clear();
            results.add(latestResult);
        }
        return results;
    }

    public void serialize(OutputStream out) {
        this.serialize(out, null);
    }

    public void serialize(OutputStream out, Properties properties) {
        this.os = out;
        EList allTestSuites = this.buildTestSuiteList();
        List[] allExecutionResults = new ArrayList[allTestSuites.size()];
        int x = 0;
        while (x < allTestSuites.size()) {
            TPFTestSuite testSuite = (TPFTestSuite)allTestSuites.get(x);
            List executionResults = ExecutionUtil.findExecutionResults(testSuite, this.startTime, this.endTime);
            if (this.isOnlyConsiderMostRecentResult()) {
                executionResults = this.filterOldExecutionResults(executionResults);
            }
            allExecutionResults[x] = executionResults;
            ++x;
        }
        this.serialize(allTestSuites, allExecutionResults, properties);
    }

    protected EList buildTestSuiteList() {
        BasicEList results = new BasicEList();
        for (TPFTestSuite testSuite : this.content) {
            for (TPFTestSuite currentTestSuite : TPFTestSuiteSerializer.findAllReferencedTestSuites(testSuite)) {
                if (currentTestSuite.getName() == null || currentTestSuite.getName().length() == 0 || results.contains((Object)currentTestSuite)) continue;
                results.add((Object)currentTestSuite);
            }
        }
        return results;
    }

    public static List findAllReferencedTestSuites(TPFTestSuite testSuite) {
        LinkedList<TPFTestSuite> referencedTestSuites = new LinkedList<TPFTestSuite>();
        referencedTestSuites.add(testSuite);
        Iterator referencedSuitesIterator = testSuite.getReferencedSuites().iterator();
        while (referencedSuitesIterator.hasNext()) {
            referencedTestSuites.addAll(TPFTestSuiteSerializer.findAllReferencedTestSuites((TPFTestSuite)referencedSuitesIterator.next()));
        }
        return referencedTestSuites;
    }

    public void serialize(EList content, List[] allExecutionResults) {
        this.serialize(content, allExecutionResults, null);
    }

    public void serialize(EList content, List[] allExecutionResults, Properties properties) {
        this.init();
        int i = 0;
        while (i < this.overallVerdict.length) {
            this.overallVerdict[i] = 0;
            ++i;
        }
        int overallTests = 0;
        int x = 0;
        while (x < content.size()) {
            TPFTestSuite testSuite = (TPFTestSuite)content.get(x);
            this.beginTag(testSuite, true);
            int totalTests = ExecutionUtil.resolveTestCaseCount(testSuite);
            int i2 = 0;
            while (i2 < this.suiteVerdict.length) {
                this.suiteVerdict[i2] = 0;
                ++i2;
            }
            List executionResults = allExecutionResults[x];
            TPFExecutionResult currentExecutionResult2 = null;
            for (TPFExecutionResult currentExecutionResult2 : executionResults) {
                EList<TPFExecutionEvent> executionEvents = currentExecutionResult2.getExecutionHistory().getExecutionEvents();
                if (executionEvents.size() <= 0) continue;
                this.setVerdict(false);
                long currentTimeStamp = ((TPFExecutionEvent)executionEvents.get(0)).getTimestamp();
                if (this.dateWithinRange(currentTimeStamp) && this.dateWithinRange(currentTimeStamp = ((TPFExecutionEvent)executionEvents.get(executionEvents.size() - 1)).getTimestamp())) {
                    this.beginTag(currentExecutionResult2, true);
                    this.recurseGenerate(executionEvents, true);
                    this.parent.setAttribute("timestamp", Long.toString(currentTimeStamp));
                    this.parent.setAttribute("totalError", Integer.toString(this.suiteVerdict[0]));
                    this.parent.setAttribute("totalFail", Integer.toString(this.suiteVerdict[1]));
                    this.parent.setAttribute("totalInconclusive", Integer.toString(this.suiteVerdict[2]));
                    this.parent.setAttribute("totalPass", Integer.toString(this.suiteVerdict[3]));
                    int totalAttempted = this.suiteVerdict[0] + this.suiteVerdict[1] + this.suiteVerdict[2] + this.suiteVerdict[3];
                    if ("AllJUnitTests".equals(testSuite.getName()) || totalAttempted > totalTests) {
                        totalTests = totalAttempted;
                    }
                    this.parent.setAttribute("totalTests", Integer.toString(totalTests));
                    overallTests += totalTests;
                    this.endTag(currentExecutionResult2, true);
                }
                this.resetVerdict();
                int i3 = 0;
                while (i3 < this.overallVerdict.length) {
                    int n = i3;
                    this.overallVerdict[n] = this.overallVerdict[n] + this.suiteVerdict[i3];
                    ++i3;
                }
            }
            if (overallTests == 0) {
                overallTests = totalTests;
            }
            this.parent.setAttribute("totalTests", Integer.toString(totalTests));
            this.endTag(testSuite, true);
            ++x;
        }
        this.parent.setAttribute("startTime", Long.toString(this.startTime));
        this.parent.setAttribute("endTime", Long.toString(this.endTime));
        this.parent.setAttribute("totalError", Integer.toString(this.overallVerdict[0]));
        this.parent.setAttribute("totalFail", Integer.toString(this.overallVerdict[1]));
        this.parent.setAttribute("totalInconclusive", Integer.toString(this.overallVerdict[2]));
        this.parent.setAttribute("totalPass", Integer.toString(this.overallVerdict[3]));
        this.parent.setAttribute("totalTests", Integer.toString(overallTests));
        Element verdictProperty = this.dom.createElement("verdictProperty");
        if (properties == null) {
            verdictProperty.setAttribute("name", "inconclusive");
        } else {
            verdictProperty.setAttribute("name", properties.getProperty("inconclusive"));
        }
        verdictProperty.setAttribute("value", Integer.toString(this.overallVerdict[2]));
        this.parent.appendChild(verdictProperty);
        verdictProperty = this.dom.createElement("verdictProperty");
        if (properties == null) {
            verdictProperty.setAttribute("name", "pass");
        } else {
            verdictProperty.setAttribute("name", properties.getProperty("pass"));
        }
        verdictProperty.setAttribute("value", Integer.toString(this.overallVerdict[3]));
        this.parent.appendChild(verdictProperty);
        verdictProperty = this.dom.createElement("verdictProperty");
        if (properties == null) {
            verdictProperty.setAttribute("name", "fail");
        } else {
            verdictProperty.setAttribute("name", properties.getProperty("fail"));
        }
        verdictProperty.setAttribute("value", Integer.toString(this.overallVerdict[1]));
        this.parent.appendChild(verdictProperty);
        verdictProperty = this.dom.createElement("verdictProperty");
        if (properties == null) {
            verdictProperty.setAttribute("name", "error");
        } else {
            verdictProperty.setAttribute("name", properties.getProperty("error"));
        }
        verdictProperty.setAttribute("value", Integer.toString(this.overallVerdict[0]));
        this.parent.appendChild(verdictProperty);
        int verdictValue = 1;
        if (this.overallVerdict[3] > 0) {
            verdictValue = 3;
        }
        if (this.overallVerdict[2] > 0) {
            verdictValue = 2;
        }
        if (this.overallVerdict[1] > 0) {
            verdictValue = 0;
        }
        this.parent.setAttribute("verdictValue", Integer.toString(verdictValue));
        try {
            this.serializeGeneratedDocument();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.cleanup();
    }

    private boolean dateWithinRange(long currentTimeStamp) {
        return !this.isConstrainDates() || currentTimeStamp >= this.startTime && currentTimeStamp <= this.endTime;
    }

    protected void recurseGenerate(EList list, boolean root) {
        for (TPFExecutionEvent executionEvent : list) {
            if (executionEvent instanceof TPFInvocationEvent) {
                TPFExecutionResult invokedExecutionResult = ((TPFInvocationEvent)executionEvent).getInvokedExecutionResult();
                EList<TPFExecutionEvent> executionEvents = invokedExecutionResult.getExecutionHistory().getExecutionEvents();
                if (executionEvents.size() <= 0) continue;
                this.setVerdict(false);
                long currentTimeStamp = ((TPFExecutionEvent)executionEvents.get(0)).getTimestamp();
                if (this.dateWithinRange(currentTimeStamp) && this.dateWithinRange(currentTimeStamp = ((TPFExecutionEvent)executionEvents.get(executionEvents.size() - 1)).getTimestamp())) {
                    EList<TPFExecutionEvent> rList = ((TPFInvocationEvent)executionEvent).getInvokedExecutionResult().getExecutionHistory().getExecutionEvents();
                    this.beginTag(executionEvent, root);
                    if (!rList.isEmpty()) {
                        this.recurseGenerate(rList, false);
                    }
                    this.endTag(executionEvent, root);
                }
                this.resetVerdict();
                continue;
            }
            if (executionEvent instanceof TPFExecutionEvent) {
                EList<TPFExecutionEvent> rList = executionEvent.getChildren();
                this.beginTag(executionEvent, root);
                if (!rList.isEmpty()) {
                    this.recurseGenerate(rList, false);
                }
                this.endTag(executionEvent, root);
                continue;
            }
            this.beginTag(executionEvent, root);
            this.endTag(executionEvent, root);
        }
    }

    protected Element createElement(Object element, boolean root) {
        String message;
        TPFExecutionEvent event;
        Element description;
        Element child = null;
        if (element instanceof TPFTestSuite) {
            TPFTestSuite testSuite = (TPFTestSuite)element;
            child = this.dom.createElement("testsuite");
            this.setAttribute(child, "name", testSuite.getName());
            this.setAttribute(child, "resource", testSuite.getResource());
            this.setAttribute(child, "location", testSuite.getLocation());
            this.setAttribute(child, "type", testSuite.getType());
            this.setAttribute(child, "id", testSuite.getId());
            if (testSuite.getDescription() != null) {
                description = this.dom.createElement("description");
                child.appendChild(description);
                this.appendTextNode(description, testSuite.getDescription());
            }
        } else if (element instanceof TPFTypedEvent) {
            event = (TPFTypedEvent)element;
            child = this.dom.createElement("typedEvent");
            if (event.getType() != null) {
                this.setAttribute(child, "type", Integer.toString(event.getType().getValue()));
            }
            if (event.getType() == TPFExecutionType.STOP_LITERAL) {
                this.setAttribute(child, "stopTime", Long.toString(event.getTimestamp()));
            } else if (this.startTime == -1L) {
                this.setAttribute(child, "startTime", Long.toString(event.getTimestamp()));
            }
        } else if (element instanceof TPFLoopEvent) {
            event = (TPFLoopEvent)element;
            child = this.dom.createElement("loopEvent");
            this.setAttribute(child, "iterations", Long.toString(event.getIterations()));
            this.setAttribute(child, "asynchronous", Boolean.toString(event.isAsynchronous()));
        } else if (element instanceof TPFVerdictEvent) {
            event = (TPFVerdictEvent)element;
            child = this.dom.createElement("verdictEvent");
            TPFVerdict verdict = event.getVerdict();
            this.setAttribute(child, "verdictName", verdict.getName());
            this.setAttribute(child, "verdictValue", Integer.toString(verdict.getValue()));
            TPFVerdictReason verdictReason = event.getReason();
            this.setAttribute(child, "verdictReasonName", verdictReason.getName());
            this.setAttribute(child, "verdictReasonValue", Integer.toString(verdictReason.getValue()));
            if (!root) {
                this.setParentContainsVerdict(true);
                if (!this.isContainsVerdict()) {
                    switch (verdict.getValue()) {
                        case 3: {
                            this.suiteVerdict[0] = this.suiteVerdict[0] + 1;
                            break;
                        }
                        case 2: {
                            this.suiteVerdict[1] = this.suiteVerdict[1] + 1;
                            break;
                        }
                        case 0: {
                            this.suiteVerdict[2] = this.suiteVerdict[2] + 1;
                            break;
                        }
                        case 1: {
                            this.suiteVerdict[3] = this.suiteVerdict[3] + 1;
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else {
                this.parent.setAttribute("verdictValue", Integer.toString(verdict.getValue()));
            }
        } else if (element instanceof TPFTimedEvent) {
            event = (TPFTimedEvent)element;
            child = event instanceof TPFWaitEvent ? this.dom.createElement("waitEvent") : this.dom.createElement("timedEvent");
            this.setAttribute(child, "endTimestamp", Long.toString(event.getEndTimestamp()));
        } else if (element instanceof TPFMessageEvent) {
            int responseTimeIndex;
            event = (TPFMessageEvent)element;
            child = this.dom.createElement("messageEvent");
            this.setAttribute(child, "severity", Integer.toString(event.getSeverity().getValue()));
            this.setAttribute(child, "severityLabel", event.getSeverity().getLabel());
            message = event.getText();
            if (message != null && (responseTimeIndex = message.indexOf(TIME)) != -1) {
                String pageName = message.substring(message.indexOf(RESPONSE_URL) + RESPONSE_URL.length(), responseTimeIndex).trim();
                String responseTime = message.substring(responseTimeIndex + TIME.length(), message.length());
                responseTime = responseTime.substring(0, responseTime.indexOf(LF)).trim();
                this.setAttribute(child, "pageName", pageName);
                this.setAttribute(child, "responseTime", responseTime);
            }
        } else if (element instanceof TPFInvocationEvent) {
            event = (TPFInvocationEvent)element;
            TPFExecutionResult invokedExecutionResult = event.getInvokedExecutionResult();
            child = this.dom.createElement("invocationEvent");
            TPFVerdict verdict = invokedExecutionResult.getVerdict();
            this.setAttribute(child, "verdictName", verdict.getName());
            this.setAttribute(child, "verdictValue", Integer.toString(verdict.getValue()));
            this.setAttribute(child, "statusName", event.getStatus().getName());
            this.setAttribute(child, "statusValue", Integer.toString(event.getStatus().getValue()));
        } else if (element instanceof TPFExecutionResult) {
            TPFExecutionResult results = (TPFExecutionResult)element;
            child = this.dom.createElement("testExecutionResults");
            this.setAttribute(child, "name", results.getName());
            this.setAttribute(child, "version", results.getTestVersion());
            this.setAttribute(child, "type", results.getType());
            if (results.getDescription() != null) {
                description = this.dom.createElement("description");
                child.appendChild(description);
                this.appendTextNode(description, results.getDescription());
            }
        }
        if (element instanceof TPFExecutionEvent) {
            TPFExecutionEvent executionEvent = (TPFExecutionEvent)element;
            if (child == null) {
                child = this.dom.createElement("testExecutionEvents");
            }
            this.setAttribute(child, "name", executionEvent.getName());
            this.setAttribute(child, "eventType", executionEvent.getEventType());
            this.setAttribute(child, "timestamp", Long.toString(executionEvent.getTimestamp()));
            if (executionEvent.getDescription() != null) {
                description = this.dom.createElement("description");
                child.appendChild(description);
                this.appendTextNode(description, executionEvent.getDescription());
            }
            if ((message = executionEvent.getText()) != null) {
                Element description2 = this.dom.createElement("text");
                child.appendChild(description2);
                this.appendTextNode(description2, executionEvent.getText());
            }
            Iterator iter = executionEvent.getProperties().iterator();
            Element propertiesElement = this.dom.createElement("properties");
            child.appendChild(propertiesElement);
            while (iter.hasNext()) {
                CMNDefaultProperty listElement = (CMNDefaultProperty)iter.next();
                if (!(listElement instanceof CMNExtendedProperty)) continue;
                CMNExtendedProperty property = (CMNExtendedProperty)element;
                Element popertyElement = this.dom.createElement("property");
                propertiesElement.appendChild(popertyElement);
                this.setAttribute(popertyElement, "name", property.getName());
                this.setAttribute(popertyElement, "type", property.getType());
                this.appendTextNode(popertyElement, property.getValue());
            }
        }
        return child;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public boolean isConstrainDates() {
        return this.constrainDates;
    }

    public void setConstrainDates(boolean constrainDates) {
        this.constrainDates = constrainDates;
    }
}

