/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.export.util.impl;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.export.util.ISerializer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class XMLSerializer
implements ISerializer {
    protected OutputStream os;
    protected EList content;
    protected Document dom;
    protected Element parent = null;
    protected Stack parentStack = new Stack();
    protected int indent = 4;
    protected boolean format = false;

    public XMLSerializer(EList content, OutputStream os) {
        this.content = content;
        this.os = os;
    }

    public XMLSerializer(EList content) {
        this.content = content;
    }

    protected void beginTag(Object element, boolean root) {
        Element child = this.createElement(element, root);
        if (child != null) {
            this.parent.appendChild(child);
            this.parent = child;
            this.parentStack.push(this.parent);
        }
    }

    protected abstract Element createElement(Object var1, boolean var2);

    protected void endTag(Object element, boolean root) {
        this.parentStack.pop();
        this.parent = (Element)this.parentStack.peek();
    }

    protected Document createDocument(String tag) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        DOMImplementation domImpl = builder.getDOMImplementation();
        Document document = domImpl.createDocument(null, tag, null);
        return document;
    }

    public String serializeGeneratedDocumentToString() throws Exception {
        if (this.dom == null) {
            return null;
        }
        OutputStreamWriter writer = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");
        DOMSource source = new DOMSource(this.dom);
        StreamResult result = new StreamResult(writer);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        if (this.format) {
            transformer.setOutputProperty("indent", "yes");
            try {
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        transformer.transform(source, result);
        return stream.toString();
    }

    public void serializeGeneratedDocument() throws Exception {
        if (this.dom == null) {
            return;
        }
        OutputStreamWriter writer = null;
        writer = new OutputStreamWriter(this.os, "UTF-8");
        DOMSource source = new DOMSource(this.dom);
        StreamResult result = new StreamResult(writer);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        if (this.format) {
            transformer.setOutputProperty("indent", "yes");
            try {
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        transformer.transform(source, result);
    }

    protected void setAttribute(Element owner, String attName, String attValue) {
        if (attValue != null) {
            owner.setAttribute(attName, attValue);
        }
    }

    protected void appendTextNode(Element owner, String text) {
        if (text != null) {
            Text textNode = this.dom.createTextNode(XMLSerializer.decode(text));
            owner.appendChild(textNode);
        }
    }

    public static String decode(String s) {
        if (s == null) {
            return s;
        }
        s = s.replaceAll("&apos;", "'");
        s = s.replaceAll("&lt;", "<");
        s = s.replaceAll("&gt;", ">");
        s = s.replaceAll("&quot;", "\"");
        s = s.replaceAll("&amp;", "&");
        return s;
    }

    protected void beginTag(String tag, boolean root) {
        Element child = this.dom.createElement(tag);
        if (child != null) {
            this.parent.appendChild(child);
            this.parent = child;
            this.parentStack.push(this.parent);
        }
    }

    protected void endTag(String tag, boolean root) {
        this.parentStack.pop();
        this.parent = (Element)this.parentStack.peek();
    }

    public Document getDom() {
        return this.dom;
    }

    public boolean isFormat() {
        return this.format;
    }

    public void setFormat(boolean format) {
        this.format = format;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }
}

