/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.facades.behavioral.impl;

import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl;
import org.eclipse.hyades.models.common.configuration.impl.CFGOperationImpl;
import org.eclipse.hyades.models.common.configuration.impl.Common_ConfigurationFactoryImpl;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITargetInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.IVariable;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.models.common.fragments.impl.BVRInteractionImpl;
import org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl;
import org.eclipse.hyades.models.common.interactions.impl.BVRLifelineImpl;
import org.eclipse.hyades.models.common.interactions.impl.BVRMessageImpl;
import org.eclipse.hyades.models.common.interactions.impl.Common_Behavior_InteractionsFactoryImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFSUTImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestCaseImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl;

public class HyadesUtil {
    public static final HyadesUtil INSTANCE = new HyadesUtil();

    public void createSUTInstances(BVRInteractionImpl interaction, BVRInteractionFragmentImpl action) {
        TPFTestSuiteImpl testSuite = null;
        if (interaction == null || action == null) {
            return;
        }
        if (interaction.getBehavior().getTest() instanceof TPFTestCaseImpl) {
            testSuite = (TPFTestSuiteImpl)((TPFTestCaseImpl)interaction.getBehavior().getTest()).getOwner();
        }
        if (interaction.getBehavior().getTest() instanceof TPFTestSuiteImpl) {
            testSuite = (TPFTestSuiteImpl)interaction.getBehavior().getTest();
        }
        if (testSuite != null) {
            List systemUnderTests = testSuite.getISystemsUnderTest();
            for (TPFSUTImpl systemUnderTest : systemUnderTests) {
                List methods = systemUnderTest.getMethods();
                for (CFGOperationImpl method : methods) {
                    if (action.getMessages().size() <= 0) continue;
                    BVRMessageImpl message = (BVRMessageImpl)action.getMessages().get(0);
                    if (!method.getName().equals(message.getOperation().getName())) continue;
                    BVRLifelineImpl sutLifeline = (BVRLifelineImpl)Common_Behavior_InteractionsFactoryImpl.eINSTANCE.createBVRLifeline();
                    sutLifeline.setDescription("self lifeline for " + systemUnderTest.getName());
                    sutLifeline.setName(String.valueOf(systemUnderTest.getName()) + "_selfLifeline");
                    interaction.getLifelines().add((Object)sutLifeline);
                    CFGInstanceImpl instance = (CFGInstanceImpl)Common_ConfigurationFactoryImpl.eINSTANCE.createCFGInstance();
                    instance.setName("instance for " + systemUnderTest.getName());
                    instance.setClassType(systemUnderTest);
                    instance.setLifeline(sutLifeline);
                    systemUnderTest.getInstances().add((Object)instance);
                }
            }
        }
    }

    public ITestSuite getTestSuite(ITest test) {
        if (test instanceof ITestCase) {
            test = ((ITestCase)test).getOwner();
        } else if (!(test instanceof ITestSuite)) {
            test = null;
        }
        return (ITestSuite)test;
    }

    public boolean containsSuite(List referencedSuites, ITestSuite test) {
        if (referencedSuites == null || test == null) {
            return false;
        }
        Iterator iter = referencedSuites.iterator();
        while (iter.hasNext()) {
            if (!((ITestSuite)iter.next()).getId().equals(test.getId())) continue;
            return true;
        }
        return false;
    }

    public static ITargetInvocation getTargetInvocation(ITestCase input) {
        IBlock block;
        ITargetInvocation targetInvocation = null;
        IImplementor implementor = input.getImplementor();
        IBlock iBlock = block = implementor == null ? null : implementor.getBlock();
        if (block != null) {
            for (Object action : block.getActions()) {
                if (!(action instanceof ITargetInvocation)) continue;
                targetInvocation = (ITargetInvocation)action;
                break;
            }
        }
        return targetInvocation;
    }

    public static ITargetInvocation createTargetInvocation(ITestCase input) {
        if (input == null) {
            return null;
        }
        if (input.getImplementor() == null) {
            HyadesFactory.INSTANCE.createImplementor(input, false);
        }
        ITargetInvocation targetInvocation = HyadesFactory.INSTANCE.createTargetInvocation(null);
        input.getImplementor().getBlock().getActions().add(targetInvocation);
        return targetInvocation;
    }

    public static String getTestSuiteVariable(ITest testSuite, String variableName) {
        IVariable var = HyadesUtil.findVariable(testSuite, variableName);
        if (var == null) {
            return null;
        }
        return var.getInitialValue();
    }

    public static void setTestSuiteVariable(ITest testSuite, String variableName, String variableValue) {
        IVariable var = HyadesUtil.findVariable(testSuite, variableName);
        if (var == null) {
            IVariable varToAdd = HyadesFactory.INSTANCE.createVariable();
            varToAdd.setName(variableName);
            varToAdd.setInitialValue(variableValue);
            testSuite.getVariables().add(varToAdd);
        } else {
            var.setInitialValue(variableValue);
        }
    }

    private static IVariable findVariable(ITest testSuite, String variableName) {
        List variables = testSuite.getVariables();
        int i = 0;
        int variableSize = variables.size();
        while (i < variableSize) {
            IVariable currentVariable = (IVariable)variables.get(i);
            if (currentVariable.getName() != null && currentVariable.getName().equals(variableName)) {
                return currentVariable;
            }
            ++i;
        }
        return null;
    }
}

