/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.testprofile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.hyades.models.plugin.ModelsPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TPFExecutionType implements Enumerator
{
    START_LITERAL(0, "start", "start"),
    STOP_LITERAL(1, "stop", "stop");

    public static final int START = 0;
    public static final int STOP = 1;
    private static final TPFExecutionType[] VALUES_ARRAY;
    public static final List<TPFExecutionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;
    private final String keyPrefix = String.valueOf(((Object)((Object)this)).getClass().getName()) + ".";

    static {
        VALUES_ARRAY = new TPFExecutionType[]{START_LITERAL, STOP_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TPFExecutionType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TPFExecutionType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TPFExecutionType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TPFExecutionType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TPFExecutionType get(int value) {
        switch (value) {
            case 0: {
                return START_LITERAL;
            }
            case 1: {
                return STOP_LITERAL;
            }
        }
        return null;
    }

    private TPFExecutionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public static TPFExecutionType getByLabel(String label) {
        if (label != null) {
            int i = 0;
            int maxi = VALUES_ARRAY.length;
            while (i < maxi) {
                if (label.equals(VALUES_ARRAY[i].getLabel())) {
                    return VALUES_ARRAY[i];
                }
                ++i;
            }
        }
        return TPFExecutionType.get(label);
    }

    public String getLabel() {
        try {
            String label = this.getString(String.valueOf(this.keyPrefix) + this.getName());
            if (label != null) {
                return label;
            }
        }
        catch (MissingResourceException missingResourceException) {}
        return this.getName();
    }

    protected String getString(String key) throws NullPointerException, MissingResourceException {
        return ModelsPlugin.getPlugin().getString(key);
    }
}

