/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.util;

import com.ibm.icu.util.Calendar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.loaders.common.provisional.TestlogFilenameExtensionManager;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.common.facades.behavioral.IAction;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.util.ResourceUtil;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;

public class ExecutionUtil {
    public static List findExecutionResults(final TPFTest test) {
        if (test != null && test.eResource() != null) {
            URI uri = test.eResource().getURI().trimFileExtension();
            final String executionPrefix = uri.lastSegment().toString();
            ResourceUtil.IGetFilesVisitor visitor = new ResourceUtil.IGetFilesVisitor(){

                public Object visit(IFile file) {
                    TPFExecutionResult executionResult;
                    EObject[] eObjects;
                    if (file.getName().startsWith(executionPrefix) && (eObjects = ResourceUtil.load((ResourceSet)new ResourceSetImpl(), file)).length == 1 && eObjects[0] instanceof TPFExecutionResult && (executionResult = (TPFExecutionResult)eObjects[0]).getTest().getId().equals(test.getId())) {
                        return executionResult;
                    }
                    return null;
                }
            };
            List fileList = ExecutionUtil.buildsLogFileList(test, visitor);
            return fileList;
        }
        return Collections.EMPTY_LIST;
    }

    private static List buildsLogFileList(TPFTest test, ResourceUtil.IGetFilesVisitor visitor) {
        List customList;
        List fileList = (List)ResourceUtil.getFiles(ResourcesPlugin.getWorkspace().getRoot(), new String[]{"execution"}, visitor).get("execution");
        String customFileNameExtension = TestlogFilenameExtensionManager.getInstance().getExtensionForTestType(test.getType());
        if (customFileNameExtension != null && (customList = (List)ResourceUtil.getFiles(ResourcesPlugin.getWorkspace().getRoot(), new String[]{customFileNameExtension}, visitor).get(customFileNameExtension)) != null && customList.size() > 0) {
            fileList.addAll(customList);
        }
        return fileList;
    }

    public static List findExecutionResults(final TPFTest test, long startDate, long endDate) {
        if (test != null && test.eResource() != null) {
            if (startDate <= 0L || startDate <= 0L) {
                Calendar currentDateTimeCalendar = Calendar.getInstance();
                currentDateTimeCalendar.set(14, 0);
                if (endDate <= 0L) {
                    endDate = currentDateTimeCalendar.getTimeInMillis();
                }
                if (startDate <= 0L) {
                    currentDateTimeCalendar.set(11, 0);
                    currentDateTimeCalendar.set(12, 0);
                    currentDateTimeCalendar.set(13, 0);
                    startDate = currentDateTimeCalendar.getTimeInMillis();
                }
            }
            final long fStartTime = startDate;
            final long fEndTime = endDate;
            ResourceUtil.IGetFilesVisitor visitor = new ResourceUtil.IGetFilesVisitor(){

                public Object visit(IFile file) {
                    TPFExecutionEvent event;
                    long timestamp;
                    TPFExecutionResult executionResult;
                    TPFExecutionHistory history;
                    EObject[] eObjects;
                    if (file.getLocalTimeStamp() >= fStartTime && (eObjects = ResourceUtil.load((ResourceSet)new ResourceSetImpl(), file)).length == 1 && eObjects[0] instanceof TPFExecutionResult && (history = (executionResult = (TPFExecutionResult)eObjects[0]).getExecutionHistory()) != null && !history.getExecutionEvents().isEmpty() && (timestamp = (event = (TPFExecutionEvent)history.getExecutionEvents().get(0)).getTimestamp()) >= fStartTime && timestamp <= fEndTime && executionResult.getTest().getId().equals(test.getId())) {
                        return executionResult;
                    }
                    return null;
                }
            };
            return ExecutionUtil.buildsLogFileList(test, visitor);
        }
        return Collections.EMPTY_LIST;
    }

    public static Map findExecutionResults(List tests, long startDate, long endDate) {
        if (tests != null) {
            final HashMap results = new HashMap();
            TPFTest test = null;
            int x = 0;
            while (x < tests.size()) {
                test = (TPFTest)tests.get(x);
                results.put(test.getId(), new ArrayList());
                ++x;
            }
            if (test != null) {
                if (startDate <= 0L || endDate <= 0L) {
                    Calendar currentDateTimeCalendar = Calendar.getInstance();
                    currentDateTimeCalendar.set(14, 0);
                    if (endDate <= 0L) {
                        endDate = currentDateTimeCalendar.getTimeInMillis();
                    }
                    if (startDate <= 0L) {
                        currentDateTimeCalendar.set(11, 0);
                        currentDateTimeCalendar.set(12, 0);
                        currentDateTimeCalendar.set(13, 0);
                        startDate = currentDateTimeCalendar.getTimeInMillis();
                    }
                }
                final HashMap timeStampLookup = new HashMap();
                final long fStartTime = startDate;
                final long fEndTime = endDate;
                ResourceUtil.IGetFilesVisitor visitor = new ResourceUtil.IGetFilesVisitor(){

                    public Object visit(IFile file) {
                        EObject[] eObjects;
                        if (file.getLocalTimeStamp() >= fStartTime && (eObjects = ResourceUtil.load((ResourceSet)new ResourceSetImpl(), file)).length == 1 && eObjects[0] instanceof TPFExecutionResult) {
                            List list;
                            TPFExecutionEvent event;
                            long timestamp;
                            TPFExecutionResult executionResult = (TPFExecutionResult)eObjects[0];
                            TPFExecutionHistory history = executionResult.getExecutionHistory();
                            if (history != null && !history.getExecutionEvents().isEmpty() && (timestamp = (event = (TPFExecutionEvent)history.getExecutionEvents().get(0)).getTimestamp()) >= fStartTime && timestamp <= fEndTime && (list = (List)results.get(executionResult.getTest().getId())) != null) {
                                long oldTimeStamp = 0L;
                                if (executionResult.getTest().getType().equals("org.eclipse.hyades.test.java.junit.testSuite")) {
                                    Object timeStampObj;
                                    boolean found = false;
                                    TPFExecutionResult oldResult = null;
                                    int y = 0;
                                    while (y < list.size()) {
                                        Object elem = list.get(y);
                                        if (elem instanceof TPFExecutionResult && ((TPFExecutionResult)elem).getName().equals(executionResult.getName())) {
                                            oldResult = (TPFExecutionResult)elem;
                                            found = true;
                                            break;
                                        }
                                        ++y;
                                    }
                                    if (!found) {
                                        timeStampLookup.put(executionResult, new Long(timestamp));
                                        list.add(executionResult);
                                    } else if (oldResult != null && (timeStampObj = timeStampLookup.get(oldResult)) != null && timestamp > (oldTimeStamp = ((Long)timeStampObj).longValue())) {
                                        list.remove(oldResult);
                                        list.add(executionResult);
                                        timeStampLookup.remove(oldResult);
                                        timeStampLookup.put(executionResult, new Long(timestamp));
                                    }
                                } else {
                                    int y = 0;
                                    while (y < list.size()) {
                                        Object elem = list.get(y);
                                        if (elem instanceof Long) {
                                            oldTimeStamp = (Long)elem;
                                            break;
                                        }
                                        ++y;
                                    }
                                    if (timestamp > oldTimeStamp) {
                                        list.clear();
                                        list.add(new Long(timestamp));
                                        list.add(executionResult);
                                    }
                                }
                            }
                            return null;
                        }
                        return null;
                    }
                };
                String[] customExtensions = TestlogFilenameExtensionManager.getInstance().getAllRegisteredLogExtensions();
                String[] extensionList = new String[customExtensions != null ? customExtensions.length + 1 : 1];
                extensionList[extensionList.length - 1] = "execution";
                ResourceUtil.getFiles(ResourcesPlugin.getWorkspace().getRoot(), extensionList, visitor);
                return results;
            }
        }
        return null;
    }

    public static List findAllExecutionResults(final TPFTest test) {
        if (test != null && test.eResource() != null) {
            ResourceUtil.IGetFilesVisitor visitor = new ResourceUtil.IGetFilesVisitor(){

                public Object visit(IFile file) {
                    TPFExecutionResult executionResult;
                    EObject[] eObjects = ResourceUtil.load((ResourceSet)new ResourceSetImpl(), file);
                    if (eObjects.length == 1 && eObjects[0] instanceof TPFExecutionResult && (executionResult = (TPFExecutionResult)eObjects[0]).getTest().equals(test)) {
                        return executionResult;
                    }
                    return null;
                }
            };
            return ExecutionUtil.buildsLogFileList(test, visitor);
        }
        return Collections.EMPTY_LIST;
    }

    public static Map findExecutionResults(List tests) {
        ArrayList<String> customLogExtensions = new ArrayList<String>();
        if (tests != null && !tests.isEmpty()) {
            ResourceSet resourceSet = null;
            HashSet<String> resourcePrefixes = new HashSet<String>(tests.size() + 1);
            for (Object object : tests) {
                if (!(object instanceof TPFTest)) continue;
                TPFTest test = (TPFTest)object;
                String customExtension = TestlogFilenameExtensionManager.getInstance().getExtensionForTestType(test.getType());
                if (customExtension != null && !customLogExtensions.contains(customExtension)) {
                    customLogExtensions.add(customExtension);
                }
                if (test.eResource() == null) continue;
                if (resourceSet == null) {
                    resourceSet = test.eResource().getResourceSet();
                }
                URI uri = test.eResource().getURI().trimFileExtension();
                resourcePrefixes.add(uri.lastSegment().toString());
            }
            if (!resourcePrefixes.isEmpty()) {
                final ResourceSet finalResourceSet = resourceSet;
                final String[] prefixes = resourcePrefixes.toArray(new String[resourcePrefixes.size()]);
                final HashMap ret = new HashMap(resourcePrefixes.size() + 1, 1.0f);
                ResourceUtil.IGetFilesVisitor visitor = new ResourceUtil.IGetFilesVisitor(){

                    public Object visit(IFile file) {
                        int i = 0;
                        int maxi = prefixes.length;
                        while (i < maxi) {
                            EObject[] eObjects;
                            if (file.getName().startsWith(prefixes[i]) && (eObjects = ResourceUtil.load(finalResourceSet, file)).length == 1 && eObjects[0] instanceof TPFExecutionResult) {
                                TPFExecutionResult executionResult = (TPFExecutionResult)eObjects[0];
                                ArrayList<TPFExecutionResult> executionResults = (ArrayList<TPFExecutionResult>)ret.get(executionResult.getTest());
                                if (executionResults == null) {
                                    executionResults = new ArrayList<TPFExecutionResult>();
                                    ret.put(executionResult.getTest(), executionResults);
                                }
                                executionResults.add(executionResult);
                            }
                            ++i;
                        }
                        return null;
                    }
                };
                String[] customExtensions = customLogExtensions.toArray(new String[0]);
                String[] fileExtensionList = new String[customExtensions.length + 1];
                fileExtensionList[fileExtensionList.length - 1] = "execution";
                ResourceUtil.getFiles(ResourcesPlugin.getWorkspace().getRoot(), fileExtensionList, visitor);
                return ret;
            }
        }
        return Collections.EMPTY_MAP;
    }

    public static void addReferencedTestSuites(TPFTestSuite testSuite, List referencedTestSuites) {
        IBlock block;
        referencedTestSuites.add(testSuite);
        IImplementor implementor = testSuite.getImplementor();
        if (implementor != null && (block = implementor.getBlock()) != null) {
            ExecutionUtil.addReferencedTestSuites(block, referencedTestSuites);
        }
    }

    private static void addReferencedTestSuites(IBlock block, List referencedTestSuites) {
        for (IAction action : block.getActions()) {
            if (action instanceof ITestInvocation) {
                TPFTestSuite testSuite;
                ITest test = ((ITestInvocation)action).getInvokedTest();
                if (test instanceof TPFTestSuite) {
                    if (referencedTestSuites.contains(test)) continue;
                    ExecutionUtil.addReferencedTestSuites((TPFTestSuite)test, referencedTestSuites);
                    continue;
                }
                if (!(test instanceof TPFTestCase) || referencedTestSuites.contains(testSuite = ((TPFTestCase)test).getTestSuite())) continue;
                ExecutionUtil.addReferencedTestSuites(testSuite, referencedTestSuites);
                continue;
            }
            if (!(action instanceof ILoop)) continue;
            ExecutionUtil.addReferencedTestSuites(((ILoop)action).getBlock(), referencedTestSuites);
        }
    }

    public static boolean containsTestCaseInvocations(TPFTestSuite testSuite) {
        IImplementor implementor = testSuite.getImplementor();
        if (implementor != null) {
            IBlock block = implementor.getBlock();
            if (block != null) {
                return ExecutionUtil.containsTestCaseInvocations(block);
            }
            return testSuite.getTestCases().size() > 0;
        }
        return false;
    }

    private static boolean containsTestCaseInvocations(IBlock block) {
        for (IAction action : block.getActions()) {
            if (!(action instanceof ITestInvocation ? ((ITestInvocation)action).getInvokedTest() instanceof TPFTestCase : action instanceof ILoop && ExecutionUtil.containsTestCaseInvocations(((ILoop)action).getBlock()))) continue;
            return true;
        }
        return false;
    }

    public static int resolveTestCaseCount(TPFTestSuite testSuite) {
        int count = 0;
        IImplementor implementor = testSuite.getImplementor();
        if (implementor != null) {
            IBlock block = implementor.getBlock();
            count = block != null ? ExecutionUtil.resolveTestCaseCount(block) : testSuite.getTestCases().size();
        }
        return count;
    }

    private static int resolveTestCaseCount(IBlock block) {
        int count = 0;
        for (IAction action : block.getActions()) {
            if (action instanceof ITestInvocation) {
                ITest test = ((ITestInvocation)action).getInvokedTest();
                if (test instanceof TPFTestSuite) {
                    count += ExecutionUtil.resolveTestCaseCount((TPFTestSuite)test);
                    continue;
                }
                if (!(test instanceof TPFTestCase)) continue;
                ++count;
                continue;
            }
            if (!(action instanceof ILoop)) continue;
            count += ExecutionUtil.resolveTestCaseCount(((ILoop)action).getBlock());
        }
        return count;
    }

    public static List getVerdictEvents(TPFExecutionResult testExecutionResult) {
        EList result;
        SimpleSearchQuery verdictQuery = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
        verdictQuery.getSources().add((Object)EcoreUtil.getURI((EObject)testExecutionResult).toString());
        verdictQuery.getRequiredPaths().add((Object)Common_TestprofilePackage.eINSTANCE.getTPFExecutionResult_ExecutionHistory());
        verdictQuery.getRequiredPaths().add((Object)Common_TestprofilePackage.eINSTANCE.getTPFExecutionHistory_ExecutionEvents());
        verdictQuery.getRequiredPaths().add((Object)Common_TestprofilePackage.eINSTANCE.getTPFExecutionEvent_Children());
        verdictQuery.getRequiredPaths().add((Object)Common_TestprofilePackage.eINSTANCE.getTPFInvocationEvent_InvokedExecutionResult());
        SimpleOperand operand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        operand.setType(Common_TestprofilePackage.eINSTANCE.getTPFVerdictEvent());
        verdictQuery.getOutputElements().add((Object)operand);
        LogicalExpression whereExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
        whereExpression.setOperator(LogicalOperators.OR_LITERAL);
        verdictQuery.setWhereExpression((WhereExpression)whereExpression);
        QueryResult queryResult = null;
        IHyadesResourceExtension hyadesResourceExtension = (IHyadesResourceExtension)HyadesResourceExtensions.getInstance().get((Object)LoadersUtils.getPostfix((String)testExecutionResult.eResource().getURI().toString()));
        if (hyadesResourceExtension != null) {
            ArrayList notLoadedTypes = new ArrayList();
            ResourceSet resourceSet = testExecutionResult.eResource().getResourceSet();
            queryResult = hyadesResourceExtension.executeQuery((Query)verdictQuery, resourceSet, notLoadedTypes);
        }
        if (!(result = queryResult.getResultEntries()).isEmpty()) {
            return (List)((ResultEntry)result.get(0)).getValue();
        }
        return Collections.EMPTY_LIST;
    }
}

