/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.util;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.plugin.ModelsPlugin;

public class ResourceUtil {
    public static final Map RESOURCE_OPTIONS = new HashMap();

    public ResourceUtil() {
        RESOURCE_OPTIONS.put("DECLARE_XML", Boolean.TRUE);
        RESOURCE_OPTIONS.put("SKIP_ESCAPE", Boolean.FALSE);
    }

    public static void createContainer(IContainer container, IProgressMonitor progressMonitor) throws CoreException {
        if (container == null || container.exists()) {
            return;
        }
        ResourceUtil.createContainer(container.getParent(), progressMonitor);
        if (container instanceof IProject) {
            ((IProject)container).create(progressMonitor);
        } else if (container instanceof IFolder) {
            ((IFolder)container).create(true, true, progressMonitor);
        }
    }

    public static Map getFiles(IWorkspaceRoot workspaceRoot, String[] fileExtensions, IGetFilesVisitor visitor) {
        HashMap filesByFileExtension = new HashMap(fileExtensions.length, 1.1f);
        int i = 0;
        int maxi = fileExtensions.length;
        while (i < maxi) {
            filesByFileExtension.put(fileExtensions[i], new ArrayList());
            ++i;
        }
        if (visitor == null) {
            visitor = new IGetFilesVisitor(){

                public Object visit(IFile file) {
                    return file;
                }
            };
        }
        IProject[] projects = workspaceRoot.getProjects();
        int i2 = 0;
        while (i2 < projects.length) {
            ResourceUtil.getFiles((IResource)projects[i2], filesByFileExtension, visitor);
            ++i2;
        }
        return filesByFileExtension;
    }

    public static Map getFiles(IResource resource, String[] fileExtensions, IGetFilesVisitor visitor) {
        if (resource == null || !resource.exists()) {
            return Collections.EMPTY_MAP;
        }
        if (visitor == null) {
            visitor = new IGetFilesVisitor(){

                public Object visit(IFile file) {
                    return file;
                }
            };
        }
        HashMap filesByFileExtension = new HashMap(fileExtensions.length, 1.1f);
        int i = 0;
        int maxi = fileExtensions.length;
        while (i < maxi) {
            filesByFileExtension.put(fileExtensions[i], new ArrayList());
            ++i;
        }
        ResourceUtil.getFiles(resource, filesByFileExtension, visitor);
        return filesByFileExtension;
    }

    private static void getFiles(IResource resource, Map filesByFileExtension, IGetFilesVisitor visitor) {
        if (resource == null || !resource.exists()) {
            return;
        }
        switch (resource.getType()) {
            case 1: {
                Object object;
                List files = (List)filesByFileExtension.get(resource.getFileExtension());
                if (files == null || (object = visitor.visit((IFile)resource)) == null) break;
                files.add(object);
                break;
            }
            case 4: {
                IProject project = (IProject)resource;
                if (!project.isOpen()) {
                    return;
                }
            }
            case 2: {
                try {
                    IResource[] members = ((IContainer)resource).members();
                    int i = 0;
                    while (i < members.length) {
                        ResourceUtil.getFiles(members[i], filesByFileExtension, visitor);
                        ++i;
                    }
                    break;
                }
                catch (CoreException e) {
                    ResourceUtil.logError(e);
                }
            }
        }
    }

    public static EObject[] load(ResourceSet resourceSet, IFile file) {
        if (file == null) {
            return new EObject[0];
        }
        return ResourceUtil.load(resourceSet, file.getFullPath().toString());
    }

    public static EObject[] load(ResourceSet resourceSet, String fullPath) {
        if (fullPath == null) {
            return new EObject[0];
        }
        URI uri = URI.createPlatformResourceURI((String)fullPath, (boolean)false);
        Resource resource = null;
        try {
            if (resourceSet != null) {
                resource = resourceSet.getResource(uri, true);
            } else {
                Path path = new Path(fullPath);
                Resource.Factory factory = ResourceUtil.getResourceFactory(path.getFileExtension());
                if (factory != null) {
                    resource = factory.createResource(uri);
                    resource.load(RESOURCE_OPTIONS);
                }
            }
        }
        catch (Exception e) {
            ResourceUtil.logError(e);
        }
        if (resource == null) {
            return new EObject[0];
        }
        return (EObject[])resource.getContents().toArray((Object[])new EObject[resource.getContents().size()]);
    }

    public static Resource.Factory getResourceFactory(String fileExtension) {
        Resource.Factory factory;
        if (fileExtension != null && (factory = (Resource.Factory)Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().get(fileExtension)) != null) {
            return factory;
        }
        return (Resource.Factory)Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().get(fileExtension);
    }

    public static final void logError(Throwable e) {
        Status status = new Status(4, ResourcesPlugin.getPlugin().getBundle().getSymbolicName(), 0, e.getMessage(), e);
        ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
        e.printStackTrace();
    }

    public static File getPluginDirectory(String pluginId) {
        File pluginDir = null;
        try {
            URL pluginURL = new URL(Platform.getBundle((String)pluginId).getEntry("/"), "plugin.xml");
            File manifestFile = new File(FileLocator.toFileURL((URL)pluginURL).getFile()).getAbsoluteFile();
            if (manifestFile.exists()) {
                pluginDir = manifestFile.getParentFile();
            }
        }
        catch (Exception e) {
            ModelsPlugin.INSTANCE.log(e);
        }
        return pluginDir;
    }

    public static interface IGetFilesVisitor {
        public Object visit(IFile var1);
    }
}

