/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.internal.probekit;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DataType implements Enumerator
{
    CLASS_NAME_LITERAL(0, "className", "className"),
    METHOD_NAME_LITERAL(1, "methodName", "methodName"),
    METHOD_SIG_LITERAL(2, "methodSig", "methodSig"),
    THIS_OBJECT_LITERAL(3, "thisObject", "thisObject"),
    ARGS_LITERAL(4, "args", "args"),
    RETURNED_OBJECT_LITERAL(5, "returnedObject", "returnedObject"),
    IS_FINALLY_LITERAL(6, "isFinally", "isFinally"),
    EXCEPTION_OBJECT_LITERAL(7, "exceptionObject", "exceptionObject"),
    STATIC_FIELD_LITERAL(8, "staticField", "staticField"),
    CLASS_SOURCE_FILE_LITERAL(9, "classSourceFile", "classSourceFile"),
    METHOD_NAMES_LITERAL(10, "methodNames", "methodNames"),
    METHOD_LINE_TABLES_LITERAL(11, "methodLineTables", "methodLineTables"),
    METHOD_NUMBER_LITERAL(12, "methodNumber", "methodNumber"),
    EXECUTABLE_UNIT_NUMBER_LITERAL(13, "executableUnitNumber", "executableUnitNumber"),
    PREVIOUS_UNIT_NUMBER_LITERAL(14, "numPreviousUnits", "numPreviousUnits");

    public static final int CLASS_NAME = 0;
    public static final int METHOD_NAME = 1;
    public static final int METHOD_SIG = 2;
    public static final int THIS_OBJECT = 3;
    public static final int ARGS = 4;
    public static final int RETURNED_OBJECT = 5;
    public static final int IS_FINALLY = 6;
    public static final int EXCEPTION_OBJECT = 7;
    public static final int STATIC_FIELD = 8;
    public static final int CLASS_SOURCE_FILE = 9;
    public static final int METHOD_NAMES = 10;
    public static final int METHOD_LINE_TABLES = 11;
    public static final int METHOD_NUMBER = 12;
    public static final int EXECUTABLE_UNIT_NUMBER = 13;
    public static final int PREVIOUS_UNIT_NUMBER = 14;
    private static final DataType[] VALUES_ARRAY;
    public static final List<DataType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DataType[]{CLASS_NAME_LITERAL, METHOD_NAME_LITERAL, METHOD_SIG_LITERAL, THIS_OBJECT_LITERAL, ARGS_LITERAL, RETURNED_OBJECT_LITERAL, IS_FINALLY_LITERAL, EXCEPTION_OBJECT_LITERAL, STATIC_FIELD_LITERAL, CLASS_SOURCE_FILE_LITERAL, METHOD_NAMES_LITERAL, METHOD_LINE_TABLES_LITERAL, METHOD_NUMBER_LITERAL, EXECUTABLE_UNIT_NUMBER_LITERAL, PREVIOUS_UNIT_NUMBER_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DataType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataType get(int value) {
        switch (value) {
            case 0: {
                return CLASS_NAME_LITERAL;
            }
            case 1: {
                return METHOD_NAME_LITERAL;
            }
            case 2: {
                return METHOD_SIG_LITERAL;
            }
            case 3: {
                return THIS_OBJECT_LITERAL;
            }
            case 4: {
                return ARGS_LITERAL;
            }
            case 5: {
                return RETURNED_OBJECT_LITERAL;
            }
            case 6: {
                return IS_FINALLY_LITERAL;
            }
            case 7: {
                return EXCEPTION_OBJECT_LITERAL;
            }
            case 8: {
                return STATIC_FIELD_LITERAL;
            }
            case 9: {
                return CLASS_SOURCE_FILE_LITERAL;
            }
            case 10: {
                return METHOD_NAMES_LITERAL;
            }
            case 11: {
                return METHOD_LINE_TABLES_LITERAL;
            }
            case 12: {
                return METHOD_NUMBER_LITERAL;
            }
            case 13: {
                return EXECUTABLE_UNIT_NUMBER_LITERAL;
            }
            case 14: {
                return PREVIOUS_UNIT_NUMBER_LITERAL;
            }
        }
        return null;
    }

    private DataType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

