/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.internal.probekit;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FragmentType implements Enumerator
{
    ENTRY_LITERAL(0, "entry", "entry"),
    CATCH_LITERAL(1, "catch", "catch"),
    EXIT_LITERAL(2, "exit", "exit"),
    BEFORE_CALL_LITERAL(3, "beforeCall", "beforeCall"),
    AFTER_CALL_LITERAL(4, "afterCall", "afterCall"),
    STATIC_INITIALIZER_LITERAL(5, "staticInitializer", "staticInitializer"),
    EXECUTABLE_UNIT_LITERAL(6, "executableUnit", "executableUnit");

    public static final int ENTRY = 0;
    public static final int CATCH = 1;
    public static final int EXIT = 2;
    public static final int BEFORE_CALL = 3;
    public static final int AFTER_CALL = 4;
    public static final int STATIC_INITIALIZER = 5;
    public static final int EXECUTABLE_UNIT = 6;
    private static final FragmentType[] VALUES_ARRAY;
    public static final List<FragmentType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FragmentType[]{ENTRY_LITERAL, CATCH_LITERAL, EXIT_LITERAL, BEFORE_CALL_LITERAL, AFTER_CALL_LITERAL, STATIC_INITIALIZER_LITERAL, EXECUTABLE_UNIT_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FragmentType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FragmentType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FragmentType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FragmentType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FragmentType get(int value) {
        switch (value) {
            case 0: {
                return ENTRY_LITERAL;
            }
            case 1: {
                return CATCH_LITERAL;
            }
            case 2: {
                return EXIT_LITERAL;
            }
            case 3: {
                return BEFORE_CALL_LITERAL;
            }
            case 4: {
                return AFTER_CALL_LITERAL;
            }
            case 5: {
                return STATIC_INITIALIZER_LITERAL;
            }
            case 6: {
                return EXECUTABLE_UNIT_LITERAL;
            }
        }
        return null;
    }

    private FragmentType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

