/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.trace;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TRCObjectValueKind implements Enumerator
{
    THIS_LITERAL(0, "this", "this"),
    AGGREGATED_LITERAL(1, "aggregated", "aggregated"),
    QUERY_LITERAL(2, "query", "query"),
    PROTOCOL_LITERAL(3, "protocol", "protocol"),
    EXCEPTION_LITERAL(4, "exception", "exception");

    public static final int THIS = 0;
    public static final int AGGREGATED = 1;
    public static final int QUERY = 2;
    public static final int PROTOCOL = 3;
    public static final int EXCEPTION = 4;
    private static final TRCObjectValueKind[] VALUES_ARRAY;
    public static final List<TRCObjectValueKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TRCObjectValueKind[]{THIS_LITERAL, AGGREGATED_LITERAL, QUERY_LITERAL, PROTOCOL_LITERAL, EXCEPTION_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TRCObjectValueKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TRCObjectValueKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TRCObjectValueKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TRCObjectValueKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TRCObjectValueKind get(int value) {
        switch (value) {
            case 0: {
                return THIS_LITERAL;
            }
            case 1: {
                return AGGREGATED_LITERAL;
            }
            case 2: {
                return QUERY_LITERAL;
            }
            case 3: {
                return PROTOCOL_LITERAL;
            }
            case 4: {
                return EXCEPTION_LITERAL;
            }
        }
        return null;
    }

    private TRCObjectValueKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

