/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.probekit.launch.internal.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;
import org.eclipse.hyades.probekit.ProbekitPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IExtendedProfilingType;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;
import org.eclipse.hyades.trace.ui.launcher.ProfilingAttribute;
import org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.tptp.platform.probekit.launch.internal.ProbekitLaunchPlugin;
import org.eclipse.tptp.platform.probekit.launch.internal.ProbekitLaunchUI;
import org.eclipse.tptp.platform.probekit.launch.internal.config.ProbePropertiesUI;
import org.eclipse.tptp.platform.probekit.launch.internal.config.ProbekitLaunchMessages;
import org.eclipse.tptp.platform.probekit.registry.ProbeRegistryEntry;
import org.eclipse.tptp.platform.probekit.util.InvalidProbeBundleException;
import org.eclipse.tptp.platform.probekit.util.ProbeLaunchConfigString;

public class ProbekitProfilingType
implements IExtendedProfilingType {
    private Composite _form;
    private ProbePropertiesUI _propertiesUI;
    private IDialogSettings _settings;
    private ProbekitLaunchUI probeUI;

    public synchronized String getVMArguments(ILaunchConfiguration conf) {
        String vmArgument = "";
        String bootClassPath = "-Xbootclasspath/p:";
        String workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        boolean log = Boolean.getBoolean("probekitLogging");
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") != -1) {
            bootClassPath = String.valueOf(bootClassPath) + "\"";
        }
        String pathSeparator = System.getProperty("path.separator");
        Map activeProbes = this.getActiveProbes(conf);
        Iterator iterKeys = activeProbes.keySet().iterator();
        while (iterKeys.hasNext()) {
            IClasspathEntry[] classpathEntryList;
            String workspaceOfProbeFile;
            String key = iterKeys.next().toString();
            String strProbeSpec = (String)activeProbes.get(key);
            ProbeLaunchConfigString probeConfigDeploy = ProbeLaunchConfigString.fromString((String)strProbeSpec);
            String strProbeID = probeConfigDeploy.getRegistryId();
            ProbeRegistryEntry registryEntry = this.probeUI.getRegistry().lookupById(strProbeID);
            IResource probeSource = null;
            try {
                probeSource = registryEntry.getSource();
            }
            catch (InvalidProbeBundleException e) {
                Status status = new Status(4, "org.eclipse.tptp.platform.probekit.launch", 0, ProbekitLaunchMessages._29, (Throwable)e);
                ProbekitPlugin.getDefault().getLog().log((IStatus)status);
                continue;
            }
            if (probeSource == null) {
                Status status = new Status(4, "org.eclipse.tptp.platform.probekit.launch", 0, ProbekitLaunchMessages._30, null);
                ProbekitPlugin.getDefault().getLog().log((IStatus)status);
                continue;
            }
            IJavaProject javaProject = JavaCore.create((IProject)probeSource.getProject());
            if (javaProject == null) continue;
            String projectName = javaProject.getPath().toString();
            if (log) {
                String message = NLS.bind((String)ProbekitLaunchMessages._36, (Object)projectName);
                Status status = new Status(1, "org.eclipse.tptp.platform.probekit.launch", 0, message, null);
                ProbekitPlugin.getDefault().getLog().log((IStatus)status);
                message = NLS.bind((String)ProbekitLaunchMessages._37, (Object)probeSource.toString());
                status = new Status(1, "org.eclipse.tptp.platform.probekit.launch", 0, message, null);
                ProbekitPlugin.getDefault().getLog().log((IStatus)status);
            }
            if ((workspaceOfProbeFile = probeSource.getLocation().toString()).indexOf(workspaceLocation) == -1) {
                workspaceLocation = workspaceOfProbeFile.substring(0, workspaceOfProbeFile.indexOf(projectName));
            }
            try {
                bootClassPath = String.valueOf(bootClassPath) + workspaceLocation + javaProject.getOutputLocation() + pathSeparator;
            }
            catch (JavaModelException e1) {
                Status status = new Status(4, "org.eclipse.tptp.platform.probekit.launch", 0, ProbekitLaunchMessages._33, (Throwable)e1);
                ProbekitPlugin.getDefault().getLog().log((IStatus)status);
            }
            try {
                classpathEntryList = javaProject.getRawClasspath();
            }
            catch (JavaModelException e) {
                Status status = new Status(4, "org.eclipse.tptp.platform.probekit.launch", 0, ProbekitLaunchMessages._31, (Throwable)e);
                ProbekitPlugin.getDefault().getLog().log((IStatus)status);
                continue;
            }
            int i = 0;
            while (i < classpathEntryList.length) {
                block37: {
                    String logMessage;
                    block36: {
                        IClasspathEntry classpathEntry = classpathEntryList[i];
                        int type = classpathEntry.getEntryKind();
                        logMessage = "Type:";
                        if (type == 3) {
                            if (classpathEntry.getPath().toString().startsWith(projectName)) {
                                bootClassPath = String.valueOf(bootClassPath) + workspaceLocation;
                            }
                            bootClassPath = String.valueOf(bootClassPath) + classpathEntry.getPath().toString() + pathSeparator;
                            logMessage = String.valueOf(logMessage) + "Source  Path:" + classpathEntry.getPath().toString();
                        } else if (type == 1) {
                            if (classpathEntry.getPath().toString().startsWith(projectName)) {
                                bootClassPath = String.valueOf(bootClassPath) + workspaceLocation;
                            }
                            bootClassPath = String.valueOf(bootClassPath) + classpathEntry.getPath().toString() + pathSeparator;
                            logMessage = String.valueOf(logMessage) + "Library  Path:" + classpathEntry.getPath().toString();
                        } else {
                            if (type == 2) {
                                IProject dependentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(classpathEntry.getPath().toString().substring(1));
                                IJavaProject dependentJavaProject = JavaCore.create((IProject)dependentProject.getProject());
                                try {
                                    bootClassPath = String.valueOf(bootClassPath) + workspaceLocation + dependentJavaProject.getOutputLocation().toString() + pathSeparator;
                                    logMessage = String.valueOf(logMessage) + "Project  Path:" + dependentJavaProject.getOutputLocation().toString();
                                    break block36;
                                }
                                catch (JavaModelException e) {
                                    Status status = new Status(4, "org.eclipse.tptp.platform.probekit.launch", 0, ProbekitLaunchMessages._33, (Throwable)e);
                                    ProbekitPlugin.getDefault().getLog().log((IStatus)status);
                                    break block37;
                                }
                            }
                            if (type == 4) {
                                if (classpathEntry.getPath().toString().startsWith(projectName)) {
                                    bootClassPath = String.valueOf(bootClassPath) + workspaceLocation;
                                }
                                bootClassPath = String.valueOf(bootClassPath) + JavaCore.getClasspathVariable((String)classpathEntry.getPath().toString()).toString() + pathSeparator;
                                logMessage = String.valueOf(logMessage) + "Variable  Path:" + JavaCore.getClasspathVariable((String)classpathEntry.getPath().toString()).toString();
                            } else if (type == 5) {
                                String logContainerContent = "";
                                String containerName = classpathEntry.getPath().toString();
                                if (containerName.indexOf("JRE_CONTAINER") != -1) {
                                    logMessage = String.valueOf(logMessage) + "Container " + containerName + " is being ignored";
                                } else {
                                    IClasspathEntry[] containerContent;
                                    try {
                                        containerContent = JavaCore.getClasspathContainer((IPath)classpathEntry.getPath(), (IJavaProject)javaProject).getClasspathEntries();
                                    }
                                    catch (JavaModelException e) {
                                        Status status = new Status(4, "org.eclipse.tptp.platform.probekit.launch", 0, ProbekitLaunchMessages._32, (Throwable)e);
                                        ProbekitPlugin.getDefault().getLog().log((IStatus)status);
                                        break block37;
                                    }
                                    int k = 0;
                                    while (k < containerContent.length) {
                                        classpathEntry = containerContent[k];
                                        type = classpathEntry.getEntryKind();
                                        if (type == 3 || type == 1 || type == 2) {
                                            if (classpathEntry.getPath().toString().startsWith(projectName)) {
                                                bootClassPath = String.valueOf(bootClassPath) + workspaceLocation;
                                            }
                                            bootClassPath = String.valueOf(bootClassPath) + classpathEntry.getPath().toString() + pathSeparator;
                                            logContainerContent = String.valueOf(logContainerContent) + classpathEntry.getPath().toString() + pathSeparator;
                                        } else {
                                            String message = NLS.bind((String)ProbekitLaunchMessages._34, (Object)new Integer(type));
                                            Status status = new Status(4, "org.eclipse.tptp.platform.probekit.launch", 0, message, null);
                                            ProbekitPlugin.getDefault().getLog().log((IStatus)status);
                                        }
                                        ++k;
                                    }
                                    logMessage = String.valueOf(logMessage) + "Container  Name:" + containerName + "  Path:" + logContainerContent;
                                }
                            }
                        }
                    }
                    if (log) {
                        Status status = new Status(1, "org.eclipse.tptp.platform.probekit.launch", 0, logMessage, null);
                        ProbekitPlugin.getDefault().getLog().log((IStatus)status);
                    }
                }
                ++i;
            }
        }
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") != -1) {
            bootClassPath = String.valueOf(bootClassPath) + "\"";
        }
        String osgiProperty = "-Dorg.osgi.framework.bootdelegation=\"*\"";
        if (log) {
            String message = NLS.bind((String)ProbekitLaunchMessages._35, (Object)bootClassPath);
            Status status = new Status(1, "org.eclipse.tptp.platform.probekit.launch", 0, message, null);
            ProbekitPlugin.getDefault().getLog().log((IStatus)status);
        }
        vmArgument = String.valueOf(bootClassPath) + " " + osgiProperty;
        return vmArgument;
    }

    public ProbekitProfilingType() {
        ProbekitLaunchPlugin plugin = ProbekitLaunchPlugin.getDefault();
        IDialogSettings workbenchSettings = plugin.getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("ProbeLaunchDialog");
        if (section == null) {
            section = workbenchSettings.addNewSection("ProbeLaunchDialog");
        }
        this._settings = section;
        this.probeUI = new ProbekitLaunchUI();
    }

    public Control createControl(Composite parent, ProfilingSetsManagerCopy config) {
        return this.probeUI.CreateControl(parent, config, true);
    }

    public Control getControl(String profilingSetName) {
        Table _tblProbeSets = this.probeUI.getProbeSets();
        if (_tblProbeSets.getItemCount() > 0) {
            ProbeRegistryEntry entry;
            TableItem tableItem;
            int indexSelection = _tblProbeSets.getSelectionIndex();
            if (indexSelection < 0) {
                indexSelection = 0;
            }
            if ((tableItem = _tblProbeSets.getItem(indexSelection)) != null && (entry = (ProbeRegistryEntry)tableItem.getData()) != null) {
                this._propertiesUI.updateWidgetValues(entry);
            }
        }
        return this._form;
    }

    protected void restoreSelections() {
        Table _tblProbeSets = this.probeUI.getProbeSets();
        String strSelection = "";
        String strTab = "";
        if (this._settings != null) {
            strSelection = this._settings.get("ProbeTableSelection");
            strTab = this._settings.get("ProbeFolderSelection");
        }
        if (strSelection != null && strSelection.length() > 0) {
            int iNumProbeSets = _tblProbeSets.getItemCount();
            TableItem[] items = _tblProbeSets.getItems();
            int j = 0;
            while (j < iNumProbeSets) {
                String strEntryID;
                ProbeRegistryEntry entry = (ProbeRegistryEntry)items[j].getData();
                if (entry != null && (strEntryID = entry.getId()).equals(strSelection)) {
                    _tblProbeSets.select(j);
                }
                ++j;
            }
        } else if (_tblProbeSets.getItemCount() > 0) {
            _tblProbeSets.select(0);
        }
        if (strTab != null && strTab.length() > 0) {
            strTab.equals(ProbekitLaunchMessages._19);
        }
    }

    protected void initializeValues(ProfilingSetsManagerCopy config) {
        int iNumProbeSets = this.probeUI.getProbeSets().getItemCount();
        TableItem[] items = this.probeUI.getProbeSets().getItems();
        Map configAttributes = config.getDefaultSet().getAttributes();
        int index = 0;
        String strName = "SETOPTION_org.eclipse.tptp.platform.probekit.Probespec." + this.probeUI.PROBE_LAUNCH_UNIQUE_PROBESPEC_SUFFIX + index;
        ProfilingAttribute attribute = (ProfilingAttribute)configAttributes.get(strName);
        while (attribute != null) {
            String strValue = attribute.getValue();
            ProbeLaunchConfigString probeConfig = ProbeLaunchConfigString.fromString((String)strValue);
            if (probeConfig != null) {
                String strProbeKitID = probeConfig.getRegistryId();
                int j = 0;
                while (j < iNumProbeSets) {
                    String strEntryID;
                    ProbeRegistryEntry entry = (ProbeRegistryEntry)items[j].getData();
                    if (entry != null && (strEntryID = entry.getId()).equals(strProbeKitID)) {
                        items[j].setChecked(true);
                        break;
                    }
                    ++j;
                }
            }
            strName = "SETOPTION_org.eclipse.tptp.platform.probekit.Probespec." + this.probeUI.PROBE_LAUNCH_UNIQUE_PROBESPEC_SUFFIX + ++index;
            attribute = (ProfilingAttribute)configAttributes.get(strName);
        }
    }

    protected Map getActiveProbes(ILaunchConfiguration launchConfig) {
        String strProbeDeployPrefix = "org.eclipse.tptp.platform.probekit.Probespec." + this.probeUI.PROBE_LAUNCH_UNIQUE_PROBESPEC_SUFFIX;
        Map map = this.getOptions(launchConfig, strProbeDeployPrefix);
        return map;
    }

    protected Map getOptions(ILaunchConfiguration launchConfig, String strPrefix) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            ProfilingSetsManager psm = ProfilingSetsManager.instance();
            Vector configOptions = psm.getOptions(launchConfig);
            for (AgentConfigurationEntry entry : configOptions) {
                String strName;
                if (entry == null || (strName = entry.getName()) == null || !strName.startsWith(strPrefix)) continue;
                String strValue = entry.getValue();
                map.put(strName, strValue);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return map;
    }

    public ProfilingAttribute[] getAttributes() {
        ArrayList<ProfilingAttribute> config = new ArrayList<ProfilingAttribute>();
        int iCheckedCount = 0;
        int iNumProbeSets = this.probeUI.getProbeSets().getItemCount();
        if (iNumProbeSets > 0) {
            TableItem[] items = this.probeUI.getProbeSets().getItems();
            int i = 0;
            while (i < iNumProbeSets) {
                ProbeRegistryEntry entry = (ProbeRegistryEntry)items[i].getData();
                if (entry != null) {
                    String strValueID = entry.getId();
                    ProbeLaunchConfigString probe = new ProbeLaunchConfigString();
                    probe.addProbeID(strValueID);
                    if (items[i].getChecked()) {
                        boolean bMatchingSetFound = false;
                        FilterSetElement set = this.probeUI.getManager().getDefaultFilterSet();
                        ArrayList attrs = null;
                        StringBuffer filterStr = new StringBuffer();
                        if (set != null) {
                            attrs = set.getChildren();
                            int idx = 0;
                            while (idx < attrs.size()) {
                                FilterTableElement elem = (FilterTableElement)attrs.get(idx);
                                filterStr.append(elem.getText());
                                if (elem.getMethod().length() > 0) {
                                    filterStr.append(":").append(elem.getMethod());
                                }
                                filterStr.append(":").append(elem.getVisibility());
                                filterStr.append("&");
                                ++idx;
                            }
                        }
                        if (bMatchingSetFound) {
                            probe.addFilters(filterStr.toString());
                        } else {
                            probe.useDefaultFilters();
                        }
                        String strName = "SETOPTION_org.eclipse.tptp.platform.probekit.Probespec." + this.probeUI.PROBE_LAUNCH_UNIQUE_PROBESPEC_SUFFIX + iCheckedCount;
                        String strValueProbeLaunch = probe.toString();
                        ProfilingAttribute attributeProbe = new ProfilingAttribute(strName, strValueProbeLaunch);
                        config.add(attributeProbe);
                        ++iCheckedCount;
                    }
                }
                ++i;
            }
        }
        ProfilingAttribute[] pOptions = new ProfilingAttribute[config.size()];
        config.toArray(pOptions);
        this.probeUI.saveSelections(iCheckedCount);
        return pOptions;
    }

    public String validateConfiguration(ProfilingSetsManagerCopy managerCopy) {
        return this.probeUI.validateConfiguration(managerCopy);
    }

    public String launch(final ILaunchConfiguration config) {
        final ProfilingSetsManager psm = ProfilingSetsManager.instance();
        final ArrayList<String> invalidProbes = new ArrayList<String>();
        String strMissingOrInvalidProbes = "";
        String strLineSeparator = System.getProperty("line.separator");
        try {
            Map mapProbeSpecs = this.getActiveProbes(config);
            Iterator iterKeys = mapProbeSpecs.keySet().iterator();
            while (iterKeys.hasNext()) {
                String key = iterKeys.next().toString();
                String strProbeSpec = (String)mapProbeSpecs.get(key);
                ProbeLaunchConfigString probeConfigDeploy = ProbeLaunchConfigString.fromString((String)strProbeSpec);
                String strProbeID = probeConfigDeploy.getRegistryId();
                ProbeRegistryEntry entry = this.probeUI.getRegistry().lookupById(strProbeID);
                if (entry == null) {
                    strMissingOrInvalidProbes = String.valueOf(strMissingOrInvalidProbes) + strProbeID + strLineSeparator;
                    invalidProbes.add(strProbeID);
                    continue;
                }
                try {
                    entry.fullValidate();
                }
                catch (InvalidProbeBundleException invalidProbeBundleException) {
                    strMissingOrInvalidProbes = String.valueOf(strMissingOrInvalidProbes) + strProbeID + strLineSeparator;
                    invalidProbes.add(strProbeID);
                    this.probeUI.getRegistry().remove(entry);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (strMissingOrInvalidProbes.length() > 0) {
            strMissingOrInvalidProbes = String.valueOf(strLineSeparator) + strMissingOrInvalidProbes;
            final String strWarningQuery = NLS.bind((String)ProbekitLaunchMessages._26, (Object)strMissingOrInvalidProbes);
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    boolean bOK = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)ProbekitLaunchMessages._27, (String)strWarningQuery);
                    if (bOK) {
                        try {
                            String setID = config.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET, null);
                            IProfilingSet set = (IProfilingSet)psm.getProfilingSets().get(setID);
                            if (set != null) {
                                String strProbeOptionPrefix = "SETOPTION_org.eclipse.tptp.platform.probekit.Probespec." + ((ProbekitProfilingType)ProbekitProfilingType.this).probeUI.PROBE_LAUNCH_UNIQUE_PROBESPEC_SUFFIX;
                                boolean bRemovedProbes = false;
                                Map attributes = set.getAttributes();
                                Iterator iterKeys = attributes.keySet().iterator();
                                while (iterKeys.hasNext()) {
                                    ProfilingAttribute profAttribute;
                                    String strValue;
                                    ProbeLaunchConfigString probeConfigDeploy;
                                    String strID;
                                    String key = iterKeys.next().toString();
                                    if (!key.startsWith(strProbeOptionPrefix) || !invalidProbes.contains(strID = (probeConfigDeploy = ProbeLaunchConfigString.fromString((String)(strValue = (profAttribute = (ProfilingAttribute)attributes.get(key)).getValue()))).getRegistryId())) continue;
                                    iterKeys.remove();
                                    bRemovedProbes = true;
                                }
                                if (bRemovedProbes) {
                                    set.setAttributes(attributes);
                                    psm.writeSetsToPreferences();
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ProbekitLaunchPlugin.reportException(e);
                        }
                    }
                }
            });
        }
        return null;
    }

    public String getDescription(ProfilingSetsManagerCopy config) {
        return this.probeUI.getDescription(config);
    }
}

