/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.probekit.launch.internal.wizard;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tptp.platform.probekit.launch.internal.ProbekitLaunchPlugin;
import org.eclipse.tptp.platform.probekit.launch.internal.wizard.CustomZipFileExporter;
import org.eclipse.tptp.platform.probekit.launch.internal.wizard.Messages;

class CustomZipFileExportOperation
implements IRunnableWithProgress {
    private CustomZipFileExporter exporter;
    private String destinationFilename;
    private IProgressMonitor monitor;
    private List resourcesToExport;
    private IResource resource;
    private List errorTable = new ArrayList(1);
    private boolean useCompression = true;
    private boolean createLeadupStructure = true;
    private boolean generateManifestFile = false;

    public CustomZipFileExportOperation(List resources, String filename) {
        Iterator elementsEnum = resources.iterator();
        while (elementsEnum.hasNext()) {
            IResource currentResource = (IResource)elementsEnum.next();
            if (!this.isDescendent(resources, currentResource)) continue;
            elementsEnum.remove();
        }
        this.resourcesToExport = resources;
        this.destinationFilename = filename;
    }

    public CustomZipFileExportOperation(IResource res, String filename) {
        this.resource = res;
        this.destinationFilename = filename;
    }

    public CustomZipFileExportOperation(IResource res, List resources, String filename) {
        this(res, filename);
        this.resourcesToExport = resources;
    }

    protected void addError(String message, Throwable e) {
        this.errorTable.add(new Status(4, ProbekitLaunchPlugin.getPluginId(), 0, message, e));
    }

    protected int countChildrenOf(IResource checkResource) throws CoreException {
        if (checkResource.getType() == 1) {
            return 1;
        }
        int count = 0;
        if (checkResource.isAccessible()) {
            IResource[] children = ((IContainer)checkResource).members();
            int i = 0;
            while (i < children.length) {
                count += this.countChildrenOf(children[i]);
                ++i;
            }
        }
        return count;
    }

    protected int countSelectedResources() throws CoreException {
        int result = 0;
        Iterator resources = this.resourcesToExport.iterator();
        while (resources.hasNext()) {
            result += this.countChildrenOf((IResource)resources.next());
        }
        return result;
    }

    protected void exportResource(IResource exportResource) throws InterruptedException {
        this.exportResource(exportResource, 1);
    }

    protected void exportResource(IResource exportResource, int leadupDepth) throws InterruptedException {
        if (!exportResource.isAccessible()) {
            return;
        }
        if (exportResource.getType() == 1) {
            IPath fullPath = exportResource.getFullPath();
            String destinationName = this.createLeadupStructure ? fullPath.makeRelative().toString() : fullPath.removeFirstSegments(fullPath.segmentCount() - leadupDepth).toString();
            this.monitor.subTask(destinationName);
            try {
                this.exporter.write((IFile)exportResource, destinationName);
            }
            catch (IOException e) {
                this.addError(NLS.bind((String)Messages.ErrorExporting, (Object[])new Object[]{exportResource.getFullPath().makeRelative(), e.getMessage()}), e);
            }
            catch (CoreException e) {
                this.addError(NLS.bind((String)Messages.ErrorExporting, (Object[])new Object[]{exportResource.getFullPath().makeRelative(), e.getMessage()}), e);
            }
            this.monitor.worked(1);
            ModalContext.checkCanceled((IProgressMonitor)this.monitor);
        } else {
            IResource[] children = null;
            try {
                children = ((IContainer)exportResource).members();
            }
            catch (CoreException e) {
                this.addError(NLS.bind((String)Messages.ErrorExporting, (Object[])new Object[]{exportResource.getFullPath()}), e);
            }
            int i = 0;
            while (i < children.length) {
                this.exportResource(children[i], leadupDepth + 1);
                ++i;
            }
        }
    }

    protected void exportSpecifiedResources() throws InterruptedException {
        for (IResource currentResource : this.resourcesToExport) {
            this.exportResource(currentResource);
        }
    }

    public List getResult() {
        return this.errorTable;
    }

    public IStatus getStatus() {
        IStatus[] errors = new IStatus[this.errorTable.size()];
        this.errorTable.toArray(errors);
        return new MultiStatus(ProbekitLaunchPlugin.getPluginId(), 0, errors, Messages.ProblemsExporting, null);
    }

    protected void initialize() throws IOException {
        this.exporter = new CustomZipFileExporter(this.destinationFilename, this.useCompression, this.generateManifestFile);
    }

    protected boolean isDescendent(List resources, IResource child) {
        if (child.getType() == 4) {
            return false;
        }
        IContainer parent = child.getParent();
        if (resources.contains(parent)) {
            return true;
        }
        return this.isDescendent(resources, (IResource)parent);
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        this.monitor = progressMonitor;
        try {
            this.initialize();
        }
        catch (IOException e) {
            throw new InvocationTargetException(e, NLS.bind((String)Messages.CannotOpen, (Object[])new Object[]{e.getMessage()}));
        }
        try {
            int totalWork = -1;
            try {
                totalWork = this.resourcesToExport == null ? this.countChildrenOf(this.resource) : this.countSelectedResources();
            }
            catch (CoreException coreException) {}
            this.monitor.beginTask(Messages.ExportingTitle, totalWork);
            if (this.resourcesToExport == null) {
                this.exportResource(this.resource);
            } else {
                this.exportSpecifiedResources();
            }
            try {
                this.exporter.finished();
            }
            catch (IOException e) {
                throw new InvocationTargetException(e, NLS.bind((String)Messages.CannotClose, (Object[])new Object[]{e.getMessage()}));
            }
        }
        finally {
            this.monitor.done();
        }
    }

    public void setCreateLeadupStructure(boolean value) {
        this.createLeadupStructure = value;
    }

    public void setGenerateManifestFile(boolean value) {
        this.generateManifestFile = value;
    }

    public void setUseCompression(boolean value) {
        this.useCompression = value;
    }
}

