/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.probekit.launch.internal.wizard;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.probekit.launch.internal.ProbekitLaunchPlugin;
import org.eclipse.tptp.platform.probekit.launch.internal.wizard.CustomWizardFileSystemResourceExportPage1;
import org.eclipse.tptp.platform.probekit.launch.internal.wizard.CustomZipFileExportOperation;
import org.eclipse.tptp.platform.probekit.launch.internal.wizard.IProbekitUIHelpContextIDs;
import org.eclipse.tptp.platform.probekit.launch.internal.wizard.Messages;
import org.eclipse.tptp.platform.probekit.util.InvalidProbeBundleException;
import org.eclipse.tptp.platform.probekit.util.ProbeBundleBuildRequiredException;
import org.eclipse.tptp.platform.probekit.util.ProbeBundleException;
import org.eclipse.tptp.platform.probekit.util.ProbeResourceBundle;
import org.eclipse.ui.PlatformUI;

public class ExportProbeWizardPage
extends CustomWizardFileSystemResourceExportPage1 {
    protected Button includeSourceFileCheckbox;
    private static final String STORE_DESTINATION_NAMES_ID = "ExportProbeWizardPage.STORE_DESTINATION_NAMES_ID";
    private static final String STORE_INCLUDE_SOURCE_ID = "ExportProbeWizardPage.STORE_INCLUDE_SOURCE_ID";

    protected ExportProbeWizardPage(String name, IStructuredSelection selection) {
        super(name, selection);
        this.setTitle(name);
        this.setDescription(Messages.Description);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IProbekitUIHelpContextIDs.EXPORT_PROBE_WIZARD_PAGE);
        this.giveFocusToTree();
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        this.includeSourceFileCheckbox = new Button((Composite)optionsGroup, 16416);
        this.includeSourceFileCheckbox.setText(Messages.IncludeSourceCheckbox);
        this.includeSourceFileCheckbox.setSelection(true);
    }

    protected void updateWidgetEnablements() {
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setMessage(null);
        }
        super.updateWidgetEnablements();
    }

    protected boolean determinePageCompletion() {
        return super.determinePageCompletion();
    }

    protected boolean ensureTargetDirectoryIsValid(String fullPathname) {
        int separatorIndex = fullPathname.lastIndexOf(File.separator);
        if (separatorIndex == -1) {
            return true;
        }
        return this.ensureTargetIsValid(new File(fullPathname.substring(0, separatorIndex)));
    }

    protected boolean ensureTargetFileIsValid(File targetFile) {
        if (targetFile.exists() && targetFile.isDirectory()) {
            this.displayErrorDialog(Messages.MustBeFile);
            this.giveFocusToDestination();
            return false;
        }
        if (targetFile.exists()) {
            if (targetFile.canWrite()) {
                if (!this.queryYesNoQuestion(Messages.AlreadyExists)) {
                    return false;
                }
            } else {
                this.displayErrorDialog(Messages.AlreadyExistsError);
                this.giveFocusToDestination();
                return false;
            }
        }
        String strExtension = this.getOutputSuffix();
        String strFileName = targetFile.getName();
        if (!strFileName.endsWith(strExtension)) {
            this.displayErrorDialog(Messages.InvalidExtension);
            this.giveFocusToDestination();
            return false;
        }
        return true;
    }

    protected boolean ensureTargetIsValid() {
        String targetPath = this.getDestinationValue();
        if (!this.ensureTargetDirectoryIsValid(targetPath)) {
            return false;
        }
        return this.ensureTargetFileIsValid(new File(targetPath));
    }

    protected boolean executeExportOperation(CustomZipFileExportOperation op) {
        op.setCreateLeadupStructure(false);
        op.setUseCompression(false);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException());
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)this.getErrorDialogTitle(), null, (IStatus)status);
            return false;
        }
        return true;
    }

    public boolean finish() {
        if (!this.ensureTargetIsValid()) {
            return false;
        }
        List resourcesToExport = this.getCurrentResourceSelection();
        if (resourcesToExport.size() > 0) {
            Object obj = resourcesToExport.get(0);
            if (obj instanceof IResource) {
                IResource resource = (IResource)obj;
                if (resource.getType() == 1) {
                    IFile resourceProbeFile = (IFile)resource;
                    try {
                        ProbeResourceBundle bundle = new ProbeResourceBundle((IResource)resourceProbeFile);
                        if (bundle.isComplete()) {
                            boolean bIncludeSource = this.includeSourceFileCheckbox.getSelection();
                            if (!bIncludeSource) {
                                resourcesToExport.remove(resourceProbeFile);
                            }
                            IResource resourceScript = bundle.getScript();
                            resourcesToExport.add(resourceScript);
                            IResource resourceInfo = bundle.getProbeInfo();
                            resourcesToExport.add(resourceInfo);
                            IResource[] resourcesClassFiles = bundle.getSupporting();
                            int i = 0;
                            while (i < resourcesClassFiles.length) {
                                resourcesToExport.add(resourcesClassFiles[i]);
                                ++i;
                            }
                            this.saveDirtyEditors();
                            this.saveWidgetValues();
                            return this.executeExportOperation(new CustomZipFileExportOperation(null, resourcesToExport, this.getDestinationValue()));
                        }
                        String strMessage = NLS.bind((String)Messages.GeneralResourceError, (Object[])new Object[]{resourceProbeFile.getName()});
                        this.displayErrorDialog(strMessage);
                    }
                    catch (InvalidProbeBundleException e) {
                        String strMessage = NLS.bind((String)Messages.GeneralResourceError, (Object[])new Object[]{resourceProbeFile.getName()});
                        String resourceMissing = e.getFileOrResourceName();
                        if (resourceMissing != null && resourceMissing.length() > 0) {
                            strMessage = NLS.bind((String)Messages.MissingResourceError, (Object[])new Object[]{resourceMissing});
                        }
                        this.displayErrorDialog(strMessage);
                    }
                    catch (ProbeBundleBuildRequiredException probeBundleBuildRequiredException) {
                        String strMessage = NLS.bind((String)Messages.BuildRequiredError, (Object)resourceProbeFile.getName());
                        String strLineSeparator = System.getProperty("line.separator");
                        strMessage = String.valueOf(strMessage) + strLineSeparator + NLS.bind((String)Messages.RebuildProjectHint, (Object)resourceProbeFile.getProject().getName());
                        this.displayErrorDialog(strMessage);
                    }
                    catch (ProbeBundleException probeBundleException) {
                        String strMessage = NLS.bind((String)Messages.InvalidProbeSourceError, (Object)resourceProbeFile.getName());
                        String strLineSeparator = System.getProperty("line.separator");
                        strMessage = String.valueOf(strMessage) + strLineSeparator + Messages.PropertyUnavailableError;
                        this.displayErrorDialog(strMessage);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        String strTitle = this.getErrorDialogTitle();
                        String strMessage = Messages.InternalError;
                        ProbekitLaunchPlugin.reportException(e, strTitle, strMessage);
                    }
                } else {
                    String strError = Messages.SourceInvalid;
                    this.setErrorMessage(strError);
                }
            } else {
                String strError = Messages.SourceInvalid;
                this.setErrorMessage(strError);
            }
        } else {
            MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)Messages.InformationDialogTitle, (String)Messages.NoneSelected);
        }
        return false;
    }

    protected void displayErrorDialog(String message) {
        MessageBox mbox = new MessageBox(this.getContainer().getShell(), 33);
        mbox.setMessage(message);
        mbox.setText(this.getErrorDialogTitle());
        mbox.open();
    }

    protected String getDestinationLabel() {
        return Messages.DestinationLabel;
    }

    protected String getDestinationValue() {
        String idealSuffix = this.getOutputSuffix();
        String destinationText = super.getDestinationValue();
        if (destinationText.length() != 0 && !destinationText.endsWith(File.separator)) {
            int dotIndex = destinationText.lastIndexOf(46);
            if (dotIndex != -1) {
                int pathSepIndex = destinationText.lastIndexOf(File.separator);
                if (pathSepIndex != -1 && dotIndex < pathSepIndex) {
                    destinationText = String.valueOf(destinationText) + idealSuffix;
                }
            } else {
                destinationText = String.valueOf(destinationText) + idealSuffix;
            }
        }
        return destinationText;
    }

    protected String getOutputSuffix() {
        return ".probekit";
    }

    protected void internalSaveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = this.addToHistory(directoryNames, this.getDestinationValue());
            settings.put(STORE_DESTINATION_NAMES_ID, directoryNames);
            settings.put(STORE_INCLUDE_SOURCE_ID, this.includeSourceFileCheckbox.getSelection());
        }
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames == null || directoryNames.length == 0) {
                return;
            }
            this.setDestinationValue(directoryNames[0]);
            int i = 0;
            while (i < directoryNames.length) {
                this.addDestinationItem(directoryNames[i]);
                ++i;
            }
            this.includeSourceFileCheckbox.setSelection(settings.getBoolean(STORE_INCLUDE_SOURCE_ID));
        }
    }

    protected String destinationEmptyMessage() {
        return Messages.DestinationEmpty;
    }
}

