/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.probekit.launch.launchpad;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.common.BinaryCustomCommand;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.tptp.platform.probekit.launch.launchpad.LaunchPadException;
import org.eclipse.tptp.platform.probekit.registry.ProbeRegistry;
import org.eclipse.tptp.platform.probekit.registry.ProbeRegistryEntry;
import org.eclipse.tptp.platform.probekit.util.InvalidProbeBundleException;
import org.eclipse.tptp.platform.probekit.util.ProbeLaunchConfigString;
import org.eclipse.tptp.platform.probekit.util.ProbekitDebugConfig;

public class LaunchPad {
    private static final String ENCODING_NAME_UTF8 = "UTF-8";
    private static final String OPCODE_PROBE = "PROBE";
    private static final String OPCODE_RULE = "RULE";
    private static final String OPCODE_RULE_WITH_BLANK = "RULE ";
    private static final String OPCODE_FILTER_WITH_BLANK = "FILTER ";
    private static final String RAC_DEPLOY_SCRIPT_COMMAND = "PROBE_SCRIPT";
    private static final String RAC_DEPLOY_CLASS_COMMAND = "REMOTE_CLASS";
    private static final String RAC_SEND_FILTERS_COMMAND = "PROBE_FILTERS";
    private Agent agent;
    private Vector filters = new Vector();

    private boolean isClass(File file) {
        return file.getName().endsWith(".class");
    }

    private byte[] readFileIntoBuffer(File file) throws FileNotFoundException, IOException {
        byte[] buffer;
        FileInputStream fs = new FileInputStream(file);
        DataInputStream probeStream = new DataInputStream(fs);
        try {
            int bufferSize = (int)file.length();
            buffer = new byte[bufferSize];
            probeStream.read(buffer);
        }
        finally {
            probeStream.close();
        }
        return buffer;
    }

    private byte[] weaveFilters(byte[] script) throws UnsupportedEncodingException {
        if (this.filters.size() == 0) {
            return script;
        }
        String[] probescriptAsStrings = this.convertBytesToStrings(script);
        boolean seenAnyProbeLinesYet = false;
        boolean seenAnyRulesYet = false;
        Vector<String> newProbescriptStringVector = new Vector<String>();
        Vector filtersAsRules = this.createRulesStringVector();
        int i = 0;
        while (i < probescriptAsStrings.length) {
            String opcode = this.getFirstWord(probescriptAsStrings[i]);
            if (opcode.equalsIgnoreCase(OPCODE_PROBE)) {
                if (seenAnyProbeLinesYet && !seenAnyRulesYet) {
                    newProbescriptStringVector.addAll(filtersAsRules);
                }
                seenAnyProbeLinesYet = true;
                seenAnyRulesYet = false;
            } else if (opcode.equalsIgnoreCase(OPCODE_RULE)) {
                seenAnyRulesYet = true;
            }
            newProbescriptStringVector.add(probescriptAsStrings[i]);
            ++i;
        }
        if (seenAnyProbeLinesYet && !seenAnyRulesYet) {
            newProbescriptStringVector.addAll(filtersAsRules);
        }
        newProbescriptStringVector.addAll(this.filters);
        Iterator itr = newProbescriptStringVector.iterator();
        int size = 0;
        while (itr.hasNext()) {
            String next = (String)itr.next();
            size += next.getBytes(ENCODING_NAME_UTF8).length + 1;
        }
        ByteBuffer buf = ByteBuffer.allocate(size);
        for (String next : newProbescriptStringVector) {
            buf.put(next.getBytes(ENCODING_NAME_UTF8));
            buf.put((byte)0);
        }
        return buf.array();
    }

    private Vector createRulesStringVector() {
        Vector<String> result = new Vector<String>();
        int i = 0;
        while (i < this.filters.size()) {
            String s = (String)this.filters.elementAt(i);
            if (s.startsWith(OPCODE_FILTER_WITH_BLANK)) {
                s = OPCODE_RULE_WITH_BLANK + s.substring(OPCODE_FILTER_WITH_BLANK.length());
            }
            result.add(s);
            ++i;
        }
        return result;
    }

    private String[] convertBytesToStrings(byte[] bytes) throws UnsupportedEncodingException {
        String oneBigString = new String(bytes, ENCODING_NAME_UTF8);
        String[] result = oneBigString.split("[\u0000\n\r\u0085\u2028\u2029]");
        return result;
    }

    private String getFirstWord(String input) {
        String[] splitResult = input.trim().split("\\s+", 2);
        return splitResult[0];
    }

    private String[] translateFilters(String filterString, String prefix) {
        if (filterString == null) {
            return new String[0];
        }
        if (filterString.endsWith("&")) {
            filterString = filterString.substring(0, filterString.length() - 1);
        }
        String[] filters = filterString.split("[&]");
        Vector<String> rules = new Vector<String>();
        int n = 0;
        while (n < filters.length) {
            StringBuffer rule = new StringBuffer(prefix);
            rule.append(' ');
            String tokenPackage1 = ".";
            String tokenPackage2 = null;
            String tokenClass1 = "*";
            String tokenClass2 = null;
            String tokenMethod = "*";
            String tokenSignature = "*";
            String tokenAction = "EXCLUDE";
            String[] tokens = filters[n].split("[:]");
            int t = 0;
            while (t < tokens.length) {
                String token = tokens[t];
                if (token.compareTo("INCLUDE") == 0 || token.compareTo("EXCLUDE") == 0) {
                    tokenAction = token;
                    break;
                }
                switch (t) {
                    case 0: {
                        int indDot = token.lastIndexOf(46);
                        int indStar = token.indexOf(42);
                        if (indDot != -1) {
                            tokenPackage1 = token.substring(0, indDot);
                            tokenClass1 = token.substring(indDot + 1);
                            if (!token.endsWith("*")) break;
                            tokenPackage2 = token;
                            tokenClass2 = "*";
                            break;
                        }
                        if (indStar != -1) {
                            if (token.startsWith("*")) {
                                if (token.length() > 1 && token.endsWith("*")) {
                                    tokenPackage1 = token;
                                    tokenClass1 = "*";
                                    tokenPackage2 = "*";
                                    tokenClass2 = token;
                                    break;
                                }
                                tokenPackage1 = "*";
                                tokenClass1 = token;
                                break;
                            }
                            tokenPackage1 = token;
                            tokenClass1 = "*";
                            tokenPackage2 = ".";
                            tokenClass2 = token;
                            break;
                        }
                        if (indStar != -1 || indDot != -1) break;
                        tokenClass1 = token;
                        break;
                    }
                    case 1: {
                        tokenMethod = token;
                        break;
                    }
                    case 2: {
                        tokenSignature = token;
                        break;
                    }
                }
                ++t;
            }
            rule.append(tokenPackage1);
            rule.append(' ');
            rule.append(tokenClass1);
            rule.append(' ');
            rule.append(tokenMethod);
            rule.append(' ');
            rule.append(tokenSignature);
            rule.append(' ');
            rule.append(tokenAction);
            rules.add(rule.toString());
            if (tokenPackage2 != null) {
                rule = new StringBuffer(prefix);
                rule.append(' ');
                rule.append(tokenPackage2);
                rule.append(' ');
                rule.append(tokenClass2);
                rule.append(' ');
                rule.append(tokenMethod);
                rule.append(' ');
                rule.append(tokenSignature);
                rule.append(' ');
                rule.append(tokenAction);
                rules.add(rule.toString());
            }
            ++n;
        }
        String[] rulesOut = new String[rules.size()];
        int i = 0;
        while (i < rulesOut.length) {
            rulesOut[i] = (String)rules.get(i);
            ++i;
        }
        return rulesOut;
    }

    private String processDefaultFilters(EList configFilters) {
        Iterator itrFilters = configFilters.iterator();
        StringBuffer newFilter = new StringBuffer();
        boolean insertDelimiter = false;
        while (itrFilters.hasNext()) {
            TRCFilter configFilter = (TRCFilter)itrFilters.next();
            String className = configFilter.getPattern();
            String methodName = configFilter.getOperation();
            String action = configFilter.getType();
            Boolean active = configFilter.getActive();
            if (!active.booleanValue()) continue;
            if (insertDelimiter) {
                newFilter.append('&');
            }
            newFilter.append(className);
            newFilter.append(':');
            newFilter.append(methodName);
            newFilter.append(':');
            newFilter.append(action);
            insertDelimiter = true;
        }
        return newFilter.toString();
    }

    public void deployProbeScript(byte[] probeScriptBuffer) throws LaunchPadException {
        LaunchPad.trace("Deploying probescript of length " + probeScriptBuffer.length);
        try {
            probeScriptBuffer = this.weaveFilters(probeScriptBuffer);
        }
        catch (UnsupportedEncodingException e) {
            throw new LaunchPadException(e);
        }
        BinaryCustomCommand command = new BinaryCustomCommand();
        byte[] header = RAC_DEPLOY_SCRIPT_COMMAND.getBytes();
        int command_size = header.length + 1 + 4 + probeScriptBuffer.length;
        ByteBuffer buffer = ByteBuffer.allocate(command_size);
        buffer.put(header).put((byte)0);
        buffer.putInt(probeScriptBuffer.length);
        buffer.put(probeScriptBuffer);
        command.setData(buffer.array());
        try {
            this.agent.invokeCustomCommand((CustomCommand)command);
        }
        catch (InactiveAgentException e) {
            LaunchPad.trace("InactiveAgentException in deployProbeScript");
            throw new LaunchPadException(e);
        }
    }

    public void deployProbeScript(File probeScriptFile) throws LaunchPadException {
        try {
            byte[] probeScriptBuffer = this.readFileIntoBuffer(probeScriptFile);
            this.deployProbeScript(probeScriptBuffer);
        }
        catch (FileNotFoundException e) {
            LaunchPad.trace("FileNotFoundException in deployProbeScript");
            throw new LaunchPadException(e);
        }
        catch (IOException e) {
            LaunchPad.trace("IOException in deployProbeScript");
            throw new LaunchPadException(e);
        }
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    public void clearFilters() {
        this.filters.clear();
    }

    public void addFilter(String filterString) {
        this.filters.add(filterString);
    }

    public void sendFilters(String[] filterStrings) throws LaunchPadException {
        try {
            int nFilters = filterStrings.length;
            int commandSize = RAC_SEND_FILTERS_COMMAND.length() + 1 + 4;
            int n = 0;
            while (n < filterStrings.length) {
                commandSize += filterStrings[n].getBytes(ENCODING_NAME_UTF8).length + 1;
                ++n;
            }
            ByteBuffer buffer = ByteBuffer.allocate(commandSize);
            buffer.put(RAC_SEND_FILTERS_COMMAND.getBytes()).put((byte)0);
            buffer.putInt(nFilters);
            int n2 = 0;
            while (n2 < filterStrings.length) {
                byte[] filterBytes = filterStrings[n2].getBytes(ENCODING_NAME_UTF8);
                buffer.put(filterBytes).put((byte)0);
                ++n2;
            }
            BinaryCustomCommand command = new BinaryCustomCommand();
            command.setData(buffer.array());
            this.agent.invokeCustomCommand((CustomCommand)command);
        }
        catch (UnsupportedEncodingException e) {
            LaunchPad.trace("UnsupportedEncodingException in deployClass1");
            throw new LaunchPadException(e);
        }
        catch (InactiveAgentException e) {
            LaunchPad.trace("InactiveAgentException in deployClass1");
            throw new LaunchPadException(e);
        }
    }

    public void deployClass(byte[] classBuffer, String className) throws LaunchPadException {
        try {
            byte[] header = RAC_DEPLOY_CLASS_COMMAND.getBytes();
            byte[] classNameBytes = className.getBytes(ENCODING_NAME_UTF8);
            BinaryCustomCommand command = new BinaryCustomCommand();
            int classSize = classBuffer.length;
            int commandSize = header.length + 1 + 4 + classSize + classNameBytes.length + 1;
            ByteBuffer buffer = ByteBuffer.allocate(commandSize);
            buffer.put(header).put((byte)0);
            buffer.putInt(classSize);
            buffer.put(classBuffer);
            buffer.put(classNameBytes).put((byte)0);
            command.setData(buffer.array());
            this.agent.invokeCustomCommand((CustomCommand)command);
        }
        catch (UnsupportedEncodingException e) {
            LaunchPad.trace("UnsupportedEncodingException in deployClass1");
            throw new LaunchPadException(e);
        }
        catch (InactiveAgentException e) {
            LaunchPad.trace("InactiveAgentException in deployClass1");
            throw new LaunchPadException(e);
        }
    }

    public void deployClass(File classFile) throws LaunchPadException {
        try {
            String fileName = classFile.getName();
            int lastSeparator = fileName.lastIndexOf(File.separator);
            String className = fileName.substring(lastSeparator + 1);
            className = className.substring(0, className.indexOf(".class"));
            byte[] classBuffer = this.readFileIntoBuffer(classFile);
            LaunchPad.trace("Deploying class file " + fileName + " of length " + classBuffer.length);
            this.deployClass(classBuffer, className);
        }
        catch (FileNotFoundException e) {
            LaunchPad.trace("FileNotFoundException in deployClass2");
            throw new LaunchPadException(e);
        }
        catch (IOException e) {
            LaunchPad.trace("IOException in deployClass2");
            throw new LaunchPadException(e);
        }
    }

    public void agentActive(TRCAgentProxy agentProxy) throws LaunchPadException {
        this.agent = (Agent)LoadersUtils.locateAgentInstance((TRCAgentProxy)agentProxy);
        if (this.agent == null) {
            throw new LaunchPadException("Agent not found");
        }
        EList configs = agentProxy.getConfigurations();
        Iterator itrConfig = configs.iterator();
        ProbeRegistry registry = ProbeRegistry.getRegistry();
        while (itrConfig.hasNext()) {
            TRCConfiguration config = (TRCConfiguration)itrConfig.next();
            config.getName();
            EList options = config.getOptions();
            for (TRCOption option : options) {
                String key = option.getKey();
                if (!key.startsWith("org.eclipse.tptp.platform.probekit.Probespec.")) continue;
                String value = option.getValue();
                ProbeLaunchConfigString probeConfig = ProbeLaunchConfigString.fromString((String)value);
                String probeFilters = probeConfig.getUseDefaultFilters() ? this.processDefaultFilters(config.getFilters()) : probeConfig.getFilters();
                String[] rules = this.translateFilters(probeFilters, OPCODE_FILTER_WITH_BLANK);
                this.clearFilters();
                int i = 0;
                while (i < rules.length) {
                    this.addFilter(rules[i]);
                    ++i;
                }
                if (probeConfig.getType() == 1) {
                    String probeID = probeConfig.getRegistryId();
                    ProbeRegistryEntry registryEntry = registry.lookupById(probeID);
                    if (registryEntry == null) continue;
                    this.deployProbe(registryEntry);
                    continue;
                }
                String script = probeConfig.getProbeScript();
                this.deployProbeScript(script.getBytes());
            }
        }
    }

    public void deployProbe(ProbeRegistryEntry probeRegistryEntry) throws LaunchPadException {
        try {
            File probeScript = probeRegistryEntry.getProbescript();
            File[] probeFiles = probeRegistryEntry.getFiles();
            this.deployProbeScript(probeScript);
            int i = 0;
            while (i < probeFiles.length) {
                if (this.isClass(probeFiles[i])) {
                    this.deployClass(probeFiles[i]);
                }
                ++i;
            }
        }
        catch (InvalidProbeBundleException invalidProbeBundleException) {
            LaunchPad.trace("InvalidProbeBundleException in deployProbe()");
            throw new LaunchPadException("Invalid registry entry:" + probeRegistryEntry.getId());
        }
    }

    static void trace(String message) {
        if (ProbekitDebugConfig.TRACE_LAUNCHPAD && message != null && message.length() > 0) {
            System.out.println("ProbeLaunchPad: " + message);
        }
    }
}

