/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.profile.server.wst.internal;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.tptp.platform.profile.server.wst.IServerProfileExtender;
import org.eclipse.tptp.platform.profile.server.wst.internal.ServerPlugin;

public class ServerProfileExtender {
    private IConfigurationElement element;
    private IServerProfileExtender extender;

    public ServerProfileExtender(IConfigurationElement element) {
        this.element = element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public String getName() {
        return this.element.getAttribute("name");
    }

    protected IServerProfileExtender getExtender() {
        if (this.extender == null) {
            if (this.element.getAttribute("class") == null) {
                return null;
            }
            try {
                this.extender = (IServerProfileExtender)this.element.createExecutableExtension("class");
            }
            catch (Throwable t) {
                ServerPlugin.logError(new Exception("Could not create delegate " + this.toString() + ": " + t.getMessage()));
            }
        }
        return this.extender;
    }

    public void process(ILaunch launch, IVMInstall vmInstall, VMRunnerConfiguration vmConfig, IProgressMonitor monitor) {
        try {
            IServerProfileExtender extender = this.getExtender();
            if (extender != null) {
                extender.process(launch, vmInstall, vmConfig, monitor);
            }
        }
        catch (Throwable t) {
            ServerPlugin.logError(new Exception("Could not create delegate " + this.toString() + ": " + t.getMessage()));
        }
    }

    public String toString() {
        return "ServerProfileExtender[" + this.getId() + "]";
    }
}

