/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.profile.server.wst.provisional;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.tptp.platform.iac.administrator.internal.common.AdminUtil;

public class ServerProfilingUtils {
    private static String os = Platform.getOS();

    public static String[] getEnvironmentVariables() {
        String probekitPath;
        String jvmTIpath;
        String libenv = "";
        libenv = os.equals("win32") ? "PATH" : (os.equals("aix") ? "LIBPATH" : (os.equals("hpux") ? "SHLIB_PATH" : "LD_LIBRARY_PATH"));
        String pathValue = null;
        String tptpAcHomeValue = null;
        String javaProfilerHomeValue = null;
        String classPathValue = null;
        String iacBinHome = AdminUtil.getIACBinFolder();
        String iacHome = AdminUtil.getIACHome();
        String acHome = AdminUtil.getIACHome();
        if (iacBinHome != null) {
            pathValue = String.valueOf(libenv) + "=" + iacBinHome + File.pathSeparator + iacHome + File.separator + "lib";
        }
        if ((jvmTIpath = AdminUtil.getJvmtiNativePath()) != null) {
            pathValue = pathValue != null ? String.valueOf(pathValue) + File.pathSeparator + jvmTIpath : String.valueOf(libenv) + "=" + jvmTIpath;
        }
        if ((probekitPath = AdminUtil.getProbekitNativePath()) != null) {
            pathValue = pathValue != null ? String.valueOf(pathValue) + File.pathSeparator + probekitPath : String.valueOf(libenv) + "=" + probekitPath;
        }
        if (acHome != null) {
            tptpAcHomeValue = "TPTP_AC_HOME=" + acHome;
        }
        if (jvmTIpath != null) {
            javaProfilerHomeValue = "JAVA_PROFILER_HOME=" + jvmTIpath;
            classPathValue = "CLASSPATH=" + jvmTIpath;
        }
        return new String[]{tptpAcHomeValue, javaProfilerHomeValue, pathValue, classPathValue};
    }

    public static String[] map2String(Map map) {
        if (map == null || map.size() == 0) {
            return null;
        }
        Map.Entry entry = null;
        Iterator iter = map.entrySet().iterator();
        ArrayList<String> strings = new ArrayList<String>(map.size());
        StringBuffer buffer = null;
        while (iter.hasNext()) {
            entry = iter.next();
            buffer = new StringBuffer((String)entry.getKey());
            buffer.append('=').append((String)entry.getValue());
            strings.add(buffer.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static Map String2map(String[] strings) {
        if (strings == null || strings.length == 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < strings.length) {
            int idx;
            String entry = strings[i];
            if (entry != null && (idx = entry.indexOf("=")) > 0) {
                String key = strings[i].substring(0, idx);
                String value = strings[i].substring(idx + 1, strings[i].length());
                map.put(key, value);
            }
            ++i;
        }
        return map;
    }

    public static Map processEnvironmentVariables(Map envcfgMap, Map envMap) {
        if (envcfgMap == null) {
            envcfgMap = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved();
        }
        Iterator iter = envMap.entrySet().iterator();
        boolean win32 = Platform.getOS().equals("win32");
        Map.Entry entry = null;
        String key = null;
        String value = null;
        String nativeValue = null;
        Iterator envIter = null;
        Object var9_9 = null;
        String nativeKey = null;
        while (iter.hasNext()) {
            entry = iter.next();
            key = (String)entry.getKey();
            value = (String)entry.getValue();
            if (value != null) {
                try {
                    value = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(value);
                }
                catch (CoreException e) {
                    System.err.print("Error substituting environement varilable value :" + value);
                    e.printStackTrace();
                }
            }
            boolean added = false;
            nativeValue = (String)envcfgMap.get(key);
            if (nativeValue != null) {
                envcfgMap.put(key, String.valueOf(value) + File.pathSeparator + nativeValue);
                added = true;
            } else if (win32) {
                for (Map.Entry entry2 : envcfgMap.entrySet()) {
                    nativeKey = (String)entry2.getKey();
                    nativeValue = (String)entry2.getValue();
                    if (!nativeKey.equalsIgnoreCase(key)) continue;
                    entry2.setValue(String.valueOf(value) + File.pathSeparator + nativeValue);
                    added = true;
                    break;
                }
            }
            if (added) continue;
            envcfgMap.put(key, value);
        }
        return envcfgMap;
    }
}

