/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.internal;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.UFormat;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.tptp.platform.report.chart.internal.ChartDecoderInputStream;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderData;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DI18N;
import org.eclipse.tptp.platform.report.core.internal.DLinkUtil;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.IDCoord;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDLink;
import org.eclipse.tptp.platform.report.core.internal.IDObject;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlReader;
import org.eclipse.tptp.platform.report.igc.awt.internal.AWTGC;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.SolidBrush;
import org.eclipse.tptp.platform.report.render.internal.DRenderRegistry;
import org.eclipse.tptp.platform.report.render.internal.IRender;
import org.eclipse.tptp.platform.report.render.internal.IRenderLocation;
import org.eclipse.tptp.platform.report.render.internal.NullRenderMonitor;
import org.eclipse.tptp.platform.report.sxp.internal.SimpleXmlParser;
import org.eclipse.tptp.platform.report.tools.internal.IVObject;

public class ChartViewerApplet
extends Applet
implements MouseListener,
MouseMotionListener,
Runnable {
    private static final long serialVersionUID = 1L;
    protected DGraphic graphic_;
    protected IVObject data_;
    protected String message_;
    protected int loading_;
    protected boolean do_tooltip_;
    protected int ttp_background_;
    protected int ttp_foreground_;
    private Rect rect = new Rect();
    private Image offscreen;
    private AWTGC awtgc;
    private boolean move_graphic_;
    private boolean moved_graphic_;
    private int defaultProperties_moveGraphicx_;
    private int defaultProperties_moveGraphicy_;
    public IDLink prevGraphLink;
    protected String ttp_text_;
    protected int ttp_x_;
    protected int ttp_y_;

    public ChartViewerApplet() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public String getAppletInfo() {
        return "IBM JScrib Chart Viewer Applet 1.0\n\ufffd Copyright IBM Corp. 2003-2004";
    }

    public void init() {
        this.message_ = "Initializing...";
    }

    public void start() {
        AnimThread anim = new AnimThread();
        anim.start();
        Thread load = new Thread(this);
        load.start();
    }

    private InputStream getZipInputStream(String param) {
        InputStream is;
        block4: {
            ByteArrayInputStream bais;
            is = bais = new ByteArrayInputStream(param.getBytes());
            ChartDecoderInputStream cis = new ChartDecoderInputStream(bais);
            ZipInputStream zis = new ZipInputStream(cis);
            is = null;
            try {
                ZipEntry zen = null;
                while ((zen = zis.getNextEntry()) != null) {
                    if (!"jsml".equals(zen.getName())) continue;
                    is = zis;
                    break;
                }
                if (is != null) break block4;
                this.message_ = "Unable to get jsml in zipped parameter";
                this.repaint();
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message_ = "Zip input reading failed, no graphic available.";
                this.repaint();
                return null;
            }
        }
        return is;
    }

    public void run() {
        this.message_ = "Loading graphic ...";
        this.loading_ = 0;
        this.repaint();
        this.do_tooltip_ = true;
        String s = this.getParameter("tooltip");
        if (s != null) {
            this.do_tooltip_ = "true".equals(s);
        }
        this.ttp_background_ = -21840;
        this.ttp_foreground_ = 52479;
        s = this.getParameter("tooltip-bgcolor");
        if (s != null) {
            try {
                this.ttp_background_ = Integer.parseInt(s, 16);
            }
            catch (Exception exception) {}
        }
        if ((s = this.getParameter("tooltip-fgcolor")) != null) {
            try {
                this.ttp_foreground_ = Integer.parseInt(s, 16);
            }
            catch (Exception exception) {}
        }
        String param = this.getParameter("jsml");
        boolean zipped = false;
        if (param == null) {
            param = this.getParameter("jsml-zip");
            zipped = true;
        }
        if (param == null) {
            this.graphic_ = null;
            this.message_ = "Malformed applet tag: missing parameter";
            this.repaint();
            return;
        }
        InputStream is = zipped ? this.getZipInputStream(param) : new ByteArrayInputStream(param.getBytes());
        SimpleXmlParser p = new SimpleXmlParser();
        DXmlReader reader = new DXmlReader(p);
        try {
            IDObject[] obj = reader.read(is);
            if (obj != null) {
                int i = 0;
                while (i < obj.length) {
                    if (obj[i] instanceof DGraphic) {
                        this.graphic_ = (DGraphic)obj[i];
                        this.message_ = null;
                        break;
                    }
                    ++i;
                }
            }
            if (this.graphic_ == null) {
                this.message_ = "Error reading input, no graphic available";
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.message_ = "Error reading input, no graphic available";
        }
        this.loading_ = -1;
        this.repaint();
    }

    public void stop() {
        this.graphic_ = null;
        this.message_ = null;
        this.offscreen = null;
        this.awtgc = null;
    }

    private AWTGC getAWTGC() {
        Rectangle rr = this.getBounds();
        if (this.offscreen == null || this.offscreen.getWidth(null) != rr.width || this.offscreen.getHeight(null) != rr.height) {
            this.rect.setRect(0, 0, rr.width, rr.height);
            this.offscreen = this.createImage(rr.width, rr.height);
            this.awtgc = new AWTGC(this.offscreen.getGraphics());
        }
        return this.awtgc;
    }

    public void paint(Graphics g) {
        Rectangle b = this.getBounds();
        if (this.graphic_ == null) {
            g.setColor(new Color(192, 192, 192));
            g.fillRect(0, 0, b.width, b.height);
            g.setColor(new Color(255, 0, 0));
            String txt = this.message_ == null ? "No graphic nor message." : this.message_;
            FontMetrics fm = g.getFontMetrics();
            int sw = fm.stringWidth(txt) + (this.loading_ >= 0 ? 20 : 0);
            int sh = fm.getHeight();
            int tx = (b.width - sw) / 2;
            int ty = (b.height - sh) / 2;
            g.drawString(txt, tx, ty);
            if (this.loading_ >= 0) {
                ty = ty - fm.getAscent() + sh / 2 - 10;
                g.setColor(new Color(0, 0, 0));
                g.fillOval(tx += sw - 16, ty, 20, 20);
                g.setColor(new Color(255, 210, 0));
                g.fillArc(tx + 1, ty + 1, 18, 18, this.loading_, 90);
                g.fillArc(tx + 1, ty + 1, 18, 18, this.loading_ + 180, 90);
            }
            return;
        }
        IRender render = DRenderRegistry.GetRender(this.graphic_);
        render.draw(this.getAWTGC(), this.rect, this.graphic_, 1.0f, null, new NullRenderMonitor(), this.data_);
        if (this.do_tooltip_ && this.ttp_text_ != null) {
            this.paintTooltip();
        }
        Point p = this.getLocation();
        g.drawImage(this.offscreen, p.x, p.y, null);
    }

    private void paintTooltip() {
        Rectangle b = this.getBounds();
        AWTGC gc = this.getAWTGC();
        ISize size = gc.textExtent(this.ttp_text_);
        int y = this.ttp_y_ - size.getH() - 6;
        int x = this.ttp_x_;
        if (x + size.getW() + 6 > b.x + b.width - 1) {
            x = b.x + b.width - size.getW() - 1 - 6;
        }
        if (x < b.x) {
            x = b.x;
        }
        if (y + size.getH() + 6 > b.y + b.height - 1) {
            y = b.y - b.height - size.getH() - 1 - 6;
        }
        if (y < b.y) {
            y = b.y;
        }
        gc.setClipping(null);
        SolidBrush br = new SolidBrush(this.ttp_background_);
        gc.setBrush(br);
        gc.fillRect(x, y, size.getW() + 6, size.getH() + 6);
        br.setRGBA(52479);
        br.setRGBA(this.ttp_foreground_);
        gc.setBrush(br);
        gc.drawText(this.ttp_text_, x + 3, y + 3);
        gc.setPen(new LineStylePen(255));
        gc.drawRect(x, y, size.getW() + 6, size.getH() + 6);
    }

    public boolean isDoubleBuffered() {
        return true;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.ttp_text_ = null;
        if (this.graphic_ == null) {
            return;
        }
        if (!this.graphic_.canMoves()) {
            return;
        }
        this.move_graphic_ = true;
        this.moved_graphic_ = false;
        this.defaultProperties_moveGraphicx_ = e.getX();
        this.defaultProperties_moveGraphicy_ = e.getY();
    }

    private String getLinkSpec(IDLink link) {
        if (link == null) {
            return "";
        }
        String spec = this.prevGraphLink.getTarget();
        if (DLinkUtil.isInternalLink(this.prevGraphLink)) {
            spec = "#" + DLinkUtil.getPath(spec);
        }
        return spec;
    }

    public void mouseReleased(MouseEvent e) {
        this.move_graphic_ = false;
        if (!this.moved_graphic_ && this.prevGraphLink != null) {
            String spec = this.getLinkSpec(this.prevGraphLink);
            URL url = null;
            try {
                url = new URL(this.getDocumentBase(), spec);
                this.getAppletContext().showDocument(url);
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (this.move_graphic_) {
            if (this.graphic_ == null) {
                return;
            }
            float phi = this.graphic_.getProperties().get("P_XYZ_PHI.DGraphic.core.jscrib", 0.3f);
            float theta = this.graphic_.getProperties().get("P_XYZ_THETA.DGraphic.core.jscrib", 0.2f);
            int dx = e.getX() - this.defaultProperties_moveGraphicx_;
            int dy = e.getY() - this.defaultProperties_moveGraphicy_;
            this.graphic_.getProperties().store("P_XYZ_PHI.DGraphic.core.jscrib", phi += 0.02f * (float)dy);
            this.graphic_.getProperties().store("P_XYZ_THETA.DGraphic.core.jscrib", theta -= 0.02f * (float)dx);
            this.defaultProperties_moveGraphicx_ = e.getX();
            this.defaultProperties_moveGraphicy_ = e.getY();
            this.repaint();
            this.moved_graphic_ = true;
            if (this.prevGraphLink != null) {
                this.setCursor(null);
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        IDItem item;
        boolean do_ttip;
        int px = e.getX() - this.getLocation().x;
        int py = e.getY() - this.getLocation().y;
        IRenderLocation loc = this.locatePointInGraphic(px, py, this.graphic_);
        IDLink link = ChartViewerApplet.extractGraphicLink(loc);
        boolean bl = do_ttip = loc != null;
        if (link != null) {
            String method = DLinkUtil.getMethod(link.getTarget());
            boolean bl2 = do_ttip = !"jscrib-tooltip".equals(method);
        }
        if (do_ttip && (item = loc.getItem()) != null) {
            if (!(item instanceof DCurve)) {
                if (item instanceof DPoint) {
                    DPoint pt = (DPoint)item;
                    IDItem p = pt.getParent();
                    DCurve c = p instanceof DCurve ? (DCurve)p : null;
                    p = p.getParent();
                    DGraphic g = p instanceof DGraphic ? (DGraphic)p : null;
                    String title = DefaultChartRenderData.getResourceString(c.getName(), (DI18N)g.getChildOfClass(DI18N.class));
                    String t = c != null && title != null ? String.valueOf(title) + ": " : "";
                    IDItem ic = item.getFirstChild();
                    while (ic != null) {
                        IDCoord coord;
                        Object v;
                        if (ic instanceof IDCoord && (v = (coord = (IDCoord)((Object)ic)).getValue(null)) != null) {
                            DAxis a = coord.getAxis();
                            NumberFormat f = null;
                            if (t.length() > 0) {
                                t = String.valueOf(t) + "  ";
                            }
                            if (a != null) {
                                if (a.getTitle() != null) {
                                    t = String.valueOf(t) + a.getTitle() + "=";
                                }
                                try {
                                    f = (UFormat)a.getProperties().get("P_UNIT_FORMAT.DAxis.core.jscrib");
                                }
                                catch (ClassCastException classCastException) {}
                            }
                            if (f == null) {
                                if (v instanceof Number) {
                                    f = NumberFormat.getInstance();
                                } else if (v instanceof Date) {
                                    f = new SimpleDateFormat("dd MMM yyyy");
                                }
                            }
                            if (f != null) {
                                try {
                                    t = String.valueOf(t) + f.format(v);
                                }
                                catch (Exception exception) {}
                            } else {
                                t = String.valueOf(t) + v.toString();
                            }
                            if (a != null && a.getUnit() != null) {
                                t = String.valueOf(t) + " " + a.getUnit();
                            }
                        }
                        ic = ic.getNext();
                    }
                    if (this.prevGraphLink != null) {
                        t = String.valueOf(t) + "  link:" + this.getLinkSpec(this.prevGraphLink);
                    }
                    this.tooltip(t, e.getX(), e.getY());
                } else {
                    this.tooltip(null, 0, 0);
                }
            }
        } else {
            this.tooltip(null, 0, 0);
        }
        if (this.prevGraphLink != link) {
            if (this.prevGraphLink != null && link == null) {
                this.setCursor(null);
            }
            if (link != null && this.prevGraphLink == null) {
                this.setCursor(new Cursor(12));
            }
            this.prevGraphLink = link;
            return;
        }
        this.prevGraphLink = link;
    }

    private void tooltip(String s, int x, int y) {
        this.getAppletContext().showStatus(s == null ? "" : s);
        this.ttp_text_ = s;
        this.ttp_x_ = x;
        this.ttp_y_ = y;
        this.repaint();
    }

    public IRenderLocation locatePointInGraphic(int px, int py, DGraphic gph) {
        if (gph == null) {
            return null;
        }
        IRender render_ = DRenderRegistry.GetRender(gph);
        IRenderLocation loc = null;
        AWTGC awtgc = this.getAWTGC();
        Rectangle r = this.getBounds();
        this.rect.setRect(r.x, r.y, r.width, r.height);
        loc = render_.locate(px, py, awtgc, this.rect, gph, 1.0f, null, this.data_);
        return loc;
    }

    public static IDLink extractGraphicLink(IRenderLocation loc) {
        IDLink link = null;
        if (loc != null) {
            IDItem item = loc.getItem();
            link = item instanceof IDLink ? (IDLink)((Object)item) : (IDLink)((Object)ChartViewerApplet.HasParent(item, IDLink.class));
        }
        return link;
    }

    private static IDItem HasParent(IDItem item, Class wanted) {
        if (item == null) {
            return null;
        }
        IDItem iparent = item.getParent();
        while (iparent != null) {
            if (wanted.isInstance(iparent)) {
                return iparent;
            }
            iparent = iparent.getParent();
        }
        return null;
    }

    private class AnimThread
    extends Thread {
        private AnimThread() {
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(125L);
                    if (ChartViewerApplet.this.loading_ < 0) break;
                    ChartViewerApplet.this.loading_ += 18;
                    if (ChartViewerApplet.this.loading_ >= 180) {
                        ChartViewerApplet.this.loading_ = 0;
                    }
                }
                catch (Throwable throwable) {}
                ChartViewerApplet.this.repaint();
            }
        }
    }
}

