/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.internal;

import com.ibm.icu.util.ULocale;
import org.eclipse.tptp.platform.report.chart.internal.CurveStyle;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderData;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderHBars;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderHStackBars;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderMeter;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderPie3D;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderSeries3D;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderStackBars;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderXY;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderXYSurface;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderXYZ;
import org.eclipse.tptp.platform.report.chart.internal.DefaultRenderChartLocation;
import org.eclipse.tptp.platform.report.chart.internal.IScale;
import org.eclipse.tptp.platform.report.chart.internal.MinMax;
import org.eclipse.tptp.platform.report.chart.internal.RenderPersistData;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DCoord;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DI18N;
import org.eclipse.tptp.platform.report.core.internal.DItem;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.DPropertyStore;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.core.internal.DWallpaper;
import org.eclipse.tptp.platform.report.core.internal.IDAlignment;
import org.eclipse.tptp.platform.report.core.internal.IDCoord;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDRenderable;
import org.eclipse.tptp.platform.report.core.internal.IDWallpaper;
import org.eclipse.tptp.platform.report.drawutil.internal.DrawUtilIGC;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.igc.alg.internal.LineAlg;
import org.eclipse.tptp.platform.report.igc.internal.IBrush;
import org.eclipse.tptp.platform.report.igc.internal.IFont;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IPen;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.Point;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;
import org.eclipse.tptp.platform.report.igc.util.internal.Radian;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.SolidBrush;
import org.eclipse.tptp.platform.report.render.internal.IRender;
import org.eclipse.tptp.platform.report.render.internal.IRenderLocation;
import org.eclipse.tptp.platform.report.render.internal.IRenderMonitor;
import org.eclipse.tptp.platform.report.tools.internal.DAlignment;
import org.eclipse.tptp.platform.report.tools.internal.DAlignmentPair;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.IVObject;
import org.eclipse.tptp.platform.report.tools.internal.VDouble;

public class DefaultChartRender
implements IRender {
    protected DefaultChartRenderData d_ = null;
    private static DefaultChartRenderHBars hbars_render;

    public boolean canRender(IDRenderable _r) {
        return _r instanceof DGraphic;
    }

    public void draw(IGC _gc, IRect _r, IDRenderable _g, float _scale, IDIImageProvider _ip, IRenderMonitor _m, IVObject _data) {
        if (_g == null) {
            return;
        }
        if (!(_g instanceof DGraphic)) {
            return;
        }
        this.d_ = new DefaultChartRenderData(true, _gc, _scale);
        try {
            this.render((DGraphic)_g, _r, _scale, _ip, _data);
        }
        catch (DefaultRenderChartLocation defaultRenderChartLocation) {}
        this.d_ = null;
    }

    public IRenderLocation locate(int _x, int _y, IGC _gc, IRect _r, IDRenderable _g, float _scale, IDIImageProvider _ip, IVObject _data) {
        if (_g == null) {
            return null;
        }
        if (!(_g instanceof DGraphic)) {
            return null;
        }
        if (!_r.contains(_x, _y)) {
            return null;
        }
        this.d_ = new DefaultChartRenderData(false, _gc, _scale);
        this.d_.lx_ = _x;
        this.d_.ly_ = _y;
        try {
            try {
                this.render((DGraphic)_g, _r, _scale, _ip, _data);
            }
            catch (DefaultRenderChartLocation _l) {
                DefaultRenderChartLocation defaultRenderChartLocation = _l;
                this.d_ = null;
                return defaultRenderChartLocation;
            }
        }
        finally {
            this.d_ = null;
        }
        return null;
    }

    protected void render(DGraphic _G, IRect _R, float scale_, IDIImageProvider _ip, IVObject data) throws DefaultRenderChartLocation {
        RenderPersistData rpd = null;
        boolean dispose_rpd = false;
        this.d_.setupMargin(_G);
        try {
            Object d;
            Object object = d = data == null ? null : data.getObject();
            if (d instanceof RenderPersistData) {
                rpd = (RenderPersistData)d;
                if (rpd.graphic != _G || rpd.graphic_type != _G.getRenderableId() || !rpd.graphic_rect.equals(_R)) {
                    rpd = null;
                }
            }
            if (rpd == null) {
                IDWallpaper wp;
                rpd = new RenderPersistData(_G);
                rpd.graphic_rect = new Rect(_R);
                rpd.graphic_type = _G.getRenderableId();
                rpd.ag_rect = new Rect(_R);
                rpd.ag_rect.shrink(this.d_.margin_);
                rpd.g_style = new IGCDStyle(_G, this.d_.scale_);
                if (rpd.graphic.getStyle() != null && (wp = rpd.graphic.getStyle().getWallpaper()) instanceof DWallpaper && rpd.g_wallpaper == null && _ip != null) {
                    rpd.g_wallpaper = _ip.getImage(wp.getName());
                    rpd.e_wallpaper = wp.getEffect();
                }
                if (data != null) {
                    data.setObject(rpd);
                } else {
                    dispose_rpd = true;
                }
            }
            if (this.d_.drawing()) {
                this.d_.gc_.setBrush(new SolidBrush(rpd.g_style.getBack()));
                this.d_.gc_.fillRect(rpd.graphic_rect);
                if (rpd.g_wallpaper != null) {
                    DrawUtilIGC.drawImage(this.d_.gc_, rpd.g_wallpaper, rpd.graphic_rect, scale_, rpd.e_wallpaper);
                }
            }
            int n_curves = 0;
            IDItem i = rpd.graphic.getFirstChild();
            while (i != null) {
                if (i instanceof DCurve) {
                    ++n_curves;
                }
                i = i.getNext();
            }
            if (rpd.curve_styles == null || n_curves != rpd.curve_styles.length) {
                rpd.rebuildCurveStyles(n_curves, this.d_.scale_);
                rpd.invalidate(2);
            }
            this.renderGraphicTitle(rpd);
            this.renderLegend(rpd);
            if (_G.isRenderableId("T_SECTORS.DGraphic.core.jscrib")) {
                this.renderSector(rpd, false);
            } else if (_G.isRenderableId("T_SECTORS3D.DGraphic.core.jscrib")) {
                this.renderSector(rpd, true);
            } else if (_G.isRenderableId("T_HISTOGRAM.DGraphic.core.jscrib")) {
                this.renderHistogram(rpd, false);
            } else if (_G.isRenderableId("T_XY.DGraphic.core.jscrib")) {
                DefaultChartRenderXY.render(this.d_, rpd);
            } else if (_G.isRenderableId("T_XYZ.DGraphic.core.jscrib")) {
                DefaultChartRenderXYZ.render(this.d_, rpd);
            } else if (_G.isRenderableId("T_WIREFRAME.DGraphic.core.jscrib")) {
                DefaultChartRenderXYZ.render(this.d_, rpd);
            } else if (_G.isRenderableId("T_HISTOGRAM_IM.DGraphic.core.jscrib")) {
                this.renderHistogram(rpd, true);
            } else if (_G.isRenderableId("T_H_HISTOGRAM_IM.DGraphic.core.jscrib")) {
                this.renderHHistogram(rpd, true);
            } else if (_G.isRenderableId("T_HISTORS.DGraphic.core.jscrib")) {
                this.renderHistors(rpd);
            } else if (_G.isRenderableId("T_HBARS.DGraphic.core.jscrib")) {
                DefaultChartRenderHBars.render(this.d_, rpd);
            } else if (_G.isRenderableId("T_STACKBARS.DGraphic.core.jscrib")) {
                DefaultChartRenderStackBars.render(this.d_, rpd);
            } else if (_G.isRenderableId("T_H_STACKBARS.DGraphic.core.jscrib")) {
                DefaultChartRenderHStackBars.render(this.d_, rpd);
            } else if (_G.isRenderableId("T_METER.DGraphic.core.jscrib")) {
                DefaultChartRenderMeter.render(this.d_, rpd);
            } else if (_G.isRenderableId("T_SERIES3D.DGraphic.core.jscrib")) {
                DefaultChartRenderSeries3D.render(this.d_, rpd);
            } else if (_G.isRenderableId("T_PIE3D.DGraphic.core.jscrib")) {
                DefaultChartRenderPie3D.render(this.d_, rpd, true);
            } else if (_G.isRenderableId("T_TORUS3D.DGraphic.core.jscrib")) {
                DefaultChartRenderPie3D.render(this.d_, rpd, false);
            } else if (_G.isRenderableId("T_XY_SURFACE.DGraphic.core.jscrib")) {
                DefaultChartRenderXYSurface.render(this.d_, rpd);
            } else {
                this.d_.error("Unknown Graphic type :\n'" + _G.getRenderableId() + "'", rpd);
                return;
            }
            if (this.d_.locating() && rpd.ag_rect.contains(this.d_.lx_, this.d_.ly_)) {
                throw new DefaultRenderChartLocation("InGraphicArea", _G, rpd.ag_rect);
            }
        }
        finally {
            if (dispose_rpd && rpd != null) {
                rpd.dispose();
                rpd = null;
            }
        }
    }

    protected void renderGraphicTitle(RenderPersistData rpd) throws DefaultRenderChartLocation {
        boolean display_title = rpd.graphic.getProperties().get("P_SHOW_TITLED.DGraphic.core.jscrib", true);
        String title = DefaultChartRenderData.getResourceString(rpd.graphic.getTitle(), (DI18N)rpd.graphic.getChildOfClass(DI18N.class));
        display_title &= title != null && !"".equals(title);
        DAlignmentPair aln = null;
        try {
            aln = (DAlignmentPair)rpd.graphic.getProperties().get("P_TITLE_LAYOUT.DGraphic.core.jscrib");
        }
        finally {
            if (aln == null) {
                aln = new DAlignmentPair(8, 4);
            }
        }
        boolean valid = false;
        if (rpd.isValid(1)) {
            boolean bl = valid = rpd.title_displayed == display_title && aln.equals(rpd.title_aln) && title == rpd.title_text;
        }
        if (!valid) {
            rpd.invalidate(1);
            rpd.invalidate(2);
            rpd.title_displayed = display_title;
            rpd.title_aln = aln;
            rpd.title_text = title;
            rpd.title_displayed_text = null;
            rpd.title_rect = null;
            rpd.title_render_aln = 0;
            if (!rpd.title_displayed) {
                rpd.validate(1);
                return;
            }
            this.d_.gc_.setFont(rpd.g_style.getFont());
            ISize size = DrawUtilIGC.textExtent(this.d_.gc_, title, aln.getAlignment());
            Rect r_ttl = new Rect(rpd.graphic_rect);
            r_ttl.shrink(this.d_.margin_);
            if (aln.haveAlignment(16)) {
                r_ttl.setTop(r_ttl.bottom() - size.getH());
                rpd.ag_rect.setBottom(rpd.ag_rect.bottom() - r_ttl.h() - this.d_.margin_);
            } else if (aln.haveAlignment(1)) {
                r_ttl.setWidth(size.getW());
                rpd.ag_rect.setLeft(rpd.ag_rect.left() + r_ttl.w() + this.d_.margin_);
            } else if (aln.haveAlignment(2)) {
                r_ttl.setLeft(r_ttl.right() - size.getW());
                rpd.ag_rect.setRight(rpd.ag_rect.right() - r_ttl.w() - this.d_.margin_);
            } else {
                r_ttl.setHeight(size.getH());
                rpd.ag_rect.setTop(rpd.ag_rect.top() + r_ttl.h() + this.d_.margin_);
            }
            rpd.title_displayed_text = DrawUtilIGC.truncateText(this.d_.gc_, title, r_ttl.w(), r_ttl.h(), aln.getAlignment());
            rpd.title_render_aln = aln.getAlignment(448) | aln.getSecondaryAlignment();
            rpd.title_rect = r_ttl;
            rpd.validate(1);
        }
        if (!rpd.title_displayed) {
            return;
        }
        this.d_.renderText(rpd.title_displayed_text, rpd.title_rect, rpd.title_render_aln, rpd.g_style, "InGraphicTitleText", rpd.graphic);
        if (this.d_.locating() && rpd.title_rect.contains(this.d_.lx_, this.d_.ly_)) {
            throw new DefaultRenderChartLocation("InGraphicTitleArea", rpd.graphic, rpd.title_rect);
        }
    }

    protected void renderLegend(RenderPersistData rpd) throws DefaultRenderChartLocation {
        boolean display_legend = rpd.graphic.getProperties().get("P_SHOW_LEGEND.DGraphic.core.jscrib", true);
        DAlignmentPair aln = null;
        try {
            aln = (DAlignmentPair)rpd.graphic.getProperties().get("P_LEGEND_LAYOUT.DGraphic.core.jscrib");
        }
        finally {
            if (aln == null) {
                aln = new DAlignmentPair(2, 32);
            }
        }
        boolean valid = false;
        if (rpd.isValid(2)) {
            valid = true;
            if (display_legend != rpd.legend_displayed) {
                valid = false;
            } else if (!aln.equals(rpd.legend_aln)) {
                valid = false;
            }
        }
        int lgd_sym_spacing = this.d_.dpiX(10);
        int lgd_vert_spacing = this.d_.dpiY(4);
        if (valid) {
            if (!display_legend) {
                return;
            }
        } else {
            Rect lgd_area;
            int n_lines;
            int n_lgd_by_line;
            rpd.legend_displayed = display_legend;
            rpd.legend_aln = new DAlignmentPair(aln);
            rpd.legend_rect = null;
            rpd.validate(2);
            if (!display_legend) {
                return;
            }
            Rect rg = rpd.ag_rect;
            boolean vert_layout = aln.haveAlignment(1) | aln.haveAlignment(2) | aln.haveAlignment(4);
            int n_legend = rpd.curve_styles.length;
            int entry_max_height = 0;
            int entry_max_width = 0;
            int entries_width = 0;
            int entries_height = 0;
            int entry_min_height = 0;
            boolean init = false;
            int i = 0;
            while (i < n_legend) {
                CurveStyle ccurve = rpd.curve_styles[i];
                this.d_.gc_.setFont(ccurve.style_.getFont());
                String name = DefaultChartRenderData.getResourceString(ccurve.curve_.getName(), (DI18N)rpd.graphic.getChildOfClass(DI18N.class));
                if (!DrawUtilIGC.isEmpty(name)) {
                    ISize sz = this.d_.gc_.textExtent(name);
                    int sz_w = sz.getW();
                    int sz_h = sz.getH();
                    entry_max_width = Math.max(entry_max_width, sz_w);
                    entry_max_height = Math.max(entry_max_height, sz_h);
                    if (vert_layout) {
                        entries_height += sz_h;
                    } else {
                        entries_width += sz_w;
                    }
                    if (!init || entry_min_height > sz_h) {
                        entry_min_height = sz_h;
                    }
                    init = true;
                }
                ++i;
            }
            if (!init) {
                rpd.legend_displayed = false;
                return;
            }
            if (vert_layout) {
                entries_width = entry_max_width;
            } else {
                entries_height = entry_max_height;
            }
            int lgd_sym_size = entry_min_height / 2;
            if (lgd_sym_size < this.d_.dpiX(7)) {
                lgd_sym_size = entry_min_height - 2;
            }
            int legend_x = 0;
            int legend_y = 0;
            int legend_H = 0;
            int legend_W = 0;
            int p_legend_limit = vert_layout ? 4 : 8;
            try {
                int pll = rpd.graphic.getProperties().get("P_LEGEND_LIMIT.DGraphic.core.jscrib", p_legend_limit);
                if (pll > 0) {
                    p_legend_limit = pll;
                }
            }
            catch (Exception exception) {}
            if (vert_layout) {
                n_lgd_by_line = 1;
                n_lines = n_legend;
                legend_W = n_lgd_by_line * (lgd_sym_size + lgd_sym_spacing + entry_max_width + this.d_.margin_) - this.d_.margin_;
                legend_H = n_lines * (entry_max_height + lgd_vert_spacing) - lgd_vert_spacing;
                if (legend_H > rg.h()) {
                    n_lines = (rg.h() + lgd_vert_spacing) / (entry_max_height + lgd_vert_spacing);
                    if (n_lines == 0) {
                        rpd.legend_displayed = false;
                        return;
                    }
                    n_lgd_by_line = n_legend / n_lines + (n_legend % n_lines == 0 ? 0 : 1);
                    n_lines = n_legend / n_lgd_by_line + (n_legend % n_lgd_by_line == 0 ? 0 : 1);
                    legend_W = n_lgd_by_line * (lgd_sym_size + lgd_sym_spacing + entry_max_width + this.d_.margin_) - this.d_.margin_;
                    legend_H = n_lines * (entry_max_height + lgd_vert_spacing) - lgd_vert_spacing;
                }
                if (legend_W + this.d_.margin_ > rg.w() / p_legend_limit) {
                    entry_max_width = (rg.w() / p_legend_limit - this.d_.margin_) / n_lgd_by_line - lgd_sym_size - lgd_sym_spacing;
                    legend_W = n_lgd_by_line * (lgd_sym_size + lgd_sym_spacing + entry_max_width + this.d_.margin_) - this.d_.margin_;
                    if (entry_max_width < 15) {
                        rpd.legend_displayed = false;
                        return;
                    }
                }
                if (legend_W < this.d_.dpiX(25)) {
                    rpd.legend_displayed = false;
                    return;
                }
                if (aln.haveAlignment(1)) {
                    legend_x = rg.x();
                    rg.setLeft(rg.left() + legend_W + this.d_.margin_);
                } else {
                    legend_x = rg.right() - legend_W;
                    rg.setRight(legend_x - this.d_.margin_);
                }
                legend_y = aln.haveSecondaryAlignment(8) ? rg.y() : (aln.haveSecondaryAlignment(16) ? rg.bottom() - legend_H : rg.centerY() - legend_H / 2);
            } else {
                n_lgd_by_line = n_legend;
                n_lines = 1;
                legend_W = n_lgd_by_line * (lgd_sym_size + lgd_sym_spacing + entry_max_width + this.d_.margin_) - this.d_.margin_;
                legend_H = n_lines * (entry_max_height + lgd_vert_spacing) - lgd_vert_spacing;
                if (legend_W + this.d_.margin_ > rg.w()) {
                    n_lgd_by_line = rg.w() / (lgd_sym_size + lgd_sym_spacing + entry_max_width + this.d_.margin_);
                    if (n_lgd_by_line == 0) {
                        n_lgd_by_line = 1;
                        n_lines = n_legend;
                        entry_max_width = rg.w() / n_lgd_by_line - lgd_sym_size - lgd_sym_spacing;
                        legend_W = n_lgd_by_line * (lgd_sym_size + lgd_sym_spacing + entry_max_width);
                        if (legend_W < 30) {
                            rpd.legend_displayed = false;
                            return;
                        }
                        legend_H = n_lines * (entry_max_height + lgd_vert_spacing) - lgd_vert_spacing;
                    } else {
                        n_lines = n_legend / n_lgd_by_line + (n_legend % n_lgd_by_line == 0 ? 0 : 1);
                        n_lgd_by_line = n_legend / n_lines + (n_legend % n_lines == 0 ? 0 : 1);
                        legend_W = n_lgd_by_line * (lgd_sym_size + lgd_sym_spacing + entry_max_width + this.d_.margin_) - this.d_.margin_;
                        legend_H = n_lines * (entry_max_height + lgd_vert_spacing) - lgd_vert_spacing;
                    }
                }
                if (legend_H > rg.h() / p_legend_limit) {
                    n_lines = (rg.h() / p_legend_limit + lgd_vert_spacing) / (entry_max_height + lgd_vert_spacing);
                    if (n_lines == 0) {
                        rpd.legend_displayed = false;
                        return;
                    }
                    n_lgd_by_line = n_legend / n_lines;
                    n_lines = n_legend / n_lgd_by_line + (n_legend % n_lgd_by_line == 0 ? 0 : 1);
                    entry_max_width = (legend_W + this.d_.margin_) / n_lgd_by_line - lgd_sym_size - lgd_sym_spacing - this.d_.margin_;
                    legend_H = n_lines * (entry_max_height + lgd_vert_spacing) - lgd_vert_spacing;
                    if (entry_max_width < this.d_.dpiX(30)) {
                        rpd.legend_displayed = false;
                        return;
                    }
                }
                if (aln.haveAlignment(8)) {
                    legend_y = rg.top();
                    rg.setTop(rg.top() + legend_H + this.d_.margin_);
                } else {
                    legend_y = rg.bottom() - legend_H;
                    rg.setBottom(legend_y - this.d_.margin_);
                }
                legend_x = aln.haveSecondaryAlignment(1) ? rg.x() : (aln.haveSecondaryAlignment(2) ? rg.right() - legend_W : rg.centerX() - legend_W / 2);
            }
            rpd.legend_rect = lgd_area = new Rect(legend_x, legend_y, legend_W, legend_H);
            rpd.entry_max_width = entry_max_width;
            rpd.entry_max_height = entry_max_height;
            rpd.legend_symbol_size = lgd_sym_size;
            rpd.legend_vertical_layout = vert_layout;
            rpd.legend_n_lines = n_lines;
            rpd.legend_n_entry_by_line = n_lgd_by_line;
            rpd.ag_rect = rg;
        }
        if (this.d_.locating() && !rpd.legend_rect.contains(this.d_.lx_, this.d_.ly_)) {
            return;
        }
        Rect r_sym = new Rect();
        Rect r_txt_area = new Rect();
        int lgx = rpd.legend_rect.x();
        int lgy = rpd.legend_rect.y();
        int i = 0;
        while (i < rpd.curve_styles.length) {
            CurveStyle ccurve = rpd.curve_styles[i];
            String name = DefaultChartRenderData.getResourceString(ccurve.curve_.getName(), (DI18N)rpd.graphic.getChildOfClass(DI18N.class));
            if (!DrawUtilIGC.isEmpty(name)) {
                this.d_.gc_.setFont(ccurve.style_.getFont());
                r_sym.setRect(lgx, lgy + (rpd.entry_max_height - rpd.legend_symbol_size) / 2, rpd.legend_symbol_size, rpd.legend_symbol_size);
                String txt = DrawUtilIGC.truncateTextH(this.d_.gc_, name, rpd.entry_max_width);
                if (this.d_.drawing()) {
                    this.d_.gc_.setPen(new LineStylePen(255));
                    this.d_.gc_.setBrush(new SolidBrush(ccurve.style_.getBack()));
                    ccurve.symbol_.draw(this.d_.gc_, r_sym);
                } else if (ccurve.symbol_.contains(this.d_.gc_, r_sym, this.d_.lx_, this.d_.ly_)) {
                    throw new DefaultRenderChartLocation("LegendColor", ccurve.curve_, r_sym);
                }
                r_txt_area.setRect(lgx + rpd.legend_symbol_size + lgd_sym_spacing, lgy, rpd.entry_max_width, rpd.entry_max_height);
                this.d_.renderText(txt, r_txt_area, 33, ccurve.style_, "LegendText", ccurve.curve_);
                if (rpd.legend_vertical_layout) {
                    lgy += rpd.entry_max_height + lgd_vert_spacing;
                    if (i % rpd.legend_n_lines == rpd.legend_n_lines - 1) {
                        lgx += rpd.entry_max_width + rpd.legend_symbol_size + lgd_sym_spacing + this.d_.margin_;
                        lgy = rpd.legend_rect.y();
                    }
                } else {
                    lgx += rpd.legend_symbol_size + lgd_sym_spacing + rpd.entry_max_width + this.d_.margin_;
                    if (i % rpd.legend_n_entry_by_line == rpd.legend_n_entry_by_line - 1) {
                        lgy += rpd.entry_max_height + lgd_vert_spacing;
                        lgx = rpd.legend_rect.x();
                    }
                }
            }
            ++i;
        }
        if (this.d_.locating() && rpd.legend_rect.contains(this.d_.lx_, this.d_.ly_)) {
            throw new DefaultRenderChartLocation("LegendArea", null, rpd.legend_rect);
        }
    }

    protected void renderHistogram(RenderPersistData rpd, boolean _im) throws DefaultRenderChartLocation {
        if (!(rpd.g instanceof RenderPersistData.Histogram)) {
            if (rpd.g != null) {
                rpd.g.dispose();
            }
            DAxis axis = null;
            IDItem i = rpd.graphic.getFirstChild();
            while (i != null) {
                if (i instanceof DAxis && axis == null) {
                    axis = (DAxis)i;
                    break;
                }
                i = i.getNext();
            }
            if (axis == null) {
                if (this.d_.drawing()) {
                    this.d_.error("Error: Histogram without axis", rpd);
                }
                return;
            }
            RenderPersistData.Histogram rpdh = new RenderPersistData.Histogram();
            rpdh.axis_style = new IGCDStyle(axis, this.d_.scale_);
            Object ay_min = axis.getProperties().get("P_MIN.DAxis.core.jscrib");
            Object ay_max = axis.getProperties().get("P_MAX.DAxis.core.jscrib");
            if (ay_max == null || ay_min == null) {
                MinMax mm = new MinMax(axis);
                int icrv = 0;
                while (icrv < rpd.curve_styles.length) {
                    CurveStyle ccurve = rpd.curve_styles[icrv];
                    IDItem item = ccurve.curve_.getFirstChild();
                    while (item != null) {
                        if (item instanceof DPoint) {
                            IDItem ic = item.getFirstChild();
                            while (ic != null) {
                                if (ic instanceof IDCoord) {
                                    mm.update((IDCoord)((Object)ic));
                                }
                                ic = ic.getNext();
                            }
                        }
                        item = item.getNext();
                    }
                    ++icrv;
                }
                if (ay_min == null) {
                    ay_min = mm.getVMin();
                }
                if (ay_max == null) {
                    ay_max = mm.getVMax();
                }
            }
            rpdh.y_scale = DefaultChartRenderData.getScale(axis, 0.0, 0.0, ay_min, ay_max);
            rpdh.axis = axis;
            if (rpdh.y_scale == null || !rpdh.y_scale.isValid()) {
                if (this.d_.drawing()) {
                    this.d_.error("Error: invalid axis", rpd);
                }
                return;
            }
            this.d_.gc_.setFont(rpdh.axis_style.getFont());
            rpdh.yam = this.d_.computeYAxisAmounts(true, true, axis, rpdh.y_scale, rpd.ag_rect, 128, null);
            int rg_x = rpd.ag_rect.x();
            int rg_y = rpd.ag_rect.y();
            int rg_w = rpd.ag_rect.w();
            int rg_h = rpd.ag_rect.h();
            IDItem item = null;
            rpdh.n_bar = 0;
            rpdh.n_max_points_by_curve = 0;
            rpdh.h_label_height = 0;
            Object prop = rpdh.axis.getProperties().get("P_LABEL_ALIGNMENT.DAxis.core.jscrib");
            if (prop instanceof IDAlignment) {
                rpdh.h_axis_alignment = (IDAlignment)prop;
                boolean bl = rpdh.h_axis_alignment.getAlignment(384) != 0;
            } else {
                rpdh.h_axis_alignment = new DAlignment(4);
            }
            IGCDStyle sty_point = new IGCDStyle(this.d_.scale_);
            Object value = null;
            int icrv = 0;
            while (icrv < rpd.curve_styles.length) {
                CurveStyle ccurve = rpd.curve_styles[icrv];
                int npoint = 0;
                item = ccurve.curve_.getFirstChild();
                while (item != null) {
                    if (item instanceof DPoint) {
                        ++npoint;
                        ++rpdh.n_bar;
                        DText label = null;
                        IDItem it = item.getFirstChild();
                        while (it != null) {
                            if (it instanceof DText) {
                                label = (DText)it;
                                break;
                            }
                            it = it.getNext();
                        }
                        String full_text = null;
                        if (label != null) {
                            sty_point.styleOf(label, this.d_.scale_);
                            full_text = label.getText();
                        } else {
                            sty_point.styleOf(item, this.d_.scale_);
                            DCoord coord = ((DPoint)item).getCoord(rpdh.axis);
                            value = coord.getValue(value);
                            full_text = rpdh.y_scale.valueText(value);
                        }
                        this.d_.gc_.setFont(sty_point.getFont());
                        int lh = DrawUtilIGC.textExtent(this.d_.gc_, full_text, rpdh.h_axis_alignment.getAlignment()).getH();
                        if (lh > rpdh.h_label_height) {
                            rpdh.h_label_height = lh;
                        }
                    }
                    item = item.getNext();
                }
                if (npoint > rpdh.n_max_points_by_curve) {
                    rpdh.n_max_points_by_curve = npoint;
                }
                ++icrv;
            }
            if (_im) {
                rpdh.n_bar += rpdh.n_max_points_by_curve - 1;
            }
            if (rpdh.h_label_height > (int)(0.5f * (float)rg_h)) {
                rpdh.h_label_height = (int)(0.5f * (float)rg_h);
            }
            rg_x += rpdh.yam.getL();
            rg_w -= rpdh.yam.getL();
            rg_y += rpdh.yam.getT();
            rg_h -= rpdh.yam.getT();
            rg_h -= rpdh.h_label_height + this.d_.axis_unit_to_dot_spacing;
            if (rpdh.n_bar > 0) {
                rpdh.thin_bar = rpd.graphic.getProperties().get("P_THIN_BAR.DGraphic.core.jscrib", false);
                boolean _3d = rpd.graphic.getProperties().get("P_3D.DGraphic.core.jscrib", false);
                float kthinbar = rpdh.thin_bar ? 0.7f : 1.0f;
                float k3d = 0.5f;
                rpdh.wbartobar = _3d ? (float)rg_w / ((float)rpdh.n_bar + k3d * kthinbar) : (float)rg_w / (float)rpdh.n_bar;
                rpdh.wbar = kthinbar * rpdh.wbartobar;
                rpdh.xdecbar = rpdh.thin_bar ? (rpdh.wbartobar - rpdh.wbar) / 2.0f : 0.0f;
                rpdh._3d_z = 0;
                if (_3d) {
                    rpdh._3d_z = (int)(k3d * rpdh.wbar);
                    rg_w -= rpdh._3d_z;
                    rg_y += rpdh._3d_z;
                    rg_h -= rpdh._3d_z;
                }
            }
            rpdh.y_scale.setScaleRange(rg_y + rg_h, rg_y);
            rpd.ag_rect.setRect(rg_x, rg_y, rg_w, rg_h);
            rpd.g = rpdh;
        }
        if (rpd.ag_rect.w() <= 0 || rpd.ag_rect.h() <= 0) {
            return;
        }
        RenderPersistData.Histogram h = (RenderPersistData.Histogram)rpd.g;
        this.d_.renderYAxis(true, true, true, h.axis, h.y_scale, rpd.ag_rect, h.yam, h.axis_style, 128, h._3d_z, h._3d_z);
        this.d_.renderMarkerLine(true, false, h.axis, rpd.ag_rect, h.y_scale);
        int rg_left = rpd.ag_rect.left();
        int rg_right = rpd.ag_rect.right();
        if (this.d_.drawing()) {
            this.d_.gc_.setPen(new LineStylePen(h.axis_style.getFore()));
            int btom = rpd.ag_rect.bottom();
            this.d_.gc_.drawLine(rg_left, rpd.ag_rect.top(), rg_left, btom);
            this.d_.gc_.drawLine(rg_left, btom, rg_right, btom);
        }
        Object vf = DefaultChartRenderData.getNewInstanceValue(h.axis);
        float xbar = rg_left;
        int y_bar_zero = (int)h.y_scale.getScaleForBar();
        if (this.d_.drawing()) {
            this.d_.gc_.drawLine(rg_left, y_bar_zero, rg_right, y_bar_zero);
        }
        DefaultRenderChartLocation loc = null;
        int n_curves = rpd.curve_styles.length;
        IShape save_clip = null;
        if (this.d_.drawing()) {
            save_clip = this.d_.gc_.getClipping();
            this.d_.gc_.setClipping(new Rect(rpd.ag_rect.x(), rpd.ag_rect.y() - h._3d_z, rpd.ag_rect.w() + h._3d_z + 1, rpd.ag_rect.h() + h._3d_z));
        }
        if (_im) {
            int ipt = 0;
            while (ipt < h.n_max_points_by_curve) {
                int icrv = 0;
                while (icrv < rpd.curve_styles.length) {
                    CurveStyle ccurve = rpd.curve_styles[icrv];
                    DPoint point = null;
                    int i = 0;
                    IDItem item = ccurve.curve_.getFirstChild();
                    while (item != null) {
                        if (item instanceof DPoint) {
                            if (i == ipt) {
                                point = (DPoint)item;
                                break;
                            }
                            ++i;
                        }
                        item = item.getNext();
                    }
                    if (point != null) {
                        try {
                            if (this.renderHistogramBar(true, rpd.ag_rect, rpd.locale, h, n_curves, vf, point, icrv, ipt, xbar, y_bar_zero, _im)) {
                                xbar += h.wbartobar;
                            }
                        }
                        catch (DefaultRenderChartLocation _loc) {
                            loc = _loc;
                        }
                    }
                    ++icrv;
                }
                xbar += h.wbartobar;
                ++ipt;
            }
        } else {
            int icrv = 0;
            while (icrv < rpd.curve_styles.length) {
                CurveStyle ccurve = rpd.curve_styles[icrv];
                int ipt = 0;
                IDItem item = ccurve.curve_.getFirstChild();
                while (item != null) {
                    if (item instanceof DPoint) {
                        DPoint point = (DPoint)item;
                        try {
                            if (this.renderHistogramBar(true, rpd.ag_rect, rpd.locale, h, n_curves, vf, point, icrv, ipt, xbar, y_bar_zero, _im)) {
                                ++ipt;
                                xbar += h.wbartobar;
                            }
                        }
                        catch (DefaultRenderChartLocation _l) {
                            loc = _l;
                            ++ipt;
                            xbar += h.wbartobar;
                        }
                    }
                    item = item.getNext();
                }
                ++icrv;
            }
        }
        if (save_clip != null) {
            this.d_.gc_.setClipping(save_clip);
        }
        if (this.d_.locating() && loc != null) {
            throw loc;
        }
        this.d_.renderYAxis(true, false, true, h.axis, h.y_scale, rpd.ag_rect, h.yam, h.axis_style, 128, h._3d_z, h._3d_z);
        this.d_.renderMarkerLine(true, true, h.axis, rpd.ag_rect, h.y_scale);
    }

    protected void renderHHistogram(RenderPersistData rpd, boolean _im) throws DefaultRenderChartLocation {
        CurveStyle ccurve;
        int icrv;
        if (!(rpd.g instanceof RenderPersistData.Histogram)) {
            if (rpd.g != null) {
                rpd.g.dispose();
            }
            DAxis axis = null;
            IDItem i = rpd.graphic.getFirstChild();
            while (i != null) {
                if (i instanceof DAxis && axis == null) {
                    axis = (DAxis)i;
                    break;
                }
                i = i.getNext();
            }
            if (axis == null) {
                if (this.d_.drawing()) {
                    this.d_.error("Error: Histogram without axis", rpd);
                }
                return;
            }
            RenderPersistData.Histogram rpdh = new RenderPersistData.Histogram();
            rpdh.axis_style = new IGCDStyle(axis, this.d_.scale_);
            Object ay_min = axis.getProperties().get("P_MIN.DAxis.core.jscrib");
            Object ay_max = axis.getProperties().get("P_MAX.DAxis.core.jscrib");
            if (ay_max == null || ay_min == null) {
                MinMax mm = new MinMax(axis);
                int icrv2 = 0;
                while (icrv2 < rpd.curve_styles.length) {
                    CurveStyle ccurve2 = rpd.curve_styles[icrv2];
                    IDItem item = ccurve2.curve_.getFirstChild();
                    while (item != null) {
                        if (item instanceof DPoint) {
                            IDItem ic = item.getFirstChild();
                            while (ic != null) {
                                if (ic instanceof IDCoord) {
                                    mm.update((IDCoord)((Object)ic));
                                }
                                ic = ic.getNext();
                            }
                        }
                        item = item.getNext();
                    }
                    ++icrv2;
                }
                if (ay_min == null) {
                    ay_min = mm.getVMin();
                }
                if (ay_max == null) {
                    ay_max = mm.getVMax();
                }
            }
            rpdh.y_scale = DefaultChartRenderData.getScale(axis, 0.0, 0.0, ay_min, ay_max);
            rpdh.axis = axis;
            if (rpdh.y_scale == null || !rpdh.y_scale.isValid()) {
                if (this.d_.drawing()) {
                    this.d_.error("Error: invalid axis", rpd);
                }
                return;
            }
            this.d_.gc_.setFont(rpdh.axis_style.getFont());
            rpdh.yam = this.d_.computeYAxisAmounts(false, true, axis, rpdh.y_scale, rpd.ag_rect, 128, null);
            int rg_x = rpd.ag_rect.x();
            int rg_y = rpd.ag_rect.y();
            int rg_w = rpd.ag_rect.w();
            int rg_h = rpd.ag_rect.h();
            IDItem item = null;
            rpdh.n_bar = 0;
            rpdh.n_max_points_by_curve = 0;
            rpdh.h_label_height = 0;
            Object prop = rpdh.axis.getProperties().get("P_LABEL_ALIGNMENT.DAxis.core.jscrib");
            rpdh.h_axis_alignment = prop instanceof IDAlignment ? (IDAlignment)prop : new DAlignment(4);
            IGCDStyle sty_point = new IGCDStyle(this.d_.scale_);
            Object value = null;
            icrv = 0;
            while (icrv < rpd.curve_styles.length) {
                ccurve = rpd.curve_styles[icrv];
                int npoint = 0;
                item = ccurve.curve_.getFirstChild();
                while (item != null) {
                    if (item instanceof DPoint) {
                        ++npoint;
                        ++rpdh.n_bar;
                        DText label = null;
                        IDItem it = item.getFirstChild();
                        while (it != null) {
                            if (it instanceof DText) {
                                label = (DText)it;
                                break;
                            }
                            it = it.getNext();
                        }
                        String full_text = null;
                        if (label != null) {
                            sty_point.styleOf(label, this.d_.scale_);
                            full_text = label.getText();
                        } else {
                            sty_point.styleOf(item, this.d_.scale_);
                            DCoord coord = ((DPoint)item).getCoord(rpdh.axis);
                            value = coord.getValue(value);
                            full_text = rpdh.y_scale.valueText(value);
                        }
                        this.d_.gc_.setFont(sty_point.getFont());
                        int lh = DrawUtilIGC.textExtent(this.d_.gc_, full_text, rpdh.h_axis_alignment.getAlignment()).getW();
                        if (lh > rpdh.h_label_height) {
                            rpdh.h_label_height = lh;
                        }
                    }
                    item = item.getNext();
                }
                if (npoint > rpdh.n_max_points_by_curve) {
                    rpdh.n_max_points_by_curve = npoint;
                }
                ++icrv;
            }
            if (_im) {
                rpdh.n_bar += rpdh.n_max_points_by_curve - 1;
            }
            if (rpdh.h_label_height > (int)(0.5f * (float)rg_h)) {
                rpdh.h_label_height = (int)(0.5f * (float)rg_h);
            }
            rg_x += rpdh.yam.getL() + rpdh.h_label_height + this.d_.axis_unit_to_dot_spacing;
            rg_w -= rpdh.yam.getL();
            rg_y += rpdh.yam.getT();
            rg_h -= rpdh.yam.getT();
            rg_w -= rpdh.h_label_height + this.d_.axis_unit_to_dot_spacing;
            if (rpdh.n_bar > 0) {
                rpdh.thin_bar = rpd.graphic.getProperties().get("P_THIN_BAR.DGraphic.core.jscrib", false);
                boolean _3d = rpd.graphic.getProperties().get("P_3D.DGraphic.core.jscrib", false);
                float kthinbar = rpdh.thin_bar ? 0.7f : 1.0f;
                float k3d = 0.5f;
                rpdh.wbartobar = _3d ? (float)rg_h / ((float)rpdh.n_bar + k3d * kthinbar) : (float)rg_h / (float)rpdh.n_bar;
                rpdh.wbar = kthinbar * rpdh.wbartobar;
                rpdh.xdecbar = rpdh.thin_bar ? (rpdh.wbartobar - rpdh.wbar) / 2.0f : 0.0f;
                rpdh._3d_z = 0;
                if (_3d) {
                    rpdh._3d_z = (int)(k3d * rpdh.wbar);
                    rg_w -= rpdh._3d_z;
                    rg_x += rpdh._3d_z;
                    rg_h -= rpdh._3d_z;
                }
            }
            rpdh.y_scale.setScaleRange(rg_x, rg_x + rg_w);
            rpd.ag_rect.setRect(rg_x, rg_y, rg_w, rg_h);
            rpd.g = rpdh;
        }
        if (rpd.ag_rect.w() <= 0 || rpd.ag_rect.h() <= 0) {
            return;
        }
        RenderPersistData.Histogram h = (RenderPersistData.Histogram)rpd.g;
        this.d_.renderYAxis(false, true, true, h.axis, h.y_scale, rpd.ag_rect, h.yam, h.axis_style, 4, h._3d_z, h._3d_z);
        this.d_.renderMarkerLine(false, false, h.axis, rpd.ag_rect, h.y_scale);
        int rg_left = rpd.ag_rect.left();
        int rg_right = rpd.ag_rect.right();
        int rg_top = rpd.ag_rect.top();
        int rg_bottom = rpd.ag_rect.bottom();
        if (this.d_.drawing()) {
            this.d_.gc_.setPen(new LineStylePen(h.axis_style.getFore()));
            int btop = rpd.ag_rect.top();
            this.d_.gc_.drawLine(rg_left, rpd.ag_rect.bottom(), rg_left, btop);
            this.d_.gc_.drawLine(rg_left, btop, rg_right, btop);
        }
        Object vf = DefaultChartRenderData.getNewInstanceValue(h.axis);
        float xbar = rg_left;
        int y_bar_zero = (int)h.y_scale.getScaleForBar();
        if (this.d_.drawing()) {
            this.d_.gc_.drawLine(y_bar_zero, rg_top, y_bar_zero, rg_bottom);
        }
        DefaultRenderChartLocation loc = null;
        int n_curves = rpd.curve_styles.length;
        IShape save_clip = null;
        if (this.d_.drawing()) {
            save_clip = this.d_.gc_.getClipping();
            this.d_.gc_.setClipping(new Rect(rpd.ag_rect.x() - h._3d_z, rpd.ag_rect.y(), rpd.ag_rect.w() + h._3d_z + 1, rpd.ag_rect.h() + h._3d_z));
        }
        if (_im) {
            int ipt = 0;
            while (ipt < h.n_max_points_by_curve) {
                int icrv3 = 0;
                while (icrv3 < rpd.curve_styles.length) {
                    CurveStyle ccurve3 = rpd.curve_styles[icrv3];
                    DPoint point = null;
                    int i = 0;
                    IDItem item = ccurve3.curve_.getFirstChild();
                    while (item != null) {
                        if (item instanceof DPoint) {
                            if (i == ipt) {
                                point = (DPoint)item;
                                break;
                            }
                            ++i;
                        }
                        item = item.getNext();
                    }
                    if (point != null) {
                        try {
                            if (this.renderHistogramBar(false, rpd.ag_rect, rpd.locale, h, n_curves, vf, point, icrv3, ipt, xbar, y_bar_zero, _im)) {
                                xbar += h.wbartobar;
                            }
                        }
                        catch (DefaultRenderChartLocation _loc) {
                            loc = _loc;
                        }
                    }
                    ++icrv3;
                }
                xbar += h.wbartobar;
                ++ipt;
            }
        } else {
            icrv = 0;
            while (icrv < rpd.curve_styles.length) {
                ccurve = rpd.curve_styles[icrv];
                int ipt = 0;
                IDItem item = ccurve.curve_.getFirstChild();
                while (item != null) {
                    if (item instanceof DPoint) {
                        DPoint point = (DPoint)item;
                        try {
                            if (this.renderHistogramBar(false, rpd.ag_rect, rpd.locale, h, n_curves, vf, point, icrv, ipt, xbar, y_bar_zero, _im)) {
                                ++ipt;
                                xbar += h.wbartobar;
                            }
                        }
                        catch (DefaultRenderChartLocation _l) {
                            loc = _l;
                            ++ipt;
                            xbar += h.wbartobar;
                        }
                    }
                    item = item.getNext();
                }
                ++icrv;
            }
        }
        if (save_clip != null) {
            this.d_.gc_.setClipping(save_clip);
        }
        if (this.d_.locating() && loc != null) {
            throw loc;
        }
        this.d_.renderYAxis(false, false, true, h.axis, h.y_scale, rpd.ag_rect, h.yam, h.axis_style, 128, h._3d_z, h._3d_z);
        this.d_.renderMarkerLine(false, true, h.axis, rpd.ag_rect, h.y_scale);
    }

    private boolean renderHistogramBar(boolean vertical, Rect _rg, ULocale locale, RenderPersistData.Histogram h, int n_curves, Object _value, DPoint _point, int _icrv, int _ipt, float _xbar, int _y_bar_zero, boolean _im) throws DefaultRenderChartLocation {
        DCoord coord = _point.getCoord(h.axis);
        if (coord == null) {
            return false;
        }
        IGCDStyle sty_point = null;
        IGCDStyle sty_label = null;
        _value = coord.getValue(_value);
        int ibh = (int)h.y_scale.toScale(_value) - _y_bar_zero;
        if (_im) {
            _xbar = vertical ? (float)_rg.x() + (float)(_ipt * (n_curves + 1) + _icrv) * h.wbartobar : (float)_rg.y() + (float)(_ipt * (n_curves + 1) + _icrv) * h.wbartobar;
        }
        Rect rbar = h.thin_bar ? (vertical ? new Rect((int)(_xbar + h.xdecbar), _y_bar_zero, (int)h.wbar, ibh) : new Rect(_y_bar_zero, (int)(_xbar + h.xdecbar), ibh, (int)h.wbar)) : (vertical ? new Rect((int)_xbar, _y_bar_zero, (int)(_xbar + h.wbartobar - (float)((int)_xbar)), ibh) : new Rect(_y_bar_zero, (int)_xbar, ibh, (int)(_xbar + h.wbartobar - (float)((int)_xbar))));
        rbar.normalize();
        sty_point = new IGCDStyle(_point, this.d_.scale_);
        this.d_.renderBar(vertical, rbar, sty_point.getBack(), _point, h._3d_z);
        DText label = null;
        IDItem it = _point.getFirstChild();
        while (it != null) {
            if (it instanceof DText) {
                label = (DText)it;
                break;
            }
            it = it.getNext();
        }
        String full_text = null;
        String loc_id = "CurvePointText";
        DItem loc_item = _point;
        if (label != null) {
            full_text = label.getText();
            loc_id = "LabelText";
            loc_item = label;
            if (!DrawUtilIGC.isEmpty(full_text)) {
                sty_label = new IGCDStyle(label, this.d_.scale_);
            }
        } else {
            full_text = h.y_scale.valueText(_value);
        }
        if (!DrawUtilIGC.isEmpty(full_text)) {
            IGCDStyle sty = sty_label != null ? sty_label : sty_point;
            this.d_.gc_.setFont(sty.getFont());
            int aln = h.h_axis_alignment.getAlignment();
            String txt = vertical ? DrawUtilIGC.truncateText(this.d_.gc_, full_text, (int)h.wbartobar, h.h_label_height, aln) : DrawUtilIGC.truncateText(this.d_.gc_, full_text, _rg.left(), h.h_label_height, aln);
            if (!DrawUtilIGC.isEmpty(txt)) {
                IShape rc = this.d_.gc_.getClipping();
                this.d_.gc_.setClipping(null);
                Rect rtxt = vertical ? new Rect((int)_xbar, _rg.bottom() + this.d_.axis_unit_to_dot_spacing, (int)h.wbartobar - this.d_.dpiX(2), h.h_label_height) : new Rect(_rg.left() - this.d_.axis_unit_to_dot_spacing - h.h_label_height, (int)_xbar, h.h_label_height, (int)h.wbartobar - this.d_.dpiX(2));
                this.d_.renderText(txt, rtxt, aln, sty, loc_id, loc_item);
                this.d_.gc_.setClipping(rc);
            }
        }
        return true;
    }

    protected void renderSector(RenderPersistData rpd, boolean _3d) throws DefaultRenderChartLocation {
        int h_for_text;
        boolean display_values = rpd.graphic.getProperties().get("P_SHOW_VALUES.DGraphic.core.jscrib", true) || rpd.graphic.getProperties().get("P_SHOW_PERCENTAGE.DGraphic.core.jscrib", false);
        int rg_w = rpd.ag_rect.w();
        int rg_h = rpd.ag_rect.h();
        int d = rg_w;
        int n = h_for_text = display_values ? this.d_.dpiX(40) : 0;
        if (d > rg_h - h_for_text) {
            d = rg_h - h_for_text;
        }
        if (display_values) {
            d = 3 * d / 4;
        }
        double v_sum = 0.0;
        CurveStyle ccurve = null;
        IDItem item = null;
        DAxis axis = null;
        item = rpd.graphic.getFirstChild();
        while (item != null) {
            if (item instanceof DAxis) {
                axis = (DAxis)item;
                break;
            }
            item = item.getNext();
        }
        if (axis == null) {
            this.d_.error("Error: missing Axis in graphic", rpd);
            return;
        }
        if (!axis.useNumbers()) {
            this.d_.error("Error: Axis in Pie Chart must use numbers", rpd);
            return;
        }
        String axis_unit = axis.getUnit();
        if (axis_unit == null) {
            axis_unit = "";
        }
        if (!_3d) {
            _3d = rpd.graphic.getProperties().get("P_3D.DGraphic.core.jscrib", false);
        }
        int n_points = 0;
        Object val = null;
        int i = 0;
        while (i < rpd.curve_styles.length) {
            ccurve = rpd.curve_styles[i];
            item = ccurve.curve_.getFirstChild();
            while (item != null) {
                DCoord coord;
                if (item instanceof DPoint && (coord = ((DPoint)item).getCoord(axis)) != null && (val = coord.getValue(val)) instanceof Number) {
                    v_sum += Math.abs(((Number)val).doubleValue());
                    ++n_points;
                }
                item = item.getNext();
            }
            ++i;
        }
        if (v_sum == 0.0) {
            return;
        }
        int x3d = 0;
        int y3d = 0;
        int r3d = 0;
        int a3d = 0;
        if (_3d) {
            if (d >= this.d_.dpiX(48)) {
                x3d = -this.d_.dpiX(8);
                y3d = this.d_.dpiX(12);
            } else {
                y3d = d / 4;
                x3d = -((int)(2.0f * (float)y3d / 3.0f));
                if (Math.abs(x3d) < this.d_.dpiX(2)) {
                    _3d = false;
                    y3d = 0;
                    x3d = 0;
                }
            }
            if (_3d) {
                r3d = (int)Math.sqrt(x3d * x3d + y3d * y3d);
                float a = (float)Math.atan2(y3d, x3d);
                if (a < 0.0f) {
                    a = (float)((double)a + Math.PI * 2);
                }
                a3d = (int)((double)(180.0f * a) / Math.PI);
            }
        }
        LineAlg l3d = new LineAlg(0, 0, x3d, y3d);
        DefaultRenderChartLocation loc_sector = null;
        int[] between_sectors = new int[n_points * 2];
        Rect r = new Rect();
        int rg_x = rpd.ag_rect.x();
        int rg_y = rpd.ag_rect.y();
        IScale scale = DefaultChartRenderData.getScale(axis, 0.0, 0.0, null, null);
        while (l3d.nextPoint(null)) {
            int dy;
            Point rc;
            int dx;
            int dx3d = l3d.getX();
            int dy3d = l3d.getY();
            boolean top = dx3d == x3d && dy3d == y3d;
            int ray = d >> 1;
            r.setRect(rg_x + (rg_w - d) / 2 + dx3d, rg_y + (rg_h - d) / 2 - dy3d, d, d);
            if (r.w() == 0 || r.h() == 0) continue;
            double loc_dist = -1.0;
            double loc_angle = -1.0;
            if (this.d_.locating() && (loc_dist = Math.sqrt((dx = this.d_.lx_ - (rc = r.center()).getX()) * dx + (dy = this.d_.ly_ - rc.getY()) * dy)) <= (double)ray) {
                double a = Math.atan2(-dy, dx);
                if (a < 0.0) {
                    a += Math.PI * 2;
                }
                loc_angle = a;
            }
            int wbs = 0;
            int ipt = 0;
            double angle = 0.0;
            int i2 = 0;
            while (i2 < rpd.curve_styles.length) {
                ccurve = rpd.curve_styles[i2];
                item = ccurve.curve_.getFirstChild();
                while (item != null) {
                    DPoint point;
                    DCoord coord;
                    if (item instanceof DPoint && (coord = (point = (DPoint)item).getCoord(axis)) != null && (val = coord.getValue(val)) instanceof Number) {
                        double rv = ((Number)val).doubleValue();
                        double v = Math.abs(rv) / v_sum;
                        double end_angle = angle + Math.PI * 2 * v;
                        if (++ipt >= n_points) {
                            end_angle = Math.PI * 2;
                        }
                        double delta_angle = Radian.D2R(Radian.iR2D(end_angle) - Radian.iR2D(angle));
                        if (this.d_.drawing()) {
                            int cx = r.centerX();
                            int cy = r.centerY();
                            int rx = r.getW() / 2;
                            int ry = r.getH() / 2;
                            int pc = IGCDStyle.GetBackColor(point);
                            if (top) {
                                this.d_.gc_.setPen(new LineStylePen(255));
                                this.d_.gc_.setBrush(new SolidBrush(pc));
                                if (delta_angle != 0.0) {
                                    this.d_.gc_.fillArc(cx, cy, 0.0, rx, ry, angle, delta_angle);
                                    this.d_.gc_.drawArc(cx, cy, 0.0, rx, ry, angle, delta_angle);
                                }
                            } else if (delta_angle != 0.0) {
                                int dark = RGBA.Darker(pc, 0.35f);
                                this.d_.gc_.setBrush(new SolidBrush(dark));
                                this.d_.gc_.fillArc(cx, cy, 0.0, rx, ry, angle, delta_angle);
                            }
                            between_sectors[wbs++] = (int)((double)cx + (double)r.w() * 0.5 * Math.cos(angle));
                            between_sectors[wbs++] = (int)((double)cy - (double)r.h() * 0.5 * Math.sin(angle));
                        } else if (loc_dist <= (double)ray && loc_angle >= angle && loc_angle <= end_angle) {
                            loc_sector = new DefaultRenderChartLocation("CurveSector", point, r);
                            loc_sector.setAngles(Radian.iR2D(angle), Radian.iR2D(end_angle));
                        }
                        if (top && display_values) {
                            int da;
                            double atxt_rad = angle + (end_angle - angle) / 2.0;
                            int atxt = Radian.iR2D(atxt_rad);
                            int r3 = 0;
                            if (_3d && (da = Math.abs(atxt - a3d - 180)) < 90) {
                                float k = 1.0f - (float)da / 90.0f;
                                r3 = (int)(k * (float)r3d);
                            }
                            String txt = null;
                            DText label = null;
                            IDItem it = point.getFirstChild();
                            while (it != null) {
                                if (it instanceof DText) {
                                    label = (DText)it;
                                    break;
                                }
                                it = it.getNext();
                            }
                            IGCDStyle sty_txt = ccurve.style_;
                            String loc_id = "CurvePointText";
                            DItem loc_item = point;
                            if (label != null) {
                                txt = label.getText();
                                loc_id = "LabelText";
                                loc_item = label;
                                if (!DrawUtilIGC.isEmpty(txt)) {
                                    sty_txt = new IGCDStyle(label, this.d_.scale_);
                                }
                            } else {
                                txt = String.valueOf(scale.valueText(val)) + axis_unit;
                                sty_txt = new IGCDStyle(point, this.d_.scale_);
                            }
                            this.d_.renderSectorText(atxt_rad, ray + r3 + this.d_.margin_, r, txt, loc_item, sty_txt, loc_id);
                        }
                        angle = end_angle;
                    }
                    item = item.getNext();
                }
                ++i2;
            }
            if (!this.d_.drawing()) continue;
            this.d_.gc_.setPen(new LineStylePen(255));
            int cx = r.centerX();
            int cy = r.centerY();
            int i3 = 0;
            while (i3 < between_sectors.length) {
                int x = between_sectors[i3++];
                int y = between_sectors[i3++];
                if (top) {
                    this.d_.gc_.drawLine(cx, cy, x, y);
                    continue;
                }
                this.d_.gc_.drawPoint(x, y);
            }
        }
        if (loc_sector != null) {
            throw loc_sector;
        }
    }

    private void renderHistorsStep(DAxis _axis, IScale _scale, String _step, int _line_style, int _cx, int _cy, String loc_id) throws DefaultRenderChartLocation {
        String step = _axis.getProperties().get(_step, null);
        if (step == null) {
            return;
        }
        IPen save_pen = null;
        if (this.d_.drawing()) {
            save_pen = this.d_.gc_.getPen();
            this.d_.gc_.setPen(new LineStylePen(this.d_.getLineColor(_axis), _line_style));
        }
        Object vs = _scale.stepFirst(step);
        while (vs != null) {
            int radius = (int)_scale.toScale(vs);
            int diameter = radius * 2;
            if (this.d_.drawing()) {
                this.d_.gc_.drawOval(_cx - radius, _cy - radius, diameter, diameter);
            } else if (DrawUtilIGC.ovalUnder(_cx - radius, _cy - radius, diameter, diameter, this.d_.lx_, this.d_.ly_)) {
                throw new DefaultRenderChartLocation(loc_id, _axis, new Rect(_cx - radius, _cy - radius, diameter, diameter));
            }
            vs = _scale.stepNext(step, vs);
        }
        if (save_pen != null) {
            this.d_.gc_.setPen(save_pen);
        }
    }

    private void renderHistorsStepUnit(DAxis _axis, ULocale locale, IScale _scale, int _center_x, int _center_y, String _axis_unit) throws DefaultRenderChartLocation {
        Object step_unit = _axis.getProperties().get("P_STEP_UNIT.DAxis.core.jscrib");
        if (step_unit != null) {
            IPen save_pen = this.d_.gc_.getPen();
            IBrush save_brush = this.d_.gc_.getBrush();
            IFont save_font = this.d_.gc_.getFont();
            IGCDStyle style = new IGCDStyle(_axis, this.d_.scale_);
            SolidBrush btext = new SolidBrush(style.getFore());
            SolidBrush bfill = new SolidBrush(style.getBack());
            this.d_.gc_.setPen(new LineStylePen(style.getFore()));
            this.d_.gc_.setFont(style.getFont());
            Rect rtxt = new Rect();
            int aln = 9;
            String loc_id = "InAxisYStepUnitText";
            boolean first = true;
            boolean opaque = _axis.getProperties().get("P_HISTORS_UNIT_OPAQUE.DAxis.core.jscrib", false);
            boolean draw_top = true;
            boolean draw_left = true;
            boolean draw_right = true;
            boolean draw_bottom = true;
            String phu = _axis.getProperties().get("P_HISTORS_UNIT.DAxis.core.jscrib", null);
            if (phu instanceof IDAlignment) {
                IDAlignment a = (IDAlignment)((Object)phu);
                draw_top = a.haveAlignment(8);
                draw_left = a.haveAlignment(1);
                draw_right = a.haveAlignment(2);
                draw_bottom = a.haveAlignment(16);
            }
            DefaultRenderChartLocation loc_last_unit_circle_win = null;
            Object vs = _scale.stepFirst(step_unit);
            while (vs != null) {
                int xray = (int)_scale.toScale(vs);
                int xray2 = xray * 2;
                if (this.d_.drawing()) {
                    this.d_.gc_.setBrush(bfill);
                    this.d_.gc_.drawOval(_center_x - xray, _center_y - xray, xray2, xray2);
                } else if (DrawUtilIGC.ovalUnder(_center_x - xray, _center_y - xray, xray2, xray2, this.d_.lx_, this.d_.ly_)) {
                    loc_last_unit_circle_win = new DefaultRenderChartLocation("InAxisYStepUnitTextDot", _axis, new Rect(_center_x - xray, _center_y - xray, xray2, xray2));
                }
                String unit = String.valueOf(_scale.valueText(vs)) + _axis_unit;
                ISize size = DrawUtilIGC.textExtent(this.d_.gc_, unit, aln);
                int sw = size.getW();
                int sh = size.getH();
                boolean first_drawn = false;
                if (draw_top) {
                    rtxt.setRect(_center_x - sw / 2, _center_y - xray - sh / 2, sw, sh);
                    if (opaque && this.d_.drawing()) {
                        this.d_.gc_.setBrush(bfill);
                        this.d_.gc_.fillRect(rtxt);
                    }
                    this.d_.gc_.setBrush(btext);
                    this.d_.renderText(unit, rtxt, aln, style, loc_id, _axis);
                    first_drawn = first;
                }
                if (draw_bottom && (!first || first && !first_drawn)) {
                    rtxt.setRect(_center_x - sw / 2, _center_y + xray - sh / 2, sw, sh);
                    if (opaque && this.d_.drawing()) {
                        this.d_.gc_.setBrush(bfill);
                        this.d_.gc_.fillRect(rtxt);
                    }
                    this.d_.gc_.setBrush(btext);
                    this.d_.renderText(unit, rtxt, aln, style, loc_id, _axis);
                    first_drawn = first;
                }
                if (draw_left && (!first || first && !first_drawn)) {
                    rtxt.setRect(_center_x - xray - sh / 2, _center_y - sw / 2, sh, sw);
                    if (opaque && this.d_.drawing()) {
                        this.d_.gc_.setBrush(bfill);
                        this.d_.gc_.fillRect(rtxt);
                    }
                    this.d_.gc_.setBrush(btext);
                    this.d_.renderText(unit, rtxt, 128, style, loc_id, _axis);
                    first_drawn = first;
                }
                if (draw_right && (!first || first && !first_drawn)) {
                    rtxt.setRect(_center_x + xray - sh / 2, _center_y - sw / 2, sh, sw);
                    if (opaque && this.d_.drawing()) {
                        this.d_.gc_.setBrush(bfill);
                        this.d_.gc_.fillRect(rtxt);
                    }
                    this.d_.gc_.setBrush(btext);
                    this.d_.renderText(unit, rtxt, 256, style, loc_id, _axis);
                }
                first = false;
                vs = _scale.stepNext(step_unit, vs);
            }
            this.d_.gc_.setPen(save_pen);
            this.d_.gc_.setBrush(save_brush);
            this.d_.gc_.setFont(save_font);
            if (loc_last_unit_circle_win != null) {
                throw loc_last_unit_circle_win;
            }
        }
    }

    private void renderHistors(RenderPersistData rpd) throws DefaultRenderChartLocation {
        int rg_h;
        boolean display_decorations = true;
        int rg_w = rpd.ag_rect.w();
        int d = rg_w;
        if (d > (rg_h = rpd.ag_rect.h())) {
            d = rg_h;
        }
        if (display_decorations) {
            d = 3 * d / 4;
        }
        int ray = d >> 1;
        DAxis axis = null;
        int nsector = 0;
        IDItem item = rpd.graphic.getFirstChild();
        while (item != null) {
            if (item instanceof DAxis) {
                axis = (DAxis)item;
                break;
            }
            item = item.getNext();
        }
        if (axis == null) {
            if (this.d_.drawing()) {
                this.d_.error("Missing axis", rpd);
            }
            return;
        }
        DPropertyStore props = axis.getProperties();
        Object vmax = props.get("P_MAX.DAxis.core.jscrib");
        Object vmin = props.get("P_MIN.DAxis.core.jscrib");
        boolean vmin_tryied_to_be_zero = false;
        if (vmin == null && vmax != null && axis.useNumbers()) {
            vmin = new VDouble(0.0);
            vmin_tryied_to_be_zero = false;
        }
        boolean do_mm = vmax == null || vmin == null;
        MinMax mm = do_mm ? new MinMax(axis) : null;
        item = rpd.graphic.getFirstChild();
        while (item != null) {
            if (item instanceof DCurve) {
                IDItem it = item.getFirstChild();
                while (it != null) {
                    DCoord coord;
                    if (it instanceof DPoint && (coord = ((DPoint)it).getCoord(axis)) != null) {
                        if (do_mm) {
                            mm.update(coord);
                        }
                        ++nsector;
                    }
                    it = it.getNext();
                }
            }
            item = item.getNext();
        }
        if (do_mm) {
            Object v;
            if (vmin == null) {
                vmin = mm.getVMin();
                v = props.get("P_MIN_HINT.DAxis.core.jscrib");
                if (v != null) {
                    try {
                        if (vmin == null) {
                            vmin = v;
                        } else if (vmin instanceof Comparable) {
                            if (((Comparable)vmin).compareTo(v) > 0) {
                                vmin = v;
                            }
                        } else if (v instanceof Comparable && ((Comparable)v).compareTo(vmin) < 0) {
                            vmin = v;
                        }
                    }
                    catch (Exception exception) {}
                }
            } else if (vmin_tryied_to_be_zero) {
                vmin = props.get("P_MIN_HINT.DAxis.core.jscrib", null);
            }
            if (vmax == null) {
                vmax = mm.getVMax();
                v = props.get("P_MAX_HINT.DAxis.core.jscrib");
                if (v != null) {
                    try {
                        if (vmax == null) {
                            vmax = v;
                        } else if (vmax instanceof Comparable) {
                            if (((Comparable)vmax).compareTo(v) < 0) {
                                vmax = v;
                            }
                        } else if (v instanceof Comparable && ((Comparable)v).compareTo(vmax) > 0) {
                            vmax = v;
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
        double s_angle = Math.PI * 2 / (double)nsector;
        int center_x = rpd.ag_rect.centerX();
        int center_y = rpd.ag_rect.centerY();
        Rect r = new Rect();
        IScale scale = DefaultChartRenderData.getScale(axis, 0.0, d / 2, vmin, vmax);
        if (!scale.isValid()) {
            if (this.d_.drawing()) {
                this.d_.error("Error: invalid scale", rpd);
            }
            return;
        }
        String axis_unit = axis.getUnit();
        if (axis_unit == null) {
            axis_unit = "";
        }
        DefaultRenderChartLocation axis_located = null;
        int x3d = 0;
        int y3d = 0;
        boolean _3d = rpd.graphic.getProperties().get("P_3D.DGraphic.core.jscrib", false);
        if (_3d) {
            if (d >= this.d_.dpiX(48)) {
                x3d = -this.d_.dpiX(8);
                y3d = this.d_.dpiX(12);
            } else {
                y3d = d / 4;
                x3d = -((int)(2.0f * (float)y3d / 3.0f));
                if (Math.abs(x3d) < this.d_.dpiX(2)) {
                    _3d = false;
                    y3d = 0;
                    x3d = 0;
                }
            }
            if (_3d) {
                int cfr_ignored_0 = (int)Math.sqrt(x3d * x3d + y3d * y3d);
                float a = (float)Math.atan2(y3d, x3d);
                if (a < 0.0f) {
                    a = (float)((double)a + Math.PI * 2);
                }
                int cfr_ignored_1 = (int)((double)(180.0f * a) / Math.PI);
            }
        }
        LineAlg l3d = new LineAlg(0, 0, x3d, y3d);
        int scx = center_x;
        int scy = center_y;
        while (l3d.nextPoint(null)) {
            int dx3d = l3d.getX();
            int dy3d = l3d.getY();
            boolean bottom = dx3d == 0 && dy3d == 0;
            boolean top = dx3d == x3d && dy3d == y3d;
            center_x = scx + dx3d;
            center_y = scy + dx3d;
            double angle = 0.0;
            Object val = null;
            if (top) {
                try {
                    this.renderHistorsStep(axis, scale, "P_STEP_DOT.DAxis.core.jscrib", 2, center_x, center_y, "InAxisYStepDot");
                }
                catch (DefaultRenderChartLocation loc) {
                    axis_located = loc;
                }
                try {
                    this.renderHistorsStep(axis, scale, "P_STEP_LINE.DAxis.core.jscrib", 0, center_x, center_y, "InAxisYStepLine");
                }
                catch (DefaultRenderChartLocation loc) {
                    axis_located = loc;
                }
                try {
                    this.renderHistorsStepUnit(axis, rpd.locale, scale, center_x, center_y, axis_unit);
                }
                catch (DefaultRenderChartLocation loc) {
                    axis_located = loc;
                }
            }
            int max_radius = (int)scale.toScale(vmax);
            int icrv = 0;
            while (icrv < rpd.curve_styles.length) {
                CurveStyle ccurve = rpd.curve_styles[icrv];
                item = ccurve.curve_.getFirstChild();
                while (item != null) {
                    DPoint point;
                    DCoord coord;
                    if (item instanceof DPoint && (coord = (point = (DPoint)item).getCoord(axis)) != null) {
                        IGCDStyle style;
                        boolean over_radius;
                        int xray = (int)scale.toScale(val = coord.getValue(val));
                        boolean bl = over_radius = xray > max_radius;
                        if (over_radius) {
                            xray = max_radius;
                        }
                        int xray2 = 2 * xray;
                        if (xray > 0) {
                            r.setRect(0, 0, xray2, xray2);
                            r.moveCenter(center_x, center_y);
                            if (this.d_.drawing()) {
                                double start_angle = angle;
                                style = new IGCDStyle(point, this.d_.scale_);
                                int dark = 0;
                                if (!top) {
                                    dark = RGBA.Darker(style.getBack(), 0.35f);
                                    this.d_.gc_.setBrush(new SolidBrush(dark));
                                } else {
                                    this.d_.gc_.setBrush(new SolidBrush(style.getBack()));
                                }
                                if (top || bottom) {
                                    this.d_.gc_.setPen(new LineStylePen(255));
                                } else {
                                    this.d_.gc_.setPen(new LineStylePen(dark));
                                }
                                if (s_angle != 0.0) {
                                    this.d_.gc_.fillArc(center_x, center_y, 0.0, xray, xray, start_angle, s_angle);
                                    if (!over_radius && (top || bottom)) {
                                        this.d_.gc_.drawArc(center_x, center_y, 0.0, xray, xray, start_angle, s_angle);
                                    }
                                }
                                int px = center_x + (int)((double)xray * Math.cos(angle));
                                int py = center_y - (int)((double)xray * Math.sin(angle));
                                if (top || bottom) {
                                    this.d_.gc_.drawLine(center_x, center_y, px, py);
                                } else {
                                    this.d_.gc_.drawPoint(px, py);
                                }
                                double r_angle = angle + s_angle;
                                px = center_x + (int)((double)xray * Math.cos(r_angle));
                                py = center_y - (int)((double)xray * Math.sin(r_angle));
                                if (top || bottom) {
                                    this.d_.gc_.drawLine(center_x, center_y, px, py);
                                } else {
                                    this.d_.gc_.drawPoint(px, py);
                                }
                            } else if (r.contains(this.d_.lx_, this.d_.ly_)) {
                                float loc_dist = -1.0f;
                                double loc_angle = -1.0;
                                int dx = this.d_.lx_ - center_x;
                                int dy = this.d_.ly_ - center_y;
                                loc_dist = (float)Math.sqrt(dx * dx + dy * dy);
                                if (loc_dist <= (float)xray) {
                                    float a = (float)Math.atan2(-dy, dx);
                                    if (a < 0.0f) {
                                        a = (float)((double)a + Math.PI * 2);
                                    }
                                    if ((loc_angle = (double)a) >= angle && loc_angle <= angle + s_angle) {
                                        DefaultRenderChartLocation loc = new DefaultRenderChartLocation("CurveSector", point, r);
                                        loc.setAngles(Radian.iR2D(angle), Radian.iR2D(angle + s_angle));
                                        if (!top) {
                                            axis_located = loc;
                                        } else {
                                            throw loc;
                                        }
                                    }
                                }
                            }
                        }
                        if (top && display_decorations) {
                            DText label = null;
                            IDItem it = point.getFirstChild();
                            while (it != null) {
                                if (it instanceof DText) {
                                    label = (DText)it;
                                    break;
                                }
                                it = it.getNext();
                            }
                            String txt = null;
                            style = null;
                            String loc_id = "CurvePointText";
                            DItem loc_item = point;
                            if (label != null) {
                                txt = label.getText();
                                loc_id = "LabelText";
                                loc_item = label;
                                if (!DrawUtilIGC.isEmpty(txt)) {
                                    style = new IGCDStyle(label, this.d_.scale_);
                                }
                            } else {
                                txt = String.valueOf(scale.valueText(val)) + axis_unit;
                                style = new IGCDStyle(point, this.d_.scale_);
                            }
                            double atxt = angle + s_angle / 2.0;
                            this.d_.renderSectorText(atxt, ray + this.d_.margin_, r, txt, loc_item, style, loc_id);
                        }
                        angle += s_angle;
                    }
                    item = item.getNext();
                }
                ++icrv;
            }
        }
        if (this.d_.locating() && axis_located != null) {
            throw axis_located;
        }
    }
}

