/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.internal;

import org.eclipse.tptp.platform.report.chart.internal.Box3D;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderData;
import org.eclipse.tptp.platform.report.chart.internal.DefaultRenderChartLocation;
import org.eclipse.tptp.platform.report.chart.internal.IScale;
import org.eclipse.tptp.platform.report.chart.internal.Insets;
import org.eclipse.tptp.platform.report.chart.internal.View3D;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.drawutil.internal.DrawUtilIGC;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.drawutil.internal.Point2D;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.Radian;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.SolidBrush;

class DefaultChartRender3D {
    DefaultChartRender3D() {
    }

    public static String axis3DName(DAxis _axis) {
        String title = _axis.getTitle();
        String unit = _axis.getUnit();
        if (!DrawUtilIGC.isEmpty(unit)) {
            title = title != null ? String.valueOf(title) + " (" + unit + ")" : "(" + unit + ")";
        }
        return title;
    }

    public static void drawBox3D(DefaultChartRenderData _d, View3D _view, Box3D _bb, boolean x_incr, boolean y_incr, boolean z_incr, boolean for_front) {
        double yzplan;
        double xzplan;
        Point2D[] p = new Point2D[8];
        double xn = _bb.getXMin();
        double xx = _bb.getXMax();
        double yn = _bb.getYMin();
        double yx = _bb.getYMax();
        double zn = _bb.getZMin();
        double zx = _bb.getZMax();
        p[0] = _view.projection(xn, yn, zn, new Point2D());
        p[1] = _view.projection(xx, yn, zn, new Point2D());
        p[2] = _view.projection(xx, yx, zn, new Point2D());
        p[3] = _view.projection(xn, yx, zn, new Point2D());
        p[4] = _view.projection(xn, yn, zx, new Point2D());
        p[5] = _view.projection(xx, yn, zx, new Point2D());
        p[6] = _view.projection(xx, yx, zx, new Point2D());
        p[7] = _view.projection(xn, yx, zx, new Point2D());
        LineStylePen pen = new LineStylePen(-1061109505);
        _d.gc_.setPen(pen);
        if (for_front) {
            xzplan = y_incr ? _bb.getYMax() : _bb.getYMin();
            yzplan = x_incr ? _bb.getXMax() : _bb.getXMin();
        } else {
            xzplan = y_incr ? _bb.getYMin() : _bb.getYMax();
            yzplan = x_incr ? _bb.getXMin() : _bb.getXMax();
        }
        p[0] = _view.projection(xn, xzplan, zn, new Point2D());
        p[1] = _view.projection(xx, xzplan, zn, new Point2D());
        p[2] = _view.projection(yzplan, yn, zn, new Point2D());
        p[3] = _view.projection(yzplan, yx, zn, new Point2D());
        p[4] = _view.projection(xn, xzplan, zx, new Point2D());
        p[5] = _view.projection(xx, xzplan, zx, new Point2D());
        p[6] = _view.projection(yzplan, yn, zx, new Point2D());
        p[7] = _view.projection(yzplan, yx, zx, new Point2D());
        _d.gc_.drawLine((int)p[0].getX(), (int)p[0].getY(), (int)p[1].getX(), (int)p[1].getY());
        _d.gc_.drawLine((int)p[2].getX(), (int)p[2].getY(), (int)p[3].getX(), (int)p[3].getY());
        _d.gc_.drawLine((int)p[4].getX(), (int)p[4].getY(), (int)p[5].getX(), (int)p[5].getY());
        _d.gc_.drawLine((int)p[6].getX(), (int)p[6].getY(), (int)p[7].getX(), (int)p[7].getY());
        _d.gc_.drawLine((int)p[0].getX(), (int)p[0].getY(), (int)p[4].getX(), (int)p[4].getY());
        _d.gc_.drawLine((int)p[1].getX(), (int)p[1].getY(), (int)p[5].getX(), (int)p[5].getY());
        _d.gc_.drawLine((int)p[2].getX(), (int)p[2].getY(), (int)p[6].getX(), (int)p[6].getY());
        _d.gc_.drawLine((int)p[3].getX(), (int)p[3].getY(), (int)p[7].getX(), (int)p[7].getY());
    }

    public static void renderZAxis3D(DefaultChartRenderData _d, View3D _view, Box3D _bb, DAxis _axis, IScale _scale, IGCDStyle _axis_style, boolean x_incr, boolean y_incr, boolean z_incr, boolean for_front, Insets insets) throws DefaultRenderChartLocation {
        String axis_title;
        double y_axis;
        double x_axis;
        boolean get_insets = insets != null;
        double xzplan = y_incr ? _bb.getYMin() : _bb.getYMax();
        double yzplan = x_incr ? _bb.getXMin() : _bb.getXMax();
        double xmin = _bb.getXMin();
        double xmax = _bb.getXMax();
        double ymin = _bb.getYMin();
        double ymax = _bb.getYMax();
        double zmin = _bb.getZMin();
        double zmax = _bb.getZMax();
        Point2D p0 = new Point2D();
        Point2D p1 = new Point2D();
        if (!for_front && !get_insets) {
            Object step = _axis.getProperties().get("P_STEP_LINE.DAxis.core.jscrib");
            if (_d.drawing() && step != null) {
                _d.gc_.setPen(new LineStylePen(_d.getLineColor(_axis)));
                Object vs = _scale.stepFirst(step);
                while (vs != null) {
                    double v = _scale.toScale(vs);
                    _view.projection(xmax, xzplan, v, p0);
                    _view.projection(xmin, xzplan, v, p1);
                    _d.gc_.drawLine((int)p0.getX(), (int)p0.getY(), (int)p1.getX(), (int)p1.getY());
                    _view.projection(yzplan, ymin, v, p0);
                    _view.projection(yzplan, ymax, v, p1);
                    _d.gc_.drawLine((int)p0.getX(), (int)p0.getY(), (int)p1.getX(), (int)p1.getY());
                    vs = _scale.stepNext(step, vs);
                }
            }
        }
        if (!for_front && !get_insets) {
            return;
        }
        if (x_incr) {
            if (y_incr) {
                x_axis = xmin;
                y_axis = ymax;
            } else {
                x_axis = xmax;
                y_axis = ymax;
            }
        } else if (y_incr) {
            x_axis = xmin;
            y_axis = ymin;
        } else {
            x_axis = xmax;
            y_axis = ymin;
        }
        double nphi = Radian.normalize(_view.getPhi());
        boolean text_on_the_right = nphi <= 1.5707963267948966 || nphi >= 4.71238898038469;
        Object step = _axis.getProperties().get("P_STEP_DOT.DAxis.core.jscrib");
        if (step != null) {
            int dot_length;
            int n = dot_length = text_on_the_right ? _d.axis_dot_size : -_d.axis_dot_size;
            if (get_insets) {
                if (text_on_the_right) {
                    insets.addR(dot_length);
                } else {
                    insets.addL(-dot_length);
                }
            } else if (_d.drawing()) {
                _d.gc_.setPen(new LineStylePen(_d.getLineColor(_axis)));
                Object vs = _scale.stepFirst(step);
                while (vs != null) {
                    double v = _scale.toScale(vs);
                    _view.projection(x_axis, y_axis, v, p0);
                    _d.gc_.drawLine((int)p0.getX(), (int)p0.getY(), (int)p0.getX() + dot_length, (int)p0.getY());
                    vs = _scale.stepNext(step, vs);
                }
            }
        }
        step = _axis.getProperties().get("P_STEP_UNIT.DAxis.core.jscrib");
        int wtx = 0;
        if (step != null) {
            if (_d.drawing()) {
                _d.gc_.setBrush(new SolidBrush(_axis_style.getFore()));
                _d.gc_.setFont(_axis_style.getFont());
                _d.gc_.setPen(new LineStylePen(_axis_style.getFore()));
            }
            Rect rtxt = new Rect();
            int fh = _d.gc_.getFontMetrics().getHeight();
            Object vs = _scale.stepFirst(step);
            while (vs != null) {
                double v = _scale.toScale(vs);
                _view.projection(x_axis, y_axis, v, p0);
                String txt = _scale.valueText(vs);
                int wt = _d.gc_.textExtent(txt).getW();
                if (wt > wtx) {
                    wtx = wt;
                }
                if (text_on_the_right) {
                    rtxt.setRect(_d.axis_unit_dot_size + _d.axis_unit_to_dot_spacing, -fh / 2, wt, fh);
                } else {
                    rtxt.setRect(-wt - _d.axis_unit_dot_size - _d.axis_unit_to_dot_spacing, -fh / 2, wt, fh);
                }
                rtxt.moveBy((int)p0.getX(), (int)p0.getY());
                if (!get_insets) {
                    if (_d.drawing()) {
                        if (text_on_the_right) {
                            _d.gc_.drawLine((int)p0.getX(), (int)p0.getY(), (int)p0.getX() + _d.axis_unit_dot_size, (int)p0.getY());
                        } else {
                            _d.gc_.drawLine((int)p0.getX(), (int)p0.getY(), (int)p0.getX() - _d.axis_unit_dot_size, (int)p0.getY());
                        }
                        DrawUtilIGC.drawText(_d.gc_, rtxt, 36, txt);
                    } else if (rtxt.contains(_d.lx_, _d.ly_)) {
                        throw new DefaultRenderChartLocation("InAxisZStepUnitText", _axis, rtxt);
                    }
                }
                vs = _scale.stepNext(step, vs);
            }
            wtx += _d.axis_unit_dot_size + _d.axis_unit_to_dot_spacing;
            if (get_insets) {
                if (text_on_the_right) {
                    insets.maxR(wtx);
                } else {
                    insets.maxL(wtx);
                }
            }
        }
        if (!DrawUtilIGC.isEmpty(axis_title = DefaultChartRender3D.axis3DName(_axis))) {
            Rect rtxt = new Rect();
            int fh = _d.gc_.getFontMetrics().getHeight();
            int wt = _d.gc_.textExtent(axis_title).getW();
            if (get_insets) {
                if (text_on_the_right) {
                    insets.addR(_d.axis_title_to_unit_spacing + fh);
                } else {
                    insets.addL(_d.axis_title_to_unit_spacing + fh);
                }
            } else {
                rtxt.setRect(0, 0, fh, wt);
                _view.projection(x_axis, y_axis, zmax, p0);
                _view.projection(x_axis, y_axis, zmin, p1);
                int x = ((int)p0.getX() + (int)p1.getX()) / 2;
                int y = ((int)p0.getY() + (int)p1.getY()) / 2;
                if (text_on_the_right) {
                    rtxt.moveCenter(x + wtx + _d.axis_title_to_unit_spacing + fh / 2, y);
                } else {
                    rtxt.moveCenter(x - wtx - _d.axis_title_to_unit_spacing - fh / 2, y);
                }
                if (_d.drawing()) {
                    _d.gc_.setBrush(new SolidBrush(_axis_style.getFore()));
                    _d.gc_.setFont(_axis_style.getFont());
                    int aln = text_on_the_right ? 292 : 164;
                    DrawUtilIGC.drawText(_d.gc_, rtxt, aln, axis_title);
                } else if (rtxt.contains(_d.lx_, _d.ly_)) {
                    throw new DefaultRenderChartLocation("InAxisZTitle", _axis, rtxt);
                }
            }
        }
    }

    public static void renderXYAxis3D(boolean for_x_axis, DefaultChartRenderData _d, View3D _view, Box3D _bb, DAxis _axis, IScale _scale, IGCDStyle _axis_style, boolean x_incr, boolean y_incr, boolean z_incr, boolean for_front, Insets insets) throws DefaultRenderChartLocation {
        String axis_title;
        Object step;
        boolean have_step_dot;
        boolean text_on_right;
        boolean text_on_top;
        boolean get_insets = insets != null;
        double xplan = x_incr ? _bb.getXMin() : _bb.getXMax();
        double yplan = y_incr ? _bb.getYMin() : _bb.getYMax();
        double zplan = z_incr ? _bb.getZMin() : _bb.getZMax();
        double xmin = _bb.getXMin();
        double xmax = _bb.getXMax();
        double ymin = _bb.getYMin();
        double ymax = _bb.getYMax();
        double zmin = _bb.getZMin();
        double zmax = _bb.getZMax();
        Point2D p0 = new Point2D();
        Point2D p1 = new Point2D();
        if (!for_front && !get_insets) {
            Object step2 = _axis.getProperties().get("P_STEP_LINE.DAxis.core.jscrib");
            if (_d.drawing() && step2 != null) {
                _d.gc_.setPen(new LineStylePen(_d.getLineColor(_axis)));
                Object vs = _scale.stepFirst(step2);
                while (vs != null) {
                    double v = _scale.toScale(vs);
                    if (for_x_axis) {
                        _view.projection(v, yplan, zmin, p0);
                        _view.projection(v, yplan, zmax, p1);
                    } else {
                        _view.projection(xplan, v, zmin, p0);
                        _view.projection(xplan, v, zmax, p1);
                    }
                    _d.gc_.drawLine((int)p0.getX(), (int)p0.getY(), (int)p1.getX(), (int)p1.getY());
                    if (for_x_axis) {
                        _view.projection(v, ymin, zplan, p0);
                        _view.projection(v, ymax, zplan, p1);
                    } else {
                        _view.projection(xmin, v, zplan, p0);
                        _view.projection(xmax, v, zplan, p1);
                    }
                    _d.gc_.drawLine((int)p0.getX(), (int)p0.getY(), (int)p1.getX(), (int)p1.getY());
                    vs = _scale.stepNext(step2, vs);
                }
            }
        }
        if (!for_front && !get_insets) {
            return;
        }
        double z_axis = 0.0;
        double x_axis = 0.0;
        double y_axis = 0.0;
        double dangle = 0.0;
        int code = (x_incr ? 100 : 0) | (y_incr ? 10 : 0) | (z_incr ? 1 : 0);
        if (for_x_axis) {
            z_axis = code == 10 || code == 11 || code == 110 || code == 111 ? zmin : zmax;
            y_axis = code == 0 || code == 10 || code == 100 || code == 110 ? ymin : ymax;
            text_on_top = code != 0 && code != 11 && code != 100 && code != 111;
            text_on_right = code >= 100;
            dangle = 1.5707963267948966;
        } else {
            z_axis = code == 0 || code == 101 || code == 110 ? zmin : zmax;
            x_axis = code == 10 || code == 110 || code == 111 ? xmin : xmax;
            text_on_top = code != 10 && code != 100 && code != 101;
            text_on_right = code == 1 || code == 111 || code == 101;
            dangle = code == 1 || code == 10 || code == 11 || code == 101 || code == 110 ? 4.71238898038469 : 1.5707963267948966;
        }
        int p = Radian.iR2D(Radian.normalize(_view.getPhi()));
        if (p > 90 && p < 180 || p > 270) {
            text_on_top = !text_on_top;
            boolean bl = text_on_right = !text_on_right;
        }
        if (for_x_axis) {
            _view.projection(xmin, y_axis, z_axis, p0);
            _view.projection(xmax, y_axis, z_axis, p1);
        } else {
            _view.projection(x_axis, ymin, z_axis, p0);
            _view.projection(x_axis, ymax, z_axis, p1);
        }
        double angle = Radian.normalize(Math.atan2(-((int)(p1.getY() - p0.getY())), (int)(p1.getX() - p0.getX())));
        angle += dangle;
        Rect r_view = null;
        if (get_insets) {
            r_view = _view.getScaledTo();
        }
        boolean bl = have_step_dot = (step = _axis.getProperties().get("P_STEP_DOT.DAxis.core.jscrib")) != null;
        if (step != null) {
            int dot_length = _d.axis_dot_size;
            int dx = (int)Math.round((double)dot_length * Math.cos(angle));
            int dy = (int)Math.round((double)dot_length * Math.sin(angle));
            if (get_insets) {
                if (dx > 0) {
                    insets.maxR(dx);
                } else {
                    insets.maxL(-dx);
                }
                if (dy > 0) {
                    insets.maxT(dy);
                } else {
                    insets.maxB(-dy);
                }
            } else if (_d.drawing()) {
                _d.gc_.setPen(new LineStylePen(_d.getLineColor(_axis)));
                Object vs = _scale.stepFirst(step);
                while (vs != null) {
                    double v = _scale.toScale(vs);
                    if (for_x_axis) {
                        _view.projection(v, y_axis, z_axis, p0);
                    } else {
                        _view.projection(x_axis, v, z_axis, p0);
                    }
                    _d.gc_.drawLine((int)p0.getX(), (int)p0.getY(), (int)p0.getX() + dx, (int)p0.getY() - dy);
                    vs = _scale.stepNext(step, vs);
                }
            }
        }
        boolean have_step_unit = false;
        step = _axis.getProperties().get("P_STEP_UNIT.DAxis.core.jscrib");
        int wtx = 0;
        if (step != null) {
            have_step_unit = true;
            if (_d.drawing()) {
                _d.gc_.setBrush(new SolidBrush(_axis_style.getFore()));
                _d.gc_.setFont(_axis_style.getFont());
                _d.gc_.setPen(new LineStylePen(_axis_style.getFore()));
            }
            Rect rtxt = new Rect();
            int fh = _d.gc_.getFontMetrics().getHeight();
            int tl = _d.axis_unit_dot_size + _d.axis_unit_to_dot_spacing;
            int dxd = (int)Math.round((double)_d.axis_unit_dot_size * Math.cos(angle));
            int dyd = (int)Math.round((double)_d.axis_unit_dot_size * Math.sin(angle));
            int dxt = (int)Math.round((double)tl * Math.cos(angle));
            int dyt = (int)Math.round((double)tl * Math.sin(angle));
            Object vs = _scale.stepFirst(step);
            while (vs != null) {
                double v = _scale.toScale(vs);
                if (for_x_axis) {
                    _view.projection(v, y_axis, z_axis, p0);
                } else {
                    _view.projection(x_axis, v, z_axis, p0);
                }
                String txt = _scale.valueText(vs);
                int wt = _d.gc_.textExtent(txt).getW();
                if (wt > wtx) {
                    wtx = wt;
                }
                if (text_on_top) {
                    rtxt.setRect((int)p0.getX() + dxt, (int)p0.getY() - dyt - fh, wt, fh);
                } else {
                    rtxt.setRect((int)p0.getX() + dxt, (int)p0.getY() - dyt, wt, fh);
                }
                if (!text_on_right) {
                    rtxt.moveBy(-wt, 0);
                }
                if (get_insets) {
                    insets.max(r_view, rtxt);
                } else if (_d.drawing()) {
                    _d.gc_.drawLine((int)p0.getX(), (int)p0.getY(), (int)p0.getX() + dxd, (int)p0.getY() - dyd);
                    DrawUtilIGC.drawText(_d.gc_, rtxt, 36, txt);
                } else if (rtxt.contains(_d.lx_, _d.ly_)) {
                    throw new DefaultRenderChartLocation(for_x_axis ? "InAxisXStepUnitText" : "InAxisYStepUnitText", _axis, rtxt);
                }
                vs = _scale.stepNext(step, vs);
            }
            wtx += _d.axis_unit_dot_size + _d.axis_unit_to_dot_spacing;
        }
        if (!DrawUtilIGC.isEmpty(axis_title = DefaultChartRender3D.axis3DName(_axis))) {
            int d;
            Rect rtxt = new Rect();
            int fh = _d.gc_.getFontMetrics().getHeight();
            int wt = _d.gc_.textExtent(axis_title).getW();
            if (for_x_axis) {
                _view.projection(xmin, y_axis, z_axis, p0);
                _view.projection(xmax, y_axis, z_axis, p1);
            } else {
                _view.projection(x_axis, ymin, z_axis, p0);
                _view.projection(x_axis, ymax, z_axis, p1);
            }
            int x = ((int)p0.getX() + (int)p1.getX()) / 2;
            int y = ((int)p0.getY() + (int)p1.getY()) / 2;
            if (have_step_unit) {
                int wtx_fh_proj;
                int ia = Radian.iR2D(Radian.normalize(angle));
                if (ia == 0 || ia == 180) {
                    wtx_fh_proj = wtx;
                } else if (ia == 90 || ia == 270) {
                    wtx_fh_proj = fh;
                } else {
                    double d1 = Math.abs((double)fh * Math.cos(1.5707963267948966 - angle));
                    double d2 = Math.abs((double)wtx * Math.cos(angle));
                    wtx_fh_proj = (int)(d1 + d2);
                }
                d = _d.axis_unit_dot_size + _d.axis_unit_to_dot_spacing + wtx_fh_proj + _d.axis_title_to_unit_spacing;
            } else {
                d = have_step_dot ? _d.axis_dot_size + _d.axis_title_to_unit_spacing : _d.axis_title_to_unit_spacing;
            }
            int dxt = (int)Math.round((double)d * Math.cos(angle));
            int dyt = (int)Math.round((double)d * Math.sin(angle));
            x += dxt;
            y -= dyt;
            if (text_on_top) {
                y -= fh;
            }
            if (!text_on_right) {
                x -= wt;
            }
            rtxt.setRect(x, y, wt, fh);
            if (get_insets) {
                insets.max(r_view, rtxt);
            } else if (_d.drawing()) {
                _d.gc_.setBrush(new SolidBrush(_axis_style.getFore()));
                _d.gc_.setFont(_axis_style.getFont());
                int aln = 36;
                DrawUtilIGC.drawText(_d.gc_, rtxt, aln, axis_title);
            } else if (rtxt.contains(_d.lx_, _d.ly_)) {
                throw new DefaultRenderChartLocation(for_x_axis ? "InAxisXTitle" : "InAxisYTitle", _axis, rtxt);
            }
        }
    }
}

