/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.internal;

import com.ibm.icu.text.UFormat;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import java.util.List;
import org.eclipse.tptp.platform.report.chart.internal.CategoryScale;
import org.eclipse.tptp.platform.report.chart.internal.DefaultRenderChartLocation;
import org.eclipse.tptp.platform.report.chart.internal.IScale;
import org.eclipse.tptp.platform.report.chart.internal.IScaleProvider;
import org.eclipse.tptp.platform.report.chart.internal.Insets;
import org.eclipse.tptp.platform.report.chart.internal.LinearDateScale;
import org.eclipse.tptp.platform.report.chart.internal.LinearNumberScale;
import org.eclipse.tptp.platform.report.chart.internal.LogNumberScale;
import org.eclipse.tptp.platform.report.chart.internal.RenderPersistData;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DCategory;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DI18N;
import org.eclipse.tptp.platform.report.core.internal.DMarkerLine;
import org.eclipse.tptp.platform.report.core.internal.DPropertyStore;
import org.eclipse.tptp.platform.report.core.internal.IDAlignment;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drawutil.internal.DrawUtilIGC;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.igc.internal.IFont;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPen;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.util.internal.Font;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.Polygon;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;
import org.eclipse.tptp.platform.report.igc.util.internal.Radian;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.SolidBrush;
import org.eclipse.tptp.platform.report.tools.internal.DAlignment;
import org.eclipse.tptp.platform.report.tools.internal.VDouble;

public class DefaultChartRenderData {
    public final int axis_title_to_unit_spacing;
    public final int axis_unit_to_dot_spacing;
    public final int axis_dot_size;
    public final int axis_unit_dot_size;
    public final int max_axis_dot_size;
    public int margin_;
    public boolean draw_;
    public IGC gc_;
    public IGCDirect gd_;
    public float scale_;
    public int lx_;
    public int ly_;
    private static DI18N _i18n;
    private static ULocale _locale;
    private static NLString _nls;

    public boolean drawing() {
        return this.draw_;
    }

    public boolean locating() {
        return !this.draw_;
    }

    public DefaultChartRenderData(boolean _draw, IGC _gc, float _scale) {
        this.gc_ = _gc;
        this.gd_ = _gc.getIGCDirect();
        this.scale_ = _scale;
        this.draw_ = _draw;
        this.ly_ = -1;
        this.lx_ = -1;
        this.margin_ = Math.min(this.dpiX(10), this.dpiY(10));
        this.axis_title_to_unit_spacing = this.dpiX(5);
        this.axis_unit_to_dot_spacing = this.dpiX(2);
        this.axis_dot_size = this.dpiX(2);
        this.axis_unit_dot_size = this.dpiX(4);
        this.max_axis_dot_size = Math.max(this.axis_dot_size, this.axis_unit_dot_size);
    }

    public void setupMargin(DGraphic _graphic) {
        this.margin_ = _graphic.getProperties().get("P_MARGIN.DGraphic.core.jscrib", 10);
        this.margin_ = Math.min(this.dpiX(this.margin_), this.dpiY(this.margin_));
    }

    public void error(String _message, RenderPersistData rpd) {
        if (this.draw_) {
            IFont font = this.gc_.getFont();
            Font nf = new Font(font);
            nf.setFontStyle(font.getFontStyle() | 1);
            this.gc_.setFont(nf);
            this.gc_.setBrush(new SolidBrush(-16776961));
            this.gc_.drawText(_message, rpd.graphic_rect.getX() + 5, rpd.graphic_rect.getY() + 5 + 12);
            this.gc_.setFont(font);
        }
    }

    public int dpiX(int x) {
        return x;
    }

    public int dpiY(int y) {
        return y;
    }

    protected int getLineColor(DAxis axis) {
        IDColor c = (IDColor)axis.getProperties().get("P_LINE_COLOR.DAxis.core.jscrib");
        if (c != null) {
            return IGCDStyle.GetRGBA(c);
        }
        return -1061109505;
    }

    public void renderText(String _text, Rect _rect, int _align, IGCDStyle _style, String _locid, IDItem _item) throws DefaultRenderChartLocation {
        if (this.draw_) {
            this.gc_.setBrush(new SolidBrush(_style.getFore()));
            this.gc_.setFont(_style.getFont());
            DrawUtilIGC.drawText(this.gc_, _rect, _align, _text);
        } else {
            Rect nrtxt = DrawUtilIGC.boundingRect(this.gc_, _rect, _align, _text);
            nrtxt.intersection(_rect);
            if (nrtxt.w() > 0 && nrtxt.contains(this.lx_, this.ly_)) {
                throw new DefaultRenderChartLocation(_locid, _item, nrtxt, _text);
            }
        }
    }

    public static String getResourceString(String tag, DI18N i18n) {
        if (i18n != null) {
            if (i18n != _i18n) {
                _locale = new ULocale(i18n.getLanguage(), i18n.getCountry());
                _nls = i18n.getResourceBundle() != null ? new NLString(i18n.getResourceBundle(), _locale) : new NLString();
            }
            return _nls.getString(tag);
        }
        if (_nls == null) {
            _nls = new NLString();
        }
        return _nls.getString(tag);
    }

    public static String getAxisTitle(DAxis _axis) {
        if (_axis == null) {
            return null;
        }
        String text = _axis.getTitle();
        String unit = _axis.getUnit();
        if (_axis.getParent() instanceof DGraphic) {
            DGraphic graph = (DGraphic)_axis.getParent();
            DI18N child = (DI18N)graph.getChildOfClass(DI18N.class);
            text = DefaultChartRenderData.getResourceString(_axis.getTitle(), child);
            unit = DefaultChartRenderData.getResourceString(_axis.getUnit(), child);
        }
        if (!DrawUtilIGC.isEmpty(unit)) {
            text = text == null ? "(" + unit + ")" : String.valueOf(text) + " (" + unit + ")";
        }
        return text;
    }

    public Insets computeXAxisAmounts(DAxis _axis, IScale _scale, Rect _R, int _title_alignment, Insets _insets) {
        String title;
        if (_insets == null) {
            _insets = new Insets();
        }
        boolean have_title = !DrawUtilIGC.isEmpty(title = DefaultChartRenderData.getAxisTitle(_axis));
        Object step_unit = _axis.getProperties().get("P_STEP_UNIT.DAxis.core.jscrib");
        if (have_title && _axis.getProperties().get("P_SHOW_TITLE.DAxis.core.jscrib", have_title)) {
            _insets.addB(DrawUtilIGC.textExtent(this.gc_, title, _title_alignment).getH() + this.axis_title_to_unit_spacing);
        }
        IDAlignment align = _axis.getProperties().hasKey("P_LABEL_ALIGNMENT.DAxis.core.jscrib") ? (IDAlignment)_axis.getProperties().get("P_LABEL_ALIGNMENT.DAxis.core.jscrib") : new DAlignment(36);
        boolean rotate90 = align.haveOneOfAlignment(384);
        int vmin_text_width = 0;
        int value_text_max_width = 0;
        if (step_unit != null) {
            int max_text_h = 0;
            boolean first = true;
            Object vs = _scale.stepFirst(step_unit);
            while (vs != null) {
                String txt = _scale.valueText(vs);
                if (txt != null) {
                    int sh;
                    int txt_width;
                    ISize size = this.gc_.textExtent(txt);
                    int n = txt_width = rotate90 ? size.getH() : size.getW();
                    if (first) {
                        vmin_text_width = txt_width;
                        first = false;
                    }
                    if (txt_width > value_text_max_width) {
                        value_text_max_width = txt_width;
                    }
                    int n2 = sh = rotate90 ? size.getW() : size.getH();
                    if (sh > max_text_h) {
                        max_text_h = sh;
                    }
                }
                vs = _scale.stepNext(step_unit, vs);
            }
            _insets.addB(this.gc_.getFontMetrics().getHeight() + this.axis_unit_to_dot_spacing + this.max_axis_dot_size);
        } else if ((double)_axis.getProperties().get("P_STEP_DOT.DAxis.core.jscrib", -1) > 0.0) {
            _insets.addB(this.axis_dot_size);
        }
        if (step_unit != null) {
            _insets.addL(vmin_text_width / 2);
        }
        if (step_unit != null) {
            _insets.addR(value_text_max_width / 2);
        }
        return _insets;
    }

    public Insets computeYAxisAmounts(boolean vertical, boolean _left, DAxis _axis, IScale _scale, Rect _R, int _title_alignment, Insets _insets) {
        String title;
        boolean have_title;
        if (_insets == null) {
            _insets = new Insets();
        }
        Object step_unit = _axis.getProperties().get("P_STEP_UNIT.DAxis.core.jscrib");
        IDAlignment align = _axis.getProperties().hasKey("P_LABEL_ALIGNMENT.DAxis.core.jscrib") ? (IDAlignment)_axis.getProperties().get("P_LABEL_ALIGNMENT.DAxis.core.jscrib") : new DAlignment(36);
        boolean rotate90 = align.haveOneOfAlignment(384);
        int value_text_max_width = 0;
        int max_text_h = 0;
        if (step_unit != null) {
            boolean first = true;
            Object vs = _scale.stepFirst(step_unit);
            while (vs != null) {
                String txt = _scale.valueText(vs);
                if (txt != null) {
                    int sh;
                    int txt_width;
                    ISize size = this.gc_.textExtent(txt);
                    if (vertical) {
                        txt_width = rotate90 ? size.getH() : size.getW();
                    } else {
                        int n = txt_width = rotate90 ? size.getW() : size.getH();
                    }
                    if (first) {
                        first = false;
                    }
                    if (txt_width > value_text_max_width) {
                        value_text_max_width = txt_width;
                    }
                    if (vertical) {
                        sh = rotate90 ? size.getW() : size.getH();
                    } else {
                        int n = sh = rotate90 ? size.getH() : size.getW();
                    }
                    if (sh > max_text_h) {
                        max_text_h = sh;
                    }
                }
                vs = _scale.stepNext(step_unit, vs);
            }
        }
        boolean bl = have_title = !DrawUtilIGC.isEmpty(title = DefaultChartRenderData.getAxisTitle(_axis));
        if (have_title && _axis.getProperties().get("P_SHOW_TITLE.DAxis.core.jscrib", have_title)) {
            if (vertical) {
                _insets.addL(DrawUtilIGC.textExtent(this.gc_, title, _title_alignment).getW() + this.axis_title_to_unit_spacing);
            } else {
                _insets.addT(DrawUtilIGC.textExtent(this.gc_, title, _title_alignment).getH() + this.axis_title_to_unit_spacing);
            }
        }
        if (step_unit != null) {
            if (vertical) {
                _insets.addL(value_text_max_width + this.axis_unit_to_dot_spacing + this.max_axis_dot_size);
            } else {
                _insets.addT(value_text_max_width + this.axis_unit_to_dot_spacing + this.max_axis_dot_size);
            }
        } else if ((double)_axis.getProperties().get("P_STEP_DOT.DAxis.core.jscrib", -1) > 0.0) {
            if (vertical) {
                _insets.addL(this.axis_dot_size);
            } else {
                _insets.addT(this.axis_dot_size);
            }
        }
        if (vertical) {
            _insets.addB(max_text_h / 2);
        } else {
            _insets.addL(max_text_h / 2);
        }
        if (vertical) {
            _insets.addT(max_text_h / 2);
        } else {
            _insets.addR(max_text_h / 2);
        }
        if (!_left && vertical) {
            _insets.setR(_insets.getL());
            _insets.setL(0);
        }
        return _insets;
    }

    public void renderXAxis(boolean _for_draw, boolean vertical, DAxis _axis, IScale _scale, Rect _R, Insets _insets, IGCDStyle _style, int _title_alignment) throws DefaultRenderChartLocation {
        this.gc_.setFont(_style.getFont());
        this.gc_.setBrush(new SolidBrush(_style.getFore()));
        if (_for_draw) {
            if (this.draw_) {
                this.onXAxis(vertical, _R, _axis, _scale, "P_STEP_LINE.DAxis.core.jscrib", _style);
                this.onXAxis(vertical, _R, _axis, _scale, "P_STEP_UNIT.DAxis.core.jscrib", _style);
                this.onXAxis(vertical, _R, _axis, _scale, "P_STEP_DOT.DAxis.core.jscrib", _style);
                this.renderXAxisTitle(vertical, _axis, _R, _insets, _style, _title_alignment);
            }
        } else if (this.locating()) {
            this.renderXAxisTitle(vertical, _axis, _R, _insets, _style, _title_alignment);
            this.onXAxis(vertical, _R, _axis, _scale, "P_STEP_UNIT.DAxis.core.jscrib", _style);
            this.onXAxis(vertical, _R, _axis, _scale, "P_STEP_LINE.DAxis.core.jscrib", _style);
            this.onXAxis(vertical, _R, _axis, _scale, "P_STEP_DOT.DAxis.core.jscrib", _style);
            if (vertical) {
                int xl = _R.left();
                this.renderLine(xl, _R.top(), xl, _R.bottom(), "InAxisXLine", _axis);
            } else {
                this.renderLine(_R.left(), _R.bottom(), _R.right(), _R.bottom(), "InAxisXLine", _axis);
            }
        }
    }

    public void renderYAxis(boolean vertical, boolean _for_draw, boolean _left, DAxis _axis, IScale _scale, Rect _R, Insets _insets, IGCDStyle _style, int _title_alignment, int _3d_line_x, int _3D_line_y) throws DefaultRenderChartLocation {
        this.gc_.setFont(_style.getFont());
        this.gc_.setBrush(new SolidBrush(_style.getFore()));
        if (_for_draw) {
            if (this.drawing()) {
                this.onYAxis(vertical, _left, _R, _axis, _scale, "P_STEP_LINE.DAxis.core.jscrib", _style, _3d_line_x, _3D_line_y);
                this.onYAxis(vertical, _left, _R, _axis, _scale, "P_STEP_UNIT.DAxis.core.jscrib", _style, _3d_line_x, _3D_line_y);
                this.onYAxis(vertical, _left, _R, _axis, _scale, "P_STEP_DOT.DAxis.core.jscrib", _style, _3d_line_x, _3D_line_y);
                this.renderYAxisTitle(vertical, _left, _axis, _R, _insets, _style, _title_alignment);
            }
        } else if (this.locating()) {
            this.renderYAxisTitle(vertical, _left, _axis, _R, _insets, _style, _title_alignment);
            this.onYAxis(vertical, _left, _R, _axis, _scale, "P_STEP_DOT.DAxis.core.jscrib", _style, _3d_line_x, _3D_line_y);
            this.onYAxis(vertical, _left, _R, _axis, _scale, "P_STEP_UNIT.DAxis.core.jscrib", _style, _3d_line_x, _3D_line_y);
            this.onYAxis(vertical, _left, _R, _axis, _scale, "P_STEP_LINE.DAxis.core.jscrib", _style, _3d_line_x, _3D_line_y);
            if (vertical) {
                int xl = _left ? _R.left() : _R.right();
                this.renderLine(xl, _R.top(), xl, _R.bottom(), "InAxisYLine", _axis);
            } else {
                this.renderLine(_R.left(), _R.bottom(), _R.right(), _R.bottom(), "InAxisYLine", _axis);
            }
        }
    }

    protected void renderXAxisTitle(boolean vertical, DAxis _axis, Rect _R, Insets _insets, IGCDStyle _style, int _title_alignment) throws DefaultRenderChartLocation {
        if (!_axis.getProperties().get("P_SHOW_TITLE.DAxis.core.jscrib", true)) {
            return;
        }
        String title = DefaultChartRenderData.getAxisTitle(_axis);
        if (DrawUtilIGC.isEmpty(title)) {
            return;
        }
        this.gc_.setFont(_style.getFont());
        if (vertical) {
            ISize size = DrawUtilIGC.textExtent(this.gc_, title, _title_alignment);
            Rect r_ttl = new Rect();
            int sw = size.getW();
            r_ttl.setRect(_R.x() - _insets.getL(), _R.top(), sw, _R.h());
            String txt = DrawUtilIGC.truncateText(this.gc_, title, r_ttl.w(), r_ttl.h(), _title_alignment);
            this.renderText(txt, r_ttl, _title_alignment, _style, "InAxisXTitle", _axis);
        } else {
            int th = DrawUtilIGC.textExtent(this.gc_, title, _title_alignment).getH();
            Rect r_ttl = new Rect(_R.x(), _R.bottom() + _insets.getB() - th, _R.w(), th);
            String txt = DrawUtilIGC.truncateText(this.gc_, title, r_ttl.w(), r_ttl.h(), _title_alignment);
            this.renderText(txt, r_ttl, _title_alignment, _style, "InAxisXTitle", _axis);
        }
    }

    protected void renderYAxisTitle(boolean vertical, boolean _left, DAxis _axis, Rect _R, Insets _insets, IGCDStyle _style, int _title_alignment) throws DefaultRenderChartLocation {
        if (!_axis.getProperties().get("P_SHOW_TITLE.DAxis.core.jscrib", true)) {
            return;
        }
        String title = DefaultChartRenderData.getAxisTitle(_axis);
        if (DrawUtilIGC.isEmpty(title)) {
            return;
        }
        this.gc_.setFont(_style.getFont());
        this.gc_.setBrush(new SolidBrush(_style.getFore()));
        if (vertical) {
            ISize size = DrawUtilIGC.textExtent(this.gc_, title, _title_alignment);
            Rect r_ttl = new Rect();
            int sw = size.getW();
            if (_left) {
                r_ttl.setRect(_R.x() - _insets.getL(), _R.top(), sw, _R.h());
            } else {
                r_ttl.setRect(_R.right() + _insets.getR() - sw, _R.top(), sw, _R.h());
            }
            String txt = DrawUtilIGC.truncateText(this.gc_, title, r_ttl.w(), r_ttl.h(), _title_alignment);
            this.renderText(txt, r_ttl, _title_alignment, _style, "InAxisYTitle", _axis);
        } else {
            int th = DrawUtilIGC.textExtent(this.gc_, title, _title_alignment).getH();
            Rect r_ttl = new Rect(_R.x(), _R.top() - _insets.getT() - th, _R.w(), th);
            String txt = DrawUtilIGC.truncateText(this.gc_, title, r_ttl.w(), r_ttl.h(), _title_alignment);
            this.renderText(txt, r_ttl, _title_alignment, _style, "InAxisYTitle", _axis);
        }
    }

    public static IScale getScale(DAxis _axis, double scale_min, double scale_max, Object vmin, Object vmax) {
        if (_axis == null) {
            return null;
        }
        ULocale locale = null;
        if (_axis.getParent() instanceof DGraphic) {
            DGraphic graph = (DGraphic)_axis.getParent();
            locale = graph.getLocale();
        }
        DPropertyStore prop = _axis.getProperties();
        IScale scale = null;
        Class data_class = (Class)prop.get("P_DATA_CLASS.DAxis.core.jscrib");
        IScaleProvider sp = (IScaleProvider)prop.get("P_DATA_SCALE_PROVIDER.DAxis.core.jscrib");
        if (sp != null) {
            scale = sp.newScaleFor(data_class == null ? Double.class : data_class);
            scale.setScaleRange(scale_min, scale_max);
            scale.setValueRange(vmin, vmax);
        }
        if (scale == null) {
            if (data_class == Date.class) {
                scale = new LinearDateScale(scale_min, scale_max, vmin, vmax);
            } else {
                List categories = _axis.getChildrenOfClass(DCategory.class);
                if (categories.size() > 0) {
                    scale = new CategoryScale(categories);
                } else if (_axis.useNumbers()) {
                    scale = _axis.isScaleType("S_LOG.DAxis.core.jscrib") ? new LogNumberScale(scale_min, scale_max, vmin, vmax) : new LinearNumberScale(scale_min, scale_max, vmin, vmax);
                }
            }
        }
        if (scale == null) {
            scale = new LinearNumberScale(0.0, 0.0, 0.0, 0.0);
        }
        scale.setLocale(locale);
        try {
            UFormat format = (UFormat)prop.get("P_UNIT_FORMAT.DAxis.core.jscrib");
            scale.setTextFormat(format);
        }
        catch (ClassCastException classCastException) {}
        return scale;
    }

    public static Object getNewInstanceValue(DAxis _axis) {
        if (_axis == null) {
            return null;
        }
        DPropertyStore prop = _axis.getProperties();
        if (prop == null) {
            return new VDouble();
        }
        Class c = (Class)prop.get("P_DATA_CLASS.DAxis.core.jscrib");
        if (c == null || c == Double.class) {
            return new VDouble();
        }
        try {
            Object i = c.newInstance();
            return i;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    protected void onXAxis(boolean vertical, Rect _R, DAxis _axis, IScale _scale, String _property, IGCDStyle _style) throws DefaultRenderChartLocation {
        int v_prop;
        IPen save_pen;
        int yd;
        IDAlignment align;
        Object step;
        block29: {
            block30: {
                if (!_scale.isValid()) {
                    return;
                }
                if (!_axis.getProperties().hasKey(_property)) {
                    return;
                }
                step = _axis.getProperties().get(_property);
                if (step == null) {
                    return;
                }
                align = _axis.getProperties().hasKey("P_LABEL_ALIGNMENT.DAxis.core.jscrib") ? (IDAlignment)_axis.getProperties().get("P_LABEL_ALIGNMENT.DAxis.core.jscrib") : new DAlignment(36);
                yd = vertical ? _R.left() : _R.bottom();
                save_pen = null;
                v_prop = 0;
                if ("P_STEP_UNIT.DAxis.core.jscrib".equals(_property)) {
                    v_prop = 1;
                    break block29;
                }
                if ("P_STEP_DOT.DAxis.core.jscrib".equals(_property)) {
                    v_prop = 2;
                    break block29;
                }
                if ("P_STEP_LINE.DAxis.core.jscrib".equals(_property)) {
                    v_prop = 3;
                    if (this.draw_) {
                        save_pen = this.gc_.getPen();
                        this.gc_.setPen(new LineStylePen(this.getLineColor(_axis)));
                    }
                    break block29;
                }
                if (save_pen == null) break block30;
                this.gc_.setPen(save_pen);
            }
            return;
        }
        try {
            Rect r_txt = new Rect();
            int x_free_for_text = -1;
            int h_text_spacing = this.dpiX(5);
            boolean reversed = _scale.isReversed();
            Object vs = _scale.stepFirst(step);
            while (vs != null) {
                int xd = (int)_scale.toScale(vs);
                switch (v_prop) {
                    case 1: {
                        int x_text;
                        int size_h;
                        int size_w;
                        String t = _scale.valueText(vs);
                        if (t == null) break;
                        ISize size = this.gc_.textExtent(t);
                        if (align.haveOneOfAlignment(384)) {
                            size_w = size.getH();
                            size_h = size.getW();
                        } else {
                            size_w = size.getW();
                            size_h = size.getH();
                        }
                        int wt = size_w;
                        int n = x_text = vertical ? xd + size_h / 2 : xd - size_w / 2;
                        if (!(!reversed && x_text >= x_free_for_text || reversed && x_text + size_w <= x_free_for_text) && x_free_for_text != -1) break;
                        if (vertical) {
                            r_txt.setRect(yd - this.max_axis_dot_size - this.axis_unit_to_dot_spacing - wt, x_text, size_w, size_h);
                        } else {
                            r_txt.setRect(x_text, yd + this.max_axis_dot_size + this.axis_unit_to_dot_spacing, size_w, size_h);
                        }
                        if (this.draw_) {
                            DrawUtilIGC.drawText(this.gc_, r_txt, align.getAlignment(), t);
                        } else if (r_txt.contains(this.lx_, this.ly_)) {
                            throw new DefaultRenderChartLocation("InAxisXStepUnitText", _axis, r_txt, t);
                        }
                        if (vertical) {
                            this.renderLine(yd, xd, yd + this.axis_unit_dot_size, xd, "InAxisXStepUnitTextDot", _axis);
                        } else {
                            this.renderLine(xd, yd, xd, yd + this.axis_unit_dot_size, "InAxisXStepUnitTextDot", _axis);
                        }
                        x_free_for_text = x_text + (reversed ? -h_text_spacing : size_w + h_text_spacing);
                        break;
                    }
                    case 2: {
                        if (vertical) {
                            this.renderLine(yd, xd, yd + this.axis_unit_dot_size, xd, "InAxisXStepUnitTextDot", _axis);
                            break;
                        }
                        this.renderLine(xd, yd, xd, yd + this.axis_dot_size, "InAxisXStepDot", _axis);
                        break;
                    }
                    case 3: {
                        if (vertical) {
                            this.renderLine(yd, _R.top() - xd, _R.right(), _R.top() - xd, "InAxisXStepLine", _axis);
                            break;
                        }
                        this.renderLine(xd, _R.top(), xd, _R.bottom(), "InAxisXStepLine", _axis);
                    }
                }
                vs = _scale.stepNext(step, vs);
            }
        }
        catch (Throwable throwable) {
            if (save_pen != null) {
                this.gc_.setPen(save_pen);
            }
            throw throwable;
        }
        if (save_pen != null) {
            this.gc_.setPen(save_pen);
        }
    }

    private void renderLine(int x1, int y1, int x2, int y2, String loc_id, IDItem loc_item) throws DefaultRenderChartLocation {
        if (this.draw_) {
            this.gc_.drawLine(x1, y1, x2, y2);
        } else if (DrawUtilIGC.segmentContains(x1, y1, x2, y2, this.lx_, this.ly_)) {
            Rect r = new Rect(x1, y1, x2 - x1, y2 - y1);
            r.normalize();
            throw new DefaultRenderChartLocation(loc_id, loc_item, r);
        }
    }

    protected void onYAxis(boolean vertical, boolean _left, Rect _R, DAxis _axis, IScale _scale, String _property, IGCDStyle _style, int _3d_line_x, int _3d_line_y) throws DefaultRenderChartLocation {
        int v_prop;
        IPen save_pen;
        int xd;
        IDAlignment align;
        Object step;
        block36: {
            block37: {
                if (!_scale.isValid()) {
                    return;
                }
                if (!_axis.getProperties().hasKey(_property)) {
                    return;
                }
                step = _axis.getProperties().get(_property);
                if (step == null) {
                    return;
                }
                align = _axis.getProperties().hasKey("P_LABEL_ALIGNMENT.DAxis.core.jscrib") ? (IDAlignment)_axis.getProperties().get("P_LABEL_ALIGNMENT.DAxis.core.jscrib") : new DAlignment(36);
                xd = vertical ? (_left ? _R.left() : _R.right()) : _R.top();
                save_pen = null;
                v_prop = 0;
                if ("P_STEP_UNIT.DAxis.core.jscrib".equals(_property)) {
                    v_prop = 1;
                    break block36;
                }
                if ("P_STEP_DOT.DAxis.core.jscrib".equals(_property)) {
                    v_prop = 2;
                    break block36;
                }
                if ("P_STEP_LINE.DAxis.core.jscrib".equals(_property)) {
                    v_prop = 3;
                    if (this.draw_) {
                        save_pen = this.gc_.getPen();
                        this.gc_.setPen(new LineStylePen(this.getLineColor(_axis)));
                    }
                    break block36;
                }
                if (save_pen == null) break block37;
                this.gc_.setPen(save_pen);
            }
            return;
        }
        try {
            int y_free_for_text = -1;
            int v_text_spacing = this.dpiY(0);
            Rect r_txt = v_prop == 1 ? new Rect() : null;
            Object vs = _scale.stepFirst(step);
            while (vs != null) {
                int yd = (int)_scale.toScale(vs);
                switch (v_prop) {
                    case 1: {
                        boolean text_bounds;
                        int y_text;
                        int size_h;
                        int size_w;
                        String t = _scale.valueText(vs);
                        if (t == null) break;
                        ISize size = this.gc_.textExtent(t);
                        if (align.haveOneOfAlignment(384)) {
                            size_w = size.getH();
                            size_h = size.getW();
                        } else {
                            size_w = size.getW();
                            size_h = size.getH();
                        }
                        int wt = size_w;
                        int n = y_text = vertical ? yd - size_h / 2 : yd - size_w / 2;
                        boolean bl = vertical ? y_text + size_h <= y_free_for_text : (text_bounds = y_text + size_w >= y_free_for_text);
                        if (!text_bounds && y_free_for_text != -1) break;
                        if (vertical) {
                            if (_left) {
                                r_txt.setRect(xd - this.max_axis_dot_size - this.axis_unit_to_dot_spacing - wt, y_text, wt, size_h);
                            } else {
                                r_txt.setRect(xd + this.max_axis_dot_size + this.axis_unit_to_dot_spacing, y_text, wt, size_h);
                            }
                        } else {
                            r_txt.setRect(y_text, xd - this.axis_unit_dot_size - this.max_axis_dot_size - size_h, wt, size_h);
                        }
                        if (vertical) {
                            if (_left) {
                                this.renderLine(xd - this.axis_unit_dot_size, yd, xd, yd, "InAxisYStepUnitTextDot", _axis);
                            } else {
                                this.renderLine(xd, yd, xd + this.axis_unit_dot_size, yd, "InAxisYStepUnitTextDot", _axis);
                            }
                        } else {
                            this.renderLine(yd, xd - this.axis_unit_dot_size, yd, xd, "InAxisYStepUnitTextDot", _axis);
                        }
                        if (this.draw_) {
                            DrawUtilIGC.drawText(this.gc_, r_txt, align.getAlignment(), t);
                        } else if (r_txt.contains(this.lx_, this.ly_)) {
                            throw new DefaultRenderChartLocation("InAxisYStepUnitText", _axis, r_txt, t);
                        }
                        y_free_for_text = vertical ? y_text - v_text_spacing : y_text - v_text_spacing;
                        break;
                    }
                    case 2: {
                        if (vertical) {
                            if (_left) {
                                this.renderLine(xd - this.axis_dot_size, yd, xd, yd, "InAxisYStepDot", _axis);
                                break;
                            }
                            this.renderLine(xd, yd, xd + this.axis_dot_size, yd, "InAxisYStepDot", _axis);
                            break;
                        }
                        this.renderLine(yd, xd - this.axis_dot_size, yd, xd, "InAxisYStepDot", _axis);
                        break;
                    }
                    case 3: {
                        if (vertical) {
                            if (_left && _3d_line_x != 0 && _3d_line_y != 0) {
                                int y3d = yd - _3d_line_y;
                                int x3d = _R.left() + _3d_line_x;
                                this.renderLine(_R.left(), yd, x3d, y3d, "InAxisYStepLine", _axis);
                                this.renderLine(x3d, y3d, _R.right() + _3d_line_x, y3d, "InAxisYStepLine", _axis);
                                break;
                            }
                            this.renderLine(_R.left(), yd, _R.right(), yd, "InAxisYStepLine", _axis);
                            break;
                        }
                        if (_3d_line_x != 0 && _3d_line_y != 0) {
                            int y3d = yd + _3d_line_x;
                            int x3d = _R.top() + _3d_line_y;
                            this.renderLine(yd, _R.top(), y3d, x3d, "InAxisYStepLine", _axis);
                            this.renderLine(y3d, x3d, y3d, _R.bottom() + _3d_line_y, "InAxisYStepLine", _axis);
                            break;
                        }
                        this.renderLine(yd, _R.top(), yd, _R.bottom(), "InAxisYStepLine", _axis);
                    }
                }
                vs = _scale.stepNext(step, vs);
            }
        }
        catch (Throwable throwable) {
            if (save_pen != null) {
                this.gc_.setPen(save_pen);
            }
            throw throwable;
        }
        if (save_pen != null) {
            this.gc_.setPen(save_pen);
        }
    }

    static boolean horizontal3DContains(int _lx, int _ly, int _w, int _3d, int _px, int _py) {
        if (_py < _ly - _3d) {
            return false;
        }
        if (_py > _ly) {
            return false;
        }
        if (_py == _ly) {
            return _px >= _lx && _px <= _lx + _w;
        }
        if (_py == _ly - _3d) {
            return _px >= _lx + _3d && _px <= _lx + _w + _3d;
        }
        int dx = _ly - _py;
        return _px >= _lx + dx && _px <= _lx + dx + _w;
    }

    static boolean vertical3DContains(int _lx, int _ly, int _h, int _3d, int _px, int _py) {
        if (_px < _lx) {
            return false;
        }
        if (_px > _lx + _3d) {
            return false;
        }
        if (_px == _lx) {
            return _py >= _ly && _py <= _ly + _h;
        }
        int dy = _px - _lx;
        int npy = _py + dy;
        return npy >= _ly && npy <= _ly + _h;
    }

    public void renderBar(boolean vertical, Rect r, int _back_rgba, IDItem _item, int _3d_z) throws DefaultRenderChartLocation {
        if (this.draw_) {
            this.gc_.setPen(new LineStylePen(255));
            this.gc_.setBrush(new SolidBrush(_back_rgba));
            this.gc_.fillRect(r);
            this.gc_.drawRect(r);
        } else if (r.contains(this.lx_, this.ly_)) {
            throw new DefaultRenderChartLocation("CurveBar", _item, r);
        }
        if (_3d_z != 0) {
            int[] ar1 = new int[8];
            int[] ar2 = new int[8];
            if (vertical) {
                ar1[0] = r.left();
                ar1[1] = r.top();
                ar1[2] = r.left() + _3d_z;
                ar1[3] = r.top() - _3d_z;
                ar1[4] = r.right() + _3d_z;
                ar1[5] = r.top() - _3d_z;
                ar1[6] = r.right();
                ar1[7] = r.top();
                ar2[0] = r.right();
                ar2[1] = r.top();
                ar2[2] = ar1[4];
                ar2[3] = ar1[5];
                ar2[4] = r.right() + _3d_z;
                ar2[5] = r.bottom() - _3d_z;
                ar2[6] = r.right();
                ar2[7] = r.bottom();
            } else {
                ar1[0] = r.right();
                ar1[1] = r.top();
                ar1[2] = r.right() + _3d_z;
                ar1[3] = r.top() + _3d_z;
                ar1[4] = r.right() + _3d_z;
                ar1[5] = r.bottom() + _3d_z;
                ar1[6] = r.right();
                ar1[7] = r.bottom();
                ar2[0] = r.right();
                ar2[1] = r.bottom();
                ar2[2] = ar1[4];
                ar2[3] = ar1[5];
                ar2[4] = r.left() + _3d_z;
                ar2[5] = r.bottom() + _3d_z;
                ar2[6] = r.left();
                ar2[7] = r.bottom();
            }
            if (this.draw_) {
                int dark2;
                int dark1;
                if (vertical) {
                    dark1 = RGBA.Darker(_back_rgba, 0.4f);
                    dark2 = RGBA.Darker(_back_rgba, 0.3f);
                } else {
                    dark1 = RGBA.Lighter(_back_rgba, 0.15f);
                    dark2 = RGBA.Darker(_back_rgba, 0.4f);
                }
                SolidBrush b = new SolidBrush(dark1);
                this.gc_.setBrush(b);
                Polygon poly = new Polygon(ar1);
                this.gc_.fillPoly(poly);
                this.gc_.drawPoly(poly);
                b.setRGBA(dark2);
                this.gc_.setBrush(b);
                poly.setPoints(ar2);
                this.gc_.fillPoly(poly);
                this.gc_.drawPoly(poly);
            } else {
                boolean in_ar2;
                boolean in_ar1;
                if (vertical) {
                    in_ar1 = DefaultChartRenderData.horizontal3DContains(r.x(), r.y(), r.w(), _3d_z, this.lx_, this.ly_);
                    in_ar2 = DefaultChartRenderData.vertical3DContains(r.right(), r.y(), r.h(), _3d_z, this.lx_, this.ly_);
                } else {
                    in_ar1 = DefaultChartRenderData.horizontal3DContains(r.left(), r.top() + r.h() + _3d_z, r.w(), _3d_z, this.lx_, this.ly_);
                    in_ar2 = DefaultChartRenderData.vertical3DContains(r.right(), r.top() + _3d_z, r.h(), _3d_z, this.lx_, this.ly_);
                }
                if (in_ar1) {
                    Rect br = vertical ? new Rect(r.x(), r.y() - _3d_z, r.w() + _3d_z, _3d_z) : new Rect(r.left(), r.top() + r.h(), r.w(), _3d_z);
                    throw new DefaultRenderChartLocation("CurveBar", _item, br);
                }
                if (in_ar2) {
                    Rect br = vertical ? new Rect(r.right(), r.y() - _3d_z, _3d_z, r.h() + _3d_z) : new Rect(r.right(), r.top(), r.h(), _3d_z);
                    throw new DefaultRenderChartLocation("CurveBar", _item, br);
                }
            }
        }
    }

    public void renderSectorText(double _angle, double _ray, Rect _rc, String _txt, IDItem _item, IGCDStyle _style, String _located) throws DefaultRenderChartLocation {
        double arad = Radian.normalize(_angle);
        int tx = (int)((double)(_rc.x() + (_rc.w() >> 1)) + _ray * Math.cos(_angle));
        int ty = (int)((double)(_rc.y() + (_rc.h() >> 1)) - _ray * Math.sin(_angle));
        this.gc_.setFont(_style.getFont());
        ISize size = this.gc_.textExtent(_txt);
        int tw = size.getW();
        int th = size.getH();
        int deg = Radian.iR2D(arad);
        if (deg == 0) {
            ty -= th / 2;
        } else if (deg < 90) {
            ty -= th;
        } else if (deg == 90) {
            tx -= tw / 2;
            ty -= th;
        } else if (deg < 180) {
            tx -= tw;
            ty -= th;
        } else if (deg == 180) {
            tx -= tw;
            ty -= th / 2;
        } else if (deg < 270) {
            tx -= tw;
        } else if (deg == 270) {
            tx -= tw / 2;
        }
        Rect rtxt = new Rect(tx, ty, tw, th);
        this.renderText(_txt, rtxt, 17, _style, _located, _item);
    }

    public void renderMarkerLine(boolean axis_vertical, boolean for_draw, DAxis axis, Rect area, IScale scale) throws DefaultRenderChartLocation {
        List l = axis.getChildrenOfClass(DMarkerLine.class);
        for (DMarkerLine ml : l) {
            Rect dr;
            int y2;
            int y = (int)scale.toScale(ml.getValue());
            int x1 = axis_vertical ? area.left() : y;
            int x2 = axis_vertical ? area.right() : y;
            int y1 = axis_vertical ? y : area.top();
            int n = y2 = axis_vertical ? y : area.bottom();
            if (for_draw) {
                if (!this.drawing()) continue;
                IDColor c = ml.getColor();
                LineStylePen newPen = c != null ? new LineStylePen(RGBA.Get(c.getRed(), c.getGreen(), c.getBlue())) : new LineStylePen(255);
                if (ml.getThickness() > 0.0) {
                    newPen.setLineWidth((int)ml.getThickness());
                }
                IPen oldpen = this.gc_.setPen(newPen);
                this.gc_.drawLine(x1, y1, x2, y2);
                this.gc_.setPen(oldpen);
                continue;
            }
            if (!this.locating() || !(dr = new Rect(x1, y1 - 3, x2 - x1, 6)).contains(this.lx_, this.ly_)) continue;
            throw new DefaultRenderChartLocation("MarkerLine", ml, dr);
        }
    }
}

