/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.internal;

import org.eclipse.tptp.platform.report.chart.internal.CurveStyle;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderData;
import org.eclipse.tptp.platform.report.chart.internal.DefaultRenderChartLocation;
import org.eclipse.tptp.platform.report.chart.internal.IScale;
import org.eclipse.tptp.platform.report.chart.internal.RenderPersistData;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.IDCoord;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.igc.internal.IPen;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.Radian;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.SolidBrush;

public class DefaultChartRenderMeter {
    public static void render(DefaultChartRenderData d, RenderPersistData rpd) throws DefaultRenderChartLocation {
        String txt;
        IScale scale;
        DGraphic gph = rpd.graphic;
        DAxis axis = null;
        IDItem item = gph.getFirstChild();
        while (item != null) {
            if (item instanceof DAxis) {
                axis = (DAxis)item;
                break;
            }
            item = item.getNext();
        }
        if (axis == null) {
            d.error("Error: missing axis", rpd);
            return;
        }
        Object vmax = axis.getProperties().get("P_MAX.DAxis.core.jscrib");
        Object vmin = axis.getProperties().get("P_MIN.DAxis.core.jscrib");
        if (vmax == null) {
            vmax = axis.getProperties().get("P_MAX_HINT.DAxis.core.jscrib");
        }
        if (vmin == null) {
            vmin = axis.getProperties().get("P_MIN_HINT.DAxis.core.jscrib");
        }
        if (vmin == null || vmax == null) {
            if (axis.useNumbers()) {
                vmin = new Double(0.0);
                vmax = new Double(100.0);
            } else {
                d.error("Error: axis min/max must be set", rpd);
                return;
            }
        }
        if (!(scale = DefaultChartRenderData.getScale(axis, Math.PI, 0.0, vmin, vmax)).isValid()) {
            d.error("Error: invalid scale", rpd);
            return;
        }
        int rg_w = rpd.ag_rect.w();
        int rg_h = rpd.ag_rect.h();
        int center_x = rpd.ag_rect.centerX();
        int center_y = rpd.ag_rect.centerY();
        int out_radius = Math.min(rg_w, rg_h) / 2;
        if (d.drawing()) {
            IPen old = d.gc_.setPen(new LineStylePen(255, 0, 3));
            d.gc_.drawCircle(center_x, center_y, out_radius);
            d.gc_.setPen(old);
        }
        out_radius -= d.dpiX(3);
        double al = 0.0;
        double ar = 0.0;
        if (d.locating()) {
            int dx = d.lx_ - center_x;
            int dy = d.ly_ - center_y;
            al = Radian.normalize(Math.atan2(-dy, dx));
            ar = Math.sqrt(dx * dx + dy * dy);
        }
        DefaultRenderChartLocation loc_region = null;
        IGCDStyle style = new IGCDStyle(axis, d.scale_);
        d.gc_.setFont(style.getFont());
        int unit_radius = DefaultChartRenderMeter.estimateUnitRadius(d, axis, scale, center_x, center_y, out_radius);
        if (unit_radius < (int)(0.65 * (double)out_radius)) {
            unit_radius = -1;
        }
        int ray = out_radius;
        if (unit_radius > 0) {
            ray = unit_radius - d.dpiX(3);
        }
        int diam = 2 * ray;
        Object v_curr = null;
        double arad_last = Math.PI;
        SolidBrush brush = new SolidBrush(-1);
        int icrv = 1;
        while (icrv < rpd.curve_styles.length) {
            CurveStyle ccurve = rpd.curve_styles[icrv];
            DPoint point = null;
            IDItem item2 = ccurve.curve_.getFirstChild();
            while (item2 != null) {
                IDCoord c;
                IDItem itc;
                if (item2 instanceof DPoint && (itc = (point = (DPoint)item2).getFirstChild()) instanceof IDCoord && (c = (IDCoord)((Object)itc)).getAxis() == axis) {
                    v_curr = c.getValue(v_curr);
                    break;
                }
                item2 = item2.getNext();
            }
            if (v_curr != null) {
                double a = scale.toScale(v_curr);
                if (d.drawing()) {
                    brush.setRGBA(IGCDStyle.GetBackColor(ccurve.curve_));
                    d.gc_.setBrush(brush);
                    double da = arad_last - a;
                    d.gc_.fillArc(center_x, center_y, 0.0, ray, ray, a, da);
                } else if (ar <= (double)ray && arad_last >= al && al >= a) {
                    loc_region = new DefaultRenderChartLocation("CurveSector", point, null);
                }
                arad_last = a;
            }
            ++icrv;
        }
        Object step = axis.getProperties().get("P_STEP_LINE.DAxis.core.jscrib");
        if (d.drawing() && step != null) {
            IPen old = d.gc_.setPen(new LineStylePen(d.getLineColor(axis)));
            int lsize = Math.min(10, ray / 4);
            if (lsize > 2) {
                int r0 = ray - d.dpiX(lsize);
                Object vs = scale.stepFirst(step);
                while (vs != null) {
                    double a = -Math.PI + scale.toScale(vs);
                    double cs = Math.cos(a);
                    double sn = Math.sin(a);
                    int x0 = center_x + (int)((double)r0 * cs);
                    int y0 = center_y + (int)((double)r0 * sn);
                    int x1 = center_x + (int)((double)ray * cs);
                    int y1 = center_y + (int)((double)ray * sn);
                    d.gc_.drawLine(x0, y0, x1, y1);
                    vs = scale.stepNext(step, vs);
                }
            }
            d.gc_.setPen(old);
        }
        if (unit_radius > 0 && (step = axis.getProperties().get("P_STEP_UNIT.DAxis.core.jscrib")) != null) {
            Object vs = scale.stepFirst(step);
            while (vs != null) {
                double a = scale.toScale(vs);
                txt = scale.valueText(vs);
                d.renderSectorText(a, unit_radius, rpd.ag_rect, txt, axis, style, "InAxisXUnit");
                vs = scale.stepNext(step, vs);
            }
        }
        int needle_axis_radius = d.dpiX(Math.min(Math.max(diam / 40, 3), 10));
        int v_margin = d.dpiY(Math.min(5, Math.max(out_radius / 20, 1)));
        int shift_axis_title = center_y + v_margin + needle_axis_radius;
        if (axis.getTitle() != null) {
            int dy;
            int dx;
            double r;
            txt = axis.getTitle();
            d.gc_.setFont(style.getFont());
            ISize size = d.gc_.textExtent(txt);
            Rect rect = new Rect(0, 0, size.getW(), size.getH());
            rect.moveCenter(center_x, shift_axis_title += size.getH() / 2);
            boolean place_title = true;
            if (rect.bottom() > center_y + out_radius) {
                place_title = false;
            }
            if (place_title && (r = Math.sqrt((dx = rect.w() / 2) * dx + (dy = rect.bottom() - center_y) * dy)) >= (double)out_radius) {
                place_title = false;
            }
            if (place_title) {
                shift_axis_title += rect.h();
                d.renderText(txt, rect, 36, style, "InAxisXTitle", axis);
            }
        }
        CurveStyle cneedle = rpd.curve_styles[0];
        boolean main_needle = true;
        int needle_margin = Math.min(5, Math.max(ray / 20, 2));
        int needle_radius = ray - needle_margin;
        LineStylePen pen = new LineStylePen(255);
        IDItem itp = cneedle.curve_.getFirstChild();
        while (itp != null) {
            if (itp instanceof DPoint) {
                Object value = null;
                DPoint point = (DPoint)itp;
                IDItem pc = point.getFirstChild();
                while (pc != null) {
                    IDCoord c;
                    if (pc instanceof IDCoord && (c = (IDCoord)((Object)pc)).getAxis() == axis) {
                        value = c.getValue(value);
                    }
                    pc = pc.getNext();
                }
                if (value != null) {
                    double a = scale.toScale(value);
                    int x = (int)((double)center_x + (double)needle_radius * Math.cos(a));
                    int y = (int)((double)center_y - (double)needle_radius * Math.sin(a));
                    IGCDStyle sty = new IGCDStyle(point, d.scale_);
                    if (d.drawing()) {
                        pen.setRGBA(sty.getFore());
                        pen.setLineWidth(3);
                        IPen old = d.gc_.setPen(pen);
                        d.gc_.drawLine(center_x, center_y, x, y);
                        d.gc_.setPen(old);
                    } else {
                        double da = Math.abs(al - a);
                        if (da < 0.031415926535897934 && ar <= (double)ray) {
                            throw new DefaultRenderChartLocation("CurvePoint", point, null);
                        }
                    }
                    if (main_needle) {
                        String txt2 = scale.valueText(value);
                        d.gc_.setFont(sty.getFont());
                        ISize size = d.gc_.textExtent(txt2);
                        Rect rect = new Rect(0, 0, Math.max(size.getW(), out_radius), size.getH());
                        rect.moveCenter(center_x, shift_axis_title + v_margin);
                        boolean render_value = true;
                        if (rect.bottom() >= center_y + out_radius) {
                            render_value = false;
                        } else {
                            int dy;
                            int dx = rect.w() / 2;
                            double r = Math.sqrt(dx * dx + (dy = rect.bottom() - center_y) * dy);
                            if (r >= (double)out_radius) {
                                int w = 2 * (int)Math.sqrt(Math.abs(out_radius * out_radius - dy * dy));
                                if (w <= size.getW()) {
                                    render_value = false;
                                } else {
                                    rect.setWidth(w);
                                    rect.moveCenter(center_x, shift_axis_title + v_margin);
                                }
                            }
                        }
                        if (render_value) {
                            if (d.drawing()) {
                                pen.setRGBA(sty.getFore());
                                pen.setLineWidth(0);
                                d.gc_.setPen(pen);
                                d.gc_.setBrush(new SolidBrush(sty.getBack()));
                                d.gc_.fillRect(rect.x(), rect.y(), rect.w(), rect.h());
                                d.gc_.drawRect(rect.x(), rect.y(), rect.w(), rect.h());
                                d.gc_.setBrush(new SolidBrush(sty.getFore()));
                                d.renderText(txt2, rect, 36, sty, "CurvePoint", point);
                            } else if (rect.contains(d.lx_, d.ly_)) {
                                throw new DefaultRenderChartLocation("CurvePoint", point, rect);
                            }
                        }
                    }
                }
                main_needle = false;
            }
            itp = itp.getNext();
        }
        if (d.drawing()) {
            d.gc_.setBrush(new SolidBrush(rpd.g_style.getBack()));
            d.gc_.setPen(new LineStylePen(style.getFore()));
            int ry = needle_axis_radius;
            d.gc_.fillCircle(center_x, center_y, ry);
            d.gc_.drawCircle(center_x, center_y, ry);
            ry = Math.min(d.dpiX(2), needle_axis_radius / 2);
            if (ry == 1) {
                d.gc_.drawPoint(center_x, center_y);
            } else {
                int cfr_ignored_0 = ry + ry;
                d.gc_.setBrush(new SolidBrush(style.getFore()));
                d.gc_.fillCircle(center_x, center_y, ry);
            }
        }
        if (loc_region != null) {
            throw loc_region;
        }
    }

    private static int estimateUnitRadius(DefaultChartRenderData d, DAxis axis, IScale scale, int center_x, int center_y, int out_radius) {
        Object step = axis.getProperties().get("P_STEP_UNIT.DAxis.core.jscrib");
        if (step == null) {
            return -1;
        }
        int unit_radius = out_radius;
        Object vs = scale.stepFirst(step);
        while (vs != null) {
            ISize size = d.gc_.textExtent(scale.valueText(vs));
            double a = scale.toScale(vs);
            double vr = unit_radius;
            do {
                int vry;
                int vrx;
                int vurx = (int)((double)unit_radius * Math.cos(a));
                int vury = (int)((double)unit_radius * Math.sin(a));
                int tw = size.getW();
                int th = size.getH();
                int dvx = tw;
                int dvy = -th;
                if (!(a < 1.5707963267948966)) {
                    if (a <= Math.PI) {
                        dvx = -tw;
                    } else if (a < 4.71238898038469) {
                        dvx = -tw;
                        dvy = th;
                    } else {
                        dvy = th;
                    }
                }
                if (!((vr = Math.sqrt((vrx = vurx + dvx) * vrx + (vry = vury + dvy) * vry)) >= (double)out_radius) || (unit_radius -= d.dpiX(3)) >= 0) continue;
                return -1;
            } while (vr >= (double)out_radius);
            vs = scale.stepNext(step, vs);
        }
        return unit_radius;
    }
}

