/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.internal;

import java.util.Arrays;
import org.eclipse.tptp.platform.report.chart.internal.Box3D;
import org.eclipse.tptp.platform.report.chart.internal.CurveStyle;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRender3D;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderData;
import org.eclipse.tptp.platform.report.chart.internal.DefaultRenderChartLocation;
import org.eclipse.tptp.platform.report.chart.internal.IScale;
import org.eclipse.tptp.platform.report.chart.internal.MinMax;
import org.eclipse.tptp.platform.report.chart.internal.RenderPersistData;
import org.eclipse.tptp.platform.report.chart.internal.View3D;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.IDCoord;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.drawutil.internal.Point2D;
import org.eclipse.tptp.platform.report.drawutil.internal.Point3D;
import org.eclipse.tptp.platform.report.drawutil.internal.Vector3D;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.Point;
import org.eclipse.tptp.platform.report.igc.util.internal.Polygon;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;
import org.eclipse.tptp.platform.report.igc.util.internal.Radian;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.SolidBrush;
import org.eclipse.tptp.platform.report.tools.internal.IDisposable;

public class DefaultChartRenderSeries3D {
    private static Point3D[] ptproj = new Point3D[]{new Point3D(), new Point3D(), new Point3D(), new Point3D(), new Point3D(), new Point3D(), new Point3D(), new Point3D(), new Point3D(), new Point3D(), new Point3D(), new Point3D(), new Point3D(), new Point3D(), new Point3D(), new Point3D()};
    private static Point3D[] ptvolume = new Point3D[]{new Point3D(), new Point3D(), new Point3D(), new Point3D(), new Point3D(), new Point3D(), new Point3D(), new Point3D(), new Point3D(), new Point3D(), new Point3D(), new Point3D(), new Point3D(), new Point3D(), new Point3D(), new Point3D()};
    private static SolidBrush brush;
    private static Face[] faces;

    static {
        faces = new Face[]{new Face(), new Face(), new Face(), new Face(), new Face(), new Face(), new Face(), new Face(), new Face(), new Face()};
    }

    private static boolean isValidPersistData(H3D p, DefaultChartRenderData d, RenderPersistData rpd) {
        if (p == null) {
            return false;
        }
        return DefaultChartRenderSeries3D.isThinBar(rpd) == p.thin_bar;
    }

    public static void render(DefaultChartRenderData d, RenderPersistData rpd) throws DefaultRenderChartLocation {
        boolean z_incr;
        H3D p = null;
        if (rpd.g instanceof H3D) {
            p = (H3D)rpd.g;
        }
        if (!DefaultChartRenderSeries3D.isValidPersistData(p, d, rpd)) {
            p = DefaultChartRenderSeries3D.rebuildPersistData(d, rpd);
        }
        if (p.axis == null) {
            if (d.drawing()) {
                String txt = "Error: missing axis";
                d.error(txt, rpd);
            }
            return;
        }
        double phi = rpd.graphic.getProperties().get("P_XYZ_PHI.DGraphic.core.jscrib", 0.3);
        double theta = rpd.graphic.getProperties().get("P_XYZ_THETA.DGraphic.core.jscrib", 0.2);
        p.shadow = rpd.graphic.getProperties().get("P_3D_SHADOW.DGraphic.core.jscrib", 0.5f);
        p.light = rpd.graphic.getProperties().get("P_3D_LIGHT.DGraphic.core.jscrib", 0.6f);
        View3D view = new View3D(phi, theta, 0.0, 1.0, p.bbox);
        int rg_w = rpd.ag_rect.w();
        int rg_h = rpd.ag_rect.h();
        view.scaleTo(rpd.ag_rect.x(), rpd.ag_rect.y(), rg_w, rg_h);
        int min_w_h = rg_w;
        if (min_w_h > rg_h) {
            min_w_h = rg_h;
        }
        LineStylePen pen = new LineStylePen();
        new Point2D();
        Object vp = null;
        new Point3D();
        new Point3D();
        double ntheta = Radian.normalize(view.getTheta());
        boolean x_incr = ntheta <= 1.5707963267948966 || ntheta >= 4.71238898038469;
        boolean y_incr = 0.0 <= ntheta && ntheta <= Math.PI;
        double nphi = Radian.normalize(view.getPhi());
        boolean bl = z_incr = 0.0 <= nphi && nphi <= Math.PI;
        if (nphi > 1.5707963267948966 && nphi < 4.71238898038469) {
            x_incr = !x_incr;
            boolean bl2 = y_incr = !y_incr;
        }
        if (d.drawing()) {
            DefaultChartRender3D.drawBox3D(d, view, p.bbox, x_incr, y_incr, z_incr, false);
        }
        DefaultChartRender3D.renderZAxis3D(d, view, p.bbox, p.axis, p.scale, p.axis_style, x_incr, y_incr, z_incr, false, null);
        IDCoord[] coords = new IDCoord[p.npoints];
        DPoint[] points = new DPoint[p.npoints];
        double bar_base = p.scale.getScaleForBar();
        Vector3D view_vector = view.getViewVector(null);
        view_vector.normalize();
        int ic0 = x_incr ? 0 : rpd.curve_styles.length - 1;
        int icX = x_incr ? rpd.curve_styles.length - 1 : 0;
        int ici = x_incr ? 1 : -1;
        DefaultRenderChartLocation bar_loc = null;
        int ic = ic0;
        while (x_incr && ic <= icX || !x_incr && ic >= icX) {
            CurveStyle ccurve = rpd.curve_styles[ic];
            if (d.drawing()) {
                pen.setRGBA(ccurve.style_.getBack());
                d.gc_.setPen(pen);
            }
            int curve_type = ccurve.curve_.getType() == null ? 0 : (ccurve.curve_.isType("LINE.DCurve.core.jscrib") ? 1 : (ccurve.curve_.isType("BAR2.DCurve.core.jscrib") ? 2 : (ccurve.curve_.isType("PYRAMID.DCurve.core.jscrib") ? 3 : (ccurve.curve_.isType("POINT.DCurve.core.jscrib") ? 4 : (ccurve.curve_.isType("CYLINDER.DCurve.core.jscrib") ? 5 : (ccurve.curve_.isType("AREA_LINE.DCurve.core.jscrib") ? 6 : 0))))));
            int npts = 0;
            int ip = 0;
            IDItem item = ccurve.curve_.getFirstChild();
            while (item != null) {
                if (item instanceof DPoint) {
                    IDItem icd = item.getFirstChild();
                    while (icd != null) {
                        if (icd instanceof IDCoord && p.axis == ((IDCoord)((Object)icd)).getAxis()) {
                            ++npts;
                            coords[ip] = (IDCoord)((Object)icd);
                            points[ip] = (DPoint)item;
                            ++ip;
                            break;
                        }
                        icd = icd.getNext();
                    }
                }
                item = item.getNext();
            }
            int xbar = ic;
            int yb0 = y_incr ? 0 : npts - 1;
            int ybX = y_incr ? npts - 1 : 0;
            int ybi = y_incr ? 1 : -1;
            double last_zbar = 0.0;
            int ybar = yb0;
            while (y_incr && ybar <= ybX || !y_incr && ybar >= ybX) {
                vp = coords[ybar].getValue(vp);
                double zbar = p.scale.toScale(vp);
                try {
                    switch (curve_type) {
                        case 0: {
                            DefaultChartRenderSeries3D.renderBar(points[ybar], d, p, view, xbar, ybar, bar_base, zbar, x_incr, y_incr, z_incr, p.bar_size, view_vector);
                            break;
                        }
                        case 1: {
                            if (ybar != yb0) {
                                DefaultChartRenderSeries3D.renderLine(points[ybar], d, p, view, xbar, ybar, zbar, last_zbar, x_incr, y_incr, z_incr, p.bar_size, view_vector);
                            }
                            last_zbar = zbar;
                            break;
                        }
                        case 2: {
                            DefaultChartRenderSeries3D.renderBar2(points[ybar], d, p, view, xbar, ybar, bar_base, zbar, x_incr, y_incr, z_incr, p.bar_size, view_vector);
                            break;
                        }
                        case 3: {
                            DefaultChartRenderSeries3D.renderPyramid(points[ybar], d, p, view, xbar, ybar, bar_base, zbar, x_incr, y_incr, z_incr, p.bar_size, view_vector);
                            break;
                        }
                        case 4: {
                            DefaultChartRenderSeries3D.renderPoint(points[ybar], d, p, view, xbar, ybar, zbar, x_incr, y_incr, z_incr, p.bar_size, view_vector);
                            break;
                        }
                        case 5: {
                            DefaultChartRenderSeries3D.renderOctogon(points[ybar], d, p, view, xbar, ybar, bar_base, zbar, x_incr, y_incr, z_incr, p.bar_size, view_vector);
                            break;
                        }
                        case 6: {
                            if (ybar != yb0) {
                                DefaultChartRenderSeries3D.renderAreaLine(points[ybar], d, p, view, xbar, ybar, bar_base, zbar, last_zbar, x_incr, y_incr, z_incr, p.bar_size, view_vector, ybar == yb0 + ybi, ybar == ybX);
                            }
                            last_zbar = zbar;
                        }
                    }
                }
                catch (DefaultRenderChartLocation loc) {
                    bar_loc = loc;
                }
                ybar += ybi;
            }
            ic += ici;
        }
        if (d.drawing()) {
            DefaultChartRender3D.drawBox3D(d, view, p.bbox, x_incr, y_incr, z_incr, true);
        }
        DefaultChartRender3D.renderZAxis3D(d, view, p.bbox, p.axis, p.scale, p.axis_style, x_incr, y_incr, z_incr, true, null);
        if (bar_loc != null) {
            throw bar_loc;
        }
    }

    private static void renderLine(DPoint point, DefaultChartRenderData d, H3D h3d, View3D view, int x, int y, double ztop, double last_ztop, boolean x_incr, boolean y_incr, boolean z_incr, float w, Vector3D view_vector) throws DefaultRenderChartLocation {
        double y1 = y_incr ? 1.0f - w / 2.0f : -(w / 2.0f);
        double y2 = y_incr ? w / 2.0f : -(1.0f - w / 2.0f);
        if (!y_incr) {
            ++y;
        }
        view.projection((double)x, (double)y - y1, last_ztop, ptproj[0]);
        view.projection((double)((float)x + w), (double)y - y1, last_ztop, ptproj[1]);
        view.projection((double)x, (double)y + y2, ztop, ptproj[2]);
        view.projection((double)((float)x + w), (double)y + y2, ztop, ptproj[3]);
        int rgba = IGCDStyle.GetBackColor(point);
        Polygon p = new Polygon(4);
        Vector3D v = new Vector3D();
        p.setPoint(0, (int)ptproj[0].getX(), (int)ptproj[0].getY());
        p.setPoint(1, (int)ptproj[1].getX(), (int)ptproj[1].getY());
        p.setPoint(2, (int)ptproj[3].getX(), (int)ptproj[3].getY());
        p.setPoint(3, (int)ptproj[2].getX(), (int)ptproj[2].getY());
        v.vectorialProduct(w, 0.0, 0.0, 0.0, y2 + y1, ztop - last_ztop);
        v.normalize();
        DefaultChartRenderSeries3D.renderPolygon(point, d, h3d, rgba, p, v, view_vector);
    }

    private static void renderAreaLine(DPoint point, DefaultChartRenderData d, H3D h3d, View3D view, int x, int y, double zbase, double ztop, double last_ztop, boolean x_incr, boolean y_incr, boolean z_incr, float w, Vector3D view_vector, boolean is_first, boolean is_last) throws DefaultRenderChartLocation {
        double y1 = y_incr ? 1.0f - w / 2.0f : -(w / 2.0f);
        double y2 = y_incr ? w / 2.0f : -(1.0f - w / 2.0f);
        if (!y_incr) {
            ++y;
        }
        view.projection((double)x, (double)y - y1, last_ztop, ptproj[0]);
        view.projection((double)((float)x + w), (double)y - y1, last_ztop, ptproj[1]);
        view.projection((double)x, (double)y + y2, ztop, ptproj[2]);
        view.projection((double)((float)x + w), (double)y + y2, ztop, ptproj[3]);
        int rgba = IGCDStyle.GetBackColor(point);
        Polygon p = new Polygon(4);
        Polygon p3 = null;
        Vector3D v = new Vector3D();
        new Point();
        ptvolume[0].setCoord(x, (double)y - y1, last_ztop);
        ptvolume[1].setCoord((float)x + w, (double)y - y1, last_ztop);
        ptvolume[2].setCoord((float)x + w, (double)y + y2, ztop);
        ptvolume[3].setCoord(x, (double)y + y2, ztop);
        ptvolume[4].setCoord(x, (double)y - y1, zbase);
        ptvolume[5].setCoord((float)x + w, (double)y - y1, zbase);
        ptvolume[6].setCoord((float)x + w, (double)y + y2, zbase);
        ptvolume[7].setCoord(x, (double)y + y2, zbase);
        int i = 0;
        while (i < 8) {
            view.projection(ptvolume[i], ptproj[i]);
            ++i;
        }
        int nf = 0;
        if (is_first) {
            faces[nf++].update(4, 5, 1, 0);
        }
        if (ztop >= zbase && last_ztop >= zbase || ztop < zbase && last_ztop < zbase) {
            faces[nf++].update(0, 1, 2, 3);
            faces[nf++].update(7, 6, 5, 4);
            faces[nf++].update(1, 5, 6, 2);
            faces[nf++].update(0, 3, 7, 4);
        } else {
            double ycut = (double)y - y1 + (y2 + y1) * (zbase - last_ztop) / (ztop - last_ztop);
            ptvolume[8].setCoord(x, ycut, zbase);
            ptvolume[9].setCoord((float)x + w, ycut, zbase);
            view.projection(ptvolume[8], ptproj[8]);
            view.projection(ptvolume[9], ptproj[9]);
            if (last_ztop >= zbase) {
                faces[nf++].update(0, 1, 9, 8);
                faces[nf++].update(8, 9, 6, 7);
                faces[nf++].update(8, 9, 5, 4);
                faces[nf++].update(9, 8, 3, 2);
            } else {
                faces[nf++].update(4, 5, 9, 8);
                faces[nf++].update(8, 9, 2, 3);
                faces[nf++].update(8, 9, 1, 0);
                faces[nf++].update(9, 8, 7, 6);
            }
            faces[nf++].update(1, 5, 9);
            faces[nf++].update(9, 2, 6);
            faces[nf++].update(0, 8, 4);
            faces[nf++].update(8, 7, 3);
            p3 = new Polygon(3);
        }
        if (is_last) {
            faces[nf++].update(7, 6, 2, 3);
        }
        Arrays.sort(faces, 0, nf);
        int i2 = nf - 1;
        while (i2 >= 0) {
            if (DefaultChartRenderSeries3D.faces[i2].ip3 < 0) {
                DefaultChartRenderSeries3D.renderTriangle(point, rgba, d, h3d, ptvolume, ptproj, p3, v, view_vector, DefaultChartRenderSeries3D.faces[i2].ip0, DefaultChartRenderSeries3D.faces[i2].ip1, DefaultChartRenderSeries3D.faces[i2].ip2);
            } else {
                DefaultChartRenderSeries3D.renderQuad(point, rgba, d, h3d, ptvolume, ptproj, p, v, view_vector, DefaultChartRenderSeries3D.faces[i2].ip0, DefaultChartRenderSeries3D.faces[i2].ip1, DefaultChartRenderSeries3D.faces[i2].ip2, DefaultChartRenderSeries3D.faces[i2].ip3);
            }
            --i2;
        }
    }

    private static void renderBar(DPoint point, DefaultChartRenderData d, H3D h3d, View3D view, int x, int y, double zbtm, double ztop, boolean x_incr, boolean y_incr, boolean z_incr, float w, Vector3D view_vector) throws DefaultRenderChartLocation {
        boolean z_inverted = false;
        if (ztop < zbtm) {
            z_inverted = true;
            z_incr = !z_incr;
        }
        view.projection((double)x, (double)y, zbtm, ptproj[0]);
        view.projection((double)((float)x + w), (double)y, zbtm, ptproj[1]);
        view.projection((double)((float)x + w), (double)((float)y + w), zbtm, ptproj[2]);
        view.projection((double)x, (double)((float)y + w), zbtm, ptproj[3]);
        view.projection((double)x, (double)y, ztop, ptproj[4]);
        view.projection((double)((float)x + w), (double)y, ztop, ptproj[5]);
        view.projection((double)((float)x + w), (double)((float)y + w), ztop, ptproj[6]);
        view.projection((double)x, (double)((float)y + w), ztop, ptproj[7]);
        int rgba = IGCDStyle.GetBackColor(point);
        Polygon p = new Polygon(4);
        Vector3D v = new Vector3D();
        new Point();
        if (z_incr) {
            DefaultChartRenderSeries3D.renderBarBottom(point, rgba, d, h3d, ptproj, p, v, view_vector, z_inverted);
        } else {
            DefaultChartRenderSeries3D.renderBarTop(point, rgba, d, h3d, ptproj, p, v, view_vector, z_inverted);
        }
        if (y_incr) {
            DefaultChartRenderSeries3D.renderBarLeft(point, rgba, d, h3d, ptproj, p, v, view_vector);
        } else {
            DefaultChartRenderSeries3D.renderBarRight(point, rgba, d, h3d, ptproj, p, v, view_vector);
        }
        if (x_incr) {
            DefaultChartRenderSeries3D.renderBarBack(point, rgba, d, h3d, ptproj, p, v, view_vector);
        } else {
            DefaultChartRenderSeries3D.renderBarFront(point, rgba, d, h3d, ptproj, p, v, view_vector);
        }
        if (y_incr) {
            DefaultChartRenderSeries3D.renderBarRight(point, rgba, d, h3d, ptproj, p, v, view_vector);
        } else {
            DefaultChartRenderSeries3D.renderBarLeft(point, rgba, d, h3d, ptproj, p, v, view_vector);
        }
        if (x_incr) {
            DefaultChartRenderSeries3D.renderBarFront(point, rgba, d, h3d, ptproj, p, v, view_vector);
        } else {
            DefaultChartRenderSeries3D.renderBarBack(point, rgba, d, h3d, ptproj, p, v, view_vector);
        }
        if (z_incr) {
            DefaultChartRenderSeries3D.renderBarTop(point, rgba, d, h3d, ptproj, p, v, view_vector, z_inverted);
        } else {
            DefaultChartRenderSeries3D.renderBarBottom(point, rgba, d, h3d, ptproj, p, v, view_vector, z_inverted);
        }
    }

    private static void renderPolygon(DPoint _point, DefaultChartRenderData d, H3D h3d, int rgba, Polygon p, Vector3D v, Vector3D view_vector) throws DefaultRenderChartLocation {
        if (d.drawing()) {
            double k = Math.abs(Vector3D.Scalar(v, view_vector));
            if (brush == null) {
                brush = new SolidBrush();
            }
            brush.setRGBA(RGBA.Shadow(rgba, h3d.shadow, h3d.light, (float)k));
            d.gc_.setBrush(brush);
            d.gc_.fillPoly(p);
        } else if (p.contains(d.lx_, d.ly_)) {
            String loc_id = "CurvePointText";
            throw new DefaultRenderChartLocation(loc_id, _point, new Rect(d.lx_, d.ly_, 0, 0));
        }
    }

    private static void renderBarBottom(DPoint _point, int rgba, DefaultChartRenderData d, H3D h3d, Point3D[] ptbar, Polygon p, Vector3D v, Vector3D view_vector, boolean z_inverted) throws DefaultRenderChartLocation {
        p.setPoint(0, (int)ptbar[0].getX(), (int)ptbar[0].getY());
        p.setPoint(1, (int)ptbar[1].getX(), (int)ptbar[1].getY());
        p.setPoint(2, (int)ptbar[2].getX(), (int)ptbar[2].getY());
        p.setPoint(3, (int)ptbar[3].getX(), (int)ptbar[3].getY());
        v.setVector(0.0, 0.0, z_inverted ? 1 : -1);
        DefaultChartRenderSeries3D.renderPolygon(_point, d, h3d, rgba, p, v, view_vector);
    }

    private static void renderBarTop(DPoint _point, int rgba, DefaultChartRenderData d, H3D h3d, Point3D[] ptbar, Polygon p, Vector3D v, Vector3D view_vector, boolean z_inverted) throws DefaultRenderChartLocation {
        p.setPoint(0, (int)ptbar[4].getX(), (int)ptbar[4].getY());
        p.setPoint(1, (int)ptbar[5].getX(), (int)ptbar[5].getY());
        p.setPoint(2, (int)ptbar[6].getX(), (int)ptbar[6].getY());
        p.setPoint(3, (int)ptbar[7].getX(), (int)ptbar[7].getY());
        v.setVector(0.0, 0.0, z_inverted ? -1 : 1);
        DefaultChartRenderSeries3D.renderPolygon(_point, d, h3d, rgba, p, v, view_vector);
    }

    private static void renderBarFront(DPoint point, int rgba, DefaultChartRenderData d, H3D h3d, Point3D[] ptbar, Polygon p, Vector3D v, Vector3D view_vector) throws DefaultRenderChartLocation {
        p.setPoint(0, (int)ptbar[1].getX(), (int)ptbar[1].getY());
        p.setPoint(1, (int)ptbar[2].getX(), (int)ptbar[2].getY());
        p.setPoint(2, (int)ptbar[6].getX(), (int)ptbar[6].getY());
        p.setPoint(3, (int)ptbar[5].getX(), (int)ptbar[5].getY());
        v.setVector(1.0, 0.0, 0.0);
        DefaultChartRenderSeries3D.renderPolygon(point, d, h3d, rgba, p, v, view_vector);
    }

    private static void renderBarBack(DPoint point, int rgba, DefaultChartRenderData d, H3D h3d, Point3D[] ptbar, Polygon p, Vector3D v, Vector3D view_vector) throws DefaultRenderChartLocation {
        p.setPoint(0, (int)ptbar[3].getX(), (int)ptbar[3].getY());
        p.setPoint(1, (int)ptbar[0].getX(), (int)ptbar[0].getY());
        p.setPoint(2, (int)ptbar[4].getX(), (int)ptbar[4].getY());
        p.setPoint(3, (int)ptbar[7].getX(), (int)ptbar[7].getY());
        v.setVector(-1.0, 0.0, 0.0);
        DefaultChartRenderSeries3D.renderPolygon(point, d, h3d, rgba, p, v, view_vector);
    }

    private static void renderBarLeft(DPoint point, int rgba, DefaultChartRenderData d, H3D h3d, Point3D[] ptbar, Polygon p, Vector3D v, Vector3D view_vector) throws DefaultRenderChartLocation {
        p.setPoint(0, (int)ptbar[0].getX(), (int)ptbar[0].getY());
        p.setPoint(1, (int)ptbar[1].getX(), (int)ptbar[1].getY());
        p.setPoint(2, (int)ptbar[5].getX(), (int)ptbar[5].getY());
        p.setPoint(3, (int)ptbar[4].getX(), (int)ptbar[4].getY());
        v.setVector(0.0, -1.0, 0.0);
        DefaultChartRenderSeries3D.renderPolygon(point, d, h3d, rgba, p, v, view_vector);
    }

    private static void renderBarRight(DPoint point, int rgba, DefaultChartRenderData d, H3D h3d, Point3D[] ptbar, Polygon p, Vector3D v, Vector3D view_vector) throws DefaultRenderChartLocation {
        p.setPoint(0, (int)ptbar[2].getX(), (int)ptbar[2].getY());
        p.setPoint(1, (int)ptbar[3].getX(), (int)ptbar[3].getY());
        p.setPoint(2, (int)ptbar[7].getX(), (int)ptbar[7].getY());
        p.setPoint(3, (int)ptbar[6].getX(), (int)ptbar[6].getY());
        v.setVector(0.0, 1.0, 0.0);
        DefaultChartRenderSeries3D.renderPolygon(point, d, h3d, rgba, p, v, view_vector);
    }

    private static boolean isThinBar(RenderPersistData rpd) {
        return rpd.graphic.getProperties().get("P_THIN_BAR.DGraphic.core.jscrib", true);
    }

    private static H3D rebuildPersistData(DefaultChartRenderData d, RenderPersistData rpd) {
        H3D p = new H3D();
        rpd.g = p;
        p.axis = null;
        IDItem item = rpd.graphic.getFirstChild();
        while (item != null) {
            if (item instanceof DAxis) {
                p.axis = (DAxis)item;
                break;
            }
            item = item.getNext();
        }
        if (p.axis == null) {
            return p;
        }
        p.thin_bar = DefaultChartRenderSeries3D.isThinBar(rpd);
        p.bar_size = p.thin_bar ? 0.7f : 1.0f;
        p.axis_style = new IGCDStyle(p.axis, d.scale_);
        int max_font_h = 0;
        d.gc_.setFont(p.axis_style.getFont());
        max_font_h = d.gc_.getFontMetrics().getHeight();
        max_font_h = 2 * max_font_h + 6;
        rpd.ag_rect.setRect(rpd.ag_rect.left() + max_font_h, rpd.ag_rect.top() + max_font_h, rpd.ag_rect.w() - 2 * max_font_h, rpd.ag_rect.h() - max_font_h);
        Object min = p.axis.getProperties().get("P_MIN.DAxis.core.jscrib");
        Object max = p.axis.getProperties().get("P_MAX.DAxis.core.jscrib");
        if (min == null || max == null) {
            MinMax mm = new MinMax(p.axis);
            int icrv = 0;
            while (icrv < rpd.curve_styles.length) {
                IDItem ip = rpd.curve_styles[icrv].curve_.getFirstChild();
                while (ip != null) {
                    IDItem ic = ip.getFirstChild();
                    while (ic != null) {
                        IDCoord coord;
                        DAxis axis;
                        if (ic instanceof IDCoord && (axis = (coord = (IDCoord)((Object)ic)).getAxis()) == p.axis) {
                            mm.update(coord);
                        }
                        ic = ic.getNext();
                    }
                    ip = ip.getNext();
                }
                ++icrv;
            }
            if (min == null) {
                min = mm.getVMin();
            }
            if (max == null) {
                max = mm.getVMax();
            }
        }
        int npts = 0;
        int ic = 0;
        while (ic < rpd.curve_styles.length) {
            int np = 0;
            if (!rpd.curve_styles[ic].curve_.isType("SECTOR.DCurve.core.jscrib")) {
                IDItem it = rpd.curve_styles[ic].curve_.getFirstChild();
                while (it != null) {
                    if (it instanceof DPoint) {
                        ++np;
                    }
                    it = it.getNext();
                }
                if (np > npts) {
                    npts = np;
                }
            }
            ++ic;
        }
        p.npoints = npts;
        p.ncurves = rpd.curve_styles.length;
        p.scale = DefaultChartRenderData.getScale(p.axis, 0.0, 1.0, min, max);
        p.bbox = new Box3D(0.0, (float)p.ncurves - (p.thin_bar ? 1.0f - p.bar_size : 0.0f), 0.0, p.npoints == 0 ? 1.0f : (float)p.npoints - (p.thin_bar ? 1.0f - p.bar_size : 0.0f), p.scale.getScaleMin(), p.scale.getScaleMax());
        return p;
    }

    private static void renderPyramid(DPoint point, DefaultChartRenderData d, H3D h3d, View3D view, int x, int y, double zbtm, double ztop, boolean x_incr, boolean y_incr, boolean z_incr, float w, Vector3D view_vector) throws DefaultRenderChartLocation {
        boolean z_inverted = false;
        if (ztop < zbtm) {
            z_inverted = true;
            z_incr = !z_incr;
        }
        ptvolume[0].setCoord(x, y, zbtm);
        ptvolume[1].setCoord((float)x + w, y, zbtm);
        ptvolume[2].setCoord((float)x + w, (float)y + w, zbtm);
        ptvolume[3].setCoord(x, (float)y + w, zbtm);
        ptvolume[4].setCoord((float)x + w / 2.0f, (float)y + w / 2.0f, ztop);
        int i = 0;
        while (i < 5) {
            view.projection(ptvolume[i].getX(), ptvolume[i].getY(), ptvolume[i].getZ(), ptproj[i]);
            ++i;
        }
        int rgba = IGCDStyle.GetBackColor(point);
        if (z_inverted) {
            faces[0].update(1, 0, 4);
            faces[1].update(2, 1, 4);
            faces[2].update(3, 2, 4);
            faces[3].update(0, 3, 4);
        } else {
            faces[0].update(0, 1, 4);
            faces[1].update(1, 2, 4);
            faces[2].update(2, 3, 4);
            faces[3].update(3, 0, 4);
        }
        Arrays.sort(faces, 0, 4);
        Polygon p4 = new Polygon(4);
        Polygon p3 = new Polygon(3);
        Vector3D v = new Vector3D();
        new Point();
        if (z_incr) {
            DefaultChartRenderSeries3D.renderBarBottom(point, rgba, d, h3d, ptproj, p4, v, view_vector, z_inverted);
        }
        int i2 = 3;
        while (i2 >= 0) {
            DefaultChartRenderSeries3D.renderTriangle(point, rgba, d, h3d, ptvolume, ptproj, p3, v, view_vector, DefaultChartRenderSeries3D.faces[i2].ip0, DefaultChartRenderSeries3D.faces[i2].ip1, DefaultChartRenderSeries3D.faces[i2].ip2);
            --i2;
        }
        if (!z_incr) {
            DefaultChartRenderSeries3D.renderBarBottom(point, rgba, d, h3d, ptproj, p4, v, view_vector, z_inverted);
        }
    }

    private static void renderTriangle(DPoint point, int rgba, DefaultChartRenderData d, H3D h3d, Point3D[] pt, Point3D[] pj, Polygon p, Vector3D v, Vector3D view_vector, int ip0, int ip1, int ip2) throws DefaultRenderChartLocation {
        p.setPoint(0, (int)pj[ip0].getX(), (int)pj[ip0].getY());
        p.setPoint(1, (int)pj[ip1].getX(), (int)pj[ip1].getY());
        p.setPoint(2, (int)pj[ip2].getX(), (int)pj[ip2].getY());
        v.vectorialProduct(pt[ip1].getX() - pt[ip0].getX(), pt[ip1].getY() - pt[ip0].getY(), pt[ip1].getZ() - pt[ip0].getZ(), pt[ip2].getX() - pt[ip1].getX(), pt[ip2].getY() - pt[ip1].getY(), pt[ip2].getZ() - pt[ip1].getZ());
        v.normalize();
        DefaultChartRenderSeries3D.renderPolygon(point, d, h3d, rgba, p, v, view_vector);
    }

    private static void renderBar2(DPoint point, DefaultChartRenderData d, H3D h3d, View3D view, int x, int y, double zbtm, double ztop, boolean x_incr, boolean y_incr, boolean z_incr, float w, Vector3D view_vector) throws DefaultRenderChartLocation {
        boolean z_inverted = false;
        if (ztop < zbtm) {
            z_inverted = true;
            z_incr = !z_incr;
        }
        float w2 = w / 2.0f;
        ptvolume[0].setCoord((float)x + w2, y, zbtm);
        ptvolume[1].setCoord((float)x + w, (float)y + w2, zbtm);
        ptvolume[2].setCoord((float)x + w2, (float)y + w, zbtm);
        ptvolume[3].setCoord(x, (float)y + w2, zbtm);
        ptvolume[4].setCoord((float)x + w2, y, ztop);
        ptvolume[5].setCoord((float)x + w, (float)y + w2, ztop);
        ptvolume[6].setCoord((float)x + w2, (float)y + w, ztop);
        ptvolume[7].setCoord(x, (float)y + w2, ztop);
        int i = 0;
        while (i < 8) {
            view.projection(ptvolume[i].getX(), ptvolume[i].getY(), ptvolume[i].getZ(), ptproj[i]);
            ++i;
        }
        int rgba = IGCDStyle.GetBackColor(point);
        if (z_inverted) {
            faces[0].update(1, 0, 4, 5);
            faces[1].update(2, 1, 5, 6);
            faces[2].update(3, 2, 6, 7);
            faces[3].update(0, 3, 7, 4);
        } else {
            faces[0].update(0, 1, 5, 4);
            faces[1].update(1, 2, 6, 5);
            faces[2].update(2, 3, 7, 6);
            faces[3].update(3, 0, 4, 7);
        }
        Arrays.sort(faces, 0, 4);
        Polygon p4 = new Polygon(4);
        Vector3D v = new Vector3D();
        new Point();
        if (z_incr) {
            DefaultChartRenderSeries3D.renderBarBottom(point, rgba, d, h3d, ptproj, p4, v, view_vector, z_inverted);
        } else {
            DefaultChartRenderSeries3D.renderBarTop(point, rgba, d, h3d, ptproj, p4, v, view_vector, z_inverted);
        }
        int i2 = 3;
        while (i2 >= 0) {
            DefaultChartRenderSeries3D.renderQuad(point, rgba, d, h3d, ptvolume, ptproj, p4, v, view_vector, DefaultChartRenderSeries3D.faces[i2].ip0, DefaultChartRenderSeries3D.faces[i2].ip1, DefaultChartRenderSeries3D.faces[i2].ip2, DefaultChartRenderSeries3D.faces[i2].ip3);
            --i2;
        }
        if (z_incr) {
            DefaultChartRenderSeries3D.renderBarTop(point, rgba, d, h3d, ptproj, p4, v, view_vector, z_inverted);
        } else {
            DefaultChartRenderSeries3D.renderBarBottom(point, rgba, d, h3d, ptproj, p4, v, view_vector, z_inverted);
        }
    }

    private static void renderQuad(DPoint point, int rgba, DefaultChartRenderData d, H3D h3d, Point3D[] pt, Point3D[] pj, Polygon p, Vector3D v, Vector3D view_vector, int ip0, int ip1, int ip2, int ip3) throws DefaultRenderChartLocation {
        p.setPoint(0, (int)pj[ip0].getX(), (int)pj[ip0].getY());
        p.setPoint(1, (int)pj[ip1].getX(), (int)pj[ip1].getY());
        p.setPoint(2, (int)pj[ip2].getX(), (int)pj[ip2].getY());
        p.setPoint(3, (int)pj[ip3].getX(), (int)pj[ip3].getY());
        v.vectorialProduct(pt[ip1].getX() - pt[ip0].getX(), pt[ip1].getY() - pt[ip0].getY(), pt[ip1].getZ() - pt[ip0].getZ(), pt[ip2].getX() - pt[ip1].getX(), pt[ip2].getY() - pt[ip1].getY(), pt[ip2].getZ() - pt[ip1].getZ());
        v.normalize();
        DefaultChartRenderSeries3D.renderPolygon(point, d, h3d, rgba, p, v, view_vector);
    }

    private static void renderPoint(DPoint point, DefaultChartRenderData d, H3D h3d, View3D view, int x, int y, double z, boolean x_incr, boolean y_incr, boolean z_incr, float w, Vector3D view_vector) throws DefaultRenderChartLocation {
        float w4 = w / 4.0f;
        float x1 = (float)x + w / 2.0f - w4;
        float x2 = (float)x + w / 2.0f + w4;
        float y1 = (float)y + w / 2.0f - w4;
        float y2 = (float)y + w / 2.0f + w4;
        double z1 = z - (double)w4;
        double z2 = z + (double)w4;
        ptvolume[0].setCoord(x1, y1, z);
        ptvolume[1].setCoord(x2, y1, z);
        ptvolume[2].setCoord(x2, y2, z);
        ptvolume[3].setCoord(x1, y2, z);
        ptvolume[4].setCoord((float)x + w / 2.0f, (float)y + w / 2.0f, z2);
        ptvolume[5].setCoord((float)x + w / 2.0f, (float)y + w / 2.0f, z1);
        int i = 0;
        while (i < 6) {
            view.projection(ptvolume[i], ptproj[i]);
            ++i;
        }
        int rgba = IGCDStyle.GetBackColor(point);
        faces[0].update(0, 1, 4);
        faces[1].update(1, 2, 4);
        faces[2].update(2, 3, 4);
        faces[3].update(3, 0, 4);
        faces[4].update(1, 0, 5);
        faces[5].update(2, 1, 5);
        faces[6].update(3, 2, 5);
        faces[7].update(0, 3, 5);
        Arrays.sort(faces, 0, 8);
        Polygon p3 = new Polygon(3);
        Vector3D v = new Vector3D();
        new Point();
        int i2 = 7;
        while (i2 >= 0) {
            DefaultChartRenderSeries3D.renderTriangle(point, rgba, d, h3d, ptvolume, ptproj, p3, v, view_vector, DefaultChartRenderSeries3D.faces[i2].ip0, DefaultChartRenderSeries3D.faces[i2].ip1, DefaultChartRenderSeries3D.faces[i2].ip2);
            --i2;
        }
    }

    private static void renderOctogon(DPoint point, DefaultChartRenderData d, H3D h3d, View3D view, int x, int y, double zbtm, double ztop, boolean x_incr, boolean y_incr, boolean z_incr, float w, Vector3D view_vector) throws DefaultRenderChartLocation {
        int i;
        float w2 = w / 2.0f;
        float xc = (float)x + w2;
        float yc = (float)y + w2;
        double zn = zbtm;
        double zx = ztop;
        if (ztop < zbtm) {
            zn = ztop;
            zx = zbtm;
        }
        double a = 0.0;
        int i2 = 0;
        while (i2 < 8) {
            double c = (double)w2 * Math.cos(a);
            double s = (double)w2 * Math.sin(a);
            ptvolume[i2].setCoord((double)xc + c, (double)yc + s, zn);
            ptvolume[i2 + 8].setCoord((double)xc + c, (double)yc + s, zx);
            ++i2;
            a += 0.7853981633974483;
        }
        i2 = 0;
        while (i2 < 16) {
            view.projection(ptvolume[i2], ptproj[i2]);
            ++i2;
        }
        int rgba = IGCDStyle.GetBackColor(point);
        faces[0].update(0, 1, 9, 8);
        faces[1].update(1, 2, 10, 9);
        faces[2].update(2, 3, 11, 10);
        faces[3].update(3, 4, 12, 11);
        faces[4].update(4, 5, 13, 12);
        faces[5].update(5, 6, 14, 13);
        faces[6].update(6, 7, 15, 14);
        faces[7].update(7, 0, 8, 15);
        Arrays.sort(faces, 0, 8);
        Polygon p4 = new Polygon(4);
        Polygon p8 = new Polygon(8);
        Vector3D v = new Vector3D();
        new Point();
        if (z_incr) {
            i = 0;
            while (i < 8) {
                p8.setPoint(i, (int)ptproj[i].getX(), (int)ptproj[i].getY());
                ++i;
            }
            v.setVector(0.0, 0.0, -1.0);
            DefaultChartRenderSeries3D.renderPolygon(point, d, h3d, rgba, p8, v, view_vector);
        } else {
            i = 0;
            while (i < 8) {
                p8.setPoint(i, (int)ptproj[i + 8].getX(), (int)ptproj[i + 8].getY());
                ++i;
            }
            v.setVector(0.0, 0.0, 1.0);
            DefaultChartRenderSeries3D.renderPolygon(point, d, h3d, rgba, p8, v, view_vector);
        }
        i = 7;
        while (i >= 0) {
            DefaultChartRenderSeries3D.renderQuad(point, rgba, d, h3d, ptvolume, ptproj, p4, v, view_vector, DefaultChartRenderSeries3D.faces[i].ip0, DefaultChartRenderSeries3D.faces[i].ip1, DefaultChartRenderSeries3D.faces[i].ip2, DefaultChartRenderSeries3D.faces[i].ip3);
            --i;
        }
        if (z_incr) {
            i = 0;
            while (i < 8) {
                p8.setPoint(i, (int)ptproj[i + 8].getX(), (int)ptproj[i + 8].getY());
                ++i;
            }
            v.setVector(0.0, 0.0, 1.0);
            DefaultChartRenderSeries3D.renderPolygon(point, d, h3d, rgba, p8, v, view_vector);
        } else {
            i = 0;
            while (i < 8) {
                p8.setPoint(i, (int)ptproj[i].getX(), (int)ptproj[i].getY());
                ++i;
            }
            v.setVector(0.0, 0.0, -1.0);
            DefaultChartRenderSeries3D.renderPolygon(point, d, h3d, rgba, p8, v, view_vector);
        }
    }

    private static abstract class AFace
    implements Comparable {
        public double pj_zavg;

        private AFace() {
        }

        public int compareTo(Object o) {
            AFace f = (AFace)o;
            if (this.pj_zavg == f.pj_zavg) {
                return 0;
            }
            if (this.pj_zavg > f.pj_zavg) {
                return 1;
            }
            return -1;
        }
    }

    private static class Face
    extends AFace {
        public int ip0;
        public int ip1;
        public int ip2;
        public int ip3;
        public DPoint point;
        public Point3D[] pj;
        public Point3D[] pt;

        public Face() {
        }

        public Face(int p0, int p1, int p2, int p3, Point3D[] pj) {
            this.ip0 = p0;
            this.ip1 = p1;
            this.ip2 = p2;
            this.ip3 = p3;
            this.pj = pj;
            this.pj_zavg = (pj[p0].getZ() + pj[p1].getZ() + pj[p2].getZ() + pj[p3].getZ()) / 4.0;
        }

        public Face(int p0, int p1, int p2, Point3D[] pj) {
            this.ip0 = p0;
            this.ip1 = p1;
            this.ip2 = p2;
            this.ip3 = -1;
            this.pj = pj;
            this.pj_zavg = (pj[p0].getZ() + pj[p1].getZ() + pj[p2].getZ()) / 3.0;
        }

        public void update(int p0, int p1, int p2) {
            this.ip0 = p0;
            this.ip1 = p1;
            this.ip2 = p2;
            this.ip3 = -1;
            this.pj_zavg = (ptproj[p0].getZ() + ptproj[p1].getZ() + ptproj[p2].getZ()) / 3.0;
        }

        public void update(int p0, int p1, int p2, int p3) {
            this.ip0 = p0;
            this.ip1 = p1;
            this.ip2 = p2;
            this.ip3 = p3;
            this.pj_zavg = (ptproj[p0].getZ() + ptproj[p1].getZ() + ptproj[p2].getZ() + ptproj[p3].getZ()) / 4.0;
        }
    }

    static class H3D
    implements IDisposable {
        DAxis axis;
        IGCDStyle axis_style;
        IScale scale;
        float shadow;
        float light;
        Box3D bbox;
        int npoints;
        int ncurves;
        boolean thin_bar;
        float bar_size;

        H3D() {
        }

        public void dispose() {
        }
    }
}

