/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.internal;

import org.eclipse.tptp.platform.report.chart.internal.Box3D;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRender3D;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderData;
import org.eclipse.tptp.platform.report.chart.internal.DefaultRenderChartLocation;
import org.eclipse.tptp.platform.report.chart.internal.IScale;
import org.eclipse.tptp.platform.report.chart.internal.IXYSurface;
import org.eclipse.tptp.platform.report.chart.internal.IXYSurfaceColorizer;
import org.eclipse.tptp.platform.report.chart.internal.Insets;
import org.eclipse.tptp.platform.report.chart.internal.LinearNumberScale;
import org.eclipse.tptp.platform.report.chart.internal.RenderPersistData;
import org.eclipse.tptp.platform.report.chart.internal.View3D;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DPropertyStore;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.drawutil.internal.Point2D;
import org.eclipse.tptp.platform.report.drawutil.internal.Point3D;
import org.eclipse.tptp.platform.report.drawutil.internal.Vector3D;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IPen;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.util.internal.GradientGenerator;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.Polygon;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;
import org.eclipse.tptp.platform.report.igc.util.internal.Radian;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.SolidBrush;
import org.eclipse.tptp.platform.report.tools.internal.IDisposable;
import org.eclipse.tptp.platform.report.tools.internal.VDouble;

public class DefaultChartRenderXYSurface {
    private static IXYSurfaceColorizer default_colorizer_;
    private static SolidBrush brush;
    private static Point2D rpp0;
    private static Point2D rpp1;
    private static Point3D rp0;
    private static Point3D rp1;
    private static LineStylePen pen;

    static {
        rpp0 = new Point2D();
        rpp1 = new Point2D();
        rp0 = new Point3D();
        rp1 = new Point3D();
        pen = new LineStylePen();
    }

    private static boolean isValidPersistData(H3D p, DefaultChartRenderData d, RenderPersistData rpd) {
        return p != null;
    }

    public static void render(DefaultChartRenderData d, RenderPersistData rpd) throws DefaultRenderChartLocation {
        boolean z_incr;
        H3D p = null;
        if (rpd.g instanceof H3D) {
            p = (H3D)rpd.g;
        }
        if (!DefaultChartRenderXYSurface.isValidPersistData(p, d, rpd)) {
            p = DefaultChartRenderXYSurface.rebuildPersistData(d, rpd);
        }
        if (p.surface == null) {
            if (d.drawing()) {
                d.error("Error: missing IXYSurface as child of DGraphic", rpd);
            }
            return;
        }
        DPropertyStore store = rpd.graphic.getProperties();
        p.shadow = store.get("P_3D_SHADOW.DGraphic.core.jscrib", 0.5f);
        p.light = store.get("P_3D_LIGHT.DGraphic.core.jscrib", 0.6f);
        String obj = store.get("P_XYS_CONTOUR_LINE.DGraphic.core.jscrib", null);
        if (obj instanceof String) {
            if (p.z_axis != null && "P_STEP_LINE.DAxis.core.jscrib".equals(obj)) {
                p.contour_line = p.z_axis.getProperties().get("P_STEP_LINE.DAxis.core.jscrib", -1.0f);
                if (p.contour_line > 0.0) {
                    p.contour_line /= p.surface.getZMax() - p.surface.getZMin();
                }
            }
        } else if (obj instanceof IDColor) {
            IDColor clr = (IDColor)((Object)obj);
            p.contour_line = RGBA.Get(clr.getRed(), clr.getGreen(), clr.getBlue());
        } else if (obj instanceof Number) {
            p.contour_line = ((Number)((Object)obj)).doubleValue();
            if (p.z_axis != null && p.contour_line > 0.0) {
                p.contour_line /= p.surface.getZMax() - p.surface.getZMin();
            }
        } else {
            p.contour_line = -1.0;
        }
        if ((obj = store.get("P_XYS_CONTOUR_LINE_COLOR.DGraphic.core.jscrib", null)) instanceof IXYSurfaceColorizer) {
            p.contour_line_colorizer = (IXYSurfaceColorizer)((Object)obj);
        } else {
            p.contour_line_colorizer = null;
            p.contour_line_rgba = obj instanceof Integer ? (Integer)((Object)obj) : 255;
        }
        p.draw_polygon = !store.get("P_XYS_NO_POLYGON.DGraphic.core.jscrib", false);
        double h = rpd.graphic.getProperties().get("P_3D_HEIGHT.DGraphic.core.jscrib", 1.0);
        p.bbox = new Box3D(0.0, 1.0, 0.0, 1.0, 0.0, h);
        double phi = rpd.graphic.getProperties().get("P_XYZ_PHI.DGraphic.core.jscrib", 0.3);
        double theta = rpd.graphic.getProperties().get("P_XYZ_THETA.DGraphic.core.jscrib", 0.2);
        View3D view = new View3D(phi, theta, 0.0, 1.0, p.bbox);
        view.scaleTo(rpd.ag_rect.x(), rpd.ag_rect.y(), rpd.ag_rect.w(), rpd.ag_rect.h());
        if (p.surface.getSizeX() < 2 || p.surface.getSizeY() < 2) {
            return;
        }
        LinearNumberScale z_scale = new LinearNumberScale(0.0, h, new Double(p.surface.getZMin()), new Double(p.surface.getZMax()));
        z_scale.setLocale(rpd.locale);
        if (!z_scale.isValid()) {
            if (d.drawing()) {
                d.error("Invalid scale can't draw surface", rpd);
            }
            return;
        }
        double ntheta = Radian.normalize(view.getTheta());
        boolean x_incr = ntheta <= 1.5707963267948966 || ntheta >= 4.71238898038469;
        boolean y_incr = 0.0 <= ntheta && ntheta <= Math.PI;
        double nphi = Radian.normalize(view.getPhi());
        boolean bl = z_incr = 0.0 <= nphi && nphi <= Math.PI;
        if (nphi > 1.5707963267948966 && nphi < 4.71238898038469) {
            x_incr = !x_incr;
            y_incr = !y_incr;
        }
        p.projected_contour_line = rpd.graphic.getProperties().get("P_XYZ_ZPROJ.DGraphic.core.jscrib", false);
        p.zproj_contour_line = z_incr ? h : 0.0;
        view.scaleTo(rpd.ag_rect.x(), rpd.ag_rect.y(), rpd.ag_rect.w(), rpd.ag_rect.h());
        Insets insets = new Insets();
        if (p.z_axis != null) {
            DefaultChartRender3D.renderZAxis3D(d, view, p.bbox, p.z_axis, z_scale, p.z_axis_style, x_incr, y_incr, z_incr, false, insets);
        }
        IScale x_scale = null;
        if (p.x_axis != null) {
            Object xmax;
            Object xmin = p.x_axis.getProperties().get("P_MIN.DAxis.core.jscrib", new Double(0.0));
            x_scale = DefaultChartRenderData.getScale(p.x_axis, 0.0, 1.0, xmin, xmax = p.x_axis.getProperties().get("P_MAX.DAxis.core.jscrib", new Double(1.0)));
            if (!x_scale.isValid()) {
                if (d.drawing()) {
                    d.error("Invalid X scale (missed DAxis.P_MIN and P_MAX properties ?)", rpd);
                }
                return;
            }
            DefaultChartRender3D.renderXYAxis3D(true, d, view, p.bbox, p.x_axis, x_scale, p.x_axis_style, x_incr, y_incr, z_incr, false, insets);
        }
        IScale y_scale = null;
        if (p.y_axis != null) {
            Object ymax;
            Object ymin = p.y_axis.getProperties().get("P_MIN.DAxis.core.jscrib", new Double(0.0));
            y_scale = DefaultChartRenderData.getScale(p.y_axis, 0.0, 1.0, ymin, ymax = p.y_axis.getProperties().get("P_MAX.DAxis.core.jscrib", new Double(1.0)));
            if (!y_scale.isValid()) {
                if (d.drawing()) {
                    d.error("Invalid Y scale (missed DAxis.P_MIN and P_MAX properties ?)", rpd);
                }
                return;
            }
            DefaultChartRender3D.renderXYAxis3D(false, d, view, p.bbox, p.y_axis, y_scale, p.y_axis_style, x_incr, y_incr, z_incr, false, insets);
        }
        view.scaleTo(rpd.ag_rect.x() + insets.getL(), rpd.ag_rect.y() + insets.getT(), rpd.ag_rect.w() - insets.getW(), rpd.ag_rect.h() - insets.getH());
        Vector3D view_vector = view.getViewVector(null);
        view_vector.normalize();
        if (d.drawing()) {
            DefaultChartRender3D.drawBox3D(d, view, p.bbox, x_incr, y_incr, z_incr, false);
        }
        if (p.x_axis != null) {
            DefaultChartRender3D.renderXYAxis3D(true, d, view, p.bbox, p.x_axis, x_scale, p.x_axis_style, x_incr, y_incr, z_incr, false, null);
        }
        if (p.y_axis != null) {
            DefaultChartRender3D.renderXYAxis3D(false, d, view, p.bbox, p.y_axis, y_scale, p.y_axis_style, x_incr, y_incr, z_incr, false, null);
        }
        if (p.z_axis != null) {
            DefaultChartRender3D.renderZAxis3D(d, view, p.bbox, p.z_axis, z_scale, p.z_axis_style, x_incr, y_incr, z_incr, false, null);
        }
        DefaultChartRenderXYSurface.renderZMap(z_scale, d, rpd, p, x_incr, y_incr, z_incr, view, view_vector, h);
        if (d.drawing()) {
            DefaultChartRender3D.drawBox3D(d, view, p.bbox, x_incr, y_incr, z_incr, true);
        }
        if (p.x_axis != null) {
            DefaultChartRender3D.renderXYAxis3D(true, d, view, p.bbox, p.x_axis, x_scale, p.x_axis_style, x_incr, y_incr, z_incr, true, null);
        }
        if (p.y_axis != null) {
            DefaultChartRender3D.renderXYAxis3D(false, d, view, p.bbox, p.y_axis, y_scale, p.y_axis_style, x_incr, y_incr, z_incr, true, null);
        }
        if (p.z_axis != null) {
            DefaultChartRender3D.renderZAxis3D(d, view, p.bbox, p.z_axis, z_scale, p.z_axis_style, x_incr, y_incr, z_incr, true, null);
        }
    }

    private static H3D rebuildPersistData(DefaultChartRenderData d, RenderPersistData rpd) {
        H3D p = new H3D();
        rpd.g = p;
        p.z_axis = null;
        p.surface = null;
        int missing = 4;
        IDItem item = rpd.graphic.getFirstChild();
        while (item != null) {
            if (item instanceof DAxis) {
                String name = ((DAxis)item).getName();
                if ("x".equals(name) && p.x_axis == null) {
                    p.x_axis = (DAxis)item;
                    --missing;
                }
                if ("y".equals(name) && p.y_axis == null) {
                    p.y_axis = (DAxis)item;
                    --missing;
                }
                if ("z".equals(name) && p.z_axis == null) {
                    p.z_axis = (DAxis)item;
                    --missing;
                }
            } else if (item instanceof IXYSurface && p.surface == null) {
                p.surface = (IXYSurface)((Object)item);
                --missing;
            }
            if (missing == 0) break;
            item = item.getNext();
        }
        if (p.x_axis != null) {
            p.x_axis_style = new IGCDStyle(p.x_axis);
        }
        if (p.y_axis != null) {
            p.y_axis_style = new IGCDStyle(p.y_axis);
        }
        if (p.z_axis != null) {
            p.z_axis_style = new IGCDStyle(p.z_axis);
        }
        p.loc_item = p.surface instanceof IDItem ? (IDItem)((Object)p.surface) : rpd.graphic;
        return p;
    }

    private static IXYSurfaceColorizer getDefaultColorizer() {
        if (default_colorizer_ == null) {
            default_colorizer_ = new IXYSurfaceColorizer(){
                GradientGenerator gg = new GradientGenerator(new int[]{-16776961, -65281, 0xFF00FF});

                public int getRGBA(double x, double y, double z, double cos_angle) {
                    return this.gg.getRGBA(z);
                }

                public boolean isApplyShadow() {
                    return true;
                }
            };
        }
        return default_colorizer_;
    }

    private static void renderZMap(IScale scale, DefaultChartRenderData d, RenderPersistData rpd, H3D p, boolean x_incr, boolean y_incr, boolean z_incr, View3D view, Vector3D view_vector, double H) throws DefaultRenderChartLocation {
        PrivPolygon p2;
        PrivPolygon p1;
        int poly_type;
        int icrvL;
        int icrvI;
        int icrvX;
        int icrv0;
        int icrv_last;
        IXYSurface surf = p.surface;
        int size_x = surf.getSizeX();
        int size_y = surf.getSizeY();
        if (y_incr) {
            icrv_last = 0;
            icrv0 = 1;
            icrvX = size_y;
            icrvI = 1;
            icrvL = icrvX - 1;
        } else {
            icrv_last = size_y - 1;
            icrv0 = icrv_last - 1;
            icrvX = -1;
            icrvI = -1;
            icrvL = 0;
        }
        int lines_rgba = 255;
        if (d.drawing() && p.contour_line <= 0.0) {
            d.gc_.setPen(new LineStylePen(lines_rgba));
        }
        Point2D p00 = new Point2D();
        Point2D p01 = new Point2D();
        Point2D p10 = new Point2D();
        Point2D p11 = new Point2D();
        if (x_incr) {
            if (y_incr) {
                poly_type = 1;
                p1 = new PrivPolygon(p00, p10, p01);
                p2 = new PrivPolygon(p01, p10, p11);
            } else {
                poly_type = 2;
                p1 = new PrivPolygon(p01, p11, p00);
                p2 = new PrivPolygon(p00, p11, p10);
            }
        } else if (y_incr) {
            poly_type = 3;
            p1 = new PrivPolygon(p10, p00, p11);
            p2 = new PrivPolygon(p11, p00, p01);
        } else {
            poly_type = 4;
            p1 = new PrivPolygon(p11, p01, p10);
            p2 = new PrivPolygon(p10, p01, p00);
        }
        String prop = rpd.graphic.getProperties().get("P_XYS_COLORIZER.DGraphic.core.jscrib", null);
        IXYSurfaceColorizer clr = null;
        clr = prop instanceof IXYSurfaceColorizer ? (IXYSurfaceColorizer)((Object)prop) : DefaultChartRenderXYSurface.getDefaultColorizer();
        Vector3D normal = new Vector3D();
        int lines_x = rpd.graphic.getProperties().get("P_XYS_LINE_X.DGraphic.core.jscrib", 0);
        int lines_y = rpd.graphic.getProperties().get("P_XYS_LINE_Y.DGraphic.core.jscrib", 0);
        boolean lines_enabled = d.drawing() && (lines_x > 0 || lines_y > 0);
        boolean apply_shadow = clr.isApplyShadow();
        new LineStylePen();
        VDouble vcz = new VDouble();
        VDouble vlz = new VDouble();
        boolean do_line_x = false;
        boolean do_line_y = false;
        int icrv = icrv0;
        while (icrv != icrvX) {
            int iptL;
            int iptI;
            int iptX;
            int ipt0;
            double ly = (double)icrv_last / (double)(size_y - 1);
            double cy = (double)icrv / (double)(size_y - 1);
            if (x_incr) {
                ipt0 = 0;
                iptX = size_x;
                iptI = 1;
                iptL = size_x - 1;
            } else {
                ipt0 = size_x - 1;
                iptX = -1;
                iptI = -1;
                iptL = 0;
            }
            if (lines_y > 0) {
                do_line_y = icrv % lines_y == 0;
            }
            double lx = 0.0;
            double lzly = 0.0;
            double lzcy = 0.0;
            int ipt = ipt0;
            while (ipt != iptX) {
                double cx = (double)ipt / (double)(size_x - 1);
                vlz.setValue(surf.getZ(ipt, icrv_last));
                vcz.setValue(surf.getZ(ipt, icrv));
                double czly = scale.toScale(vlz);
                double czcy = scale.toScale(vcz);
                view.projection(cx, ly, czly, p10);
                view.projection(cx, cy, czcy, p11);
                if (lines_x > 0) {
                    boolean bl = do_line_x = ipt % lines_x == 0;
                }
                if (ipt != ipt0) {
                    int rgba = 0;
                    double cos_angle = 0.0;
                    if (d.drawing()) {
                        double ctrx = (lx + cx) / 2.0;
                        double ctry = (ly + cy) / 2.0;
                        double ctrz = (lzly + czly + lzcy + czcy) / 4.0;
                        normal.vectorialProduct(0.0, cy - ly, lzcy - lzly, cx - lx, 0.0, czcy - lzcy);
                        normal.normalize();
                        cos_angle = Vector3D.Scalar(normal, view_vector);
                        rgba = clr.getRGBA(ctrx, ctry, ctrz / H, cos_angle);
                        if (apply_shadow) {
                            rgba = RGBA.Shadow(rgba, p.shadow, p.light, (float)Math.abs(cos_angle));
                        }
                    }
                    switch (poly_type) {
                        case 1: {
                            DefaultChartRenderXYSurface.renderPolygon(d, p, p1, lx, ly, lzly, cx, ly, czly, lx, cy, lzcy, normal, view_vector, view, H, apply_shadow, rgba, cos_angle);
                            DefaultChartRenderXYSurface.renderPolygon(d, p, p2, lx, cy, lzcy, cx, ly, czly, cx, cy, czcy, normal, view_vector, view, H, apply_shadow, rgba, cos_angle);
                            break;
                        }
                        case 2: {
                            DefaultChartRenderXYSurface.renderPolygon(d, p, p1, lx, cy, lzcy, cx, cy, czcy, lx, ly, lzly, normal, view_vector, view, H, apply_shadow, rgba, cos_angle);
                            DefaultChartRenderXYSurface.renderPolygon(d, p, p2, lx, ly, lzly, cx, cy, czcy, cx, ly, czly, normal, view_vector, view, H, apply_shadow, rgba, cos_angle);
                            break;
                        }
                        case 3: {
                            DefaultChartRenderXYSurface.renderPolygon(d, p, p1, cx, ly, czly, lx, ly, lzly, cx, cy, czcy, normal, view_vector, view, H, apply_shadow, rgba, cos_angle);
                            DefaultChartRenderXYSurface.renderPolygon(d, p, p2, cx, cy, czcy, lx, ly, lzly, lx, cy, lzcy, normal, view_vector, view, H, apply_shadow, rgba, cos_angle);
                            break;
                        }
                        case 4: {
                            DefaultChartRenderXYSurface.renderPolygon(d, p, p1, cx, cy, czcy, lx, cy, lzcy, cx, ly, czly, normal, view_vector, view, H, apply_shadow, rgba, cos_angle);
                            DefaultChartRenderXYSurface.renderPolygon(d, p, p2, cx, ly, czly, lx, cy, lzcy, lx, ly, lzly, normal, view_vector, view, H, apply_shadow, rgba, cos_angle);
                        }
                    }
                    if (lines_enabled) {
                        if (p.contour_line > 0.0) {
                            d.gc_.setPen(new LineStylePen(lines_rgba));
                        }
                        if (do_line_x) {
                            d.gc_.drawLine((int)p00.getX(), (int)p00.getY(), (int)p01.getX(), (int)p01.getY());
                        }
                        if (do_line_y) {
                            d.gc_.drawLine((int)p00.getX(), (int)p00.getY(), (int)p10.getX(), (int)p10.getY());
                        }
                        if (ipt == iptL && do_line_y) {
                            d.gc_.drawLine((int)p01.getX(), (int)p01.getY(), (int)p11.getX(), (int)p11.getY());
                        }
                        if (icrv == icrvL && do_line_x) {
                            d.gc_.drawLine((int)p10.getX(), (int)p10.getY(), (int)p11.getX(), (int)p11.getY());
                        }
                    }
                }
                p00.setPoint(p10);
                p01.setPoint(p11);
                lx = cx;
                lzcy = czcy;
                lzly = czly;
                ipt += iptI;
            }
            icrv_last = icrv;
            icrv += icrvI;
        }
    }

    private static boolean haveLevelZ(double lz, double x1, double y1, double z1, double x2, double y2, double z2, Point3D res) {
        double zx;
        double zn;
        if (z1 == z2) {
            return false;
        }
        if (z1 <= z2) {
            zn = z1;
            zx = z2;
        } else {
            zn = z2;
            zx = z1;
        }
        if (lz < zn || lz > zx) {
            return false;
        }
        double k = (lz - z1) / (z2 - z1);
        double x = x1 + k * (x2 - x1);
        double y = y1 + k * (y2 - y1);
        res.setCoord(x, y, lz);
        return true;
    }

    private static void renderPolygon(DefaultChartRenderData d, H3D p, PrivPolygon poly, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, Vector3D normal, Vector3D view_vector, View3D view, double H, boolean apply_shadow, int rgba, double cos_angle) throws DefaultRenderChartLocation {
        poly.update();
        if (d.drawing()) {
            if (p.draw_polygon) {
                if (brush == null) {
                    brush = new SolidBrush();
                }
                brush.setRGBA(rgba);
                d.gc_.setBrush(brush);
                d.gc_.fillPoly(poly);
            }
            if (p.contour_line > 0.0) {
                if (p.contour_line_colorizer == null) {
                    pen.setRGBA(p.contour_line_rgba);
                    d.gc_.setPen(pen);
                }
                double zn = z1;
                double zx = z1;
                if (z2 < zn) {
                    zn = z2;
                } else if (z2 > zx) {
                    zx = z2;
                }
                if (z3 < zn) {
                    zn = z3;
                } else if (z3 > zx) {
                    zx = z3;
                }
                double lz = 0.0;
                while (lz < zn) {
                    lz += p.contour_line;
                }
                while (lz <= zx) {
                    boolean both = false;
                    if (DefaultChartRenderXYSurface.haveLevelZ(lz, x1, y1, z1, x2, y2, z2, rp0)) {
                        if (DefaultChartRenderXYSurface.haveLevelZ(lz, x1, y1, z1, x3, y3, z3, rp1) || DefaultChartRenderXYSurface.haveLevelZ(lz, x2, y2, z2, x3, y3, z3, rp1)) {
                            both = true;
                        }
                    } else if (DefaultChartRenderXYSurface.haveLevelZ(lz, x2, y2, z2, x3, y3, z3, rp0) && DefaultChartRenderXYSurface.haveLevelZ(lz, x1, y1, z1, x3, y3, z3, rp1)) {
                        both = true;
                    }
                    if (both) {
                        if (p.contour_line_colorizer != null) {
                            pen.setRGBA(p.contour_line_colorizer.getRGBA(rp0.getX(), rp0.getY(), lz, cos_angle));
                            d.gc_.setPen(pen);
                        }
                        if (p.projected_contour_line) {
                            view.projection(rp0.getX(), rp0.getY(), p.zproj_contour_line, rpp0);
                            view.projection(rp1.getX(), rp1.getY(), p.zproj_contour_line, rpp1);
                        } else {
                            view.projection(rp0.getX(), rp0.getY(), rp0.getZ(), rpp0);
                            view.projection(rp1.getX(), rp1.getY(), rp1.getZ(), rpp1);
                        }
                        d.gc_.drawLine((int)rpp0.getX(), (int)rpp0.getY(), (int)rpp1.getX(), (int)rpp1.getY());
                    }
                    lz += p.contour_line;
                }
            }
        } else if (poly.contains(d.lx_, d.ly_)) {
            String loc_id = "CurvePoint";
            throw new DefaultRenderChartLocation(loc_id, p.loc_item, new Rect(d.lx_, d.ly_, 0, 0));
        }
    }

    private static void drawNormalVector(IGC gc, Vector3D normal, double sx, double sy, double sz, View3D view, int rgba) {
        Point2D pt1 = new Point2D();
        Point2D pt2 = new Point2D();
        view.projection(sx, sy, sz, pt1);
        normal.normalize();
        float k = 0.2f;
        view.projection(sx + (double)k * normal.getX(), sy + (double)k * normal.getY(), sz + (double)k * normal.getZ(), pt2);
        pen.setRGBA(rgba);
        IPen ppp = gc.setPen(pen);
        gc.drawLine((int)pt1.getX(), (int)pt1.getY(), (int)pt2.getX(), (int)pt2.getY());
        gc.setPen(ppp);
    }

    static class H3D
    implements IDisposable {
        DAxis z_axis;
        DAxis x_axis;
        DAxis y_axis;
        IGCDStyle z_axis_style;
        IGCDStyle x_axis_style;
        IGCDStyle y_axis_style;
        Box3D bbox;
        float shadow;
        float light;
        IXYSurface surface;
        IDItem loc_item;
        double contour_line;
        boolean contour_line_z_axis;
        int contour_line_rgba;
        IXYSurfaceColorizer contour_line_colorizer;
        boolean projected_contour_line;
        double zproj_contour_line;
        boolean draw_polygon;

        H3D() {
        }

        public void dispose() {
        }
    }

    private static class PrivPolygon
    extends Polygon {
        Point2D p0;
        Point2D p1;
        Point2D p2;

        public PrivPolygon(Point2D pt0, Point2D pt1, Point2D pt2) {
            super(4);
            this.p0 = pt0;
            this.p1 = pt1;
            this.p2 = pt2;
        }

        public int getPolySize() {
            return 3;
        }

        public int getPolyX(int index) {
            switch (index) {
                case 0: {
                    return (int)this.p0.getX();
                }
                case 1: {
                    return (int)this.p1.getX();
                }
                case 2: {
                    return (int)this.p2.getX();
                }
                case 4: {
                    return (int)this.p0.getX();
                }
            }
            return 0;
        }

        public int getPolyY(int index) {
            switch (index) {
                case 0: {
                    return (int)this.p0.getY();
                }
                case 1: {
                    return (int)this.p1.getY();
                }
                case 2: {
                    return (int)this.p2.getY();
                }
                case 4: {
                    return (int)this.p0.getY();
                }
            }
            return 0;
        }

        public boolean isPolyClosed() {
            return true;
        }

        public IShape copyShape() {
            return null;
        }

        public void update() {
            this.points_xy_[0] = (int)this.p0.getX();
            this.points_xy_[1] = (int)this.p0.getY();
            this.points_xy_[2] = (int)this.p1.getX();
            this.points_xy_[3] = (int)this.p1.getY();
            this.points_xy_[4] = (int)this.p2.getX();
            this.points_xy_[5] = (int)this.p2.getY();
            this.points_xy_[6] = this.points_xy_[0];
            this.points_xy_[7] = this.points_xy_[1];
        }

        public IRect getBounds() {
            return null;
        }
    }
}

