/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.internal;

import org.eclipse.tptp.platform.report.chart.internal.Box3D;
import org.eclipse.tptp.platform.report.chart.internal.CurveStyle;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRender3D;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderData;
import org.eclipse.tptp.platform.report.chart.internal.DefaultRenderChartLocation;
import org.eclipse.tptp.platform.report.chart.internal.ICoordTransformation;
import org.eclipse.tptp.platform.report.chart.internal.IScale;
import org.eclipse.tptp.platform.report.chart.internal.MinMax;
import org.eclipse.tptp.platform.report.chart.internal.RenderPersistData;
import org.eclipse.tptp.platform.report.chart.internal.View3D;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.IDCoord;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drawutil.internal.DrawUtilIGC;
import org.eclipse.tptp.platform.report.drawutil.internal.HSV;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.drawutil.internal.Point2D;
import org.eclipse.tptp.platform.report.drawutil.internal.Point3D;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.SolidBrush;
import org.eclipse.tptp.platform.report.tools.internal.IDisposable;

public class DefaultChartRenderXYZ {
    private static final int XProj = 1;
    private static final int YProj = 2;
    private static final int ZProj = 3;
    private static final int Curve = 4;
    private static final int Finished = 5;
    private static final int AxisX = 1;
    private static final int AxisY = 2;
    private static final int AxisZ = 3;
    private static ForceCoord force_coord = new ForceCoord();
    private static ForceCoord force_coord2 = new ForceCoord();

    /*
     * Enabled aggressive block sorting
     */
    public static void render(DefaultChartRenderData d, RenderPersistData rpd) throws DefaultRenderChartLocation {
        boolean display_decorations = true;
        XYZ p = null;
        if (rpd.g instanceof XYZ) {
            p = (XYZ)rpd.g;
        }
        if (p == null) {
            p = DefaultChartRenderXYZ.rebuildPersistData(d, rpd, display_decorations);
        }
        if (p.x_axis == null || p.y_axis == null || p.z_axis == null) {
            if (d.drawing()) {
                String txt = "Error: missing ";
                boolean comma = false;
                if (p.x_axis == null) {
                    txt = String.valueOf(txt) + "'x'";
                    comma = true;
                }
                if (p.y_axis == null) {
                    if (comma) {
                        txt = String.valueOf(txt) + ", ";
                    }
                    txt = String.valueOf(txt) + "'y'";
                    comma = true;
                }
                if (p.y_axis == null) {
                    if (comma) {
                        txt = String.valueOf(txt) + ", ";
                    }
                    txt = String.valueOf(txt) + "'z'";
                    comma = true;
                }
                txt = String.valueOf(txt) + " axis";
                d.error(txt, rpd);
            }
            return;
        }
        double phi = rpd.graphic.getProperties().get("P_XYZ_PHI.DGraphic.core.jscrib", 0.3);
        double theta = rpd.graphic.getProperties().get("P_XYZ_THETA.DGraphic.core.jscrib", 0.2);
        View3D view = new View3D(phi, theta, 0.0, 1.0, p.bbox);
        int rg_w = rpd.ag_rect.w();
        int rg_h = rpd.ag_rect.h();
        view.scaleTo(rpd.ag_rect.x(), rpd.ag_rect.y(), rg_w, rg_h);
        int min_w_h = rg_w;
        if (min_w_h > rg_h) {
            min_w_h = rg_h;
        }
        double x_proj = p.bbox.getXMin();
        double y_proj = p.bbox.getYMin();
        double z_proj = p.bbox.getZMin();
        LineStylePen pen = new LineStylePen();
        if (display_decorations) {
            if (d.drawing()) {
                pen.setRGBA(-1061109505);
                d.gc_.setPen(pen);
                DefaultChartRenderXYZ.drawBox3D(d, view, p.bbox);
            }
            DefaultChartRenderXYZ.renderAnAxis3D(d, view, p.bbox, p.x_axis, p.x_scale, p.x_axis_style, 1);
            DefaultChartRenderXYZ.renderAnAxis3D(d, view, p.bbox, p.y_axis, p.y_scale, p.y_axis_style, 2);
            DefaultChartRenderXYZ.renderAnAxis3D(d, view, p.bbox, p.z_axis, p.z_scale, p.z_axis_style, 3);
        }
        CurveStyle ccurve = null;
        CurveStyle p_ccurve = null;
        double last_x = 0.0;
        double last_y = 0.0;
        int background_color = rpd.g_style.getBack();
        HSV bhsv = new HSV(background_color);
        boolean do_xproj = rpd.graphic.getProperties().get("P_XYZ_XPROJ.DGraphic.core.jscrib", true);
        boolean do_yproj = rpd.graphic.getProperties().get("P_XYZ_YPROJ.DGraphic.core.jscrib", true);
        boolean do_zproj = rpd.graphic.getProperties().get("P_XYZ_ZPROJ.DGraphic.core.jscrib", true);
        Point2D pt = new Point2D();
        Object vp = null;
        Point3D p3c = new Point3D();
        Point3D p3l = new Point3D();
        int proj_color = 0;
        int ic = 0;
        while (ic < rpd.curve_styles.length) {
            ccurve = rpd.curve_styles[ic];
            int what = 1;
            if (display_decorations && d.drawing()) {
                proj_color = RGBA.Lighter(ccurve.style_.getBack(), 0.75f);
                HSV hsv = new HSV(proj_color);
                int ecart = Math.abs(bhsv.getV() - hsv.getV()) + Math.abs(bhsv.getS() - hsv.getS()) >> 1;
                if (ecart < 20) {
                    proj_color = RGBA.Darker(ccurve.style_.getBack(), 0.5f);
                }
                pen.setRGBA(proj_color);
                d.gc_.setPen(pen);
                what = 1;
            } else {
                what = 4;
            }
            block7: while (what < 5) {
                view.resetCoordTransformation();
                switch (what) {
                    case 1: {
                        if (!do_xproj) {
                            what = 2;
                            continue block7;
                        }
                        DefaultChartRenderXYZ.force_coord.value_ = x_proj;
                        view.setXCoordTransformation(force_coord);
                        what = 2;
                        break;
                    }
                    case 2: {
                        if (!do_yproj) {
                            what = 3;
                            continue block7;
                        }
                        DefaultChartRenderXYZ.force_coord.value_ = y_proj;
                        view.setYCoordTransformation(force_coord);
                        what = 3;
                        break;
                    }
                    case 3: {
                        if (!do_zproj) {
                            what = 4;
                            continue block7;
                        }
                        DefaultChartRenderXYZ.force_coord.value_ = z_proj;
                        view.setZCoordTransformation(force_coord);
                        what = 4;
                        break;
                    }
                    case 4: {
                        if (d.drawing()) {
                            pen.setRGBA(ccurve.style_.getBack());
                            d.gc_.setPen(pen);
                        }
                        what = 5;
                    }
                }
                boolean first = true;
                DPoint curr_curve_prev_point = null;
                DPoint prev_curve_curr_point = null;
                if (p.is_wireframe && p_ccurve != null) {
                    IDItem it = p_ccurve.curve_.getFirstChild();
                    while (it != null) {
                        if (!(it instanceof DPoint)) {
                            it = it.getNext();
                            continue;
                        }
                        prev_curve_curr_point = (DPoint)it;
                        break;
                    }
                }
                IDItem item = ccurve.curve_.getFirstChild();
                while (item != null) {
                    if (item instanceof DPoint) {
                        DPoint curr_curve_curr_point = (DPoint)item;
                        if (DefaultChartRenderXYZ.getPoint(curr_curve_curr_point, p, vp, p3c)) {
                            view.projection(p3c.getX(), p3c.getY(), p3c.getZ(), pt);
                            double p_x = pt.getX();
                            double p_y = pt.getY();
                            if (first) {
                                first = false;
                            } else if (d.drawing()) {
                                d.gc_.drawLine((int)last_x, (int)last_y, (int)p_x, (int)p_y);
                            } else if (what == 5 && DrawUtilIGC.segmentContains((int)last_x, (int)last_y, (int)p_x, (int)p_y, d.lx_, d.ly_)) {
                                DefaultRenderChartLocation loc = new DefaultRenderChartLocation("CurveLine", curr_curve_curr_point, new Rect((int)p_x, (int)p_y, (int)(last_x - p_x), (int)(last_y - p_y)));
                                loc.setPreviousPoint(curr_curve_prev_point);
                                throw loc;
                            }
                            last_x = p_x;
                            last_y = p_y;
                            if (DefaultChartRenderXYZ.getPoint(prev_curve_curr_point, p, vp, p3l)) {
                                view.projection(p3l.getX(), p3l.getY(), p3l.getZ(), pt);
                                double p_p_x = pt.getX();
                                double p_p_y = pt.getY();
                                if (d.drawing()) {
                                    d.gc_.drawLine((int)p_x, (int)p_y, (int)p_p_x, (int)p_p_y);
                                } else if (what == 5 && DrawUtilIGC.segmentContains((int)p_x, (int)p_y, (int)p_p_x, (int)p_p_y, d.lx_, d.ly_)) {
                                    DefaultRenderChartLocation loc = new DefaultRenderChartLocation("CurveLine", prev_curve_curr_point, new Rect((int)p_x, (int)p_y, (int)(p_p_x - p_x), (int)(p_p_y - p_y)));
                                    loc.setPreviousPoint(curr_curve_curr_point);
                                    throw loc;
                                }
                                IDItem it = prev_curve_curr_point.getNext();
                                while (it != null) {
                                    if (!(it instanceof DPoint)) {
                                        it = it.getNext();
                                        continue;
                                    }
                                    prev_curve_curr_point = (DPoint)it;
                                    break;
                                }
                            }
                        }
                        curr_curve_prev_point = curr_curve_curr_point;
                    }
                    item = item.getNext();
                }
            }
            p_ccurve = ccurve;
            ++ic;
        }
    }

    private static XYZ rebuildPersistData(DefaultChartRenderData d, RenderPersistData rpd, boolean display_decorations) {
        XYZ p = new XYZ();
        rpd.g = p;
        p.is_wireframe = rpd.graphic.isRenderableId("T_WIREFRAME.DGraphic.core.jscrib");
        p.x_axis = null;
        p.y_axis = null;
        p.z_axis = null;
        int axis_missed = 3;
        IDItem item = rpd.graphic.getFirstChild();
        while (item != null) {
            if (item instanceof DAxis) {
                DAxis axis = (DAxis)item;
                if (p.x_axis == null && "x".equals(axis.getName())) {
                    p.x_axis = axis;
                    --axis_missed;
                } else if (p.y_axis == null & "y".equals(axis.getName())) {
                    p.y_axis = axis;
                    --axis_missed;
                } else if (p.z_axis == null & "z".equals(axis.getName())) {
                    p.z_axis = axis;
                    --axis_missed;
                }
                if (axis_missed == 0) break;
            }
            item = item.getNext();
        }
        if (axis_missed != 0) {
            return p;
        }
        p.x_axis_style = new IGCDStyle(p.x_axis, d.scale_);
        p.y_axis_style = new IGCDStyle(p.y_axis, d.scale_);
        p.z_axis_style = new IGCDStyle(p.z_axis, d.scale_);
        int max_font_h = 0;
        if (display_decorations) {
            d.gc_.setFont(p.x_axis_style.getFont());
            max_font_h = d.gc_.getFontMetrics().getHeight();
            d.gc_.setFont(p.y_axis_style.getFont());
            int hf = d.gc_.getFontMetrics().getHeight();
            if (max_font_h < hf) {
                max_font_h = hf;
            }
            d.gc_.setFont(p.z_axis_style.getFont());
            hf = d.gc_.getFontMetrics().getHeight();
            if (max_font_h < hf) {
                max_font_h = hf;
            }
            max_font_h = 2 * max_font_h + 6;
        }
        rpd.ag_rect.setRect(rpd.ag_rect.left() + max_font_h, rpd.ag_rect.top() + max_font_h, rpd.ag_rect.w() - 2 * max_font_h, rpd.ag_rect.h() - max_font_h);
        Object x_min = p.x_axis.getProperties().get("P_MIN.DAxis.core.jscrib");
        Object x_max = p.x_axis.getProperties().get("P_MAX.DAxis.core.jscrib");
        Object y_min = p.y_axis.getProperties().get("P_MIN.DAxis.core.jscrib");
        Object y_max = p.y_axis.getProperties().get("P_MAX.DAxis.core.jscrib");
        Object z_min = p.z_axis.getProperties().get("P_MIN.DAxis.core.jscrib");
        Object z_max = p.z_axis.getProperties().get("P_MAX.DAxis.core.jscrib");
        if (x_min == null || x_max == null || y_min == null || y_max == null || z_min == null || z_max == null) {
            MinMax x_mm = new MinMax(p.x_axis);
            MinMax y_mm = new MinMax(p.y_axis);
            MinMax z_mm = new MinMax(p.z_axis);
            int icrv = 0;
            while (icrv < rpd.curve_styles.length) {
                IDItem ip = rpd.curve_styles[icrv].curve_.getFirstChild();
                while (ip != null) {
                    IDItem ic = ip.getFirstChild();
                    while (ic != null) {
                        if (ic instanceof IDCoord) {
                            IDCoord coord = (IDCoord)((Object)ic);
                            DAxis axis = coord.getAxis();
                            if (axis == p.x_axis) {
                                x_mm.update(coord);
                            } else if (axis == p.y_axis) {
                                y_mm.update(coord);
                            } else if (axis == p.z_axis) {
                                z_mm.update(coord);
                            }
                        }
                        ic = ic.getNext();
                    }
                    ip = ip.getNext();
                }
                ++icrv;
            }
            if (x_min == null) {
                x_min = x_mm.getVMin();
            }
            if (x_max == null) {
                x_max = x_mm.getVMax();
            }
            if (y_min == null) {
                y_min = y_mm.getVMin();
            }
            if (y_max == null) {
                y_max = y_mm.getVMax();
            }
            if (z_min == null) {
                z_min = z_mm.getVMin();
            }
            if (z_max == null) {
                z_max = z_mm.getVMax();
            }
        }
        if (p.x_axis.useNumbers() && p.y_axis.useNumbers() && p.z_axis.useNumbers() && p.x_axis.isScaleType("S_LIN.DAxis.core.jscrib") && p.y_axis.isScaleType("S_LIN.DAxis.core.jscrib") && p.z_axis.isScaleType("S_LIN.DAxis.core.jscrib")) {
            double xmin = ((Number)x_min).doubleValue();
            double xmax = ((Number)x_max).doubleValue();
            double ymin = ((Number)y_min).doubleValue();
            double ymax = ((Number)y_max).doubleValue();
            double zmin = ((Number)z_min).doubleValue();
            double zmax = ((Number)z_max).doubleValue();
            double kx = xmax - xmin;
            double ky = ymax - ymin;
            double kz = zmax - zmin;
            double k = Math.max(kx, Math.max(ky, kz));
            double x_smax = kx / k;
            double y_smax = ky / k;
            double z_smax = kz / k;
            p.x_scale = DefaultChartRenderData.getScale(p.x_axis, 0.0, x_smax, x_min, x_max);
            p.y_scale = DefaultChartRenderData.getScale(p.y_axis, 0.0, y_smax, y_min, y_max);
            p.z_scale = DefaultChartRenderData.getScale(p.z_axis, 0.0, z_smax, z_min, z_max);
        } else {
            p.x_scale = DefaultChartRenderData.getScale(p.x_axis, -1.0, 1.0, x_min, x_max);
            p.y_scale = DefaultChartRenderData.getScale(p.y_axis, -1.0, 1.0, y_min, y_max);
            p.z_scale = DefaultChartRenderData.getScale(p.z_axis, -1.0, 1.0, z_min, z_max);
        }
        p.bbox = new Box3D(p.x_scale.getScaleMin(), p.x_scale.getScaleMax(), p.y_scale.getScaleMin(), p.y_scale.getScaleMax(), p.z_scale.getScaleMin(), p.z_scale.getScaleMax());
        return p;
    }

    private static void drawBox3D(DefaultChartRenderData _d, View3D _view, Box3D _bb) {
        Point2D[] p = new Point2D[8];
        double xn = _bb.getXMin();
        double xx = _bb.getXMax();
        double yn = _bb.getYMin();
        double yx = _bb.getYMax();
        double zn = _bb.getZMin();
        double zx = _bb.getZMax();
        p[0] = _view.projection(xn, yn, zn, new Point2D());
        p[1] = _view.projection(xn, yn, zx, new Point2D());
        p[2] = _view.projection(xx, yn, zx, new Point2D());
        p[3] = _view.projection(xx, yn, zn, new Point2D());
        p[4] = _view.projection(xn, yx, zx, new Point2D());
        p[5] = _view.projection(xx, yx, zx, new Point2D());
        p[6] = _view.projection(xx, yx, zn, new Point2D());
        p[7] = _view.projection(xn, yx, zn, new Point2D());
        _d.gc_.drawLine((int)p[0].getX(), (int)p[0].getY(), (int)p[1].getX(), (int)p[1].getY());
        _d.gc_.drawLine((int)p[0].getX(), (int)p[0].getY(), (int)p[3].getX(), (int)p[3].getY());
        _d.gc_.drawLine((int)p[0].getX(), (int)p[0].getY(), (int)p[7].getX(), (int)p[7].getY());
        _d.gc_.drawLine((int)p[2].getX(), (int)p[2].getY(), (int)p[1].getX(), (int)p[1].getY());
        _d.gc_.drawLine((int)p[2].getX(), (int)p[2].getY(), (int)p[3].getX(), (int)p[3].getY());
        _d.gc_.drawLine((int)p[2].getX(), (int)p[2].getY(), (int)p[5].getX(), (int)p[5].getY());
        _d.gc_.drawLine((int)p[4].getX(), (int)p[4].getY(), (int)p[1].getX(), (int)p[1].getY());
        _d.gc_.drawLine((int)p[4].getX(), (int)p[4].getY(), (int)p[5].getX(), (int)p[5].getY());
        _d.gc_.drawLine((int)p[4].getX(), (int)p[4].getY(), (int)p[7].getX(), (int)p[7].getY());
        _d.gc_.drawLine((int)p[6].getX(), (int)p[6].getY(), (int)p[3].getX(), (int)p[3].getY());
        _d.gc_.drawLine((int)p[6].getX(), (int)p[6].getY(), (int)p[5].getX(), (int)p[5].getY());
        _d.gc_.drawLine((int)p[6].getX(), (int)p[6].getY(), (int)p[7].getX(), (int)p[7].getY());
    }

    private static void renderAnAxis3D(DefaultChartRenderData _d, View3D _view, Box3D _bb, DAxis _axis, IScale _scale, IGCDStyle _axis_style, int _axis_type) throws DefaultRenderChartLocation {
        String axis_title;
        int wt;
        int fh;
        Rect rtxt;
        double x_proj = _bb.getXMin();
        double x_proj2 = _bb.getXMax();
        double y_proj = _bb.getYMin();
        double y_proj2 = _bb.getYMax();
        double z_proj = _bb.getZMin();
        double z_proj2 = _bb.getZMax();
        Point2D p0 = new Point2D();
        Point2D p1 = new Point2D();
        Point2D p2 = new Point2D();
        LineStylePen pen = new LineStylePen();
        Object step = _axis.getProperties().get("P_STEP_LINE.DAxis.core.jscrib");
        if (_d.drawing() && step != null) {
            pen.setRGBA(_d.getLineColor(_axis));
            _d.gc_.setPen(pen);
            switch (_axis_type) {
                case 1: {
                    double v;
                    Object vs = _scale.stepFirst(step);
                    while (vs != null) {
                        v = _scale.toScale(vs);
                        _view.projection(v, y_proj2, z_proj, p0);
                        _view.projection(v, y_proj, z_proj, p1);
                        _view.projection(v, y_proj, z_proj2, p2);
                        _d.gc_.drawLine((int)p0.getX(), (int)p0.getY(), (int)p1.getX(), (int)p1.getY());
                        _d.gc_.drawLine((int)p2.getX(), (int)p2.getY(), (int)p1.getX(), (int)p1.getY());
                        vs = _scale.stepNext(step, vs);
                    }
                    break;
                }
                case 2: {
                    double v;
                    Object vs = _scale.stepFirst(step);
                    while (vs != null) {
                        v = _scale.toScale(vs);
                        _view.projection(x_proj2, v, z_proj, p0);
                        _view.projection(x_proj, v, z_proj, p1);
                        _view.projection(x_proj, v, z_proj2, p2);
                        _d.gc_.drawLine((int)p0.getX(), (int)p0.getY(), (int)p1.getX(), (int)p1.getY());
                        _d.gc_.drawLine((int)p2.getX(), (int)p2.getY(), (int)p1.getX(), (int)p1.getY());
                        vs = _scale.stepNext(step, vs);
                    }
                    break;
                }
                case 3: {
                    double v;
                    Object vs = _scale.stepFirst(step);
                    while (vs != null) {
                        v = _scale.toScale(vs);
                        _view.projection(x_proj2, y_proj, v, p0);
                        _view.projection(x_proj, y_proj, v, p1);
                        _view.projection(x_proj, y_proj2, v, p2);
                        _d.gc_.drawLine((int)p0.getX(), (int)p0.getY(), (int)p1.getX(), (int)p1.getY());
                        _d.gc_.drawLine((int)p2.getX(), (int)p2.getY(), (int)p1.getX(), (int)p1.getY());
                        vs = _scale.stepNext(step, vs);
                    }
                    break;
                }
            }
        }
        boolean have_step_unit = false;
        step = _axis.getProperties().get("P_STEP_UNIT.DAxis.core.jscrib");
        if (step != null) {
            have_step_unit = true;
            float d_angle = 0.0f;
            switch (_axis_type) {
                case 1: {
                    _view.projection(_bb.getXMin(), _bb.getYMin(), _bb.getZMin(), p0);
                    _view.projection(_bb.getXMax(), _bb.getYMin(), _bb.getZMin(), p1);
                    d_angle = 180.0f;
                    break;
                }
                case 2: {
                    _view.projection(_bb.getXMin(), _bb.getYMin(), _bb.getZMin(), p0);
                    _view.projection(_bb.getXMin(), _bb.getYMax(), _bb.getZMin(), p1);
                    d_angle = 0.0f;
                    break;
                }
                case 3: {
                    _view.projection(_bb.getXMin(), _bb.getYMin(), _bb.getZMin(), p0);
                    _view.projection(_bb.getXMin(), _bb.getYMin(), _bb.getZMax(), p1);
                    d_angle = 180.0f;
                }
            }
            float angle = (float)Math.atan2(p1.getY() - p0.getY(), p1.getX() - p0.getX());
            angle = (float)((double)(180.0f * angle) / Math.PI + (double)d_angle);
            if (_d.drawing()) {
                _d.gc_.setBrush(new SolidBrush(_axis_style.getFore()));
                _d.gc_.setFont(_axis_style.getFont());
            }
            rtxt = new Rect();
            fh = _d.gc_.getFontMetrics().getHeight();
            Object vs = _scale.stepFirst(step);
            while (vs != null) {
                double v = _scale.toScale(vs);
                switch (_axis_type) {
                    case 1: {
                        _view.projection(v, y_proj, z_proj2, p2);
                        break;
                    }
                    case 2: {
                        _view.projection(x_proj, v, z_proj2, p2);
                        break;
                    }
                    case 3: {
                        _view.projection(x_proj, y_proj2, v, p2);
                    }
                }
                String txt = _scale.valueText(vs);
                wt = _d.gc_.textExtent(txt).getW();
                rtxt.setRect(-wt / 2, -3 - fh, wt, fh);
                rtxt.moveBy((int)p2.getX(), (int)p2.getY());
                if (_d.drawing()) {
                    DrawUtilIGC.drawText(_d.gc_, rtxt, 36, txt);
                }
                vs = _scale.stepNext(step, vs);
            }
        }
        if (!DrawUtilIGC.isEmpty(axis_title = DefaultChartRender3D.axis3DName(_axis))) {
            String location = null;
            rtxt = new Rect();
            fh = _d.gc_.getFontMetrics().getHeight();
            switch (_axis_type) {
                case 1: {
                    _view.projection(_bb.getXMin(), y_proj, z_proj2, p0);
                    _view.projection(_bb.getXMax(), y_proj, z_proj2, p1);
                    location = "InAxisXTitle";
                    break;
                }
                case 2: {
                    _view.projection(x_proj, _bb.getYMin(), z_proj2, p0);
                    _view.projection(x_proj, _bb.getYMax(), z_proj2, p1);
                    location = "InAxisYTitle";
                    break;
                }
                case 3: {
                    _view.projection(x_proj, y_proj2, _bb.getZMin(), p0);
                    _view.projection(x_proj, y_proj2, _bb.getZMax(), p1);
                    location = "InAxisZTitle";
                }
            }
            double center_x = (p0.getX() + p1.getX()) / 2.0;
            double center_y = (p0.getY() + p1.getY()) / 2.0;
            wt = _d.gc_.textExtent(axis_title).getW();
            rtxt.setRect(-wt / 2, -6 - 2 * fh, wt, fh);
            rtxt.moveCenter((int)center_x, (int)center_y - (have_step_unit ? fh + 4 : 0) - 4);
            if (_d.drawing()) {
                DrawUtilIGC.drawText(_d.gc_, rtxt, 36, axis_title);
            } else if (rtxt.contains(_d.lx_, _d.ly_)) {
                throw new DefaultRenderChartLocation(location, _axis, rtxt);
            }
        }
    }

    private static boolean getPoint(DPoint point, XYZ p, Object vp, Point3D ret) {
        if (point == null) {
            return false;
        }
        int coords = 0;
        IDItem icd = point.getFirstChild();
        while (icd != null) {
            if (icd instanceof IDCoord) {
                IDCoord coord = (IDCoord)((Object)icd);
                DAxis axis = coord.getAxis();
                if (axis == p.x_axis && (coords & 1) == 0) {
                    vp = coord.getValue(vp);
                    ret.setX(p.x_scale.toScale(vp));
                    coords |= 1;
                } else if (axis == p.y_axis && (coords & 2) == 0) {
                    vp = coord.getValue(vp);
                    ret.setY(p.y_scale.toScale(vp));
                    coords |= 2;
                } else if (axis == p.z_axis && (coords & 4) == 0) {
                    vp = coord.getValue(vp);
                    ret.setZ(p.z_scale.toScale(vp));
                    coords |= 4;
                }
            }
            icd = icd.getNext();
        }
        return coords == 7;
    }

    private static class ForceCoord
    implements ICoordTransformation {
        public double value_ = 0.0;

        private ForceCoord() {
        }

        public double apply(double _f) {
            return this.value_;
        }
    }

    static class XYZ
    implements IDisposable {
        DAxis x_axis;
        DAxis y_axis;
        DAxis z_axis;
        IGCDStyle x_axis_style;
        IGCDStyle y_axis_style;
        IGCDStyle z_axis_style;
        IScale x_scale;
        IScale y_scale;
        IScale z_scale;
        Box3D bbox;
        boolean is_wireframe;

        XYZ() {
        }

        public void dispose() {
        }
    }
}

