/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.internal;

import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;

public class Insets {
    protected int left_;
    protected int right_;
    protected int top_;
    protected int bottom_;

    public Insets() {
        this.bottom_ = 0;
        this.top_ = 0;
        this.right_ = 0;
        this.left_ = 0;
    }

    public Insets(int i) {
        this.top_ = this.bottom_ = i;
        this.right_ = this.bottom_;
        this.left_ = this.bottom_;
    }

    public Insets(int _left, int _right, int _top, int _bottom) {
        this.left_ = _left;
        this.right_ = _right;
        this.top_ = _top;
        this.bottom_ = _bottom;
    }

    public int getL() {
        return this.left_;
    }

    public int getR() {
        return this.right_;
    }

    public int getT() {
        return this.top_;
    }

    public int getB() {
        return this.bottom_;
    }

    public int getW() {
        return this.left_ + this.right_;
    }

    public int getH() {
        return this.top_ + this.bottom_;
    }

    public boolean isEmpty() {
        return this.left_ == 0 && this.right_ == 0 && this.top_ == 0 && this.bottom_ == 0;
    }

    public void reset() {
        this.bottom_ = 0;
        this.top_ = 0;
        this.right_ = 0;
        this.left_ = 0;
    }

    public void setInsets(int _left, int _right, int _top, int _bottom) {
        this.left_ = _left;
        this.right_ = _right;
        this.top_ = _top;
        this.bottom_ = _bottom;
    }

    public void setInsets(int _len) {
        this.top_ = this.bottom_ = _len;
        this.right_ = this.bottom_;
        this.left_ = this.bottom_;
    }

    public void setL(int v) {
        this.left_ = v;
    }

    public void setR(int v) {
        this.right_ = v;
    }

    public void setT(int v) {
        this.top_ = v;
    }

    public void setB(int v) {
        this.bottom_ = v;
    }

    public void addL(int v) {
        this.left_ += v;
    }

    public void addR(int v) {
        this.right_ += v;
    }

    public void addT(int v) {
        this.top_ += v;
    }

    public void addB(int v) {
        this.bottom_ += v;
    }

    public void maxL(int v) {
        if (v > this.left_) {
            this.left_ = v;
        }
    }

    public void maxR(int v) {
        if (v > this.right_) {
            this.right_ = v;
        }
    }

    public void maxT(int v) {
        if (v > this.top_) {
            this.top_ = v;
        }
    }

    public void maxB(int v) {
        if (v > this.bottom_) {
            this.bottom_ = v;
        }
    }

    public void max(IRect base, IRect rect2) {
        int l1 = Rect.Left(base);
        int r1 = Rect.Right(base);
        int t1 = Rect.Top(base);
        int b1 = Rect.Bottom(base);
        int l2 = Rect.Left(rect2);
        int r2 = Rect.Right(rect2);
        int t2 = Rect.Top(rect2);
        int b2 = Rect.Bottom(rect2);
        if (l2 < l1) {
            this.maxL(l1 - l2);
        }
        if (r2 > r1) {
            this.maxR(r2 - r1);
        }
        if (t2 < t1) {
            this.maxT(t1 - t2);
        }
        if (b2 > b1) {
            this.maxB(b2 - b1);
        }
    }

    public String toString() {
        String s = String.valueOf(super.toString()) + "{l:" + this.left_ + ",r:" + this.right_ + ",t:" + this.top_ + ",b:" + this.bottom_ + "}";
        return s;
    }
}

