/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.internal;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.UFormat;
import com.ibm.icu.util.ULocale;
import org.eclipse.tptp.platform.report.chart.internal.IScale;
import org.eclipse.tptp.platform.report.tools.internal.VDouble;
import org.eclipse.tptp.platform.report.tools.internal.VNumber;

public class LinearNumberScale
implements IScale {
    protected double dmin_;
    protected double dmax_;
    protected double vmin_;
    protected double vmax_;
    protected double k_;
    protected boolean reverse_;
    protected UFormat format_;
    protected ULocale locale_;
    private boolean output_once = false;

    public LinearNumberScale(double dmin, double dmax, double vmin, double vmax) {
        this.dmin_ = dmin;
        this.dmax_ = dmax;
        this.reverse_ = false;
        this.setValueRange(vmin, vmax);
    }

    public LinearNumberScale(double dmin, double dmax, Object vmin, Object vmax) {
        this.dmin_ = dmin;
        this.dmax_ = dmax;
        this.reverse_ = false;
        this.setValueRange(vmin, vmax);
    }

    public void setValueRange(Object v1, Object v2) {
        this.vmin_ = -1.0;
        this.vmax_ = -2.0;
        this.k_ = Double.NaN;
        if (!(v1 instanceof Number)) {
            return;
        }
        if (!(v2 instanceof Number)) {
            return;
        }
        this.setValueRange(((Number)v1).doubleValue(), ((Number)v2).doubleValue());
    }

    public void setValueRange(double d1, double d2) {
        if (d1 < d2) {
            this.vmin_ = d1;
            this.vmax_ = d2;
        } else {
            this.vmin_ = d2;
            this.vmax_ = d1;
        }
        this.k_ = this.vmax_ == this.vmin_ ? Double.NaN : (this.dmax_ - this.dmin_) / (this.vmax_ - this.vmin_);
    }

    public boolean isValid() {
        return this.vmin_ < this.vmax_;
    }

    public void setTextFormat(UFormat _format) {
        this.format_ = _format;
    }

    public String valueText(Object _value) {
        Number number = null;
        if (!(_value instanceof Number)) {
            return null;
        }
        number = (Number)_value;
        if (this.format_ == null) {
            NumberFormat f = this.locale_ == null ? NumberFormat.getInstance() : NumberFormat.getInstance((ULocale)this.locale_);
            f.setMaximumFractionDigits(2);
            f.setMinimumFractionDigits(2);
            this.format_ = f;
        }
        try {
            String txt = this.format_.format(_value);
            return txt;
        }
        catch (IllegalArgumentException e) {
            if (!this.output_once) {
                System.err.println("For object's class =" + (_value == null ? null : number.getClass().getName()));
                e.printStackTrace();
                this.output_once = true;
            }
            return null;
        }
    }

    public void setReversed(boolean b) {
        this.reverse_ = b;
    }

    public boolean isReversed() {
        return this.reverse_;
    }

    public Object getValueMax(Object _value) {
        if (_value instanceof VNumber) {
            return ((VNumber)_value).setValue(this.vmax_);
        }
        return new VDouble(this.vmax_);
    }

    public Object getValueMin(Object _value) {
        if (_value instanceof VNumber) {
            return ((VNumber)_value).setValue(this.vmin_);
        }
        return new VDouble(this.vmin_);
    }

    public double getScaleMin() {
        return this.dmin_;
    }

    public double getScaleMax() {
        return this.dmax_;
    }

    public double toScale(Object _value) {
        if (!(_value instanceof Number)) {
            return -1.0;
        }
        return this.toScale(((Number)_value).doubleValue());
    }

    public double toScale(double _value) {
        double dbl = this.reverse_ ? this.dmin_ + this.k_ * (_value - this.vmin_) : this.dmin_ + this.k_ * (_value - this.vmin_);
        return dbl;
    }

    public Object toValue(double dbl, Object _value) {
        double val = this.reverse_ ? this.vmin_ + (this.dmax_ - dbl) / this.k_ : this.vmin_ + (dbl - this.dmin_) / this.k_;
        if (_value instanceof VDouble) {
            return ((VDouble)_value).setValue(val);
        }
        return new VDouble(val);
    }

    public void setScaleRange(double dmin, double dmax) {
        this.dmin_ = dmin;
        this.dmax_ = dmax;
        this.k_ = this.vmax_ == this.vmin_ ? Double.NaN : (this.dmax_ - this.dmin_) / (this.vmax_ - this.vmin_);
    }

    public Object stepFirst(Object _step) {
        double step = -1.0;
        if (_step instanceof Number) {
            step = ((Number)_step).doubleValue();
        }
        if (step <= 0.0) {
            return null;
        }
        double vdn = Math.ceil(this.vmin_ / step);
        if (Math.abs(vdn) < 1.0E-6) {
            vdn = 0.0;
        }
        return new VDouble(vdn *= step);
    }

    public Object stepNext(Object _step, Object _last) {
        double step = -1.0;
        if (_step instanceof Number) {
            step = ((Number)_step).doubleValue();
        }
        if (!(_last instanceof VDouble)) {
            return null;
        }
        VDouble v_last = (VDouble)_last;
        double next = v_last.doubleValue() + step;
        if (next > this.vmax_) {
            return null;
        }
        v_last.setValue(next);
        return v_last;
    }

    public double getScaleForBar() {
        if (this.vmin_ >= 0.0) {
            return this.dmin_;
        }
        if (this.vmax_ <= 0.0) {
            return this.dmax_;
        }
        return this.toScale(0.0);
    }

    public String toString() {
        return String.valueOf(super.toString()) + "{pixels=" + this.dmin_ + ".." + this.dmax_ + ", range=" + this.vmin_ + ".." + this.vmax_ + "}";
    }

    public boolean isGT(double scale_left, double scale_right) {
        if (this.reverse_) {
            return scale_right > scale_left;
        }
        return scale_left > scale_right;
    }

    public boolean isLT(double scale_left, double scale_right) {
        if (this.reverse_) {
            return scale_right < scale_left;
        }
        return scale_left < scale_right;
    }

    public double max(double scale_left, double scale_right) {
        if (this.reverse_) {
            return Math.min(scale_left, scale_right);
        }
        return Math.max(scale_left, scale_right);
    }

    public double min(double scale_left, double scale_right) {
        if (this.reverse_) {
            return Math.max(scale_left, scale_right);
        }
        return Math.min(scale_left, scale_right);
    }

    public boolean isIN(double scale_left, double pixel, double scale_right) {
        if (this.reverse_) {
            return pixel < scale_left && scale_right < pixel;
        }
        return scale_left < pixel && pixel < scale_right;
    }

    public void setLocale(ULocale _locale) {
        this.locale_ = _locale;
    }
}

