/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.internal;

import org.eclipse.tptp.platform.report.chart.internal.Box3D;
import org.eclipse.tptp.platform.report.chart.internal.ICoordTransformation;
import org.eclipse.tptp.platform.report.drawutil.internal.Point2D;
import org.eclipse.tptp.platform.report.drawutil.internal.Point3D;
import org.eclipse.tptp.platform.report.drawutil.internal.Vector3D;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;

public class View3D {
    protected double phi_;
    protected double theta_;
    protected double R_;
    protected double D_;
    protected double a1;
    protected double a2;
    protected double a3;
    protected double a4;
    protected double a5;
    protected double a6;
    protected double a7;
    protected double a8;
    protected Box3D bb_;
    protected double screen_dx_;
    protected double screen_dy_;
    protected double Dx_;
    protected double Dy_;
    protected static ICoordTransformation ct_idem_ = new NoTransformation();
    protected ICoordTransformation tX_;
    protected ICoordTransformation tY_;
    protected ICoordTransformation tZ_;
    private int scr_x_;
    private int scr_y_;
    private int scr_w_;
    private int scr_h_;

    public View3D(double _phi, double _theta, double _R, double _D, Box3D _bounding_box) {
        this.bb_ = _bounding_box;
        this.phi_ = _phi;
        this.theta_ = _theta;
        this.R_ = _R;
        this.D_ = _D;
        this.tX_ = ct_idem_;
        this.tY_ = ct_idem_;
        this.tZ_ = ct_idem_;
        this.screen_dy_ = 0.0;
        this.screen_dx_ = 0.0;
        this.Dy_ = 1.0;
        this.Dx_ = 1.0;
        this.update();
    }

    protected void update() {
        this.a1 = Math.sin(this.theta_);
        this.a2 = Math.sin(this.phi_);
        this.a3 = Math.cos(this.theta_);
        this.a4 = Math.cos(this.phi_);
        this.a5 = this.a3 * this.a2;
        this.a6 = this.a1 * this.a2;
        this.a7 = this.a3 * this.a4;
        this.a8 = this.a1 * this.a4;
    }

    public double getD() {
        return this.D_;
    }

    public double getR() {
        return this.R_;
    }

    public double getPhi() {
        return this.phi_;
    }

    public double getTheta() {
        return this.theta_;
    }

    public Vector3D getViewVector(Vector3D v) {
        if (v == null) {
            v = new Vector3D();
        }
        v.setVector(this.a3 * this.a4, this.a1 * this.a4, this.a2);
        return v;
    }

    public void setD(float _d) {
        this.D_ = _d;
    }

    public Point2D projection(double _x, double _y, double _z, Point2D _p) {
        double nx = this.tX_.apply(_x);
        double ny = this.tY_.apply(_y);
        double nz = this.tZ_.apply(_z);
        double xo = -nx * this.a1 + ny * this.a3;
        double yo = -nx * this.a5 - ny * this.a6 + nz * this.a4;
        _p.setX(this.screen_dx_ + this.Dx_ * xo);
        _p.setY(this.screen_dy_ + this.Dy_ * yo);
        return _p;
    }

    public void projection(double _x, double _y, double _z, Point3D _p) {
        double nx = this.tX_.apply(_x);
        double ny = this.tY_.apply(_y);
        double nz = this.tZ_.apply(_z);
        double xo = -nx * this.a1 + ny * this.a3;
        double yo = -nx * this.a5 - ny * this.a6 + nz * this.a4;
        double zo = -nx * this.a7 - ny * this.a8 - nz * this.a2 + this.R_;
        _p.setX(this.screen_dx_ + this.Dx_ * xo);
        _p.setY(this.screen_dy_ + this.Dy_ * yo);
        _p.setZ(zo);
    }

    public final void projection(Point3D _p, Point3D _j) {
        this.projection(_p.getX(), _p.getY(), _p.getZ(), _j);
    }

    public Rect getScaledTo() {
        return new Rect(this.scr_x_, this.scr_y_, this.scr_w_, this.scr_h_);
    }

    public void scaleTo(int _scr_x, int _scr_y, int _scr_width, int _scr_height) {
        this.scr_x_ = _scr_x;
        this.scr_y_ = _scr_y;
        this.scr_w_ = _scr_width;
        this.scr_h_ = _scr_height;
        this.screen_dy_ = 0.0;
        this.screen_dx_ = 0.0;
        this.D_ = 1.0;
        this.Dy_ = 1.0;
        this.Dx_ = 1.0;
        double scr_x_min = 1.0E8;
        double scr_y_min = 1.0E8;
        double scr_x_max = -1.0E8;
        double scr_y_max = -1.0E8;
        Point2D p = new Point2D();
        this.projection(this.bb_.getXMin(), this.bb_.getYMin(), this.bb_.getZMin(), p);
        double px = p.getX();
        double py = p.getY();
        if (px < scr_x_min) {
            scr_x_min = px;
        }
        if (px > scr_x_max) {
            scr_x_max = px;
        }
        if (py < scr_y_min) {
            scr_y_min = py;
        }
        if (py > scr_y_max) {
            scr_y_max = py;
        }
        this.projection(this.bb_.getXMin(), this.bb_.getYMin(), this.bb_.getZMax(), p);
        px = p.getX();
        py = p.getY();
        if (px < scr_x_min) {
            scr_x_min = px;
        }
        if (px > scr_x_max) {
            scr_x_max = px;
        }
        if (py < scr_y_min) {
            scr_y_min = py;
        }
        if (py > scr_y_max) {
            scr_y_max = py;
        }
        this.projection(this.bb_.getXMax(), this.bb_.getYMin(), this.bb_.getZMax(), p);
        px = p.getX();
        py = p.getY();
        if (px < scr_x_min) {
            scr_x_min = px;
        }
        if (px > scr_x_max) {
            scr_x_max = px;
        }
        if (py < scr_y_min) {
            scr_y_min = py;
        }
        if (py > scr_y_max) {
            scr_y_max = py;
        }
        this.projection(this.bb_.getXMax(), this.bb_.getYMin(), this.bb_.getZMin(), p);
        px = p.getX();
        py = p.getY();
        if (px < scr_x_min) {
            scr_x_min = px;
        }
        if (px > scr_x_max) {
            scr_x_max = px;
        }
        if (py < scr_y_min) {
            scr_y_min = py;
        }
        if (py > scr_y_max) {
            scr_y_max = py;
        }
        this.projection(this.bb_.getXMin(), this.bb_.getYMax(), this.bb_.getZMax(), p);
        px = p.getX();
        py = p.getY();
        if (px < scr_x_min) {
            scr_x_min = px;
        }
        if (px > scr_x_max) {
            scr_x_max = px;
        }
        if (py < scr_y_min) {
            scr_y_min = py;
        }
        if (py > scr_y_max) {
            scr_y_max = py;
        }
        this.projection(this.bb_.getXMax(), this.bb_.getYMax(), this.bb_.getZMax(), p);
        px = p.getX();
        py = p.getY();
        if (px < scr_x_min) {
            scr_x_min = px;
        }
        if (px > scr_x_max) {
            scr_x_max = px;
        }
        if (py < scr_y_min) {
            scr_y_min = py;
        }
        if (py > scr_y_max) {
            scr_y_max = py;
        }
        this.projection(this.bb_.getXMax(), this.bb_.getYMax(), this.bb_.getZMin(), p);
        px = p.getX();
        py = p.getY();
        if (px < scr_x_min) {
            scr_x_min = px;
        }
        if (px > scr_x_max) {
            scr_x_max = px;
        }
        if (py < scr_y_min) {
            scr_y_min = py;
        }
        if (py > scr_y_max) {
            scr_y_max = py;
        }
        this.projection(this.bb_.getXMin(), this.bb_.getYMax(), this.bb_.getZMin(), p);
        px = p.getX();
        py = p.getY();
        if (px < scr_x_min) {
            scr_x_min = px;
        }
        if (px > scr_x_max) {
            scr_x_max = px;
        }
        if (py < scr_y_min) {
            scr_y_min = py;
        }
        if (py > scr_y_max) {
            scr_y_max = py;
        }
        double scr_w = scr_x_max - scr_x_min;
        double scr_h = scr_y_max - scr_y_min;
        double kx = Math.abs((double)_scr_width / scr_w);
        double ky = Math.abs((double)_scr_height / scr_h);
        this.D_ = ky < kx ? ky : kx;
        this.Dx_ = this.D_;
        this.Dy_ = -this.D_;
        int left = _scr_x;
        int right = left + _scr_width;
        int top = _scr_y;
        int bottom = top + _scr_height;
        this.screen_dx_ = (int)(((double)(left + right) - this.D_ * (scr_x_max + scr_x_min)) / 2.0);
        this.screen_dy_ = (int)(((double)(top + bottom) + this.D_ * (scr_y_max + scr_y_min)) / 2.0);
    }

    protected double screenDx() {
        return this.screen_dx_;
    }

    protected double screenDy() {
        return this.screen_dy_;
    }

    public void resetCoordTransformation() {
        this.tY_ = this.tZ_ = ct_idem_;
        this.tX_ = this.tZ_;
    }

    public void setXCoordTransformation(ICoordTransformation _ct) {
        this.tX_ = _ct == null ? ct_idem_ : _ct;
    }

    public void setYCoordTransformation(ICoordTransformation _ct) {
        this.tY_ = _ct == null ? ct_idem_ : _ct;
    }

    public void setZCoordTransformation(ICoordTransformation _ct) {
        this.tZ_ = _ct == null ? ct_idem_ : _ct;
    }

    protected static class NoTransformation
    implements ICoordTransformation {
        protected NoTransformation() {
        }

        public double apply(double _c) {
            return _c;
        }
    }
}

