/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.tptp.platform.report.chart.svg.internal.IGraphicDocumentGenerator;
import org.eclipse.tptp.platform.report.chart.svg.internal.SVGGeneratorException;
import org.eclipse.tptp.platform.report.chart.svg.internal.SVGGeneratorInvalidInputException;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.InputDOMDocument;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.ChartArea;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.DefaultResources;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.XMLLoader;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class SVGGenerator
implements IGraphicDocumentGenerator {
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String SVG_VERSION = "-//W3C//DTD SVG 1.0//EN";
    public static final String SVG_DTD = "http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd";
    private DefaultResources resources;
    private String schemaLocation;
    public Chart chart;

    public Chart getChart() {
        return this.chart;
    }

    public SVGGenerator() {
        this.resources = new DefaultResources();
    }

    public SVGGenerator(String dir) {
        String resourceDir = dir.endsWith("/") || dir.endsWith("\\") ? dir.substring(0, dir.length() - 1) : dir;
        resourceDir = resourceDir.replace('\\', '/');
        this.resources = new DefaultResources(resourceDir);
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public Document generateGraphicDocument(Document input, boolean validateInput) throws SVGGeneratorException {
        if (validateInput) {
            String xml = this.serializeGeneratedDocumentToString(input);
            StringReader reader = new StringReader(xml);
            InputSource inputSource = new InputSource(reader);
            XMLLoader validator = this.schemaLocation != null ? new XMLLoader(this.schemaLocation) : new XMLLoader();
            validator.setValidating(true);
            if (!validator.load(inputSource)) {
                throw new SVGGeneratorInvalidInputException(validator.getException());
            }
        }
        InputDOMDocument inputDoc = new InputDOMDocument(input);
        this.chart = inputDoc.getChart();
        return this.generateGraphicDocument(inputDoc.getChart());
    }

    public Document generateGraphicDocument(InputStream input, boolean validateInput) throws SVGGeneratorException {
        Document inputDom;
        DocumentBuilderFactory factory;
        BufferedInputStream in = new BufferedInputStream(input);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        if (validateInput) {
            factory = DocumentBuilderFactory.newInstance();
            factory.setAttribute(JAXP_SCHEMA_SOURCE, new File(this.schemaLocation));
            try {
                InputSource inputSource = new InputSource(reader);
                DocumentBuilder builder = factory.newDocumentBuilder();
                inputDom = builder.parse(inputSource);
            }
            catch (Exception e) {
                throw new SVGGeneratorInvalidInputException(e);
            }
        }
        factory = DocumentBuilderFactory.newInstance();
        try {
            InputSource inputSource = new InputSource(reader);
            DocumentBuilder builder = factory.newDocumentBuilder();
            inputDom = builder.parse(inputSource);
        }
        catch (Exception e) {
            throw new SVGGeneratorInvalidInputException(e);
        }
        InputDOMDocument inputDoc = new InputDOMDocument(inputDom);
        this.chart = inputDoc.getChart();
        return this.generateGraphicDocument(inputDoc.getChart());
    }

    public void generateGraphicDocument(Document input, boolean validateInput, OutputStream outputStream) throws SVGGeneratorException {
        Document svgDoc = this.generateGraphicDocument(input, validateInput);
        this.writeDocumentToOutputStream(svgDoc, outputStream);
    }

    public void generateGraphicDocument(InputStream input, boolean validateInput, OutputStream outputStream) throws SVGGeneratorException {
        Document svgDoc = this.generateGraphicDocument(input, validateInput);
        this.writeDocumentToOutputStream(svgDoc, outputStream);
    }

    public boolean serializeGeneratedDocumentToFile(Document generatedDocument, String uri) throws SVGGeneratorException {
        if (generatedDocument == null) {
            return false;
        }
        FileOutputStream fs = null;
        try {
            fs = new FileOutputStream(uri);
        }
        catch (IOException ioe) {
            throw new SVGGeneratorException(ioe);
        }
        this.writeDocumentToOutputStream(generatedDocument, fs);
        return true;
    }

    public String serializeGeneratedDocumentToString(Document generatedDocument) throws SVGGeneratorException {
        if (generatedDocument == null) {
            return null;
        }
        OutputStreamWriter writer = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");
            DOMSource source = new DOMSource(generatedDocument);
            StreamResult result = new StreamResult(writer);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (Exception exception) {
            Utilities.assertion(false);
        }
        return stream.toString();
    }

    public Document generateGraphicDocument(Chart input) throws SVGGeneratorException {
        Document generatedDocument = this.createSvgDocument();
        try {
            ChartArea svgChart = new ChartArea(input, this.resources);
            Element svgRoot = svgChart.doImplementation(generatedDocument);
            Element docRoot = generatedDocument.getDocumentElement();
            docRoot.appendChild(svgRoot);
            docRoot.setAttribute("onload", "SVGGEN_init(evt)");
            docRoot.setAttribute("width", svgChart.getWidth());
            docRoot.setAttribute("height", svgChart.getHeight());
            docRoot.setAttribute("xmlns", "http://www.w3.org/2000/svg");
            docRoot.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SVGGeneratorException(e);
        }
        return generatedDocument;
    }

    private Document createSvgDocument() throws SVGGeneratorException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation domImpl = builder.getDOMImplementation();
            DocumentType dType = domImpl.createDocumentType("svg", SVG_VERSION, SVG_DTD);
            Document svgDocument = domImpl.createDocument("http://www.w3.org/2000/svg", "svg", dType);
            return svgDocument;
        }
        catch (ParserConfigurationException e) {
            throw new SVGGeneratorException(e);
        }
    }

    public void writeDocumentToOutputStream(Document svgDocument, OutputStream outputStream) throws SVGGeneratorException {
        if (svgDocument != null && outputStream != null) {
            OutputStreamWriter writer = null;
            try {
                writer = new OutputStreamWriter(outputStream, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Utilities.assertion(false);
            }
            try {
                DOMSource source = new DOMSource(svgDocument);
                StreamResult result = new StreamResult(writer);
                TransformerFactory transFactory = TransformerFactory.newInstance();
                Transformer transformer = transFactory.newTransformer();
                transformer.transform(source, result);
            }
            catch (Exception ioe) {
                throw new SVGGeneratorException(ioe);
            }
        }
    }
}

