/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.generator;

import java.io.Serializable;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.ISVGGraphicBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SVGGraphicBase
extends SVGBase
implements ISVGGraphicBase,
Serializable {
    private String transformation;
    private String fill;
    private String stroke;
    private String xCoordinate;
    private String yCoordinate;
    private String filter;

    protected Element doImplementation(Document svgDocument) throws DOMException {
        Element baseElement = super.doImplementation(svgDocument);
        if (baseElement != null) {
            if (this.transformation != null) {
                baseElement.setAttribute("transform", this.transformation);
            }
            if (this.fill != null) {
                baseElement.setAttribute("fill", this.fill);
            }
            if (this.stroke != null && this.stroke.length() > 0) {
                baseElement.setAttribute("stroke", this.stroke);
            }
            if (this.xCoordinate != null) {
                baseElement.setAttribute("x", this.xCoordinate);
            }
            if (this.yCoordinate != null) {
                baseElement.setAttribute("y", this.yCoordinate);
            }
            if (this.filter != null) {
                baseElement.setAttribute("filter", this.filter);
            }
        }
        return baseElement;
    }

    public String getTransformation() {
        return this.transformation;
    }

    public String getFill() {
        return this.fill;
    }

    public String getStroke() {
        return this.stroke;
    }

    public String getXCoordinate() {
        return this.xCoordinate;
    }

    public String getYCoordinate() {
        return this.yCoordinate;
    }

    public void setTransformation(String tTransformation) {
        this.transformation = tTransformation;
    }

    public void setFill(String fill) {
        if (fill != null && !fill.trim().equals("")) {
            this.fill = fill;
        }
    }

    public void setStroke(String stroke) {
        if (stroke != null && !stroke.trim().equals("")) {
            this.stroke = stroke;
        }
    }

    public void setXCoordinate(String xCoordinate) {
        this.xCoordinate = xCoordinate;
    }

    public void setYCoordinate(String yCoordinate) {
        this.yCoordinate = yCoordinate;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }
}

