/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.generator;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGScript
extends SVGBase {
    private Element implementation;
    static final long serialVersionUID = -6753429640054522891L;
    private String defaultScripts = null;
    private String userScript = null;

    public SVGScript() {
        this.setTagName("script");
    }

    public Element doImplementation(Document svgDocument) throws DOMException, NullPointerException {
        this.implementation = super.doImplementation(svgDocument);
        if (this.defaultScripts != null) {
            Utilities.assertion(this.userScript == null);
            CDATASection domCDATA = svgDocument.createCDATASection(this.defaultScripts);
            this.implementation.appendChild(domCDATA);
        } else if (this.userScript != null) {
            Utilities.assertion(this.defaultScripts == null);
            this.implementation.setAttribute("xlink:href", this.userScript);
        } else {
            Utilities.assertion(false);
        }
        this.implementation.setAttribute("type", "text/javascript");
        return this.implementation;
    }

    public Element getImplementation() {
        return this.implementation;
    }

    public void setDefaultScripts(String scriptsString) {
        this.defaultScripts = scriptsString;
    }

    public void setUserScript(String scriptFileName) {
        this.userScript = scriptFileName;
    }
}

