/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Axes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.AxisDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DependentAxisDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAxisDefinitionImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGDependentAxisDefinitionImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGInputBase;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.IDItem;

public class SVGAxesImpl
extends SVGInputBase
implements Axes {
    protected AxisDefinition independentAxis = null;
    protected AxisDefinition primaryDependentAxis = null;
    protected DependentAxisDefinition secondaryDependentAxis = null;
    public static final String PRIMARY_DEPENDENT_AXIS_ID = "y";
    public static final String SECONDARY_DEPENDENT_AXIS_ID = "y2";
    public static final String INDEPENDENT_AXIS_ID = "x";
    protected DAxis indepAxis = null;
    protected DAxis priDepAxis = null;
    protected DAxis secDepAxis = null;

    protected SVGAxesImpl() {
    }

    public SVGAxesImpl(SVGChartImpl chart) {
        this(chart, chart.getDGraphic());
    }

    public SVGAxesImpl(Chart chart, DGraphic dgraphic) {
        this._chart = chart;
        this._dgraphic = dgraphic;
    }

    public AxisDefinition getIndependentAxis() {
        if (this.independentAxis == null && this._dgraphic != null) {
            IDItem item = this._dgraphic.getFirstChild();
            while (item != null) {
                if (item instanceof DAxis && ((DAxis)item).getName().equals(INDEPENDENT_AXIS_ID)) {
                    this.independentAxis = new SVGAxisDefinitionImpl(this._chart, this._dgraphic, (DAxis)item);
                }
                item = item.getNext();
            }
        }
        return this.independentAxis;
    }

    public void setIndependentAxis(AxisDefinition newIndependentAxis) {
        this.independentAxis = newIndependentAxis;
    }

    public void assignIndependentAxis(AxisDefinition source) {
        this.indepAxis = new DAxis(INDEPENDENT_AXIS_ID);
        this._dgraphic.addChild(this.indepAxis);
        this.independentAxis = new SVGAxisDefinitionImpl(this._chart, this._dgraphic, this.indepAxis);
        if (source != null) {
            ((SVGAxisDefinitionImpl)this.independentAxis).assign(source);
        }
        this.indepAxis.setName(INDEPENDENT_AXIS_ID);
    }

    public AxisDefinition getPrimaryDependentAxis() {
        if (this.primaryDependentAxis == null && this._dgraphic != null) {
            IDItem item = this._dgraphic.getFirstChild();
            while (item != null) {
                if (item instanceof DAxis && ((DAxis)item).getName().equals(PRIMARY_DEPENDENT_AXIS_ID)) {
                    this.primaryDependentAxis = new SVGDependentAxisDefinitionImpl(this._chart, this._dgraphic, (DAxis)item, PRIMARY_DEPENDENT_AXIS_ID);
                }
                item = item.getNext();
            }
        }
        return this.primaryDependentAxis;
    }

    public void setPrimaryDependentAxis(AxisDefinition newPrimaryDependentAxis) {
        this.primaryDependentAxis = newPrimaryDependentAxis;
    }

    public void assignPrimaryDependentAxis(AxisDefinition source) {
        this.priDepAxis = new DAxis(PRIMARY_DEPENDENT_AXIS_ID);
        this._dgraphic.addChild(this.priDepAxis);
        this.primaryDependentAxis = new SVGDependentAxisDefinitionImpl(this._chart, this._dgraphic, this.priDepAxis, PRIMARY_DEPENDENT_AXIS_ID);
        if (source != null) {
            ((SVGDependentAxisDefinitionImpl)this.primaryDependentAxis).assign(source);
        }
        this.priDepAxis.setName(PRIMARY_DEPENDENT_AXIS_ID);
    }

    public DependentAxisDefinition getSecondaryDependentAxis() {
        if (this.secondaryDependentAxis == null && this._dgraphic != null) {
            IDItem item = this._dgraphic.getFirstChild();
            while (item != null) {
                if (item instanceof DAxis && ((DAxis)item).getName().equals(SECONDARY_DEPENDENT_AXIS_ID)) {
                    this.secondaryDependentAxis = new SVGDependentAxisDefinitionImpl(this._chart, this._dgraphic, (DAxis)item, SECONDARY_DEPENDENT_AXIS_ID);
                }
                item = item.getNext();
            }
        }
        return this.secondaryDependentAxis;
    }

    public void setSecondaryDependentAxis(DependentAxisDefinition newSecondaryDependentAxis) {
        this.secondaryDependentAxis = newSecondaryDependentAxis;
    }

    public void assignSecondaryDependentAxis(DependentAxisDefinition source) {
        this.secDepAxis = new DAxis(SECONDARY_DEPENDENT_AXIS_ID);
        this._dgraphic.addChild(this.secDepAxis);
        this.secondaryDependentAxis = new SVGDependentAxisDefinitionImpl(this._chart, this._dgraphic, this.secDepAxis, SECONDARY_DEPENDENT_AXIS_ID);
        if (source != null) {
            ((SVGDependentAxisDefinitionImpl)this.secondaryDependentAxis).assign(source);
        }
        this.secDepAxis.setName(SECONDARY_DEPENDENT_AXIS_ID);
    }

    public DAxis getDIndepAxis() {
        return this.indepAxis;
    }

    public DAxis getDPriDepAxis() {
        return this.priDepAxis;
    }

    public DAxis getDSecDepAxis() {
        return this.secDepAxis;
    }
}

