/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Accessibility;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Category;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Tooltip;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAccessibilityImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGInputBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGTooltipImpl;
import org.eclipse.tptp.platform.report.core.internal.DCategory;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;

public class SVGCategoryImpl
extends SVGInputBase
implements Category {
    protected static final String ID_EDEFAULT = null;
    protected static final String LABEL_EDEFAULT = null;
    protected Accessibility accessibility = null;
    protected List eventHandler = null;
    protected Tooltip tooltip = null;
    protected DCategory category;

    protected SVGCategoryImpl() {
    }

    public SVGCategoryImpl(SVGChartImpl chart) {
        this(chart, chart.getDGraphic(), null);
    }

    public SVGCategoryImpl(Chart chart, DGraphic dgraphic, DCategory category) {
        this._chart = chart;
        this._dgraphic = dgraphic;
        this.category = category;
    }

    public Accessibility getAccessibility() {
        if (this.accessibility == null) {
            this.accessibility = this.getAccessibility(this.category);
        }
        return this.accessibility;
    }

    public void setAccessibility(Accessibility newAccessibility) {
        this.accessibility = newAccessibility;
    }

    public void assignAccessibility(Accessibility source) {
        this.accessibility = new SVGAccessibilityImpl(this._chart, this._dgraphic, SVGAccessibilityImpl.TITLE_EDEFAULT, SVGAccessibilityImpl.DESCRIPTION_EDEFAULT);
        ((SVGAccessibilityImpl)this.accessibility).assign(source);
        super.constructAccessibilityModel(this.accessibility, this.category);
    }

    public List getEventHandler() {
        if (this.eventHandler == null) {
            this.eventHandler = this.getEventHandler(this.category);
        }
        return this.eventHandler;
    }

    public void setEventHandler(List newEventHandler) {
        this.eventHandler = newEventHandler;
        super.constructEventHandlerModel(this.eventHandler, this.category);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (id: ");
        result.append(this.getId());
        result.append(", label: ");
        result.append(this.getLabel());
        result.append(')');
        return result.toString();
    }

    public String getId() {
        return this.category.getId();
    }

    public String getLabel() {
        return this.category.getLabel();
    }

    public Tooltip getTooltip() {
        if (this.tooltip == null && this.category.getTooltip() != null) {
            this.tooltip = new SVGTooltipImpl(this._chart, this._dgraphic, this.category.getTooltip());
        }
        return this.tooltip;
    }

    public void setId(String id) {
        this.category.setId(id);
    }

    public void setLabel(String label) {
        this.category.setLabel(label);
    }

    public void setTooltip(Tooltip tooltip) {
        this.tooltip = tooltip;
        this.category.setTooltip(tooltip.getLabel());
    }

    public void assignTooltip(Tooltip source) {
        this.tooltip = new SVGTooltipImpl(this._chart, this._dgraphic, SVGTooltipImpl.LABEL_EDEFAULT);
        ((SVGTooltipImpl)this.tooltip).assign(source);
        this.category.setTooltip(this.tooltip.getLabel());
    }

    public DCategory getDCategory() {
        return this.category;
    }
}

