/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Accessibility;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.ChartArea;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAccessibilityImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGInputBase;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;

public class SVGChartAreaImpl
extends SVGInputBase
implements ChartArea {
    protected static final String BACKGROUND_COLOR_EDEFAULT = null;
    protected static final boolean BORDER_EDEFAULT = true;
    protected boolean borderESet = false;
    protected Accessibility accessibility = null;
    protected List eventHandler = null;

    protected SVGChartAreaImpl() {
    }

    public SVGChartAreaImpl(SVGChartImpl chart) {
        this(chart, chart.getDGraphic());
    }

    public SVGChartAreaImpl(Chart chart, DGraphic dgraphic) {
        this._chart = chart;
        this._dgraphic = dgraphic;
    }

    public String getBackgroundColor() {
        DColor color = (DColor)this._dgraphic.getProperties().get("P_BACKCOLOR.DGraphic.core.jscrib");
        if (color != null) {
            return color.serializeToString();
        }
        return BACKGROUND_COLOR_EDEFAULT;
    }

    public void setBackgroundColor(String newBackgroundColor) {
        if (newBackgroundColor != null && newBackgroundColor != "" && !newBackgroundColor.substring(0, 1).equals("#")) {
            newBackgroundColor = this.convertToHex(newBackgroundColor);
        }
        if (newBackgroundColor == null || newBackgroundColor == "") {
            this._dgraphic.getProperties().remove("P_BACKCOLOR.DGraphic.core.jscrib");
            return;
        }
        this._dgraphic.getProperties().store("P_BACKCOLOR.DGraphic.core.jscrib", newBackgroundColor);
    }

    public boolean isBorder() {
        if (this._dgraphic.getProperties().get("P_SHOW_BORDER.DGraphic.core.jscrib") != null) {
            this.borderESet = true;
        }
        return this._dgraphic.getProperties().get("P_SHOW_BORDER.DGraphic.core.jscrib", true);
    }

    public void setBorder(boolean newBorder) {
        this._dgraphic.getProperties().store("P_SHOW_BORDER.DGraphic.core.jscrib", newBorder);
        this.borderESet = true;
    }

    public void unsetBorder() {
        this.borderESet = false;
        this._dgraphic.getProperties().remove("P_SHOW_BORDER.DGraphic.core.jscrib");
    }

    public boolean isSetBorder() {
        if (!this.borderESet) {
            this.isBorder();
        }
        return this.borderESet;
    }

    public Accessibility getAccessibility() {
        if (this.accessibility == null) {
            this.accessibility = this.getAccessibility(this._dgraphic);
        }
        return this.accessibility;
    }

    public void setAccessibility(Accessibility newAccessibility) {
        this.accessibility = newAccessibility;
    }

    public void assignAccessibility(Accessibility source) {
        this.accessibility = new SVGAccessibilityImpl(this._chart, this._dgraphic, SVGAccessibilityImpl.TITLE_EDEFAULT, SVGAccessibilityImpl.DESCRIPTION_EDEFAULT);
        ((SVGAccessibilityImpl)this.accessibility).assign(source);
        super.constructAccessibilityModel(this.accessibility, this._dgraphic);
    }

    public List getEventHandler() {
        if (this.eventHandler == null) {
            this.eventHandler = this.getEventHandler(this._dgraphic);
        }
        return this.eventHandler;
    }

    public void setEventHandler(List newEventHandler) {
        this.eventHandler = newEventHandler;
        super.constructEventHandlerModel(this.eventHandler, this._dgraphic);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (backgroundColor: ");
        result.append(this.getBackgroundColor());
        result.append(", border: ");
        if (this.borderESet) {
            result.append(this.isBorder());
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }
}

