/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.HashMap;
import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Configuration;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGConfigurationImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGDataImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGInputBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DCategory;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DColorRegistry;
import org.eclipse.tptp.platform.report.core.internal.DCoordObject;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlError;

public class SVGChartImpl
extends SVGInputBase
implements Chart {
    protected static final String ID_EDEFAULT = null;
    protected static final String TYPE_EDEFAULT = null;
    protected String type = TYPE_EDEFAULT;
    protected static final String VERSION_EDEFAULT = "3.0";
    protected String version = "3.0";
    protected boolean typeESet = false;
    protected boolean versionESet = false;
    protected Data data = null;
    protected Configuration configuration = null;
    private DColorRegistry colors;
    private HashMap colorsId;

    public SVGChartImpl() {
    }

    public SVGChartImpl(DGraphic dgraphic) {
        this._dgraphic = dgraphic;
        if (this.getType().equals("pie") || this.getType().equals("pie3D") || this.getType().equals("verticalBar3D") || this.getType().equals("verticalBar") || this.getType().equals("horizontalBar3D") || this.getType().equals("horizontalBar")) {
            this.pieMigration(dgraphic);
        } else if (this.getType().equals("horizontalStackedBar") || this.getType().equals("horizontalStackedBar3D") || this.getType().equals("verticalStackedBar") || this.getType().equals("verticalStackedBar3D")) {
            this.stackMigration(dgraphic);
        }
    }

    protected void stackMigration(DGraphic dgraphic) {
        boolean hasCategory = false;
        if (this._dgraphic != null) {
            IDItem item = this._dgraphic.getFirstChild();
            while (item != null) {
                if (item instanceof DAxis) {
                    IDItem itemCat = item.getFirstChild();
                    while (itemCat != null) {
                        if (itemCat instanceof DCategory) {
                            hasCategory = true;
                            break;
                        }
                        itemCat = itemCat.getNext();
                    }
                    if (hasCategory) break;
                }
                item = item.getNext();
            }
            if (!hasCategory) {
                List curves = this._dgraphic.getChildrenOfClass(DCurve.class);
                DAxis yaxis = (DAxis)this._dgraphic.getChildOfClass(DAxis.class);
                if (yaxis == null) {
                    return;
                }
                yaxis.setName("y");
                DAxis xaxis = new DAxis("x");
                DCurve curve = (DCurve)curves.get(0);
                List points = curve.getChildrenOfClass(DPoint.class);
                String[] cat = new String[points.size()];
                int x = 0;
                while (x < points.size()) {
                    DPoint point = (DPoint)points.get(x);
                    DText text = (DText)point.getChildOfClass(DText.class);
                    DCategory category = new DCategory();
                    if (text == null) {
                        return;
                    }
                    category.setId(String.valueOf(EventTools.getHashCode(text)));
                    category.setLabel(text.getText());
                    xaxis.addChild(category);
                    cat[x] = category.getId();
                    ++x;
                }
                int y = 0;
                while (y < curves.size()) {
                    curve = (DCurve)curves.get(y);
                    points = curve.getChildrenOfClass(DPoint.class);
                    int x2 = 0;
                    while (x2 < points.size()) {
                        DPoint point = (DPoint)points.get(x2);
                        DCoordObject coordObj = new DCoordObject();
                        coordObj.setAxis(xaxis);
                        coordObj.setValue(cat[x2]);
                        point.addChild(coordObj);
                        ++x2;
                    }
                    ++y;
                }
                this._dgraphic.addChild(xaxis);
            }
        }
    }

    protected void pieMigration(DGraphic dgraphic) {
        boolean hasCategory = false;
        if (this._dgraphic != null) {
            List axes;
            IDItem item = this._dgraphic.getFirstChild();
            while (item != null) {
                if (item instanceof DAxis) {
                    IDItem itemCat = item.getFirstChild();
                    while (itemCat != null) {
                        if (itemCat instanceof DCategory) {
                            hasCategory = true;
                            break;
                        }
                        itemCat = itemCat.getNext();
                    }
                    if (hasCategory) break;
                }
                item = item.getNext();
            }
            if (!hasCategory && (axes = this._dgraphic.getChildrenOfClass(DAxis.class)).size() > 0) {
                DAxis xAxis = new DAxis("x");
                this._dgraphic.addChild(xAxis);
                int y = 0;
                while (y < axes.size()) {
                    DAxis axis = (DAxis)axes.get(y);
                    axis.setName("y");
                    IDItem itemCat = axis.getFirstChild();
                    while (itemCat != null) {
                        if (itemCat instanceof DCurve) {
                            DCurve curve = (DCurve)itemCat;
                            DPoint point = (DPoint)curve.getChildOfClass(DPoint.class);
                            DCoordObject coordObj = new DCoordObject();
                            coordObj.setAxis(xAxis);
                            coordObj.setValue(curve.getName());
                            point.addChild(coordObj);
                            DCategory category = new DCategory();
                            category.setId(curve.getName());
                            category.setLabel(curve.getName());
                            xAxis.addChild(category);
                        }
                        itemCat = itemCat.getNext();
                    }
                    ++y;
                }
            }
        }
    }

    public String getId() {
        return (String)this._dgraphic.getProperties().get("P_ID.DGraphic.core.jscrib");
    }

    public void setId(String newId) {
        if (newId == null) {
            newId = String.valueOf(EventTools.getHashCode(this));
        }
        this._dgraphic.getProperties().store("P_ID.DGraphic.core.jscrib", newId);
    }

    public String getType() {
        if (!this.typeESet) {
            boolean threeD = false;
            this.type = this._dgraphic.getGraphicType();
            threeD = this._dgraphic.getProperties().get("P_3D.DGraphic.core.jscrib", false);
            if ("T_HBARS.DGraphic.core.jscrib".equals(this.type)) {
                this.type = threeD ? "horizontalBar3D" : "horizontalBar";
            } else if ("T_HISTOGRAM.DGraphic.core.jscrib".equals(this.type)) {
                this.type = threeD ? "verticalBar3D" : "verticalBar";
            } else if ("T_STACKBARS.DGraphic.core.jscrib".equals(this.type)) {
                this.type = threeD ? "verticalStackedBar3D" : "verticalStackedBar";
            } else if ("T_SECTORS3D.DGraphic.core.jscrib".equals(this.type)) {
                this.type = "pie3D";
            } else if ("T_SECTORS.DGraphic.core.jscrib".equals(this.type)) {
                this.type = "pie";
            } else if ("T_METER.DGraphic.core.jscrib".equals(this.type)) {
                this.type = "meter";
            } else if ("T_XY.DGraphic.core.jscrib".equals(this.type)) {
                this.type = "line";
            } else if ("T_XYZ.DGraphic.core.jscrib".equals(this.type)) {
                Utilities.assertion(false);
            } else if ("T_WIREFRAME.DGraphic.core.jscrib".equals(this.type)) {
                Utilities.assertion(false);
            } else if ("T_XYZ.DGraphic.core.jscrib".equals(this.type)) {
                Utilities.assertion(false);
            } else if ("T_PIE3D.DGraphic.core.jscrib".equals(this.type)) {
                Utilities.assertion(false);
            } else if ("T_TORUS3D.DGraphic.core.jscrib".equals(this.type)) {
                Utilities.assertion(false);
            }
            this.typeESet = true;
        }
        return this.type;
    }

    public void setType(String newType) {
        this.type = newType;
        if (this._dgraphic != null) {
            String dGraphicType = null;
            if (this.type.equals("horizontalBar")) {
                dGraphicType = "T_HBARS.DGraphic.core.jscrib";
            } else if (this.type.equals("horizontalBar3D")) {
                dGraphicType = "T_HBARS.DGraphic.core.jscrib";
                this._dgraphic.getProperties().store("P_3D.DGraphic.core.jscrib", true);
            } else if (this.type.equals("verticalBar")) {
                dGraphicType = "T_HISTOGRAM.DGraphic.core.jscrib";
            } else if (this.type.equals("verticalBar3D")) {
                dGraphicType = "T_HISTOGRAM.DGraphic.core.jscrib";
                this._dgraphic.getProperties().store("P_3D.DGraphic.core.jscrib", true);
            } else if (this.type.equals("verticalStackedBar")) {
                dGraphicType = "T_STACKBARS.DGraphic.core.jscrib";
            } else if (this.type.equals("verticalStackedBar3D")) {
                dGraphicType = "T_STACKBARS.DGraphic.core.jscrib";
                this._dgraphic.getProperties().store("P_3D.DGraphic.core.jscrib", true);
            } else {
                dGraphicType = this.type.equals("pie3D") ? "T_SECTORS3D.DGraphic.core.jscrib" : (this.type.equals("pie") ? "T_SECTORS.DGraphic.core.jscrib" : (this.type.equals("meter") ? "T_METER.DGraphic.core.jscrib" : (this.type.equals("line") ? "T_XY.DGraphic.core.jscrib" : this.type)));
            }
            this._dgraphic.setGraphicType(dGraphicType);
        }
    }

    public String getVersion() {
        if (this._dgraphic != null) {
            this.version = this._dgraphic.getProperties().get("P_VERSION.DGraphic.core.jscrib", VERSION_EDEFAULT);
            if (this._dgraphic.getProperties().get("P_VERSION.DGraphic.core.jscrib") != null) {
                this.versionESet = true;
            }
        }
        return this.version;
    }

    public void setVersion(String newVersion) {
        this.version = newVersion;
        this.versionESet = true;
        if (this._dgraphic != null) {
            this._dgraphic.getProperties().store("P_VERSION.DGraphic.core.jscrib", newVersion);
        }
    }

    public void unsetVersion() {
        this.versionESet = false;
        this.version = VERSION_EDEFAULT;
        if (this._dgraphic != null) {
            this._dgraphic.getProperties().remove("P_VERSION.DGraphic.core.jscrib");
        }
    }

    public boolean isSetVersion() {
        if (!this.versionESet) {
            this.getVersion();
        }
        return this.versionESet;
    }

    public Data getData() {
        if (this.data == null && this._dgraphic != null) {
            this.data = new SVGDataImpl(this, this._dgraphic);
        }
        return this.data;
    }

    public void setData(Data newData) {
        this.data = newData;
    }

    public void assignData(Data source) {
        this.data = new SVGDataImpl(this, this._dgraphic);
        ((SVGDataImpl)this.data).assign(source);
    }

    public Configuration getConfiguration() {
        if (this.configuration == null && this._dgraphic != null) {
            this.configuration = new SVGConfigurationImpl(this, this._dgraphic);
        }
        return this.configuration;
    }

    public void setConfiguration(Configuration newConfiguration) {
        this.configuration = newConfiguration;
    }

    public void assignConfiguration(Configuration source) {
        this.configuration = new SVGConfigurationImpl(this, this._dgraphic);
        ((SVGConfigurationImpl)this.configuration).assign(source);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (id: ");
        result.append(this.getId());
        result.append(", type: ");
        result.append(this.type);
        result.append(", version: ");
        if (this.versionESet) {
            result.append(this.version);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    public void assign(Chart source) {
        this.setId(source.getId());
        this.setType(source.getType());
        if (source.isSetVersion()) {
            this.setVersion(source.getVersion());
        }
        if (source.getConfiguration() != null) {
            this.assignConfiguration(source.getConfiguration());
        }
        if (source.getData() != null) {
            this.assignData(source.getData());
        }
    }

    public IDColor getColor(String val) {
        DColor color = null;
        if (val.charAt(0) != '#' && val.length() < 7) {
            throw new DXmlError("Bad syntax color (" + val + ") while parsing '' tag");
        }
        if (this.colorsId == null) {
            this.colorsId = new HashMap();
        }
        if ((color = (DColor)this.colorsId.get(val)) == null) {
            color = new DColor();
            color.serializeFromString(val);
            if (this.colors == null) {
                this.colors = new DColorRegistry();
            }
            this.colors.putColor(color);
            this.colorsId.put(val, color);
        }
        return color;
    }
}

