/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSetColor;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGInputBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.IDColor;

public class SVGDataSetColorImpl
extends SVGInputBase
implements DataSetColor {
    protected static final IDColor COLOR_EDEFAULT = null;
    protected IDColor color = COLOR_EDEFAULT;
    protected Object dataSetId = null;
    protected DCurve curve = null;

    public SVGDataSetColorImpl(SVGChartImpl chart) {
        this(chart, chart.getDGraphic(), null);
    }

    public SVGDataSetColorImpl(Chart chart, DGraphic dgraphic, DCurve curve) {
        this._chart = chart;
        this._dgraphic = dgraphic;
        this.curve = curve;
    }

    public String getColor() {
        if (this.color == COLOR_EDEFAULT) {
            this.color = (IDColor)this.curve.getProperties().get("P_COLOR.DCurve.core.jscrib");
        }
        if (this.color != null) {
            return this.color.serializeToString();
        }
        return null;
    }

    public static boolean hasColor(DCurve curve) {
        return curve.getProperties().get("P_COLOR.DCurve.core.jscrib") != null;
    }

    public void setColor(String newColor) {
        if (newColor != null && newColor != "" && !newColor.substring(0, 1).equals("#")) {
            newColor = this.convertToHex(newColor);
        }
        if (newColor == null || newColor == "") {
            this.curve.getProperties().remove("P_COLOR.DCurve.core.jscrib");
            return;
        }
        this.curve.getProperties().store("P_COLOR.DCurve.core.jscrib", ((SVGChartImpl)this._chart).getColor(newColor));
    }

    public Object getDataSetId() {
        if (this.dataSetId == null && this._dgraphic != null) {
            String refId = Integer.toString(EventTools.getHashCode(this.curve));
            Data data = this._chart.getData();
            DataSets dataSets = data.getDataSets();
            List dataSetList = dataSets.getDataSet();
            int i = 0;
            while (i < dataSetList.size()) {
                DataSet dataSet = (DataSet)dataSetList.get(i);
                if (dataSet.getId() != null && dataSet.getId().equals(refId)) {
                    this.dataSetId = dataSet;
                    break;
                }
                ++i;
            }
        }
        return this.dataSetId;
    }

    public void setDataSetId(Object newDataSetId) {
        this.dataSetId = newDataSetId;
        DataSet dataSet = null;
        try {
            dataSet = (DataSet)newDataSetId;
            String dataSetIdStr = dataSet.getId();
            if (this.curve != null) {
                this.curve.setName(dataSetIdStr);
            }
        }
        catch (ClassCastException classCastException) {}
    }

    public void assignDataSetId(Object newDataSetId) {
        try {
            DataSet dataSet = (DataSet)newDataSetId;
            String dataSetIdStr = dataSet.getId();
            if (this.curve != null) {
                this.curve.getProperties().store("P_ID.DCurve.core.jscrib", dataSetIdStr);
            }
        }
        catch (ClassCastException classCastException) {}
    }

    public String fetchDataSetId() {
        return this.curve.getProperties().get("P_ID.DCurve.core.jscrib").toString();
    }

    public void setDCurve(DCurve dcurve) {
        this.curve = dcurve;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (color: ");
        result.append(this.color);
        result.append(')');
        return result.toString();
    }
}

