/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Accessibility;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Category;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Palettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Shapes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Tooltip;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAccessibilityImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAxesImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGCategoricalDataImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGCategoryImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGConfigurationImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGCoordinatesImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGDataSetColorImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGInputBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGPalettesImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGShapeImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGShapesImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGTooltipImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DCategory;
import org.eclipse.tptp.platform.report.core.internal.DCoord;
import org.eclipse.tptp.platform.report.core.internal.DCoordObject;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.IDCoord;
import org.eclipse.tptp.platform.report.core.internal.IDItem;

public class SVGDataSetImpl
extends SVGInputBase
implements DataSet {
    protected static final String ID_EDEFAULT = null;
    protected static final String LABEL_EDEFAULT = "";
    protected List dataPoint = null;
    protected List coordinates = null;
    protected Accessibility accessibility = null;
    protected List eventHandler = null;
    protected Tooltip tooltip = null;
    protected DCurve curve = null;
    protected static final String DUMMY_CAT = "__dummy_cat__";

    protected SVGDataSetImpl() {
    }

    public SVGDataSetImpl(SVGChartImpl chart) {
        this(chart, chart.getDGraphic(), null);
    }

    public SVGDataSetImpl(Chart chart, DGraphic dgraphic, DCurve curve) {
        this._chart = chart;
        this._dgraphic = dgraphic;
        this.curve = curve;
    }

    public String getId() {
        return Integer.toString(EventTools.getHashCode(this.curve));
    }

    public void setId(String newId) {
        this.curve.getProperties().store("P_ID.DCurve.core.jscrib", newId);
    }

    public String getLabel() {
        if (this.curve.getName() == null) {
            return LABEL_EDEFAULT;
        }
        return this.curve.getName();
    }

    public void setLabel(String newLabel) {
        this.curve.setName(newLabel);
    }

    public List getDataPoint() {
        if (this.dataPoint == null) {
            this.buildCoordinateAndCatagoryData(this.curve);
        }
        return this.dataPoint;
    }

    public void assignDataPoint(List source) {
        this.assignCoordinatesAndDataPoints(source, false);
    }

    protected void buildCoordinateAndCatagoryData(DCurve curve) {
        if (this.dataPoint == null) {
            this.dataPoint = new ArrayList();
        }
        if (this.coordinates == null) {
            this.coordinates = new ArrayList();
        }
        IDItem obj = curve.getFirstChild();
        while (obj != null) {
            if (obj instanceof DPoint) {
                DPoint point = (DPoint)obj;
                boolean isCoordinate = true;
                IDCoord independantCoord = null;
                IDCoord dependantCoord = null;
                IDItem item = point.getFirstChild();
                while (item != null) {
                    if (item instanceof IDCoord) {
                        IDCoord coord = (IDCoord)((Object)item);
                        boolean isCategory = false;
                        List list = coord.getAxis().getChildrenOfClass(DCategory.class);
                        if (list != null && list.size() > 0) {
                            isCoordinate = false;
                            isCategory = true;
                        }
                        if (coord.getAxis() != null) {
                            if (coord.getAxis().getName().equals("x")) {
                                independantCoord = coord;
                            } else if (coord.getAxis().getName().equals("y")) {
                                dependantCoord = coord;
                            } else if (coord.getAxis().getName().equals("y2")) {
                                dependantCoord = coord;
                            } else if (isCategory) {
                                independantCoord = coord;
                            } else if (independantCoord == null) {
                                independantCoord = coord;
                            } else {
                                dependantCoord = coord;
                            }
                        }
                    }
                    item = item.getNext();
                }
                if (!isCoordinate || dependantCoord == null) {
                    if (dependantCoord == null) {
                        dependantCoord = new DCoordObject();
                        dependantCoord.setValue(DUMMY_CAT);
                        ArrayList<SVGCategoryImpl> category = this._chart.getData().getCategories().getCategory();
                        if (category == null) {
                            category = new ArrayList<SVGCategoryImpl>();
                        }
                        if (!category.contains(DUMMY_CAT)) {
                            DCategory dcategory = new DCategory();
                            dcategory.setLabel(DUMMY_CAT);
                            dcategory.setId(DUMMY_CAT);
                            category.add(new SVGCategoryImpl(this._chart, this._dgraphic, dcategory));
                        }
                        DCoordObject cordTemp = dependantCoord;
                        dependantCoord = independantCoord;
                        independantCoord = cordTemp;
                    }
                    this.dataPoint.add(new SVGCategoricalDataImpl(this._chart, this._dgraphic, point, independantCoord, dependantCoord));
                } else {
                    this.coordinates.add(new SVGCoordinatesImpl(this._chart, this._dgraphic, point, independantCoord, dependantCoord));
                }
            }
            obj = obj.getNext();
        }
    }

    public List getCoordinates() {
        if (this.coordinates == null) {
            this.buildCoordinateAndCatagoryData(this.curve);
        }
        return this.coordinates;
    }

    public void assignCoordinates(List source) {
        this.assignCoordinatesAndDataPoints(source, true);
    }

    public void assignCoordinatesAndDataPoints(List source, boolean isCoord) {
        DPoint newPoint;
        int i;
        List association = null;
        boolean useSecAxis = false;
        if (((SVGAxesImpl)this._chart.getConfiguration().getAxes()).getDIndepAxis() == null) {
            ((SVGAxesImpl)this._chart.getConfiguration().getAxes()).assignIndependentAxis(null);
        }
        if (((SVGAxesImpl)this._chart.getConfiguration().getAxes()).getDPriDepAxis() == null) {
            ((SVGAxesImpl)this._chart.getConfiguration().getAxes()).assignPrimaryDependentAxis(null);
        }
        DAxis indepAxis = ((SVGAxesImpl)this._chart.getConfiguration().getAxes()).getDIndepAxis();
        DAxis priDepAxis = ((SVGAxesImpl)this._chart.getConfiguration().getAxes()).getDPriDepAxis();
        DAxis secDepAxis = ((SVGAxesImpl)this._chart.getConfiguration().getAxes()).getDSecDepAxis();
        if (secDepAxis != null && (association = this._chart.getConfiguration().getAxes().getSecondaryDependentAxis().getDataSetAssociations().getDataSetIds()) != null) {
            int k = 0;
            while (k < association.size()) {
                String assoName = (String)association.get(k);
                if (assoName.equals(this.getId())) {
                    useSecAxis = true;
                    break;
                }
                ++k;
            }
        }
        this._dgraphic.addChild(this.curve);
        if (isCoord) {
            this.coordinates = new ArrayList();
            i = 0;
            while (i < source.size()) {
                newPoint = new DPoint();
                this.curve.addChild(newPoint);
                double dummyValue = 0.0;
                DCoord independentCoord = new DCoord(indepAxis, dummyValue);
                DCoord dependentCoord = null;
                dependentCoord = useSecAxis ? new DCoord(secDepAxis, dummyValue) : new DCoord(priDepAxis, dummyValue);
                SVGCoordinatesImpl newCoord = new SVGCoordinatesImpl(this._chart, this._dgraphic, newPoint, independentCoord, dependentCoord);
                newCoord.assign(source.get(i));
                this.coordinates.add(newCoord);
                newPoint.addChild(independentCoord);
                newPoint.addChild(dependentCoord);
                ++i;
            }
        } else {
            this.dataPoint = new ArrayList();
            i = 0;
            while (i < source.size()) {
                newPoint = new DPoint();
                this.curve.addChild(newPoint);
                CategoricalData catData = (CategoricalData)source.get(i);
                double dummyValue = 0.0;
                Category catObj = (Category)catData.getCategoryId();
                String catID = null;
                catID = catObj != null ? catObj.getId() : "dummy";
                DCoordObject independentCoord = new DCoordObject(indepAxis, catID);
                DCoord dependentCoord = null;
                dependentCoord = useSecAxis ? new DCoord(secDepAxis, dummyValue) : new DCoord(priDepAxis, dummyValue);
                SVGCategoricalDataImpl newCoord = new SVGCategoricalDataImpl(this._chart, this._dgraphic, newPoint, independentCoord, dependentCoord);
                newCoord.assign(source.get(i));
                this.dataPoint.add(newCoord);
                newPoint.addChild(independentCoord);
                newPoint.addChild(dependentCoord);
                ++i;
            }
        }
        List shapeList = null;
        Shapes shapes = ((SVGConfigurationImpl)this._chart.getConfiguration()).shapes;
        if (shapes != null) {
            shapeList = ((SVGShapesImpl)shapes).shape;
        }
        if (shapeList != null) {
            int i2 = 0;
            while (i2 < shapeList.size()) {
                SVGShapeImpl shape = (SVGShapeImpl)shapeList.get(i2);
                if (this.getId().equals(shape.fetchDataSetId())) {
                    String shapeId = shape.getShapeId();
                    if (shapeId == null) break;
                    shape.setDCurve(this.curve);
                    shape.setShapeId(shapeId);
                    break;
                }
                ++i2;
            }
        }
        List dataColorList = null;
        Palettes palettes = ((SVGConfigurationImpl)this._chart.getConfiguration()).palettes;
        if (palettes != null) {
            dataColorList = ((SVGPalettesImpl)palettes).dataSetColor;
        }
        if (dataColorList != null) {
            int i3 = 0;
            while (i3 < dataColorList.size()) {
                SVGDataSetColorImpl dataColor = (SVGDataSetColorImpl)dataColorList.get(i3);
                if (this.getId().equals(dataColor.fetchDataSetId())) {
                    String color = dataColor.getColor();
                    if (color == null || color == LABEL_EDEFAULT) break;
                    dataColor.setDCurve(this.curve);
                    dataColor.setColor(color);
                    break;
                }
                ++i3;
            }
        }
    }

    public Accessibility getAccessibility() {
        if (this.accessibility == null) {
            this.accessibility = this.getAccessibility(this.curve);
        }
        return this.accessibility;
    }

    public void setAccessibility(Accessibility newAccessibility) {
        this.accessibility = newAccessibility;
    }

    public void assignAccessibility(Accessibility source) {
        this.accessibility = new SVGAccessibilityImpl(this._chart, this._dgraphic, SVGAccessibilityImpl.TITLE_EDEFAULT, SVGAccessibilityImpl.DESCRIPTION_EDEFAULT);
        ((SVGAccessibilityImpl)this.accessibility).assign(source);
        super.constructAccessibilityModel(this.accessibility, this.curve);
    }

    public List getEventHandler() {
        if (this.eventHandler == null) {
            this.eventHandler = this.getEventHandler(this.curve);
        }
        return this.eventHandler;
    }

    public void setEventHandler(List newEventHandler) {
        this.eventHandler = newEventHandler;
        super.constructEventHandlerModel(this.eventHandler, this.curve);
    }

    public Tooltip getTooltip() {
        if (this.tooltip == null && this.curve.getTooltip() != null) {
            this.tooltip = new SVGTooltipImpl(this._chart, this._dgraphic, this.curve.getTooltip());
        }
        return this.tooltip;
    }

    public void setTooltip(Tooltip newTooltip) {
        this.tooltip = newTooltip;
        this.curve.setTooltip(newTooltip.getLabel());
    }

    public void assignTooltip(Tooltip source) {
        this.tooltip = new SVGTooltipImpl(this._chart, this._dgraphic, SVGTooltipImpl.LABEL_EDEFAULT);
        ((SVGTooltipImpl)this.tooltip).assign(source);
        this.curve.setTooltip(this.tooltip.getLabel());
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (id: ");
        result.append(this.getId());
        result.append(", label: ");
        result.append(this.getLabel());
        result.append(')');
        return result.toString();
    }

    public DCurve getCurve() {
        return this.curve;
    }
}

