/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataValue;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.NumberFormat;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGInputBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGNumberFormatImpl;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;

public class SVGDataValueImpl
extends SVGInputBase
implements DataValue {
    protected String percentageVisibility;
    protected String valueVisibility;
    protected NumberFormat numberFormat;

    public SVGDataValueImpl(SVGChartImpl chart) {
        this(chart, chart.getDGraphic());
    }

    public SVGDataValueImpl(Chart chart, DGraphic dgraphic) {
        this._chart = chart;
        this._dgraphic = dgraphic;
    }

    public String getPercentageVisibility() {
        Boolean visible = (Boolean)this._dgraphic.getProperties().get("P_SHOW_PERCENTAGE.DGraphic.core.jscrib", Boolean.FALSE);
        if (visible != null) {
            this.percentageVisibility = visible != false ? "visible" : "hidden";
        }
        return this.percentageVisibility;
    }

    public void setPercentageVisibility(String value) {
        this.percentageVisibility = value;
        this._dgraphic.getProperties().store("P_SHOW_PERCENTAGE.DGraphic.core.jscrib", this.percentageVisibility.equals("visible"));
    }

    public String getValueVisibility() {
        Boolean visible = (Boolean)this._dgraphic.getProperties().get("P_SHOW_VALUES.DGraphic.core.jscrib", Boolean.FALSE);
        if (visible != null) {
            this.valueVisibility = visible != false ? "visible" : "hidden";
        }
        return this.valueVisibility;
    }

    public void setValueVisibility(String value) {
        this.valueVisibility = value;
        this._dgraphic.getProperties().store("P_SHOW_VALUES.DGraphic.core.jscrib", this.valueVisibility.equals("visible"));
    }

    public NumberFormat getNumberFormat() {
        String format;
        if (this.numberFormat == null && this._dgraphic != null && (format = (String)this._dgraphic.getProperties().get("P_VALUE_FORMAT.DGraphic.core.jscrib")) != null) {
            this.numberFormat = new SVGNumberFormatImpl(this._chart, this._dgraphic, format);
        }
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat value) {
        this.numberFormat = value;
    }

    public void assignNumberFormat(NumberFormat source) {
        this.numberFormat = new SVGNumberFormatImpl(this._chart, this._dgraphic, SVGNumberFormatImpl.PATTERN_EDEFAULT);
        ((SVGNumberFormatImpl)this.numberFormat).assign(source);
        this._dgraphic.getProperties().store("P_VALUE_FORMAT.DGraphic.core.jscrib", source.getPattern());
    }
}

