/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Legend;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGInputBase;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.IDAlignment;
import org.eclipse.tptp.platform.report.tools.internal.DAlignmentPair;

public class SVGLegendImpl
extends SVGInputBase
implements Legend {
    protected static final String BACKGROUND_COLOR_EDEFAULT = null;
    protected static final int MARGIN_EDEFAULT = 10;
    protected static final double HEIGHT_EDEFAULT = 0.0;
    protected boolean heightESet = false;
    protected static final String ID_EDEFAULT = null;
    protected static final String LOCATION_EDEFAULT = "RIGHT";
    protected boolean locationESet = false;
    protected static final boolean SHOW_EDEFAULT = true;
    protected boolean showESet = false;
    protected static final String TITLE_EDEFAULT = null;
    protected static final double WIDTH_EDEFAULT = 0.0;
    protected boolean widthESet = false;
    protected boolean marginESet = false;
    protected IDAlignment alignment = null;

    protected SVGLegendImpl() {
    }

    public SVGLegendImpl(SVGChartImpl chart) {
        this(chart, chart.getDGraphic());
    }

    public SVGLegendImpl(Chart chart, DGraphic dgraphic) {
        this._chart = chart;
        this._dgraphic = dgraphic;
        this.alignment = (DAlignmentPair)this._dgraphic.getProperties().get("P_LEGEND_LAYOUT.DGraphic.core.jscrib");
    }

    public String getBackgroundColor() {
        DColor color = (DColor)this._dgraphic.getProperties().get("P_LEGEND_BACKCOLOR.DGraphic.core.jscrib");
        if (color != null) {
            return color.serializeToString();
        }
        return BACKGROUND_COLOR_EDEFAULT;
    }

    public void setBackgroundColor(String newBackgroundColor) {
        if (newBackgroundColor != null && newBackgroundColor != "" && !newBackgroundColor.substring(0, 1).equals("#")) {
            newBackgroundColor = this.convertToHex(newBackgroundColor);
        }
        if (newBackgroundColor == null || newBackgroundColor == "") {
            this._dgraphic.getProperties().remove("P_BACKCOLOR.DGraphic.core.jscrib");
            return;
        }
        this._dgraphic.getProperties().store("P_LEGEND_BACKCOLOR.DGraphic.core.jscrib", ((SVGChartImpl)this._chart).getColor(newBackgroundColor));
    }

    public String getId() {
        return this._dgraphic.getProperties().get("P_LEGEND_ID.DGraphic.core.jscrib", ID_EDEFAULT);
    }

    public void setId(String newId) {
        this._dgraphic.getProperties().store("P_LEGEND_ID.DGraphic.core.jscrib", newId);
    }

    public String getLocation() {
        this.locationESet = true;
        String location = (String)this._dgraphic.getProperties().get("P_LEGEND_LOCATION.DGraphic.core.jscrib");
        if (location != null) {
            return location;
        }
        if (this.alignment != null) {
            if (this.alignment.haveOneOfAlignment(1)) {
                return "W";
            }
            if (this.alignment.haveOneOfAlignment(2)) {
                return "E";
            }
            if (this.alignment.haveOneOfAlignment(8)) {
                return "N";
            }
            if (this.alignment.haveOneOfAlignment(16)) {
                return "S";
            }
            this.locationESet = false;
            return "E";
        }
        this.locationESet = false;
        return "TRAILING";
    }

    public void setLocation(String newLocation) {
        this.locationESet = true;
        if (newLocation.equalsIgnoreCase("E") || newLocation.equalsIgnoreCase("W") || newLocation.equalsIgnoreCase("N") || newLocation.equalsIgnoreCase("S")) {
            if (this.alignment == null) {
                this.alignment = new DAlignmentPair();
                this._dgraphic.getProperties().store("P_LEGEND_LAYOUT.DGraphic.core.jscrib", this.alignment);
            }
            if (newLocation.trim().equalsIgnoreCase("E")) {
                this.alignment.setAlignment(2);
            } else if (newLocation.trim().equalsIgnoreCase("W")) {
                this.alignment.setAlignment(1);
            } else if (newLocation.trim().equalsIgnoreCase("N")) {
                this.alignment.setAlignment(8);
            } else {
                this.alignment.setAlignment(16);
            }
        } else {
            this._dgraphic.getProperties().store("P_LEGEND_LOCATION.DGraphic.core.jscrib", newLocation);
        }
    }

    public void unsetLocation() {
        this.locationESet = false;
        this.alignment.setAlignment(2);
    }

    public boolean isSetLocation() {
        if (!this.locationESet) {
            this.getLocation();
        }
        return this.locationESet;
    }

    public boolean isShow() {
        if (this._dgraphic.getProperties().get("P_SHOW_LEGEND.DGraphic.core.jscrib") != null) {
            this.showESet = true;
        }
        return this._dgraphic.getProperties().get("P_SHOW_LEGEND.DGraphic.core.jscrib", true);
    }

    public void setShow(boolean newShow) {
        this._dgraphic.getProperties().store("P_SHOW_LEGEND.DGraphic.core.jscrib", newShow);
        this.showESet = true;
    }

    public void unsetShow() {
        this.showESet = false;
        this._dgraphic.getProperties().remove("P_SHOW_LEGEND.DGraphic.core.jscrib");
    }

    public boolean isSetShow() {
        if (!this.showESet) {
            this.isShow();
        }
        return this.showESet;
    }

    public String getTitle() {
        String title = (String)this._dgraphic.getProperties().get("P_LEGEND_LABEL.DGraphic.core.jscrib");
        if (title != null && title != "") {
            return title;
        }
        return null;
    }

    public void setTitle(String newTitle) {
        this._dgraphic.getProperties().store("P_LEGEND_LABEL.DGraphic.core.jscrib", newTitle);
    }

    public double getHeight() {
        int sizingFactor;
        String loc = this.getLocation();
        if (this._dgraphic.getProperties().get("P_LEGEND_LIMIT.DGraphic.core.jscrib") != null && (sizingFactor = ((Integer)this._dgraphic.getProperties().get("P_LEGEND_LIMIT.DGraphic.core.jscrib", new Integer(4))).intValue()) != 4) {
            this.heightESet = true;
            if (loc.equals("S") || loc.equals("N")) {
                return this._chart.getConfiguration().getSize().getHeight() / (double)sizingFactor;
            }
        }
        return 0.0;
    }

    public void setHeight(double newHeight) {
    }

    public void unsetHeight() {
        this.heightESet = false;
        this._dgraphic.getProperties().remove("P_LEGEND_HEIGHT.DGraphic.core.jscrib");
    }

    public boolean isSetHeight() {
        if (!this.heightESet) {
            this.getHeight();
        }
        return this.heightESet;
    }

    public double getWidth() {
        String loc = this.getLocation();
        if (this._dgraphic.getProperties().get("P_LEGEND_LIMIT.DGraphic.core.jscrib") != null) {
            this.widthESet = true;
        }
        if (loc.equals("E") || loc.equals("W")) {
            int sizingFactor = (Integer)this._dgraphic.getProperties().get("P_LEGEND_LIMIT.DGraphic.core.jscrib", new Integer(4));
            return this._chart.getConfiguration().getSize().getWidth() / (double)sizingFactor;
        }
        return 0.0;
    }

    public void setWidth(double newWidth) {
    }

    public void unsetWidth() {
        this.widthESet = false;
        this._dgraphic.getProperties().remove("P_LEGEND_WIDTH.DGraphic.core.jscrib");
    }

    public boolean isSetWidth() {
        if (!this.widthESet) {
            this.getWidth();
        }
        return this.widthESet;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (id: ");
        result.append(this.getId());
        result.append(", location: ");
        if (this.locationESet) {
            result.append(this.getLocation());
        } else {
            result.append("<unset>");
        }
        result.append(", show: ");
        if (this.showESet) {
            result.append(this.isShow());
        } else {
            result.append("<unset>");
        }
        result.append(", title: ");
        if (this.widthESet) {
            result.append(this.getWidth());
        } else {
            result.append("<unset>");
        }
        result.append(", title: ");
        if (this.heightESet) {
            result.append(this.getHeight());
        } else {
            result.append("<unset>");
        }
        result.append(", title: ");
        result.append(this.getTitle());
        result.append(')');
        return result.toString();
    }

    public int getMargin() {
        if (this._dgraphic.getProperties().get("P_MARGIN.DGraphic.core.jscrib") != null) {
            this.marginESet = true;
        }
        return (Integer)this._dgraphic.getProperties().get("P_MARGIN.DGraphic.core.jscrib", new Integer(10));
    }

    public void setMargin(int value) {
        this._dgraphic.getProperties().store("P_MARGIN.DGraphic.core.jscrib", new Float(value));
        this.marginESet = true;
    }

    public void unsetMagin() {
        this.marginESet = false;
        this._dgraphic.getProperties().store("P_MARGIN.DGraphic.core.jscrib", new Integer(10));
    }

    public boolean isSetMagin() {
        if (!this.marginESet) {
            this.getMargin();
        }
        return this.marginESet;
    }
}

