/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.PlotArea;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGInputBase;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;

public class SVGPlotAreaImpl
extends SVGInputBase
implements PlotArea {
    protected static final String BACKGROUND_COLOR_EDEFAULT = null;
    protected String backgroundColor = BACKGROUND_COLOR_EDEFAULT;
    protected static final boolean BORDER_EDEFAULT = true;
    protected boolean border = true;
    protected boolean borderESet = false;

    protected SVGPlotAreaImpl() {
    }

    public SVGPlotAreaImpl(SVGChartImpl chart) {
        this(chart, chart.getDGraphic());
    }

    public SVGPlotAreaImpl(Chart chart, DGraphic dgraphic) {
        this._chart = chart;
        this._dgraphic = dgraphic;
    }

    public String getBackgroundColor() {
        DColor color = (DColor)this._dgraphic.getProperties().get("P_PLOTAREA_BACKCOLOR.DGraphic.core.jscrib");
        if (color != null) {
            return color.serializeToString();
        }
        return BACKGROUND_COLOR_EDEFAULT;
    }

    public void setBackgroundColor(String newBackgroundColor) {
        if (newBackgroundColor != null && newBackgroundColor != "" && !newBackgroundColor.substring(0, 1).equals("#")) {
            newBackgroundColor = this.convertToHex(newBackgroundColor);
        }
        if (newBackgroundColor == null || newBackgroundColor == "") {
            this._dgraphic.getProperties().remove("P_PLOTAREA_BACKCOLOR.DGraphic.core.jscrib");
            return;
        }
        this._dgraphic.getProperties().store("P_PLOTAREA_BACKCOLOR.DGraphic.core.jscrib", ((SVGChartImpl)this._chart).getColor(newBackgroundColor));
    }

    public boolean isBorder() {
        if (this._dgraphic.getProperties().get("P_SHOW_PLOTAREA_BORDER.DGraphic.core.jscrib") != null) {
            this.borderESet = true;
        }
        return this._dgraphic.getProperties().get("P_SHOW_PLOTAREA_BORDER.DGraphic.core.jscrib", true);
    }

    public void setBorder(boolean newBorder) {
        this._dgraphic.getProperties().store("P_SHOW_PLOTAREA_BORDER.DGraphic.core.jscrib", newBorder);
        this.borderESet = true;
    }

    public void unsetBorder() {
        this.borderESet = false;
        this._dgraphic.getProperties().remove("P_SHOW_PLOTAREA_BORDER.DGraphic.core.jscrib");
        this.border = true;
    }

    public boolean isSetBorder() {
        if (!this.borderESet) {
            this.isBorder();
        }
        return this.borderESet;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (backgroundColor: ");
        result.append(this.backgroundColor);
        result.append(", border: ");
        if (this.borderESet) {
            result.append(this.border);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }
}

